/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.events.server;

import com.pg85.otg.OTG;
import com.pg85.otg.common.BiomeIds;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.customobjects.bo4.BO4;
import com.pg85.otg.exception.BiomeNotFoundException;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.OTGPlugin;
import com.pg85.otg.forge.biomes.ForgeBiome;
import com.pg85.otg.forge.dimensions.OTGDimensionManager;
import com.pg85.otg.forge.dimensions.OTGTeleporter;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.minecraft.defaults.MobNames;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.DerivedWorldInfo;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public final class OTGCommandHandler
implements ICommand {
    private final List<String> aliases = Arrays.asList("otg");
    private static final TextFormatting ERROR_COLOR = TextFormatting.RED;
    private static final TextFormatting MESSAGE_COLOR = TextFormatting.GREEN;
    private static final TextFormatting VALUE_COLOR = TextFormatting.DARK_GREEN;

    /*
     * WARNING - void declaration
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] argString) {
        World mcWorld = sender.func_130014_f_();
        boolean isOp = sender.func_70003_b(2, this.func_71517_b());
        if (!mcWorld.field_72995_K) {
            ForgeWorld world = ((ForgeEngine)OTG.getEngine()).getWorld(mcWorld);
            boolean isOTGWorld = false;
            if (world != null || argString.length != 0 && (argString[0].toLowerCase().trim().equals("dimension") || argString[0].toLowerCase().trim().equals("dim")) && argString.length < 3) {
                isOTGWorld = true;
            }
            BlockPos pos = sender.func_180425_c();
            int playerX = pos.func_177958_n();
            int playerY = pos.func_177956_o();
            int playerZ = pos.func_177952_p();
            if (argString != null && argString.length > 0 && (argString[0].toLowerCase().trim().equals("pregen") || argString[0].toLowerCase().trim().equals("pregenerator"))) {
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "The /pregen command has been deprecated. Press the \"O\" button to access the OTG dimensions menu, you can manage the pregenerator from there."));
                return;
            }
            if (argString != null && argString.length > 0 && argString[0].toLowerCase().trim().equals("summon")) {
                int radius = 1;
                if (argString.length > 1) {
                    radius = Integer.parseInt(argString[1]);
                }
                if (radius > 50) {
                    radius = 50;
                    OTG.log(LogMarker.WARN, "Error in summon call: Parameter radius can be no higher than 50. Radius was set to 50.", new Object[0]);
                }
                argString = new String[]{"GetModData", "OTG", radius + ""};
            }
            if (argString == null || argString.length == 0) {
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentString("-- OpenTerrainGenerator --"));
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentString("Press \"O\" to open the world settings menu."));
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentString("Commands:"));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg world " + VALUE_COLOR + "Show author and description information for this world."));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg biome <-f, -s, -d, -m> " + VALUE_COLOR + "Show biome information for the biome at the player's coordinates."));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg bo3 " + VALUE_COLOR + "Show author and description information for any structure at the player's coordinates."));
                if (isOp) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg tp <biome name or id / dimension name> " + VALUE_COLOR + "Teleport to the given dimension or the nearest biome with the given name or id (max distance 16000 blocks)."));
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg dim " + VALUE_COLOR + "Shows information about OTG dimensions. Same as /otg dimension."));
                if (isOp) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg dim -u <dimension name> " + VALUE_COLOR + "Flags the dimension for unloading, even if it has forceDrupChunk set to true in the WorldConfig to make sure it never unloads. Same as /otg dimension -u <dimension name>"));
                }
                if (isOp) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg blocks " + VALUE_COLOR + "Show a list of block names that can be spawned inside BO3's with the Block() tag and used in biome- and world-configs."));
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg entities " + VALUE_COLOR + "Show a list of entities that can be spawned inside BO3's using the Entity() tag."));
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg flushcache " + VALUE_COLOR + "Unloads all loaded BO2/BO3 files, use this to refresh BO2's/BO3's after editing them. Also flushes chunk generator cache to free up memory."));
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg GetModData <ModName> <Radius> " + VALUE_COLOR + "Sends any ModData() tags in BO3's within the specified <Radius> in chunks to the specified <ModName>. Some OTG mob spawning commands can be used this way. Be sure to set up ModData() tags in your BO3 to make this work."));
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg summon <Radius> " + VALUE_COLOR + "Shorthand for /mcw GetModData OTG <Radius>. Used to summon mobs and entities that are configured to spawn inside BO3's."));
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg exportBO4Data " + VALUE_COLOR + "Exports all BO4 files and BO3 files that have isOTGPlus:true as BO4Data files (if none exist already). BO4Data files can significantly reduce filesize and loading times, and should be used by OTG content creators when packaging presets for players."));
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentString("Tips:"));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "- If you're an op, press the \"O\" button to access the OTG dimensions menu."));
            } else if (argString[0].toLowerCase().trim().equals("exportbo4data") && isOp) {
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "Exporting .BO4Data files for world, this may take a while."));
                ArrayList<BO4> bo4s = OTG.getEngine().getCustomObjectManager().getGlobalObjects().getAllBO4sForWorld(world.getName());
                boolean bl = false;
                for (BO4 bo4 : bo4s) {
                    void var13_26;
                    OTG.log(LogMarker.INFO, "Exporting .BO4Data " + (int)(++var13_26) + "/" + bo4s.size() + " \"" + bo4.getName() + "\"", new Object[0]);
                    bo4.generateBO4Data();
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + ".BO4Data export complete."));
            } else if (argString[0].toLowerCase().trim().equals("blocks") && isOp) {
                OTG.log(LogMarker.INFO, "-- Blocks List --", new Object[0]);
                sender.func_145747_a((ITextComponent)new TextComponentString("-- Blocks List --"));
                Set as = ForgeRegistries.BLOCKS.getKeys();
                for (ResourceLocation blockAlias : as) {
                    OTG.log(LogMarker.INFO, blockAlias + "", new Object[0]);
                    sender.func_145747_a((ITextComponent)new TextComponentString(blockAlias + ""));
                }
                OTG.log(LogMarker.INFO, "----", new Object[0]);
            } else if (argString[0].toLowerCase().trim().equals("flushcache") && isOp) {
                OTG.log(LogMarker.INFO, "Clearing caches", new Object[0]);
                OTG.log(LogMarker.INFO, "Unloading BO3's", new Object[0]);
                OTG.getEngine().getCustomObjectManager().reloadCustomObjectFiles();
                OTG.log(LogMarker.INFO, "BO3's unloaded", new Object[0]);
                sender.func_145747_a((ITextComponent)new TextComponentString("BO3's unloaded"));
                OTG.log(LogMarker.INFO, "Clearing chunkgenerator cache", new Object[0]);
                world.getChunkGenerator().clearChunkCache(false);
                OTG.log(LogMarker.INFO, "Caches cleared", new Object[0]);
            } else if (isOp && argString[0].toLowerCase().trim().equals("tp") && argString.length > 1) {
                void var13_29;
                String biomeOrDimensionName = "";
                boolean bl = true;
                while (var13_29 < argString.length) {
                    biomeOrDimensionName = biomeOrDimensionName + argString[var13_29] + " ";
                    ++var13_29;
                }
                if (biomeOrDimensionName != null && biomeOrDimensionName.trim().length() > 0) {
                    int n;
                    biomeOrDimensionName = biomeOrDimensionName.trim();
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "Searching for destination biome or dimension \"" + VALUE_COLOR + biomeOrDimensionName + MESSAGE_COLOR + "\".", new Object[0]));
                    int n2 = -1;
                    try {
                        n = Integer.parseInt(biomeOrDimensionName.replace(" ", ""));
                    }
                    catch (NumberFormatException blockAlias) {
                        // empty catch block
                    }
                    for (int i = -1; i < 1024; ++i) {
                        DimensionType dimensionType;
                        if (!DimensionManager.isDimensionRegistered((int)i) || !(dimensionType = DimensionManager.getProviderType((int)i)).func_186065_b().toLowerCase().trim().equals(biomeOrDimensionName.toLowerCase())) continue;
                        OTGTeleporter.changeDimension(i, (EntityPlayerMP)sender.func_174793_f(), false, true);
                        return;
                    }
                    ChunkCoordinate playerChunk = ChunkCoordinate.fromBlockCoords(playerX, playerZ);
                    if (world != null) {
                        int n3;
                        ForgeBiome targetBiome;
                        int maxRadius = 1000;
                        if (n == -1 && (targetBiome = (ForgeBiome)world.getBiomeByNameOrNull(biomeOrDimensionName)) != null) {
                            n3 = targetBiome.getIds().getOTGBiomeId();
                        }
                        if (n3 != -1) {
                            for (int cycle = 1; cycle < maxRadius; ++cycle) {
                                for (int x1 = playerX - cycle; x1 <= playerX + cycle; ++x1) {
                                    if (x1 != playerX - cycle && x1 != playerX + cycle) continue;
                                    for (int i = playerZ - cycle; i <= playerZ + cycle; ++i) {
                                        ChunkCoordinate chunkCoord;
                                        ForgeBiome biome;
                                        if (i != playerZ - cycle && i != playerZ + cycle || (biome = (ForgeBiome)world.getBiome((chunkCoord = ChunkCoordinate.fromChunkCoords(playerChunk.getChunkX() + (x1 - playerX), playerChunk.getChunkZ() + (i - playerZ))).getBlockXCenter(), chunkCoord.getBlockZCenter())) == null || biome.getIds().getOTGBiomeId() != n3) continue;
                                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "Teleporting to \"" + VALUE_COLOR + biomeOrDimensionName + MESSAGE_COLOR + "\".", new Object[0]));
                                        ((Entity)sender).func_70634_a((double)chunkCoord.getBlockXCenter(), (double)world.getHighestBlockYAt(chunkCoord.getBlockXCenter(), chunkCoord.getBlockZCenter(), true, true, false, false), (double)chunkCoord.getBlockZCenter());
                                        return;
                                    }
                                }
                            }
                        }
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "Could not find biome \"" + biomeOrDimensionName + "\".", new Object[0]));
                    return;
                }
            } else if (argString[0].toLowerCase().trim().equals("worldinfo") || argString[0].toLowerCase().trim().equals("world")) {
                if (!isOTGWorld) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(""));
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "This command is only available for OpenTerrainGenerator worlds.", new Object[0]));
                    return;
                }
                WorldConfig worldConfig = world.getConfigs().getWorldConfig();
                DimensionConfig dimensionConfig = OTG.getDimensionsConfig().getDimensionConfig(world.getName());
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentString("-- World info --"));
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "Name: " + VALUE_COLOR + dimensionConfig.PresetName));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "Author: " + VALUE_COLOR + worldConfig.author));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "Description: " + VALUE_COLOR + worldConfig.description));
            } else if (argString[0].toLowerCase().trim().equals("entities")) {
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                OTG.log(LogMarker.INFO, "-- Entities List --", new Object[0]);
                sender.func_145747_a((ITextComponent)new TextComponentString("-- Entities List --"));
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "Some of these, like ThrownPotion, FallingSand, Mob and Painting may crash the game so be sure to test your BO3 in single player."));
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                EnumCreatureType[] aenumcreaturetype = EnumCreatureType.values();
                for (ResourceLocation entry : EntityList.func_180124_b()) {
                    if (EntityList.getClass((ResourceLocation)entry) == null) continue;
                    String msg = entry.func_110624_b() + ":" + entry.func_110623_a();
                    for (int k3 = 0; k3 < aenumcreaturetype.length; ++k3) {
                        EnumCreatureType enumcreaturetype = aenumcreaturetype[k3];
                        if (!enumcreaturetype.func_75598_a().isAssignableFrom(EntityList.getClass((ResourceLocation)entry))) continue;
                        msg = msg + VALUE_COLOR + " (" + enumcreaturetype.name() + ")";
                    }
                    OTG.log(LogMarker.INFO, msg.replace("\u00ef\u00bf\u00bd2", "").replace("\u00ef\u00bf\u00bd", "").replace("\u00ef\u00bf\u00bda", ""), new Object[0]);
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "- " + msg));
                }
                OTG.log(LogMarker.INFO, "----", new Object[0]);
            } else if (argString[0].toLowerCase().trim().equals("dimension") || argString[0].toLowerCase().trim().equals("dim")) {
                if (argString.length < 2 || this.containsArgument(argString, "-l")) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(""));
                    sender.func_145747_a((ITextComponent)new TextComponentString("-- Dimensions --"));
                    sender.func_145747_a((ITextComponent)new TextComponentString(""));
                    int dimId = sender.func_130014_f_().field_73011_w.getDimension();
                    DimensionType dimensionType = DimensionManager.getProviderType((int)dimId);
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "Currently in dimension " + VALUE_COLOR + dimensionType.func_186065_b() + MESSAGE_COLOR + " at id " + VALUE_COLOR + dimId + MESSAGE_COLOR + ".", new Object[0]));
                    sender.func_145747_a((ITextComponent)new TextComponentString(""));
                    for (int i = -1; i < 1024; ++i) {
                        if (!DimensionManager.isDimensionRegistered((int)i)) continue;
                        DimensionType dimensionType2 = DimensionManager.getProviderType((int)i);
                        ForgeWorld forgeWorld = null;
                        if (i == 0) {
                            forgeWorld = ((ForgeEngine)OTG.getEngine()).getOverWorld();
                        } else {
                            forgeWorld = (ForgeWorld)OTG.getWorld(dimensionType2.func_186065_b());
                            if (forgeWorld == null) {
                                forgeWorld = (ForgeWorld)OTG.getUnloadedWorld(dimensionType2.func_186065_b());
                            }
                        }
                        String materials = "";
                        if (forgeWorld != null) {
                            DimensionConfig dimensionConfig = OTG.getDimensionsConfig().getDimensionConfig(forgeWorld.getName());
                            if (dimensionConfig.Settings.DimensionPortalMaterials != null && dimensionConfig.Settings.DimensionPortalMaterials.length > 0) {
                                materials = materials + MESSAGE_COLOR + " (";
                                ArrayList<LocalMaterialData> mats = dimensionConfig.Settings.GetDimensionPortalMaterials();
                                for (LocalMaterialData material : mats) {
                                    materials = materials + VALUE_COLOR + material.toString() + MESSAGE_COLOR + ", ";
                                }
                                materials = materials.substring(0, materials.length() - 2);
                                materials = materials + MESSAGE_COLOR + ")";
                            }
                        }
                        String string = VALUE_COLOR + dimensionType2.func_186065_b() + MESSAGE_COLOR + " at id " + VALUE_COLOR + i + (OTG.getUnloadedWorld(dimensionType2.func_186065_b()) == null ? MESSAGE_COLOR + " (loaded)" : VALUE_COLOR + " (unloaded)") + materials;
                        sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "- " + string));
                    }
                } else if (isOp && argString.length > 2) {
                    void var18_92;
                    WorldServer overWorld;
                    String mainWorldName;
                    long seed = -1L;
                    String dimName = argString[2];
                    if (argString.length > 3) {
                        for (int i = 3; i < argString.length; ++i) {
                            if (argString[i].equals("-s")) {
                                if (argString.length <= i + 1) break;
                                seed = new Random().nextLong();
                                String sSeed = argString[i + 1];
                                if (StringUtils.isEmpty((CharSequence)sSeed)) break;
                                try {
                                    long j = Long.parseLong(sSeed);
                                    if (j == 0L) break;
                                    seed = j;
                                }
                                catch (NumberFormatException var7) {
                                    seed = sSeed.hashCode();
                                }
                                break;
                            }
                            dimName = dimName + " " + argString[i];
                        }
                    }
                    if ((mainWorldName = (overWorld = DimensionManager.getWorld((int)0)).func_72912_H().func_76065_j()).toLowerCase().trim().equals(dimName.toLowerCase().trim())) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(""));
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "Cannot target overworld.", new Object[0]));
                        return;
                    }
                    boolean existingDim = false;
                    OTGDimensionManager.getAllOTGDimensions();
                    int n = 2;
                    while (var18_92 < 1024) {
                        if (DimensionManager.isDimensionRegistered((int)var18_92)) {
                            DimensionType dimensionType = DimensionManager.getProviderType((int)var18_92);
                            if (OTGDimensionManager.IsOTGDimension((int)var18_92) && dimensionType.func_186065_b().equals(dimName)) {
                                existingDim = var18_92;
                            }
                        }
                        ++var18_92;
                    }
                    if (this.containsArgument(argString, "-u") && existingDim > true && ((ForgeEngine)OTG.getEngine()).getWorldLoader().getWorld(dimName) != null && ((ForgeEngine)OTG.getEngine()).getWorldLoader().getUnloadedWorld(dimName) == null) {
                        DimensionConfig dimensionConfig = OTG.getDimensionsConfig().getDimensionConfig(dimName);
                        dimensionConfig.Settings.CanDropChunk = true;
                        sender.func_145747_a((ITextComponent)new TextComponentString(""));
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "World is marked for unloading, if no players are in the world minecraft will unload it automatically, this may take a while.", new Object[0]));
                        return;
                    }
                }
            } else if (argString[0].toLowerCase().trim().equals("biomes") && isOp) {
                if (!isOTGWorld) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(""));
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "This command is only available for OpenTerrainGenerator worlds.", new Object[0]));
                    return;
                }
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "ForgeRegistries.BIOMES contains:", new Object[0]));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("", new Object[0]));
                for (Map.Entry entry : ForgeRegistries.BIOMES.getEntries()) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(VALUE_COLOR + ((ResourceLocation)entry.getKey()).toString() + MESSAGE_COLOR + " : " + VALUE_COLOR + ((Biome)entry.getValue()).toString(), new Object[0]));
                }
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("", new Object[0]));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "Biome.REGISTRY.registryObjects contains:", new Object[0]));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("", new Object[0]));
                for (Map.Entry entry : Biome.field_185377_q.field_82596_a.entrySet()) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(VALUE_COLOR + ((ResourceLocation)entry.getKey()).toString() + MESSAGE_COLOR + " : " + VALUE_COLOR + ((Biome)entry.getValue()).toString(), new Object[0]));
                }
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("", new Object[0]));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "Biome.REGISTRY.inverseRegistryObjects contains:", new Object[0]));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("", new Object[0]));
                for (Map.Entry entry : Biome.field_185377_q.field_148758_b.entrySet()) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(VALUE_COLOR + ((Biome)entry.getKey()).toString() + MESSAGE_COLOR + " : " + VALUE_COLOR + ((ResourceLocation)entry.getValue()).toString(), new Object[0]));
                }
            } else {
                if (argString[0].toLowerCase().trim().equals("biome")) {
                    if (!isOTGWorld) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(""));
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "This command is only available for OpenTerrainGenerator worlds.", new Object[0]));
                        return;
                    }
                    if (sender.func_130014_f_().func_72912_H() instanceof DerivedWorldInfo && !((DerivedWorldInfo)sender.func_130014_f_().func_72912_H()).field_76115_a.func_82571_y().equals("OpenTerrainGenerator") || !(sender.func_130014_f_().func_72912_H() instanceof DerivedWorldInfo) && !sender.func_130014_f_().func_72912_H().func_82571_y().equals("OpenTerrainGenerator")) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(""));
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "Biome information is not available for this dimension.", new Object[0]));
                        return;
                    }
                    LocalBiome biome = world.getBiome(playerX, playerZ);
                    BiomeIds biomeIds = biome.getIds();
                    sender.func_145747_a((ITextComponent)new TextComponentString(""));
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "According to OTG, you are in the " + VALUE_COLOR + biome.getName() + MESSAGE_COLOR + " biome, with id " + VALUE_COLOR + biomeIds.getOTGBiomeId(), new Object[0]));
                    if (this.containsArgument(argString, "-f")) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(""));
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "The base temperature of this biome is " + VALUE_COLOR + biome.getBiomeConfig().biomeTemperature + MESSAGE_COLOR + ", \n" + MESSAGE_COLOR + " at your height it is " + VALUE_COLOR + biome.getTemperatureAt(playerX, playerY, playerZ), new Object[0]));
                    }
                    if (this.containsArgument(argString, "-s")) {
                        try {
                            String savedBiomeName = world.getSavedBiomeName(playerX, playerZ);
                            sender.func_145747_a((ITextComponent)new TextComponentString(""));
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "According to the world save files, you are in the " + VALUE_COLOR + savedBiomeName + MESSAGE_COLOR + " biome, with id " + VALUE_COLOR + biome.getIds().getSavedId(), new Object[0]));
                        }
                        catch (BiomeNotFoundException e) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(""));
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "An unknown biome (" + e.getBiomeName() + ") was saved to the save files here.", new Object[0]));
                        }
                    }
                    if (this.containsArgument(argString, "-d")) {
                        try {
                            ForgeBiome forgeBiome = (ForgeBiome)world.getBiome(playerX, playerZ);
                            EnumCreatureType[] types = BiomeDictionary.getTypes((Biome)forgeBiome.biomeBase);
                            String typesString = "";
                            for (BiomeDictionary.Type type : types) {
                                if (typesString.length() == 0) {
                                    typesString = typesString + type.getName();
                                    continue;
                                }
                                typesString = typesString + ", " + type.getName();
                            }
                            sender.func_145747_a((ITextComponent)new TextComponentString(""));
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "BiomeDict: " + VALUE_COLOR + typesString, new Object[0]));
                        }
                        catch (BiomeNotFoundException e) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(""));
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "An unknown biome (" + e.getBiomeName() + ") was saved to the save files here.", new Object[0]));
                        }
                    }
                    if (this.containsArgument(argString, "-m")) {
                        try {
                            ForgeBiome calculatedBiome = (ForgeBiome)world.getCalculatedBiome(playerX, playerZ);
                            sender.func_145747_a((ITextComponent)new TextComponentString(""));
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation("-- Biome mob spawning settings --", new Object[0]));
                            for (EnumCreatureType enumCreatureType : EnumCreatureType.values()) {
                                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                                sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + enumCreatureType.name() + ": ", new Object[0]));
                                ArrayList creatureList = (ArrayList)calculatedBiome.biomeBase.func_76747_a(enumCreatureType);
                                if (creatureList == null || creatureList.size() <= 0) continue;
                                for (Biome.SpawnListEntry spawnListEntry : creatureList) {
                                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(VALUE_COLOR + "{\"mob\": \"" + MobNames.toInternalName(spawnListEntry.field_76300_b.getSimpleName()) + "\", \"weight\": " + spawnListEntry.field_76292_a + ", \"min\": " + spawnListEntry.field_76301_c + ", \"max\": " + spawnListEntry.field_76299_d + "}", new Object[0]));
                                }
                            }
                        }
                        catch (BiomeNotFoundException e) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(""));
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "An unknown biome (" + e.getBiomeName() + ") was saved to the save files here.", new Object[0]));
                        }
                    }
                    return;
                }
                if (argString[0].toLowerCase().trim().equals("bo3") || argString[0].toLowerCase().trim().equals("bo3info") || argString[0].toLowerCase().trim().equals("bo4") || argString[0].toLowerCase().trim().equals("bo4info")) {
                    if (!isOTGWorld) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(""));
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "This command is only available for OpenTerrainGenerator worlds.", new Object[0]));
                        return;
                    }
                    String structureInfo = world.getWorldSession().getStructureInfoAt(sender.func_180425_c().func_177958_n(), sender.func_180425_c().func_177952_p());
                    if (structureInfo.length() > 0) {
                        for (String messagePart : structureInfo.split("\r\n")) {
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(messagePart, new Object[0]));
                        }
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("There's nothing here.", new Object[0]));
                    }
                } else if (argString[0].toLowerCase().trim().equals("getmoddata") && argString.length > 1) {
                    if (!isOTGWorld) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(""));
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "This command is only available for OpenTerrainGenerator worlds.", new Object[0]));
                        return;
                    }
                    if (!(sender instanceof EntityPlayer) || isOp) {
                        if (argString.length == 2) {
                            ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(playerX, playerZ);
                            FMLInterModComms.sendRuntimeMessage((Object)OTGPlugin.Instance, (String)argString[1], (String)"GetModData", (String)(sender.func_130014_f_().func_72912_H().func_76065_j() + "," + chunkCoord.getChunkX() + "," + chunkCoord.getChunkZ()));
                        } else if (argString.length == 3) {
                            try {
                                int n;
                                ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(playerX, playerZ);
                                int n4 = Integer.parseInt(argString[2]);
                                if (n4 > 50) {
                                    n = 50;
                                    OTG.log(LogMarker.WARN, "Error in GetModData call: Parameter radius can be no higher than 50. Radius was set to 50.", new Object[0]);
                                }
                                for (void x = -n; x <= n; ++x) {
                                    for (int z = -n; z <= n; ++z) {
                                        ChunkCoordinate chunkCoord2 = ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + x, chunkCoord.getChunkZ() + z);
                                        FMLInterModComms.sendRuntimeMessage((Object)OTGPlugin.Instance, (String)argString[1], (String)"GetModData", (String)(sender.func_130014_f_().func_72912_H().func_76065_j() + "," + chunkCoord2.getChunkX() + "," + chunkCoord2.getChunkZ()));
                                    }
                                }
                            }
                            catch (NumberFormatException ex) {
                                OTG.log(LogMarker.WARN, "Error in GetModData call: value \"" + argString[2] + "\" was expected to be a number", new Object[0]);
                            }
                        }
                    }
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString(""));
                    sender.func_145747_a((ITextComponent)new TextComponentString("Unknown command. Type /otg for a list of commands."));
                }
            }
        }
    }

    public boolean func_82358_a(String[] var1, int var2) {
        return false;
    }

    public String func_71517_b() {
        return "otg";
    }

    public String func_71518_a(ICommandSender sender) {
        return "otg";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        ArrayList<String> listComplet = new ArrayList<String>();
        listComplet.add("worldinfo");
        listComplet.add("biome");
        listComplet.add("bo3");
        listComplet.add("bo4");
        listComplet.add("tp");
        listComplet.add("dimension");
        listComplet.add("dim");
        listComplet.add("blocks");
        listComplet.add("entities");
        listComplet.add("flushcache");
        listComplet.add("getmoddata");
        listComplet.add("exportbo4data");
        return listComplet;
    }

    public int compareTo(ICommand o) {
        return 0;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    private boolean containsArgument(String[] args, String arg) {
        for (String str : args) {
            if (!str.equalsIgnoreCase(arg)) continue;
            return true;
        }
        return false;
    }
}

