/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.generator;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.biomes.OTGBiomeProvider;
import com.pg85.otg.generator.biome.OutputType;
import com.pg85.otg.generator.biome.VanillaBiomeGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;

public class ForgeVanillaBiomeGenerator
extends VanillaBiomeGenerator {
    private Biome[] BiomeArray;
    private BiomeProvider worldChunkManager;

    public ForgeVanillaBiomeGenerator(LocalWorld world) {
        super(world);
    }

    @Override
    public int[] getBiomesUnZoomed(int[] biomeArray, int x, int z, int x_size, int z_size, OutputType outputType) {
        this.BiomeArray = this.worldChunkManager.func_76937_a(this.BiomeArray, x, z, x_size, z_size);
        if (biomeArray == null || biomeArray.length < x_size * z_size) {
            biomeArray = new int[x_size * z_size];
        }
        int biomeId = -1;
        for (int i = 0; i < x_size * z_size; ++i) {
            biomeId = -1;
            biomeId = ((ForgeEngine)OTG.getEngine()).getBiomeRegistryManager().getBiomeRegistryId(this.BiomeArray[i]);
            if (biomeId == -1) {
                throw new RuntimeException();
            }
            biomeArray[i] = biomeId;
        }
        return biomeArray;
    }

    @Override
    public int[] getBiomes(int[] biomeArray, int x, int z, int x_size, int z_size, OutputType outputType) {
        this.BiomeArray = this.worldChunkManager.func_76931_a(this.BiomeArray, x, z, x_size, z_size, true);
        if (biomeArray == null || biomeArray.length < x_size * z_size) {
            biomeArray = new int[x_size * z_size];
        }
        int biomeId = -1;
        for (int i = 0; i < x_size * z_size; ++i) {
            biomeId = -1;
            biomeId = ((ForgeEngine)OTG.getEngine()).getBiomeRegistryManager().getBiomeRegistryId(this.BiomeArray[i]);
            if (biomeId == -1) {
                throw new RuntimeException();
            }
            biomeArray[i] = biomeId;
        }
        return biomeArray;
    }

    @Override
    public int getBiome(int x, int z) {
        int biomeId = ((ForgeEngine)OTG.getEngine()).getBiomeRegistryManager().getBiomeRegistryId(this.worldChunkManager.func_180631_a(new BlockPos(x, 0, z)));
        if (biomeId == -1) {
            throw new RuntimeException();
        }
        return biomeId;
    }

    @Override
    public void cleanupCache() {
        this.worldChunkManager.func_76938_b();
    }

    @Override
    public boolean canGenerateUnZoomed() {
        return true;
    }

    public void setBiomeProvider(BiomeProvider biomeProvider) {
        if (biomeProvider instanceof OTGBiomeProvider) {
            throw new IllegalArgumentException(this.getClass() + " expects a vanilla BiomeProvider, " + biomeProvider.getClass() + " given");
        }
        this.worldChunkManager = biomeProvider;
    }
}

