/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.generator;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.customobjects.bofunctions.ModDataFunction;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.OTGPlugin;
import com.pg85.otg.forge.generator.ForgeChunkBuffer;
import com.pg85.otg.forge.util.ForgeMaterialData;
import com.pg85.otg.forge.util.NBTHelper;
import com.pg85.otg.generator.ChunkProviderOTG;
import com.pg85.otg.generator.ObjectSpawner;
import com.pg85.otg.generator.biome.OutputType;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.network.ConfigProvider;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.FifoMap;
import com.pg85.otg.util.bo3.NamedBinaryTag;
import com.pg85.otg.util.helpers.MaterialHelper;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockSand;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class OTGChunkGenerator
implements IChunkGenerator {
    private boolean testMode = false;
    private ForgeWorld world;
    private ChunkProviderOTG generator;
    public ObjectSpawner spawner;
    private ArrayList<ChunkCoordinate> populatedChunks;
    private FifoMap<ChunkCoordinate, ChunkColumns> unloadedChunkCache = new FifoMap(128);
    private Map<ChunkCoordinate, Chunk> loadedChunkCache = new HashMap<ChunkCoordinate, Chunk>();
    private Chunk lastUsedChunk;
    private int lastUsedChunkX;
    private int lastUsedChunkZ;
    private ForgeChunkBuffer chunkBuffer;
    private boolean firstRun = true;
    private ArrayList<LocalMaterialData> originalBlocks = new ArrayList();
    private ChunkCoordinate spawnChunk;
    private boolean spawnChunkFixed = false;
    private boolean allowSpawningOutsideBounds = false;
    private int[] biomeShortArray;
    private DataFixer dataFixer = DataFixesManager.func_188279_a();

    public OTGChunkGenerator(ForgeWorld _world) {
        this.world = _world;
        this.testMode = this.world.getConfigs().getWorldConfig().modeTerrain == WorldConfig.TerrainMode.TerrainTest;
        this.generator = new ChunkProviderOTG(this.world.getConfigs(), this.world);
        this.spawner = new ObjectSpawner(this.world.getConfigs(), this.world);
        this.populatedChunks = new ArrayList();
    }

    public void setAllowSpawningOutsideBounds(boolean allowSpawningOutsideBounds) {
        this.allowSpawningOutsideBounds = allowSpawningOutsideBounds;
    }

    public void clearChunkCache(boolean onlyLoadedChunks) {
        this.loadedChunkCache.clear();
        this.lastUsedChunk = null;
        if (!onlyLoadedChunks) {
            this.unloadedChunkCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk func_185932_a(int chunkX, int chunkZ) {
        Chunk chunk;
        ChunkCoordinate chunkCoords = ChunkCoordinate.fromChunkCoords(chunkX, chunkZ);
        boolean bFound = false;
        ArrayList<ChunkCoordinate> arrayList = this.populatedChunks;
        synchronized (arrayList) {
            if (!this.populatedChunks.contains(chunkCoords)) {
                this.populatedChunks.add(chunkCoords);
            } else {
                bFound = true;
            }
        }
        if (bFound) {
            chunk = this.world.getChunk(chunkCoords.getBlockX(), chunkCoords.getBlockZ(), true);
            if (chunk == null) {
                chunk = this.world.getWorld().func_72964_e(chunkX, chunkZ);
                if (chunk == null) {
                    throw new RuntimeException();
                }
                OTG.log(LogMarker.WARN, "Double population prevented", new Object[0]);
            }
            if (chunk != null) {
                OTG.log(LogMarker.WARN, "Double population prevented", new Object[0]);
                return chunk;
            }
            OTG.log(LogMarker.WARN, "Double population could not be prevented for chunk X" + chunkX + " Z" + chunkZ, new Object[0]);
        }
        chunk = this.getBlocks(chunkX, chunkZ, true);
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(chunkX, chunkZ);
        if (this.testMode) {
            if (this.testMode) {
                this.world.getChunkGenerator().clearChunkCache(false);
            }
            return;
        }
        BlockSand.field_149832_M = true;
        BlockGravel.field_149832_M = true;
        if (!this.spawner.processing) {
            this.spawner.populatingX = chunkX;
            this.spawner.populatingZ = chunkZ;
        }
        this.fixSpawnChunk();
        DimensionConfig dimConfig = OTG.getDimensionsConfig().getDimensionConfig(this.world.getName());
        if (dimConfig.Settings.SpawnPointSet) {
            this.world.getWorld().field_73011_w.setSpawnPoint(new BlockPos(dimConfig.Settings.SpawnPointX, dimConfig.Settings.SpawnPointY, dimConfig.Settings.SpawnPointZ));
            dimConfig.Settings.SpawnPointSet = false;
        }
        this.spawner.populate(chunkCoord);
        BlockSand.field_149832_M = false;
        BlockGravel.field_149832_M = false;
        HashMap<String, ArrayList<ModDataFunction<?>>> MessagesPerMod = this.world.getWorldSession().getModDataForChunk(chunkCoord);
        if (MessagesPerMod != null && MessagesPerMod.entrySet().size() > 0) {
            for (Map.Entry<String, ArrayList<ModDataFunction<?>>> modNameAndData : MessagesPerMod.entrySet()) {
                String messageString = "";
                if (modNameAndData.getKey().equals("OTG")) {
                    for (ModDataFunction<?> modData : modNameAndData.getValue()) {
                        boolean autoSpawn;
                        String[] paramString2 = modData.modData.split("\\/");
                        if (paramString2.length <= 1 || !paramString2[0].equals("mob") || !(autoSpawn = paramString2.length > 4 ? Boolean.parseBoolean(paramString2[4]) : false)) continue;
                        messageString = messageString + "[" + modData.x + "," + modData.y + "," + modData.z + "," + modData.modData + "]";
                    }
                } else {
                    for (ModDataFunction<?> modData : modNameAndData.getValue()) {
                        messageString = messageString + "[" + modData.x + "," + modData.y + "," + modData.z + "," + modData.modData + "]";
                    }
                }
                if (messageString.length() <= 0) continue;
                FMLInterModComms.sendRuntimeMessage((Object)OTGPlugin.Instance, (String)modNameAndData.getKey(), (String)"ModData", (String)("[[" + this.world.getName() + "," + chunkX + "," + chunkZ + "]" + messageString + "]"));
            }
        }
        this.clearChunkCache(true);
    }

    public Chunk getChunk(int x, int z, boolean allowOutsidePopulatingArea) {
        Chunk spawnedChunk;
        boolean outsidePopulatingArea;
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        if (this.lastUsedChunk != null && this.lastUsedChunkX == chunkX && this.lastUsedChunkZ == chunkZ) {
            return this.lastUsedChunk;
        }
        Chunk chunk = this.loadedChunkCache.get(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ));
        if (chunk != null) {
            this.lastUsedChunk = chunk;
            this.lastUsedChunkX = chunkX;
            this.lastUsedChunkZ = chunkZ;
            return chunk;
        }
        boolean bl = outsidePopulatingArea = chunkX != this.world.getObjectSpawner().populatingX && chunkX != this.world.getObjectSpawner().populatingX + 1 || chunkZ != this.world.getObjectSpawner().populatingZ && chunkZ != this.world.getObjectSpawner().populatingZ + 1;
        if (outsidePopulatingArea && !allowOutsidePopulatingArea || this.allowSpawningOutsideBounds) {
            if (!allowOutsidePopulatingArea) {
                if (this.world.getConfigs().getWorldConfig().populationBoundsCheck) {
                    return null;
                }
                Chunk loadedChunk = this.getLoadedChunkWithoutMarkingActive(chunkX, chunkZ);
                if (loadedChunk != null) {
                    this.lastUsedChunk = loadedChunk;
                    this.lastUsedChunkX = chunkX;
                    this.lastUsedChunkZ = chunkZ;
                    this.loadedChunkCache.put(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ), loadedChunk);
                }
                if (!this.allowSpawningOutsideBounds || loadedChunk != null) {
                    return loadedChunk;
                }
            }
            if (this.allowSpawningOutsideBounds) {
                spawnedChunk = this.world.getWorld().func_72964_e(chunkX, chunkZ);
                if (spawnedChunk == null) {
                    OTG.log(LogMarker.FATAL, "Chunk request failed X" + chunkX + " Z" + chunkZ, new Object[0]);
                    throw new RuntimeException("Chunk request failed X" + chunkX + " Z" + chunkZ);
                }
                this.loadedChunkCache.put(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ), spawnedChunk);
                this.lastUsedChunk = spawnedChunk;
                this.lastUsedChunkX = chunkX;
                this.lastUsedChunkZ = chunkZ;
                return spawnedChunk;
            }
        }
        if (outsidePopulatingArea && !((WorldServer)this.world.getWorld()).func_175667_e(new BlockPos(chunkX * 16, 1, chunkZ * 16))) {
            return null;
        }
        spawnedChunk = this.world.getWorld().func_72964_e(chunkX, chunkZ);
        if (spawnedChunk == null) {
            OTG.log(LogMarker.FATAL, "Chunk request failed X" + chunkX + " Z" + chunkZ, new Object[0]);
            throw new RuntimeException("Chunk request failed X" + chunkX + " Z" + chunkZ);
        }
        this.loadedChunkCache.put(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ), spawnedChunk);
        this.lastUsedChunk = spawnedChunk;
        this.lastUsedChunkX = chunkX;
        this.lastUsedChunkZ = chunkZ;
        return spawnedChunk;
    }

    private Chunk getLoadedChunkWithoutMarkingActive(int chunkX, int chunkZ) {
        long i = ChunkPos.func_77272_a((int)chunkX, (int)chunkZ);
        return (Chunk)((ChunkProviderServer)this.world.getWorld().func_72863_F()).field_73244_f.get(i);
    }

    private void fixSpawnChunk() {
        if (!this.firstRun) {
            if (!this.spawnChunkFixed && this.world.getConfigs().getWorldConfig().isOTGPlus) {
                this.setAllowSpawningOutsideBounds(true);
                int i = 0;
                for (int x = 0; x < 15; ++x) {
                    for (int z = 0; z < 15; ++z) {
                        if (!this.originalBlocks.get(i).toDefaultMaterial().equals((Object)DefaultMaterial.AIR) || !this.originalBlocks.get(i + 1).toDefaultMaterial().equals((Object)DefaultMaterial.AIR)) {
                            this.world.setBlock(this.spawnChunk.getBlockX() + x, 63, this.spawnChunk.getBlockZ() + z, this.originalBlocks.get(i), null, true);
                            this.world.setBlock(this.spawnChunk.getBlockX() + x, 64, this.spawnChunk.getBlockZ() + z, this.originalBlocks.get(i + 1), null, true);
                        } else {
                            for (int h = 62; h > 0; ++h) {
                                if (this.world.getMaterial(this.spawnChunk.getBlockX() + x, h, this.spawnChunk.getBlockZ() + z, true).toDefaultMaterial().equals((Object)DefaultMaterial.AIR)) continue;
                                this.world.setBlock(this.spawnChunk.getBlockX() + x, 63, this.spawnChunk.getBlockZ() + z, this.originalBlocks.get(i), null, true);
                                this.world.setBlock(this.spawnChunk.getBlockX() + x, 64, this.spawnChunk.getBlockZ() + z, this.originalBlocks.get(i + 1), null, true);
                                break;
                            }
                        }
                        i += 2;
                    }
                }
                this.setAllowSpawningOutsideBounds(false);
            }
            this.spawnChunkFixed = true;
        }
    }

    private Chunk getBlocks(int chunkX, int chunkZ, boolean provideChunk) {
        ChunkColumns chunkCacheEntry = (ChunkColumns)this.unloadedChunkCache.get(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ));
        Chunk chunk = null;
        if (chunkCacheEntry != null) {
            chunk = chunkCacheEntry.chunk;
        }
        if (chunk == null) {
            chunk = new Chunk(this.world.getWorld(), chunkX, chunkZ);
            ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(chunkX, chunkZ);
            this.chunkBuffer = new ForgeChunkBuffer(chunkCoord);
            this.generator.generate(this.chunkBuffer);
            if (this.firstRun && this.world.getConfigs().getWorldConfig().isOTGPlus) {
                this.spawnChunk = chunkCoord;
                for (int x = 0; x < 15; ++x) {
                    for (int z = 0; z < 15; ++z) {
                        this.originalBlocks.add(this.chunkBuffer.getBlock(x, 63, z));
                        this.originalBlocks.add(this.chunkBuffer.getBlock(x, 64, z));
                        this.chunkBuffer.setBlock(x, 63, z, MaterialHelper.toLocalMaterialData(DefaultMaterial.GRASS, 0));
                        this.chunkBuffer.setBlock(x, 64, z, MaterialHelper.toLocalMaterialData(DefaultMaterial.AIR, 0));
                    }
                }
            }
            this.firstRun = false;
            chunk = this.chunkBuffer.toChunk(this.world.getWorld());
            this.fillBiomeArray(chunk);
            chunk.func_76603_b();
            this.chunkBuffer = null;
        } else {
            this.fillBiomeArray(chunk);
            chunk.func_76603_b();
            this.unloadedChunkCache.remove(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ));
        }
        return chunk;
    }

    private void fillBiomeArray(Chunk chunk) {
        byte[] chunkBiomeArray = chunk.func_76605_m();
        ConfigProvider configProvider = this.world.getConfigs();
        this.biomeShortArray = this.world.getBiomeGenerator().getBiomes(this.biomeShortArray, chunk.field_76635_g * 16, chunk.field_76647_h * 16, 16, 16, OutputType.DEFAULT_FOR_WORLD);
        for (int i = 0; i < chunkBiomeArray.length; ++i) {
            int generationId = this.biomeShortArray[i];
            LocalBiome biome = configProvider.getBiomeByOTGIdOrNull(generationId);
            chunkBiomeArray[i] = (byte)biome.getIds().getSavedId();
        }
    }

    public LocalMaterialData[] getBlockColumnInUnloadedChunk(int x, int z) {
        IBlockState blockInChunk;
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        int chunkX = chunkCoord.getChunkX();
        int chunkZ = chunkCoord.getChunkZ();
        byte blockX = (byte)(x &= 0xF);
        byte blockZ = (byte)(z &= 0xF);
        LocalCoords2D columnLocalCoords = new LocalCoords2D(blockX, blockZ);
        ChunkColumns chunkCacheEntry = (ChunkColumns)this.unloadedChunkCache.get(chunkCoord);
        Chunk chunk = null;
        HashMap<LocalCoords2D, Object> blockColumnCache = null;
        LocalMaterialData[] cachedColumn = null;
        if (chunkCacheEntry != null) {
            chunk = chunkCacheEntry.chunk;
            blockColumnCache = chunkCacheEntry.blockColumns;
            cachedColumn = blockColumnCache.get(columnLocalCoords);
        }
        if (cachedColumn != null) {
            return cachedColumn;
        }
        if (chunk == null) {
            chunk = new Chunk(this.world.getWorld(), chunkX, chunkZ);
            ForgeChunkBuffer chunkBuffer = new ForgeChunkBuffer(chunkCoord);
            this.generator.generate(chunkBuffer);
            chunk = chunkBuffer.toChunk(this.world.getWorld());
            blockColumnCache = new HashMap(256);
            this.unloadedChunkCache.put(chunkCoord, new ChunkColumns(chunk, blockColumnCache));
        }
        LocalMaterialData[] blocksInColumn = new LocalMaterialData[256];
        for (int y = 0; y < 256 && (blockInChunk = chunk.func_177435_g(new BlockPos((int)blockX, y, (int)blockZ))) != null; y = (int)((short)(y + 1))) {
            blocksInColumn[y] = ForgeMaterialData.ofMinecraftBlockState(blockInChunk);
        }
        blockColumnCache.put(columnLocalCoords, blocksInColumn);
        return blocksInColumn;
    }

    public LocalMaterialData getMaterialInUnloadedChunk(int x, int y, int z) {
        LocalMaterialData[] blockColumn = this.getBlockColumnInUnloadedChunk(x, z);
        return blockColumn[y];
    }

    public int getHighestBlockYInUnloadedChunk(int x, int z, boolean findSolid, boolean findLiquid, boolean ignoreLiquid, boolean ignoreSnow) {
        int height = -1;
        LocalMaterialData[] blockColumn = this.getBlockColumnInUnloadedChunk(x, z);
        for (int y = 255; y > -1; --y) {
            boolean isSolid;
            ForgeMaterialData material = (ForgeMaterialData)blockColumn[y];
            boolean isLiquid = material.isLiquid();
            boolean bl = isSolid = material.isSolid() || !ignoreSnow && material.toDefaultMaterial().equals((Object)DefaultMaterial.SNOW);
            if (isLiquid && ignoreLiquid) continue;
            if (findSolid && isSolid || findLiquid && isLiquid) {
                return y;
            }
            if ((!findSolid || !isLiquid) && (!findLiquid || !isSolid)) continue;
            return -1;
        }
        return height;
    }

    public void setBlock(int x, int y, int z, LocalMaterialData material, NamedBinaryTag metaDataTag, boolean allowOutsidePopulatingArea) {
        if (y < 0 || y >= 256) {
            return;
        }
        IBlockState newState = ((ForgeMaterialData)material).internalBlock();
        BlockPos pos = new BlockPos(x, y, z);
        Chunk chunk = this.getChunk(x, z, allowOutsidePopulatingArea);
        if (chunk == null) {
            throw new RuntimeException("Whatever it is you're trying to do, we didn't write any code for it (sorry). Please contact Team OTG about this crash.");
        }
        IBlockState iblockstate = this.setBlockState(chunk, pos, newState);
        if (iblockstate == null) {
            return;
        }
        if (metaDataTag != null) {
            this.attachMetadata(x, y, z, metaDataTag, allowOutsidePopulatingArea);
        }
        this.world.getWorld().markAndNotifyBlock(pos, chunk, iblockstate, newState, 18);
    }

    private IBlockState setBlockState(Chunk _this, BlockPos pos, IBlockState state) {
        TileEntity te;
        int k;
        int l;
        int i = pos.func_177958_n() & 0xF;
        int j = pos.func_177956_o();
        if (j >= _this.field_76638_b[l = (k = pos.func_177952_p() & 0xF) << 4 | i] - 1) {
            _this.field_76638_b[l] = -999;
        }
        int i1 = _this.func_177445_q()[l];
        IBlockState iblockstate = _this.func_177435_g(pos);
        if (iblockstate == state) {
            return null;
        }
        Block block = state.func_177230_c();
        Block block1 = iblockstate.func_177230_c();
        int k1 = iblockstate.getLightOpacity((IBlockAccess)_this.func_177412_p(), pos);
        ExtendedBlockStorage extendedblockstorage = _this.func_76587_i()[j >> 4];
        boolean flag = false;
        if (extendedblockstorage == Chunk.field_186036_a) {
            if (block == Blocks.field_150350_a) {
                return null;
            }
            _this.func_76587_i()[j >> 4] = extendedblockstorage = new ExtendedBlockStorage(j >> 4 << 4, _this.func_177412_p().field_73011_w.func_191066_m());
            flag = j >= i1;
        }
        extendedblockstorage.func_177484_a(i, j & 0xF, k, state);
        if (!_this.func_177412_p().field_72995_K) {
            if (block1 != block) {
                block1.func_180663_b(_this.func_177412_p(), pos, iblockstate);
            }
            if ((te = _this.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK)) != null && te.shouldRefresh(_this.func_177412_p(), pos, iblockstate, state)) {
                _this.func_177412_p().func_175713_t(pos);
            }
        } else if (block1.hasTileEntity(iblockstate) && (te = _this.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK)) != null && te.shouldRefresh(_this.func_177412_p(), pos, iblockstate, state)) {
            _this.func_177412_p().func_175713_t(pos);
        }
        if (extendedblockstorage.func_177485_a(i, j & 0xF, k).func_177230_c() != block) {
            return null;
        }
        if (flag) {
            _this.func_76603_b();
        } else {
            int j1 = state.getLightOpacity((IBlockAccess)_this.func_177412_p(), pos);
            if (j1 > 0) {
                if (j >= i1) {
                    _this.func_76615_h(i, j + 1, k);
                }
            } else if (j == i1 - 1) {
                _this.func_76615_h(i, j, k);
            }
            if (j1 != k1 && (j1 < k1 || _this.func_177413_a(EnumSkyBlock.SKY, pos) > 0 || _this.func_177413_a(EnumSkyBlock.BLOCK, pos) > 0)) {
                _this.func_76595_e(i, k);
            }
        }
        if (block.hasTileEntity(state)) {
            TileEntity tileentity1 = _this.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
            if (tileentity1 == null) {
                tileentity1 = block.createTileEntity(_this.func_177412_p(), state);
                _this.func_177412_p().func_175690_a(pos, tileentity1);
            }
            if (tileentity1 != null) {
                tileentity1.func_145836_u();
            }
        }
        _this.func_76630_e();
        return iblockstate;
    }

    private void attachMetadata(int x, int y, int z, NamedBinaryTag tag, boolean allowOutsidePopulatingArea) {
        NBTTagCompound nmsTag = NBTHelper.getNMSFromNBTTagCompound(tag);
        nmsTag.func_74768_a("x", x);
        nmsTag.func_74768_a("y", y);
        nmsTag.func_74768_a("z", z);
        nmsTag = this.dataFixer.func_188257_a((IFixType)FixTypes.BLOCK_ENTITY, nmsTag);
        TileEntity tileEntity = this.world.getWorld().func_175625_s(new BlockPos(x, y, z));
        if (tileEntity != null) {
            tileEntity.func_145839_a(nmsTag);
        } else if (OTG.getPluginConfig().spawnLog) {
            OTG.log(LogMarker.WARN, "Skipping tile entity with id {}, cannot be placed at {},{},{} on id {}", nmsTag.func_74779_i("id"), x, y, z, this.world.getMaterial(x, y, z, allowOutsidePopulatingArea));
        }
    }

    public void func_180514_a(Chunk chunkIn, int chunkX, int chunkZ) {
        this.world.recreateStructures(chunkIn, chunkX, chunkZ);
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return this.world.isInsideStructure(structureName, pos);
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos blockPos, boolean p_180513_4_) {
        return this.world.getNearestStructurePos(structureName, blockPos, p_180513_4_);
    }

    public int getHighestBlockInCurrentlyPopulatingChunk(int x, int z) {
        for (int i = 255; i > 0; --i) {
            LocalMaterialData material = this.chunkBuffer.getBlock(x, i, z);
            if (material == null || material.isAir()) continue;
            return i;
        }
        return 0;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType paramaca, BlockPos blockPos) {
        return this.world.getPossibleCreatures(paramaca, blockPos);
    }

    private class ChunkColumns {
        Chunk chunk;
        HashMap<LocalCoords2D, LocalMaterialData[]> blockColumns;

        ChunkColumns(Chunk chunk, HashMap<LocalCoords2D, LocalMaterialData[]> blockColumns) {
            this.chunk = chunk;
            this.blockColumns = blockColumns;
        }
    }

    private class LocalCoords2D {
        byte x;
        byte z;

        LocalCoords2D(byte x, byte z) {
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof LocalCoords2D && ((LocalCoords2D)other).x == this.x && ((LocalCoords2D)other).z == this.z;
        }
    }
}

