/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.network.server.packets;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.dimensions.DimensionConfigGui;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.dimensions.DimensionData;
import com.pg85.otg.forge.dimensions.OTGDimensionInfo;
import com.pg85.otg.forge.dimensions.OTGDimensionManager;
import com.pg85.otg.forge.network.OTGPacket;
import com.pg85.otg.forge.network.client.AbstractClientMessageHandler;
import com.pg85.otg.forge.network.client.ClientPacketManager;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.network.ClientConfigProvider;
import com.pg85.otg.network.ConfigToNetworkSender;
import com.pg85.otg.util.helpers.StreamHelper;
import io.netty.buffer.ByteBuf;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class DimensionSyncPacket
extends OTGPacket {
    public DimensionSyncPacket() {
    }

    public DimensionSyncPacket(ByteBuf nettyBuffer) {
        super(nettyBuffer);
    }

    public static void writeToStream(DataOutput stream) throws IOException {
        OTGDimensionInfo otgDimData = OTGDimensionManager.LoadOrderedDimensionData();
        stream.writeInt(6);
        stream.writeInt(0);
        StreamHelper.writeStringToStream(stream, OTG.getDimensionsConfig().toYamlString());
        LocalWorld localWorld = ((ForgeEngine)OTG.getEngine()).getOverWorld();
        stream.writeInt(ForgeEngine.Presets.size());
        for (DimensionConfigGui dimConfig : ForgeEngine.Presets.values()) {
            StreamHelper.writeStringToStream(stream, dimConfig.toYamlString());
        }
        stream.writeInt(otgDimData.orderedDimensions.size());
        for (int i = 0; i <= otgDimData.highestOrder; ++i) {
            if (!otgDimData.orderedDimensions.containsKey(i)) continue;
            DimensionData dimData = otgDimData.orderedDimensions.get(i);
            localWorld = OTG.getWorld(dimData.dimensionName);
            if (localWorld == null) {
                localWorld = OTG.getUnloadedWorld(dimData.dimensionName);
                stream.writeBoolean(false);
            } else {
                stream.writeBoolean(true);
            }
            try {
                stream.writeInt(dimData.dimensionId);
                ConfigToNetworkSender.writeConfigsToStream(localWorld.getConfigs(), stream, false);
                continue;
            }
            catch (IOException e) {
                OTG.printStackTrace(LogMarker.FATAL, e);
            }
        }
    }

    public static ForgeWorld registerClientWorldBukkit(WorldClient mcWorld, DataInputStream wrappedStream, HashMap<String, ForgeWorld> worlds, HashMap<String, ForgeWorld> unloadedWorlds) throws IOException {
        ForgeWorld world = new ForgeWorld(StreamHelper.readStringFromStream(wrappedStream));
        ClientConfigProvider configs = new ClientConfigProvider(wrappedStream, world, Minecraft.func_71410_x().func_71356_B());
        world.provideClientConfigsBukkit(mcWorld, configs);
        return world;
    }

    public static class Handler
    extends AbstractClientMessageHandler<DimensionSyncPacket> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IMessage handleClientMessage(EntityPlayer player, DimensionSyncPacket message, MessageContext ctx) {
            block7: {
                if (Minecraft.func_71410_x().func_71356_B()) {
                    return null;
                }
                try {
                    int packetType = message.getStream().readInt();
                    if (packetType == 0) {
                        ClientPacketManager.registerClientWorlds(message.getStream(), ((ForgeEngine)OTG.getEngine()).getWorldLoader());
                        break block7;
                    }
                    throw new RuntimeException();
                }
                catch (Exception e) {
                    OTG.log(LogMarker.FATAL, "Failed to receive packet", new Object[0]);
                    OTG.printStackTrace(LogMarker.FATAL, e);
                }
                finally {
                    message.getData().release();
                }
            }
            return null;
        }
    }
}

