/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.pregenerator;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.dimensions.DimensionConfig;
import com.pg85.otg.configuration.standard.WorldStandardValues;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;

public class Pregenerator {
    private int currentX;
    private int currentZ;
    private boolean processing = false;
    private long startTime = System.currentTimeMillis();
    private int pregenerationRadius;
    private int cycle = 0;
    private int left = 0;
    private int right = 0;
    private int top = 0;
    private int bottom = 0;
    private int iLeft = Integer.MIN_VALUE;
    private int iRight = Integer.MIN_VALUE;
    private int iTop = Integer.MIN_VALUE;
    private int iBottom = Integer.MIN_VALUE;
    private int spawned = 0;
    private double total;
    private int spawnedThisTick = 0;
    private int lastSpawnedWhenSaved = 0;
    private int compressCustomStructureCacheThreshHold = 1000;
    private boolean pregeneratorIsRunning;
    private int maxSpawnPerTick;
    public String pregenerationWorld = "";
    public String preGeneratorProgressStatus = "";
    public String preGeneratorProgress = "";
    public String progressScreenElapsedTime = "";
    public String progressScreenEstimatedTime = "";
    public int progressScreenWorldSizeInBlocks;
    public long progressScreenServerUsedMbs = 0L;
    public long progressScreenServerTotalMbs = 0L;
    private long lastMessage = System.currentTimeMillis();
    private ForgeWorld world;
    private ChunkCoordinate preGeneratorCenterPoint;

    public Pregenerator(LocalWorld world) {
        this.world = (ForgeWorld)world;
        if (this.world.world != null) {
            this.loadPregeneratorData();
        }
        this.maxSpawnPerTick = OTG.getPluginConfig().pregeneratorMaxChunksPerTick;
        this.pregenerationWorld = world.getConfigs().getWorldConfig().getName();
    }

    public int getPregenerationRadius() {
        return this.pregenerationRadius;
    }

    public void setPregeneratorIsRunning(boolean pregeneratorIsRunning) {
        this.pregeneratorIsRunning = pregeneratorIsRunning;
    }

    public int setPregenerationRadius(int radius) {
        this.pregenerationRadius = radius > this.cycle && radius > 0 ? radius : this.cycle;
        if (this.world != null) {
            this.savePregeneratorData(true);
        }
        this.total = (this.pregenerationRadius * 2 + 1) * (this.pregenerationRadius * 2 + 1);
        return this.pregenerationRadius;
    }

    public int getPregenerationBorderLeft() {
        return this.left;
    }

    public int getPregenerationBorderRight() {
        return this.right;
    }

    public int getPregenerationBorderTop() {
        return this.top;
    }

    public int getPregenerationBorderBottom() {
        return this.bottom;
    }

    public ChunkCoordinate getPregenerationCenterPoint() {
        return this.preGeneratorCenterPoint;
    }

    public boolean getPregeneratorIsRunning() {
        return this.pregeneratorIsRunning;
    }

    public void processTick() {
        if (!this.processing) {
            this.processing = true;
            this.pregenerate();
            this.processing = false;
        }
    }

    private void pregenerate() {
        if ((double)this.spawned < this.total && this.pregenerationRadius > 0) {
            ChunkProviderServer chunkProvider = (ChunkProviderServer)this.world.getWorld().func_72863_F();
            if (chunkProvider == null) {
                this.pregeneratorIsRunning = false;
                return;
            }
            this.pregeneratorIsRunning = true;
            this.currentX = -this.pregenerationRadius;
            this.currentZ = -this.pregenerationRadius;
            boolean leftEdgeFound = this.left >= this.pregenerationRadius;
            boolean rightEdgeFound = this.right >= this.pregenerationRadius;
            boolean topEdgeFound = this.top >= this.pregenerationRadius;
            boolean bottomEdgeFound = this.bottom >= this.pregenerationRadius;
            this.spawnedThisTick = 0;
            int spawnChunkX = this.preGeneratorCenterPoint.getChunkX();
            int spawnChunkZ = this.preGeneratorCenterPoint.getChunkZ();
            while (!(leftEdgeFound && rightEdgeFound && topEdgeFound && bottomEdgeFound)) {
                int i;
                if (this.cycle == 0 && this.spawned == 0) {
                    this.pregenerateChunk(spawnChunkX, spawnChunkZ);
                    ++this.cycle;
                    if (this.spawnedThisTick >= this.maxSpawnPerTick) {
                        this.pause();
                        return;
                    }
                }
                if (!rightEdgeFound && this.iBottom == Integer.MIN_VALUE && this.iTop == Integer.MIN_VALUE && this.iRight < this.bottom) {
                    for (i = -this.top; i <= this.bottom; ++i) {
                        this.currentX = spawnChunkX + this.cycle;
                        this.currentZ = spawnChunkZ + i;
                        if (i <= this.iRight) continue;
                        this.iRight = i;
                        this.pregenerateChunk(this.currentX, this.currentZ);
                        if (this.spawnedThisTick < this.maxSpawnPerTick) continue;
                        if (i == this.bottom) {
                            ++this.right;
                            if (this.right >= this.pregenerationRadius) {
                                rightEdgeFound = true;
                            }
                        }
                        this.pause();
                        return;
                    }
                    ++this.right;
                    if (this.right >= this.pregenerationRadius) {
                        rightEdgeFound = true;
                    }
                }
                if (!leftEdgeFound && this.iBottom == Integer.MIN_VALUE && this.iTop == Integer.MIN_VALUE && this.iLeft < this.bottom) {
                    for (i = -this.top; i <= this.bottom; ++i) {
                        this.currentX = spawnChunkX - this.cycle;
                        this.currentZ = spawnChunkZ + i;
                        if (i <= this.iLeft) continue;
                        this.iLeft = i;
                        this.pregenerateChunk(this.currentX, this.currentZ);
                        if (this.spawnedThisTick < this.maxSpawnPerTick) continue;
                        if (i == this.bottom) {
                            ++this.left;
                            if (this.left >= this.pregenerationRadius) {
                                leftEdgeFound = true;
                            }
                        }
                        this.pause();
                        return;
                    }
                    ++this.left;
                    if (this.left >= this.pregenerationRadius) {
                        leftEdgeFound = true;
                    }
                }
                if (!bottomEdgeFound && this.iBottom < this.right) {
                    for (i = -this.left; i <= this.right; ++i) {
                        this.currentX = spawnChunkX + i;
                        this.currentZ = spawnChunkZ + this.cycle;
                        if (i <= this.iBottom) continue;
                        this.iBottom = i;
                        this.pregenerateChunk(this.currentX, this.currentZ);
                        if (this.spawnedThisTick < this.maxSpawnPerTick) continue;
                        if (i == this.right) {
                            ++this.bottom;
                            if (this.bottom >= this.pregenerationRadius) {
                                bottomEdgeFound = true;
                            }
                        }
                        this.pause();
                        return;
                    }
                    ++this.bottom;
                    if (this.bottom >= this.pregenerationRadius) {
                        bottomEdgeFound = true;
                    }
                }
                if (!topEdgeFound && this.iTop < this.right) {
                    for (i = -this.left; i <= this.right; ++i) {
                        this.currentX = spawnChunkX + i;
                        this.currentZ = spawnChunkZ - this.cycle;
                        if (i <= this.iTop) continue;
                        this.iTop = i;
                        this.pregenerateChunk(this.currentX, this.currentZ);
                        if (this.spawnedThisTick < this.maxSpawnPerTick) continue;
                        if (i == this.right) {
                            ++this.top;
                            if (this.top >= this.pregenerationRadius) {
                                topEdgeFound = true;
                            }
                        }
                        this.pause();
                        return;
                    }
                    ++this.top;
                    if (this.top >= this.pregenerationRadius) {
                        topEdgeFound = true;
                    }
                }
                this.iLeft = Integer.MIN_VALUE;
                this.iBottom = Integer.MIN_VALUE;
                this.iRight = Integer.MIN_VALUE;
                this.iTop = Integer.MIN_VALUE;
                ++this.cycle;
            }
            this.world.getChunkGenerator().clearChunkCache(false);
            this.world.getStructureCache().compressCache();
            this.savePregeneratorData(false);
        }
        this.pregeneratorIsRunning = false;
    }

    private void pause() {
        if ((double)this.spawned == this.total) {
            this.iLeft = Integer.MIN_VALUE;
            this.iBottom = Integer.MIN_VALUE;
            this.iRight = Integer.MIN_VALUE;
            this.iTop = Integer.MIN_VALUE;
            ++this.cycle;
            this.world.getChunkGenerator().clearChunkCache(false);
            this.world.getStructureCache().compressCache();
            this.savePregeneratorData(false);
        } else {
            this.processing = false;
        }
    }

    private void pregenerateChunk(int currentX, int currentZ) {
        ++this.spawned;
        ++this.spawnedThisTick;
        this.updateProgressMessage(true);
        ChunkProviderServer chunkProvider = (ChunkProviderServer)this.world.getWorld().func_72863_F();
        Chunk chunk = chunkProvider.func_186025_d(currentX, currentZ);
        if (!chunk.func_150802_k()) {
            chunk.func_76601_a(true);
            chunkProvider.func_186025_d(currentX, currentZ + 1).func_76601_a(true);
            chunkProvider.func_186025_d(currentX + 1, currentZ).func_76601_a(true);
            chunkProvider.func_186025_d(currentX + 1, currentZ + 1).func_76601_a(true);
        }
        if (this.spawned - this.lastSpawnedWhenSaved > this.compressCustomStructureCacheThreshHold) {
            this.lastSpawnedWhenSaved = this.spawned;
            this.world.getStructureCache().compressCache();
        }
    }

    private void updateProgressMessage(boolean loggingCanBeIgnored) {
        if ((double)this.spawned < this.total) {
            boolean dontLog = false;
            loggingCanBeIgnored = System.currentTimeMillis() - this.lastMessage < 1000L;
            if (loggingCanBeIgnored) {
                dontLog = true;
            } else {
                this.lastMessage = System.currentTimeMillis();
            }
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            int hours = (int)Math.floor((double)elapsedTime / 1000.0 / 60.0 / 60.0);
            int minutes = (int)Math.floor((double)elapsedTime / 1000.0 / 60.0) - hours * 60;
            int seconds = (int)Math.floor((double)elapsedTime / 1000.0) - minutes * 60 - hours * 60 * 60;
            String sElapsedTime = (hours < 10 ? "0" + hours : Integer.valueOf(hours)) + ":" + (minutes < 10 ? "0" + minutes : Integer.valueOf(minutes)) + ":" + (seconds < 10 ? "0" + seconds : Integer.valueOf(seconds));
            double eTA = this.total / (double)this.spawned * (double)elapsedTime - (double)elapsedTime;
            hours = (int)Math.floor(eTA / 1000.0 / 60.0 / 60.0);
            minutes = (int)Math.floor(eTA / 1000.0 / 60.0) - hours * 60;
            seconds = (int)Math.floor(eTA / 1000.0) - minutes * 60 - hours * 60 * 60;
            String estimatedTime = (hours < 10 ? "0" + hours : Integer.valueOf(hours)) + ":" + (minutes < 10 ? "0" + minutes : Integer.valueOf(minutes)) + ":" + (seconds < 10 ? "0" + seconds : Integer.valueOf(seconds));
            long i = Runtime.getRuntime().maxMemory();
            long j = Runtime.getRuntime().totalMemory();
            long k = Runtime.getRuntime().freeMemory();
            long l = j - k;
            String memoryUsage = " Mem: " + Long.valueOf(l * 100L / i) + "% " + Long.valueOf(this.bytesToMb(l)) + " / " + Long.valueOf(this.bytesToMb(i)) + " MB ";
            this.progressScreenWorldSizeInBlocks = (this.pregenerationRadius * 2 + 1) * 16;
            this.preGeneratorProgressStatus = this.spawned + "/" + (int)this.total;
            this.preGeneratorProgress = (int)Math.round((double)this.spawned / this.total * 100.0) + "";
            this.progressScreenElapsedTime = sElapsedTime;
            this.progressScreenEstimatedTime = estimatedTime;
            if (!dontLog) {
                OTG.log(LogMarker.INFO, "Pre-generating world \"" + this.pregenerationWorld + "\". Radius: " + this.cycle + "/" + this.pregenerationRadius + " Spawned: " + this.spawned + "/" + (int)this.total + " " + (int)Math.round((double)this.spawned / this.total * 100.0) + "% done. Elapsed: " + sElapsedTime + " ETA: " + estimatedTime + memoryUsage, new Object[0]);
            }
        } else {
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            int hours = (int)Math.floor((double)elapsedTime / 1000.0 / 60.0 / 60.0);
            int minutes = (int)Math.floor((double)elapsedTime / 1000.0 / 60.0) - hours * 60;
            int seconds = (int)Math.floor((double)elapsedTime / 1000.0) - minutes * 60 - hours * 60 * 60;
            String sElapsedTime = (hours < 10 ? "0" + hours : Integer.valueOf(hours)) + ":" + (minutes < 10 ? "0" + minutes : Integer.valueOf(minutes)) + ":" + (seconds < 10 ? "0" + seconds : Integer.valueOf(seconds));
            this.preGeneratorProgressStatus = "Done";
            this.preGeneratorProgress = "";
            this.progressScreenElapsedTime = "";
            this.progressScreenEstimatedTime = "";
            this.progressScreenWorldSizeInBlocks = 0;
            OTG.log(LogMarker.INFO, "Pre-generating chunks done for world " + this.pregenerationWorld + ", " + this.spawned + " chunks spawned in " + sElapsedTime, new Object[0]);
        }
    }

    private long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    public void shutDown() {
        if (this.pregeneratorIsRunning) {
            if (this.world.world != null) {
                this.savePregeneratorData(false);
            }
            this.pregeneratorIsRunning = false;
        }
    }

    public void savePregeneratorData() {
        if (this.world.world != null) {
            this.savePregeneratorData(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePregeneratorData(boolean forceSave) {
        if (this.pregeneratorIsRunning || forceSave) {
            int dimensionId = this.world.getDimensionId();
            File pregeneratedChunksFile = new File(this.world.getWorldSaveDir().getAbsolutePath() + File.separator + "OpenTerrainGenerator" + File.separator + (dimensionId != 0 ? "DIM-" + dimensionId + File.separator : "") + WorldStandardValues.PregeneratedChunksFileName);
            if (pregeneratedChunksFile.exists()) {
                pregeneratedChunksFile.delete();
            }
            StringBuilder stringbuilder = new StringBuilder();
            stringbuilder.append(this.spawned + "," + this.left + "," + this.top + "," + this.right + "," + this.bottom + "," + this.cycle + "," + (System.currentTimeMillis() - this.startTime) + "," + this.iTop + "," + this.iBottom + "," + this.iLeft + "," + this.iRight + "," + this.pregenerationRadius + "," + this.preGeneratorCenterPoint.getChunkX() + "," + this.preGeneratorCenterPoint.getChunkZ());
            BufferedWriter writer = null;
            try {
                pregeneratedChunksFile.getParentFile().mkdirs();
                writer = new BufferedWriter(new FileWriter(pregeneratedChunksFile));
                writer.write(stringbuilder.toString());
                OTG.log(LogMarker.DEBUG, "Pre-generator data saved", new Object[0]);
            }
            catch (IOException e) {
                OTG.log(LogMarker.ERROR, "Could not save pre-generator data.", new Object[0]);
                e.printStackTrace();
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPregeneratorData() {
        int dimensionId = this.world.getDimensionId();
        File pregeneratedChunksFile = new File(this.world.getWorldSaveDir().getAbsolutePath() + File.separator + "OpenTerrainGenerator" + File.separator + (dimensionId != 0 ? "DIM-" + dimensionId + File.separator : "") + WorldStandardValues.PregeneratedChunksFileName);
        String[] pregeneratedChunksFileValues = new String[]{};
        if (pregeneratedChunksFile.exists()) {
            try {
                StringBuilder stringbuilder = new StringBuilder();
                try (BufferedReader reader = new BufferedReader(new FileReader(pregeneratedChunksFile));){
                    String line = reader.readLine();
                    while (line != null) {
                        stringbuilder.append(line);
                        line = reader.readLine();
                    }
                    if (stringbuilder.length() > 0) {
                        pregeneratedChunksFileValues = stringbuilder.toString().split(",");
                    }
                    OTG.log(LogMarker.DEBUG, "Pre-generator data loaded", new Object[0]);
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        if (pregeneratedChunksFileValues.length > 0) {
            this.lastSpawnedWhenSaved = this.spawned = Integer.parseInt(pregeneratedChunksFileValues[0]);
            this.left = Integer.parseInt(pregeneratedChunksFileValues[1]);
            this.top = Integer.parseInt(pregeneratedChunksFileValues[2]);
            this.right = Integer.parseInt(pregeneratedChunksFileValues[3]);
            this.bottom = Integer.parseInt(pregeneratedChunksFileValues[4]);
            this.cycle = Math.min(Math.min(Math.min(this.left, this.top), this.right), this.bottom) + 1;
            this.startTime = System.currentTimeMillis() - Long.parseLong(pregeneratedChunksFileValues[6]);
            this.iTop = Integer.parseInt(pregeneratedChunksFileValues[7]);
            this.iBottom = Integer.parseInt(pregeneratedChunksFileValues[8]);
            this.iLeft = Integer.parseInt(pregeneratedChunksFileValues[9]);
            this.iRight = Integer.parseInt(pregeneratedChunksFileValues[10]);
            this.pregenerationRadius = Integer.parseInt(pregeneratedChunksFileValues[11]);
            this.preGeneratorCenterPoint = ChunkCoordinate.fromChunkCoords(Integer.parseInt(pregeneratedChunksFileValues[12]), Integer.parseInt(pregeneratedChunksFileValues[13]));
            this.total = (this.pregenerationRadius * 2 + 1) * (this.pregenerationRadius * 2 + 1);
        } else {
            this.spawned = 0;
            this.left = 0;
            this.top = 0;
            this.right = 0;
            this.bottom = 0;
            this.cycle = 0;
            this.startTime = System.currentTimeMillis();
            this.iTop = Integer.MIN_VALUE;
            this.iBottom = Integer.MIN_VALUE;
            this.iLeft = Integer.MIN_VALUE;
            this.iRight = Integer.MIN_VALUE;
            this.preGeneratorCenterPoint = this.world.getSpawnChunk();
            DimensionConfig dimConfig = OTG.getDimensionsConfig().getDimensionConfig(this.world.getName());
            this.setPregenerationRadius(dimConfig.PregeneratorRadiusInChunks);
            this.savePregeneratorData(false);
        }
    }
}

