/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.util;

import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.helpers.BlockHelper;
import com.pg85.otg.util.helpers.MaterialHelper;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;

public class ForgeMaterialData
implements LocalMaterialData {
    private final IBlockState blockData;

    private ForgeMaterialData(IBlockState blockData) {
        this.blockData = blockData;
    }

    public static ForgeMaterialData ofString(String input) throws InvalidConfigException {
        if (input.toLowerCase().equals("blank")) {
            return new ForgeMaterialData(null);
        }
        String newInput = input;
        Block block = Block.func_149684_b((String)newInput);
        if (block != null) {
            if (block == Blocks.field_150427_aO || block == Blocks.field_150367_z || block == Blocks.field_150400_ck || block == Blocks.field_150487_bG || block == Blocks.field_150389_bf || block == Blocks.field_150401_cl || block == Blocks.field_150481_bH || block == Blocks.field_150387_bl || block == Blocks.field_150476_ad || block == Blocks.field_185769_cV || block == Blocks.field_150370_cb || block == Blocks.field_180396_cN || block == Blocks.field_150372_bz || block == Blocks.field_150485_bF || block == Blocks.field_150390_bg || block == Blocks.field_150446_ar) {
                newInput = input + ":0";
            } else {
                return ForgeMaterialData.ofMinecraftBlock(block);
            }
        }
        try {
            return ForgeMaterialData.getMaterial0(newInput);
        }
        catch (NumberFormatException e) {
            throw new InvalidConfigException("Unknown material: " + input);
        }
    }

    private static ForgeMaterialData getMaterial0(String input) throws NumberFormatException, InvalidConfigException {
        DefaultMaterial defaultMaterial;
        Block block;
        String blockName = input;
        int blockData = -1;
        int splitIndex = input.lastIndexOf(":");
        if (splitIndex == -1) {
            splitIndex = input.lastIndexOf(".");
        }
        if (splitIndex != -1) {
            blockName = input.substring(0, splitIndex);
            blockData = Integer.parseInt(input.substring(splitIndex + 1));
        }
        if ((block = Block.func_149684_b((String)blockName)) == null && (defaultMaterial = DefaultMaterial.getMaterial(blockName)) != DefaultMaterial.UNKNOWN_BLOCK) {
            block = Block.func_149729_e((int)defaultMaterial.id);
            if (blockData == -1 && (block == Blocks.field_150427_aO || block == Blocks.field_150367_z || block == Blocks.field_150400_ck || block == Blocks.field_150487_bG || block == Blocks.field_150389_bf || block == Blocks.field_150401_cl || block == Blocks.field_150481_bH || block == Blocks.field_150387_bl || block == Blocks.field_150476_ad || block == Blocks.field_185769_cV || block == Blocks.field_150370_cb || block == Blocks.field_180396_cN || block == Blocks.field_150372_bz || block == Blocks.field_150485_bF || block == Blocks.field_150390_bg || block == Blocks.field_150446_ar)) {
                blockData = 0;
            }
        }
        if (block != null) {
            if (blockData == -1) {
                return ForgeMaterialData.ofMinecraftBlock(block);
            }
            try {
                return ForgeMaterialData.ofMinecraftBlockState(block.func_176203_a(blockData));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new InvalidConfigException("Illegal meta data for the block type, cannot use " + input);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidConfigException("Illegal block data for the block type, cannot use " + input);
            }
        }
        throw new InvalidConfigException("Unknown material: " + input);
    }

    private static ForgeMaterialData ofIds(int id, int data) {
        Block block = Block.func_149729_e((int)id);
        IBlockState blockData = block.func_176203_a(data);
        return ForgeMaterialData.ofMinecraftBlockState(blockData);
    }

    public static ForgeMaterialData ofDefaultMaterial(DefaultMaterial material, int data) {
        return ForgeMaterialData.ofIds(material.id, data);
    }

    public static ForgeMaterialData ofMinecraftBlock(Block block) {
        return ForgeMaterialData.ofMinecraftBlockState(block.func_176223_P());
    }

    public static ForgeMaterialData ofMinecraftBlockState(IBlockState blockData) {
        return new ForgeMaterialData(blockData);
    }

    @Override
    public LocalMaterialData withBlockData(int i) {
        if (this.blockData == null) {
            return this;
        }
        if (i == this.getBlockData()) {
            return this;
        }
        Block block = this.blockData.func_177230_c();
        return ForgeMaterialData.ofMinecraftBlockState(block.func_176203_a(i));
    }

    @Override
    public LocalMaterialData withDefaultBlockData() {
        if (this.blockData == null) {
            return this;
        }
        Block block = this.blockData.func_177230_c();
        return this.withBlockData(block.func_176201_c(block.func_176223_P()));
    }

    @Override
    public byte getBlockData() {
        return this.blockData == null ? (byte)0 : (byte)this.blockData.func_177230_c().func_176201_c(this.blockData);
    }

    @Override
    public int getBlockId() {
        return this.blockData == null ? 0 : Block.func_149682_b((Block)this.blockData.func_177230_c());
    }

    @Override
    public String getName() {
        boolean nonDefaultData;
        if (this.blockData == null) {
            return "Unknown";
        }
        Block block = this.blockData.func_177230_c();
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        byte data = this.getBlockData();
        boolean bl = nonDefaultData = !block.func_176223_P().equals(this.blockData);
        if (defaultMaterial == DefaultMaterial.UNKNOWN_BLOCK) {
            if (nonDefaultData) {
                return Block.field_149771_c.func_177774_c((Object)this.blockData.func_177230_c()) + ":" + data;
            }
            return ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.blockData.func_177230_c())).toString();
        }
        if (nonDefaultData) {
            return defaultMaterial.name() + ":" + this.getBlockData();
        }
        return defaultMaterial.name();
    }

    public IBlockState internalBlock() {
        return this.blockData;
    }

    @Override
    public boolean isMaterial(DefaultMaterial material) {
        return material.id == this.getBlockId();
    }

    @Override
    public boolean isLiquid() {
        return this.blockData == null ? false : this.blockData.func_185904_a().func_76224_d();
    }

    @Override
    public boolean isSolid() {
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        if (defaultMaterial != DefaultMaterial.UNKNOWN_BLOCK) {
            return defaultMaterial.isSolid();
        }
        return this.blockData == null ? false : this.blockData.func_185904_a().func_76220_a();
    }

    @Override
    public boolean isAir() {
        return this.blockData == null ? true : this.blockData.func_185904_a() == Material.field_151579_a;
    }

    @Override
    public boolean canFall() {
        return this.blockData == null ? false : this.blockData.func_177230_c() instanceof BlockFalling;
    }

    @Override
    public boolean canSnowFallOn() {
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        if (defaultMaterial != DefaultMaterial.UNKNOWN_BLOCK) {
            return defaultMaterial.canSnowFallOn();
        }
        return this.blockData == null ? false : this.blockData.func_185904_a().func_76220_a();
    }

    @Override
    public boolean isSmoothAreaAnchor(boolean allowWood, boolean ignoreWater) {
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        return (defaultMaterial.equals((Object)DefaultMaterial.ICE) || defaultMaterial.equals((Object)DefaultMaterial.PACKED_ICE) || defaultMaterial.equals((Object)DefaultMaterial.FROSTED_ICE) || this.isSolid() || !ignoreWater && this.isLiquid()) && (allowWood || !defaultMaterial.equals((Object)DefaultMaterial.LOG) && !defaultMaterial.equals((Object)DefaultMaterial.LOG_2)) && !defaultMaterial.equals((Object)DefaultMaterial.WATER_LILY);
    }

    @Override
    public LocalMaterialData rotate() {
        byte blockDataByte;
        int newData;
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        if (defaultMaterial != DefaultMaterial.UNKNOWN_BLOCK && (newData = BlockHelper.rotateData(defaultMaterial, blockDataByte = this.getBlockData())) != blockDataByte) {
            try {
                return MaterialHelper.readMaterial(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.blockData.func_177230_c())).toString() + ":" + newData);
            }
            catch (InvalidConfigException e) {
                e.printStackTrace();
                return null;
            }
        }
        return this;
    }

    @Override
    public LocalMaterialData rotate(int rotateTimes) {
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        if (defaultMaterial != DefaultMaterial.UNKNOWN_BLOCK) {
            int blockDataByte = 0;
            int newData = 0;
            for (int i = 0; i < rotateTimes; ++i) {
                blockDataByte = this.getBlockData();
                newData = BlockHelper.rotateData(defaultMaterial, blockDataByte);
            }
            if (newData != blockDataByte) {
                return ForgeMaterialData.ofMinecraftBlockState(this.blockData.func_177230_c().func_176203_a(newData));
            }
        }
        return this;
    }

    @Override
    public DefaultMaterial toDefaultMaterial() {
        if (this.blockData == null) {
            return DefaultMaterial.UNKNOWN_BLOCK;
        }
        return DefaultMaterial.getMaterial(this.getBlockId());
    }

    @Override
    public int hashCode() {
        return 65535 + this.getBlockId() * 16 + this.getBlockData();
    }

    @Override
    public int hashCodeWithoutBlockData() {
        return this.getBlockId();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ForgeMaterialData)) {
            return false;
        }
        ForgeMaterialData other = (ForgeMaterialData)obj;
        return this.blockData.equals(other.blockData);
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

