/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.resource;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.ConfigFunction;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.resource.SaplingType;
import com.pg85.otg.util.bo3.Rotation;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class SaplingGen
extends ConfigFunction<BiomeConfig> {
    private static final Map<Rotation, int[]> TREE_OFFSET = new EnumMap<Rotation, int[]>(Rotation.class);
    public SaplingType saplingType;
    private List<Double> treeChances;
    private List<String> treeNames;
    private List<CustomObject> trees;

    public SaplingGen(BiomeConfig biomeConfig, List<String> args) throws InvalidConfigException {
        super(biomeConfig);
        this.assureSize(3, args);
        this.saplingType = SaplingType.get(args.get(0));
        if (this.saplingType == null) {
            throw new InvalidConfigException("Unknown sapling type " + args.get(0));
        }
        this.trees = new ArrayList<CustomObject>();
        this.treeNames = new ArrayList<String>();
        this.treeChances = new ArrayList<Double>();
        for (int i = 1; i < args.size() - 1; i += 2) {
            String treeName = args.get(i);
            this.trees.add(SaplingGen.getTreeObject(treeName, biomeConfig.worldConfig.getName()));
            this.treeNames.add(treeName);
            this.treeChances.add(this.readDouble(args.get(i + 1), 1.0, 100.0));
        }
    }

    private static CustomObject getTreeObject(String objectName, String worldName) throws InvalidConfigException {
        CustomObject maybeTree = OTG.getCustomObjectManager().getGlobalObjects().getObjectByName(objectName, worldName);
        if (maybeTree == null) {
            throw new InvalidConfigException("Unknown object " + objectName);
        }
        if (!maybeTree.canSpawnAsTree()) {
            throw new InvalidConfigException("Cannot spawn " + objectName + " as tree");
        }
        return maybeTree;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        SaplingGen compare = (SaplingGen)other;
        return this.saplingType == compare.saplingType && (this.treeNames == null ? this.treeNames == compare.treeNames : this.treeNames.equals(compare.treeNames)) && (this.treeNames == null ? this.treeNames == compare.treeNames : this.treeNames.equals(compare.treeNames)) && (this.treeChances == null ? this.treeChances == compare.treeChances : this.treeChances.equals(compare.treeChances));
    }

    public int getPriority() {
        return -30;
    }

    public boolean growSapling(LocalWorld world, Random random, boolean isWideTree, int x, int y, int z) {
        for (int treeNumber = 0; treeNumber < this.trees.size(); ++treeNumber) {
            if (!((double)random.nextInt(100) < this.treeChances.get(treeNumber))) continue;
            CustomObject tree = this.trees.get(treeNumber);
            Rotation rotation = tree.canRotateRandomly() ? Rotation.getRandomRotation(random) : Rotation.NORTH;
            int spawnX = x;
            int spawnZ = z;
            if (isWideTree) {
                int[] offset = TREE_OFFSET.get((Object)rotation);
                spawnX += offset[0];
                spawnZ += offset[1];
            }
            if (!tree.spawnFromSapling(world, random, rotation, spawnX, y, spawnZ)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.trees != null ? this.trees.hashCode() : 0);
        hash = 37 * hash + (this.treeNames != null ? this.treeNames.hashCode() : 0);
        hash = 37 * hash + (this.treeChances != null ? this.treeChances.hashCode() : 0);
        hash = 37 * hash + (this.saplingType != null ? this.saplingType.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean isAnalogousTo(ConfigFunction<BiomeConfig> other) {
        return other.getClass().equals(this.getClass()) && this.saplingType.equals((Object)((SaplingGen)other).saplingType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Sapling(").append((Object)this.saplingType);
        for (int i = 0; i < this.treeNames.size(); ++i) {
            sb.append(",").append(this.treeNames.get(i)).append(",").append(this.treeChances.get(i));
        }
        return sb.append(')').toString();
    }

    static {
        TREE_OFFSET.put(Rotation.NORTH, new int[]{0, 0});
        TREE_OFFSET.put(Rotation.EAST, new int[]{1, 0});
        TREE_OFFSET.put(Rotation.SOUTH, new int[]{1, 1});
        TREE_OFFSET.put(Rotation.WEST, new int[]{0, 1});
    }
}

