/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.resource;

import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.resource.Resource;
import com.pg85.otg.generator.resource.Vein;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.helpers.RandomHelper;
import com.pg85.otg.util.materials.MaterialSet;
import java.util.List;
import java.util.Random;

public class VeinGen
extends Resource {
    int maxAltitude;
    private int maxRadius;
    int minAltitude;
    private int minRadius;
    int oreFrequency;
    int oreRarity;
    int oreSize;
    MaterialSet sourceBlocks;
    private double veinRarity;

    public VeinGen(BiomeConfig biomeConfig, List<String> args) throws InvalidConfigException {
        super(biomeConfig);
        this.assureSize(9, args);
        this.material = this.readMaterial(args.get(0));
        this.minRadius = this.readInt(args.get(1), 10, 200);
        this.maxRadius = this.readInt(args.get(2), this.minRadius, 201);
        this.veinRarity = this.readDouble(args.get(3), 1.0E-7, 100.0);
        this.oreSize = this.readInt(args.get(4), 1, 64);
        this.oreFrequency = this.readInt(args.get(5), 1, 100);
        this.oreRarity = this.readInt(args.get(6), 1, 100);
        this.minAltitude = this.readInt(args.get(7), 0, 255);
        this.maxAltitude = this.readInt(args.get(8), this.minAltitude, 256);
        this.sourceBlocks = this.readMaterials(args, 9);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        VeinGen compare = (VeinGen)other;
        return this.veinRarity == compare.veinRarity && this.minRadius == compare.minRadius && this.maxRadius == compare.maxRadius && this.oreSize == compare.oreSize && this.oreFrequency == compare.oreFrequency && this.oreRarity == compare.oreRarity && this.minAltitude == compare.minAltitude && this.maxAltitude == compare.maxAltitude && (this.sourceBlocks == null ? this.sourceBlocks == compare.sourceBlocks : this.sourceBlocks.equals(compare.sourceBlocks));
    }

    @Override
    public int getPriority() {
        return 9;
    }

    private Vein getVeinStartInChunk(LocalWorld world, int chunkX, int chunkZ) {
        Random random = RandomHelper.getRandomForCoords(chunkX, chunkZ, (long)(this.material.hashCode() * (this.minRadius + this.maxRadius + 100)) + world.getSeed());
        if (random.nextDouble() * 100.0 < this.veinRarity) {
            int veinX = chunkX * 16 + random.nextInt(16) + 8;
            int veinY = RandomHelper.numberInRange(random, this.minAltitude, this.maxAltitude);
            int veinZ = chunkZ * 16 + random.nextInt(16) + 8;
            int veinSize = RandomHelper.numberInRange(random, this.minRadius, this.maxRadius);
            return new Vein(veinX, veinY, veinZ, veinSize);
        }
        return null;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + super.hashCode();
        hash = 29 * hash + (int)(Double.doubleToLongBits(this.veinRarity) ^ Double.doubleToLongBits(this.veinRarity) >>> 32);
        hash = 29 * hash + this.minRadius;
        hash = 29 * hash + this.maxRadius;
        hash = 29 * hash + this.oreSize;
        hash = 29 * hash + this.oreFrequency;
        hash = 29 * hash + this.oreRarity;
        hash = 29 * hash + this.minAltitude;
        hash = 29 * hash + this.maxAltitude;
        hash = 29 * hash + (this.sourceBlocks != null ? this.sourceBlocks.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        String result = "Vein(" + this.material + "," + this.minRadius + "," + this.maxRadius + "," + this.veinRarity + ",";
        result = result + this.oreSize + "," + this.oreFrequency + "," + this.oreRarity + "," + this.minAltitude + "," + this.maxAltitude + this.makeMaterials(this.sourceBlocks) + ")";
        return result;
    }

    @Override
    public void spawn(LocalWorld world, Random random, boolean villageInChunk, int x, int z) {
    }

    @Override
    protected void spawnInChunk(LocalWorld world, Random random, boolean villageInChunk, ChunkCoordinate chunkCoord) {
        int searchRadius = (this.maxRadius + 15) / 16;
        int currentChunkX = chunkCoord.getChunkX();
        int currentChunkZ = chunkCoord.getChunkZ();
        for (int searchChunkX = currentChunkX - searchRadius; searchChunkX < currentChunkX + searchRadius; ++searchChunkX) {
            for (int searchChunkZ = currentChunkZ - searchRadius; searchChunkZ < currentChunkZ + searchRadius; ++searchChunkZ) {
                Vein vein = this.getVeinStartInChunk(world, searchChunkX, searchChunkZ);
                if (vein == null || !vein.reachesChunk(currentChunkX, currentChunkZ)) continue;
                vein.spawn(world, random, chunkCoord, this);
            }
        }
    }
}

