/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.surface;

import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.generator.ChunkBuffer;
import com.pg85.otg.generator.GeneratingChunk;
import com.pg85.otg.generator.surface.SurfaceGenerator;
import com.pg85.otg.util.helpers.MaterialHelper;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;

public class SimpleSurfaceGenerator
implements SurfaceGenerator {
    private final LocalMaterialData air = MaterialHelper.toLocalMaterialData(DefaultMaterial.AIR, 0);
    private final LocalMaterialData sandstone = MaterialHelper.toLocalMaterialData(DefaultMaterial.SANDSTONE, 0);
    private final LocalMaterialData red_sandstone = MaterialHelper.toLocalMaterialData(DefaultMaterial.RED_SANDSTONE, 0);

    @Override
    public LocalMaterialData getCustomBlockData(LocalWorld world, BiomeConfig biomeConfig, int xInWorld, int yInWorld, int zInWorld) {
        return null;
    }

    @Override
    public void spawn(long worldSeed, GeneratingChunk generatingChunk, ChunkBuffer chunkBuffer, BiomeConfig biomeConfig, int xInWorld, int zInWorld) {
        this.spawnColumn(biomeConfig.surfaceBlock, biomeConfig.groundBlock, generatingChunk, chunkBuffer, biomeConfig, xInWorld & 0xF, zInWorld & 0xF);
    }

    protected final void spawnColumn(LocalMaterialData defaultSurfaceBlock, LocalMaterialData defaultGroundBlock, GeneratingChunk generatingChunk, ChunkBuffer chunkBuffer, BiomeConfig biomeConfig, int x, int z) {
        WorldConfig worldConfig = biomeConfig.worldConfig;
        float currentTemperature = biomeConfig.biomeTemperature;
        int surfaceBlocksNoise = (int)(generatingChunk.getNoise(x, z) / 3.0 + 3.0 + generatingChunk.random.nextDouble() * 0.25);
        if (worldConfig.ceilingBedrock) {
            chunkBuffer.setBlock(x, generatingChunk.heightCap - 2, z, worldConfig.bedrockBlock);
        }
        LocalMaterialData currentSurfaceBlock = defaultSurfaceBlock;
        LocalMaterialData currentGroundBlock = defaultGroundBlock;
        int surfaceBlocksCount = -1;
        int currentWaterLevel = generatingChunk.getWaterLevel(x, z);
        for (int y = 255; y >= 0; --y) {
            if (generatingChunk.mustCreateBedrockAt(worldConfig, y)) {
                chunkBuffer.setBlock(x, y, z, worldConfig.bedrockBlock);
                continue;
            }
            LocalMaterialData blockOnCurrentPos = chunkBuffer.getBlock(x, y, z);
            if (blockOnCurrentPos.isAir()) {
                surfaceBlocksCount = -1;
                continue;
            }
            if (!blockOnCurrentPos.equals(biomeConfig.stoneBlock)) continue;
            if (surfaceBlocksCount == -1) {
                if (surfaceBlocksNoise <= 0 && !worldConfig.removeSurfaceStone) {
                    currentSurfaceBlock = this.air;
                    currentGroundBlock = biomeConfig.stoneBlock;
                } else if (y >= currentWaterLevel - 4 && y <= currentWaterLevel + 1) {
                    currentSurfaceBlock = defaultSurfaceBlock;
                    currentGroundBlock = defaultGroundBlock;
                }
                if (y < currentWaterLevel && y > worldConfig.waterLevelMin && currentSurfaceBlock.isAir()) {
                    currentSurfaceBlock = currentTemperature < 0.15f ? biomeConfig.iceBlock : biomeConfig.waterBlock;
                }
                surfaceBlocksCount = surfaceBlocksNoise;
                if (y >= currentWaterLevel - 1) {
                    chunkBuffer.setBlock(x, y, z, currentSurfaceBlock);
                    continue;
                }
                chunkBuffer.setBlock(x, y, z, currentGroundBlock);
                continue;
            }
            if (surfaceBlocksCount <= 0) continue;
            chunkBuffer.setBlock(x, y, z, currentGroundBlock);
            if (--surfaceBlocksCount != 0 || !currentGroundBlock.isMaterial(DefaultMaterial.SAND) || surfaceBlocksNoise <= 1) continue;
            surfaceBlocksCount = generatingChunk.random.nextInt(4) + Math.max(0, y - generatingChunk.getWaterLevel(x, z));
            currentGroundBlock = currentGroundBlock.getBlockData() == 1 ? this.red_sandstone : this.sandstone;
        }
    }

    @Override
    public String toString() {
        return "";
    }
}

