/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.network;

import com.pg85.otg.OTG;
import com.pg85.otg.common.BiomeIds;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.configuration.biome.BiomeConfigFinder;
import com.pg85.otg.configuration.biome.BiomeLoadInstruction;
import com.pg85.otg.configuration.io.FileSettingsReader;
import com.pg85.otg.configuration.io.FileSettingsWriter;
import com.pg85.otg.configuration.io.SettingsMap;
import com.pg85.otg.configuration.standard.BiomeStandardValues;
import com.pg85.otg.configuration.world.WorldConfig;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.network.ConfigProvider;
import com.pg85.otg.util.helpers.FileHelper;
import com.pg85.otg.util.minecraft.defaults.BiomeRegistryNames;
import com.pg85.otg.util.minecraft.defaults.DefaultBiome;
import com.pg85.otg.worldsave.BiomeIdData;
import com.pg85.otg.worldsave.WorldSaveData;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ServerConfigProvider
implements ConfigProvider {
    private static final int MAX_INHERITANCE_DEPTH = 15;
    private LocalWorld world;
    private File settingsDir;
    private WorldConfig worldConfig;
    private LocalBiome[] biomesByOTGId;
    private int biomesCount;

    public ServerConfigProvider(File settingsDir, LocalWorld world, File worldSaveFolder) {
        this.settingsDir = settingsDir;
        this.world = world;
        this.biomesByOTGId = new LocalBiome[world.getMaxBiomesCount()];
        this.loadSettings(worldSaveFolder, false);
    }

    @Override
    public WorldConfig getWorldConfig() {
        return this.worldConfig;
    }

    @Override
    public LocalBiome getBiomeByOTGIdOrNull(int id) {
        if (id < 0 || id > this.biomesByOTGId.length) {
            return null;
        }
        return this.biomesByOTGId[id];
    }

    private int getRequestedSavedId(String resourceLocation) {
        return this.world.getRegisteredBiomeId(resourceLocation);
    }

    @Override
    public LocalBiome[] getBiomeArrayByOTGId() {
        return this.biomesByOTGId;
    }

    private int getRequestedGenerationId(BiomeConfig biomeConfig) {
        Integer requestedGenerationId = DefaultBiome.getId(biomeConfig.getName());
        if (requestedGenerationId == null) {
            requestedGenerationId = biomeConfig.worldConfig.customBiomeGenerationIds.get(biomeConfig.getName());
        }
        if (requestedGenerationId == null) {
            return -1;
        }
        return requestedGenerationId;
    }

    private void loadSettings(File worldSaveFolder, boolean isReload) {
        SettingsMap worldConfigSettings = this.loadWorldConfig();
        this.loadBiomes(worldConfigSettings, worldSaveFolder, isReload);
        this.worldConfig.biomeGroupManager.processBiomeData(this.world);
    }

    private SettingsMap loadWorldConfig() {
        File worldConfigFile = new File(this.settingsDir, "WorldConfig.ini");
        SettingsMap settingsMap = FileSettingsReader.read(this.world.getName(), worldConfigFile);
        ArrayList<String> biomes = new ArrayList<String>();
        File biomesDirectory = new File(this.settingsDir, "WorldBiomes");
        this.addBiomesFromDirRecursive(biomes, biomesDirectory);
        this.worldConfig = new WorldConfig(this.settingsDir, settingsMap, this.world, biomes);
        FileSettingsWriter.writeToFile(this.worldConfig.getSettingsAsMap(), worldConfigFile, this.worldConfig.settingsMode);
        return settingsMap;
    }

    private void addBiomesFromDirRecursive(ArrayList<String> biomes, File biomesDirectory) {
        if (biomesDirectory.exists()) {
            for (File biomeConfig : biomesDirectory.listFiles()) {
                if (biomeConfig.isFile() && biomeConfig.getName().endsWith(BiomeStandardValues.BIOME_CONFIG_EXTENSION.getDefaultValue())) {
                    biomes.add(biomeConfig.getName().replace(BiomeStandardValues.BIOME_CONFIG_EXTENSION.getDefaultValue(), ""));
                    continue;
                }
                if (!biomeConfig.isDirectory()) continue;
                this.addBiomesFromDirRecursive(biomes, biomeConfig);
            }
        }
    }

    private void loadBiomes(SettingsMap worldConfigSettings, File worldSaveFolder, boolean isReload) {
        ArrayList<File> biomeDirs = new ArrayList<File>(2);
        biomeDirs.add(new File(this.settingsDir, this.correctOldBiomeConfigFolder(this.settingsDir)));
        biomeDirs.add(new File(OTG.getEngine().getOTGRootFolder(), "GlobalBiomes"));
        FileHelper.makeFolders(biomeDirs);
        HashSet<BiomeLoadInstruction> biomesToLoad = new HashSet<BiomeLoadInstruction>();
        if (worldConfigSettings.isNewConfig()) {
            Collection<? extends BiomeLoadInstruction> defaultBiomes = this.world.getDefaultBiomes();
            for (BiomeLoadInstruction biomeLoadInstruction : defaultBiomes) {
                this.worldConfig.worldBiomes.add(biomeLoadInstruction.getBiomeName());
                biomesToLoad.add(new BiomeLoadInstruction(biomeLoadInstruction.getBiomeName(), biomeLoadInstruction.getBiomeTemplate()));
            }
        }
        BiomeConfigFinder biomeConfigFinder = new BiomeConfigFinder(OTG.getPluginConfig().biomeConfigExtension);
        Map<String, BiomeConfigFinder.BiomeConfigStub> biomeConfigStubs = biomeConfigFinder.findBiomes(this.worldConfig, this.world, this.worldConfig.worldHeightScale, biomeDirs, biomesToLoad);
        Map<String, BiomeConfig> map = this.readAndWriteSettings(worldConfigSettings, biomeConfigStubs);
        String loadedBiomeNames = this.indexSettings(this.worldConfig.customBiomeGenerationIds, worldConfigSettings.isNewConfig(), map, worldSaveFolder, isReload);
        OTG.log(LogMarker.DEBUG, "{} biomes Loaded", this.biomesCount);
        OTG.log(LogMarker.DEBUG, "{}", loadedBiomeNames);
    }

    @Override
    public void reload() {
        Arrays.fill(this.biomesByOTGId, null);
        this.biomesCount = 0;
        this.loadSettings(this.world.getWorldSaveDir(), true);
    }

    private Map<String, BiomeConfig> readAndWriteSettings(SettingsMap worldConfigSettings, Map<String, BiomeConfigFinder.BiomeConfigStub> biomeConfigStubs) {
        HashMap<String, BiomeConfig> loadedBiomes = new HashMap<String, BiomeConfig>();
        for (BiomeConfigFinder.BiomeConfigStub biomeConfigStub : biomeConfigStubs.values()) {
            this.processInheritance(biomeConfigStubs, biomeConfigStub, 0);
            this.processMobInheritance(biomeConfigStubs, biomeConfigStub, 0);
            BiomeConfig biomeConfig = new BiomeConfig(biomeConfigStub.getLoadInstructions(), biomeConfigStub, biomeConfigStub.getSettings(), this.worldConfig);
            loadedBiomes.put(biomeConfigStub.getBiomeName(), biomeConfig);
            File writeFile = biomeConfigStub.getFile();
            if (!biomeConfig.biomeExtends.isEmpty()) {
                writeFile = new File(writeFile.getAbsolutePath() + ".inherited");
            }
            FileSettingsWriter.writeToFile(biomeConfig.getSettingsAsMap(), writeFile, this.worldConfig.settingsMode);
        }
        return loadedBiomes;
    }

    private String indexSettings(Map<String, Integer> worldBiomes, boolean isNewWorldConfig, Map<String, BiomeConfig> loadedBiomes, File worldSaveFolder, boolean isReload) {
        boolean bl;
        boolean hasWorldData;
        StringBuilder loadedBiomeNames = new StringBuilder();
        ArrayList<BiomeConfig> nonVirtualBiomesExisting = new ArrayList<BiomeConfig>();
        ArrayList<BiomeConfig> nonVirtualBiomes = new ArrayList<BiomeConfig>();
        ArrayList<BiomeConfig> virtualBiomesExisting = new ArrayList<BiomeConfig>();
        ArrayList<BiomeConfig> virtualBiomes = new ArrayList<BiomeConfig>();
        ArrayList<BiomeIdData> loadedBiomeIdData = BiomeIdData.loadBiomeIdData(worldSaveFolder);
        boolean bl2 = hasWorldData = loadedBiomeIdData != null;
        if (hasWorldData) {
            boolean bFound = false;
            for (BiomeIdData biomeIdData : loadedBiomeIdData) {
                if (!biomeIdData.biomeName.startsWith(this.world.getName() + "_")) continue;
                bFound = true;
                break;
            }
            if (!(hasWorldData = bFound)) {
                loadedBiomeIdData = null;
            }
        }
        for (Map.Entry<String, BiomeConfig> entry : loadedBiomes.entrySet()) {
            if (entry.getValue().replaceToBiomeName != null && entry.getValue().replaceToBiomeName.trim().length() > 0) {
                String string = BiomeRegistryNames.getRegistryNameForDefaultBiome(entry.getValue().replaceToBiomeName);
                if (string == null) continue;
                entry.getValue().replaceToBiomeName = string;
                continue;
            }
            String string = BiomeRegistryNames.getRegistryNameForDefaultBiome(entry.getValue().getName());
            if (string == null) continue;
            entry.getValue().replaceToBiomeName = string;
        }
        ArrayList<BiomeConfig> loadedBiomeList = new ArrayList<BiomeConfig>(loadedBiomes.values());
        if (!OTG.IsNewWorldBeingCreated && !hasWorldData && worldBiomes.size() > 0) {
            loadedBiomeIdData = new ArrayList();
            for (Map.Entry<String, Integer> entry : worldBiomes.entrySet()) {
                BiomeConfig biomeConfig = loadedBiomes.get(entry.getKey());
                loadedBiomeIdData.add(new BiomeIdData(this.world.getName() + "_" + entry.getKey(), entry.getValue(), entry.getValue() > 255 || biomeConfig.replaceToBiomeName != null && biomeConfig.replaceToBiomeName.trim().length() > 0 ? -1 : entry.getValue()));
            }
        }
        WorldSaveData worldSaveData = WorldSaveData.loadWorldSaveData(worldSaveFolder);
        boolean bl3 = bl = !hasWorldData || worldSaveData != null && worldSaveData.version == 6;
        if (worldSaveData == null) {
            WorldSaveData worldSaveData2 = new WorldSaveData(bl ? 6 : 8);
            WorldSaveData.saveWorldSaveData(worldSaveFolder, worldSaveData2);
        }
        if (bl) {
            Collections.sort(loadedBiomeList, new Comparator<BiomeConfig>(){

                @Override
                public int compare(BiomeConfig a, BiomeConfig b) {
                    return ServerConfigProvider.this.getRequestedGenerationId(a) - ServerConfigProvider.this.getRequestedGenerationId(b);
                }
            });
        }
        ArrayList<BiomeConfig> usedBiomes = loadedBiomeList;
        if (loadedBiomeIdData != null) {
            usedBiomes = new ArrayList();
            if (!hasWorldData && !OTG.IsNewWorldBeingCreated) {
                Iterator defaultBiomes = this.world.getDefaultBiomes();
                Iterator<Object> iterator = defaultBiomes.iterator();
                while (iterator.hasNext()) {
                    BiomeLoadInstruction defaultBiome = (BiomeLoadInstruction)iterator.next();
                    for (BiomeConfig biomeConfig : loadedBiomeList) {
                        if (!defaultBiome.getBiomeName().equals(biomeConfig.getName())) continue;
                        usedBiomes.add(biomeConfig);
                    }
                }
            }
            block5: for (BiomeIdData biomeIdData : loadedBiomeIdData) {
                if (!biomeIdData.biomeName.startsWith(this.world.getName() + "_")) continue;
                for (BiomeConfig biomeConfig : loadedBiomeList) {
                    if (!(this.world.getName() + "_" + biomeConfig.getName()).equals(biomeIdData.biomeName)) continue;
                    if (!usedBiomes.contains(biomeConfig)) {
                        usedBiomes.add(biomeConfig);
                    }
                    if (OTG.getEngine().isOTGBiomeIdAvailable(this.world.getName(), biomeIdData.otgBiomeId)) {
                        OTG.getEngine().setOTGBiomeId(this.world.getName(), biomeIdData.otgBiomeId, biomeConfig, false);
                    } else if ((this.world.getName() + "_" + OTG.getEngine().getOTGBiomeIds(this.world.getName())[biomeIdData.otgBiomeId].getName()).equals(biomeIdData.biomeName)) {
                        OTG.getEngine().setOTGBiomeId(this.world.getName(), biomeIdData.otgBiomeId, biomeConfig, true);
                    } else {
                        throw new RuntimeException("This shouldn't happen");
                    }
                    if (biomeIdData.otgBiomeId > -1 && biomeIdData.otgBiomeId < 256) {
                        if (biomeConfig.replaceToBiomeName != null && biomeConfig.replaceToBiomeName.trim().length() > 0) {
                            throw new RuntimeException("Error: Biome \"" + biomeConfig.getName() + "\" has an id between 0-255 but uses replaceToBiomeName. Virtual biomes must have id's above 255, please check your WorldConfig's custom biomes setting.");
                        }
                        nonVirtualBiomesExisting.add(biomeConfig);
                        continue block5;
                    }
                    if (biomeIdData.otgBiomeId <= 255) continue block5;
                    virtualBiomesExisting.add(biomeConfig);
                    continue block5;
                }
            }
        }
        for (BiomeConfig biomeConfig : usedBiomes) {
            int i;
            ++this.biomesCount;
            loadedBiomeNames.append(biomeConfig.getName());
            loadedBiomeNames.append(", ");
            BiomeConfig[] otgIds2 = OTG.getEngine().getOTGBiomeIds(this.world.getName());
            int otgBiomeId = -1;
            boolean bFound = false;
            for (i = 0; i < otgIds2.length; ++i) {
                BiomeConfig biomeConfig2 = otgIds2[i];
                if (biomeConfig == biomeConfig2) {
                    bFound = true;
                    break;
                }
                if (biomeConfig2 == null || !biomeConfig.getName().equals(biomeConfig2.getName()) || !biomeConfig.worldConfig.getName().equals(biomeConfig2.worldConfig.getName())) continue;
                OTG.getEngine().setOTGBiomeId(this.world.getName(), i, biomeConfig2, true);
                otgBiomeId = i;
                break;
            }
            if (bFound || otgBiomeId != -1) continue;
            int n = i = !biomeConfig.replaceToBiomeName.isEmpty() ? 256 : 0;
            while (i < otgIds2.length) {
                if (biomeConfig.replaceToBiomeName.isEmpty() && i > 255 || biomeConfig.replaceToBiomeName.isEmpty() && i >= OTG.getEngine().getOTGBiomeIds(this.world.getName()).length) {
                    OTG.log(LogMarker.FATAL, "Biome could not be registered, no free biome id's!", new Object[0]);
                    throw new RuntimeException("Biome could not be registered, no free biome id's!");
                }
                if (OTG.getEngine().isOTGBiomeIdAvailable(this.world.getName(), i)) {
                    otgBiomeId = i;
                    OTG.getEngine().setOTGBiomeId(this.world.getName(), i, biomeConfig, false);
                    break;
                }
                ++i;
            }
            if (otgBiomeId > -1 && otgBiomeId < 256) {
                nonVirtualBiomes.add(biomeConfig);
                continue;
            }
            if (otgBiomeId <= 255) continue;
            virtualBiomes.add(biomeConfig);
        }
        for (BiomeConfig biomeConfig : nonVirtualBiomesExisting) {
            this.createAndRegisterBiome(loadedBiomeIdData, biomeConfig, isReload);
        }
        for (BiomeConfig biomeConfig : virtualBiomesExisting) {
            this.createAndRegisterBiome(loadedBiomeIdData, biomeConfig, isReload);
        }
        for (BiomeConfig biomeConfig : nonVirtualBiomes) {
            this.createAndRegisterBiome(loadedBiomeIdData, biomeConfig, isReload);
        }
        for (BiomeConfig biomeConfig : virtualBiomes) {
            this.createAndRegisterBiome(loadedBiomeIdData, biomeConfig, isReload);
        }
        BiomeIdData.saveBiomeIdData(worldSaveFolder, this, this.world);
        ArrayList<LocalWorld> worlds = OTG.getAllWorlds();
        if (worlds != null) {
            for (LocalWorld world : worlds) {
                if (this.worldConfig.maxSmoothRadius >= world.getConfigs().getWorldConfig().maxSmoothRadius) continue;
                this.worldConfig.maxSmoothRadius = world.getConfigs().getWorldConfig().maxSmoothRadius;
            }
        }
        if (this.biomesCount > 0) {
            loadedBiomeNames.delete(loadedBiomeNames.length() - 2, loadedBiomeNames.length());
        }
        return loadedBiomeNames.toString();
    }

    private void createAndRegisterBiome(ArrayList<BiomeIdData> loadedBiomeIdData, BiomeConfig biomeConfig, boolean isReload) {
        LocalBiome biome;
        int i;
        int savedBiomeId = -1;
        if (loadedBiomeIdData != null) {
            for (BiomeIdData biomeIdData : loadedBiomeIdData) {
                if (!(this.world.getName() + "_" + biomeConfig.getName()).equals(biomeIdData.biomeName)) continue;
                savedBiomeId = biomeIdData.savedBiomeId;
                break;
            }
        }
        int otgBiomeId = -1;
        BiomeConfig[] otgIds2 = OTG.getEngine().getOTGBiomeIds(this.world.getName());
        for (i = 0; i < otgIds2.length; ++i) {
            if (otgIds2[i] != biomeConfig) continue;
            otgBiomeId = i;
            break;
        }
        if (otgBiomeId == -1) {
            OTG.log(LogMarker.FATAL, "Biome was not registered, most likely there were no id's available.", new Object[0]);
            throw new RuntimeException("Biome was not registered, most likely there were no id's available.");
        }
        if (!biomeConfig.replaceToBiomeName.isEmpty()) {
            String replaceToBiomeNameNew;
            String[] replaceToBiomeNameArr;
            for (i = 0; i < otgIds2.length; ++i) {
                if (otgIds2[i] == null || otgIds2[i].getName() != biomeConfig.replaceToBiomeName) continue;
                savedBiomeId = i;
                break;
            }
            if (savedBiomeId == -1) {
                savedBiomeId = this.getRequestedSavedId(biomeConfig.replaceToBiomeName);
            }
            if (savedBiomeId == -1 && (replaceToBiomeNameArr = biomeConfig.replaceToBiomeName.split(",")).length == 1 && (replaceToBiomeNameNew = BiomeRegistryNames.getRegistryNameForDefaultBiome(biomeConfig.replaceToBiomeName)) != null && (savedBiomeId = this.getRequestedSavedId(replaceToBiomeNameNew)) != -1) {
                biomeConfig.replaceToBiomeName = replaceToBiomeNameNew;
            }
            if (savedBiomeId == -1 || savedBiomeId > 255) {
                LocalBiome biome2 = this.world.getBiomeByNameOrNull(this.worldConfig.defaultOceanBiome);
                if (biome2 != null) {
                    savedBiomeId = biome2.getIds().getOTGBiomeId();
                } else {
                    savedBiomeId = this.getRequestedSavedId(biomeConfig.replaceToBiomeName);
                    OTG.log(LogMarker.FATAL, "ReplaceToBiomeName: " + biomeConfig.replaceToBiomeName + " for biome " + biomeConfig.getName() + " could not be found. Please note that it is not possible to ReplaceToBiomeName to a ReplaceToBiomeName biome. Please update your biome configs.", new Object[0]);
                    throw new RuntimeException("ReplaceToBiomeName: " + biomeConfig.replaceToBiomeName + " for biome " + biomeConfig.getName() + " could not be found. Please note that it is not possible to ReplaceToBiomeName to a ReplaceToBiomeName biome. Please update your biome configs.");
                }
            }
        }
        this.biomesByOTGId[biome.getIds().getOTGBiomeId()] = biome = this.world.createBiomeFor(biomeConfig, new BiomeIds(otgBiomeId, savedBiomeId), this, isReload);
        if (!this.worldConfig.biomeConfigsHaveReplacement) {
            this.worldConfig.biomeConfigsHaveReplacement = biomeConfig.replacedBlocks.hasReplaceSettings();
        }
        if (this.worldConfig.maxSmoothRadius < biomeConfig.smoothRadius) {
            this.worldConfig.maxSmoothRadius = biomeConfig.smoothRadius;
        }
        if (this.worldConfig.biomeMode == OTG.getBiomeModeManager().FROM_IMAGE) {
            if (this.worldConfig.biomeColorMap == null) {
                this.worldConfig.biomeColorMap = new HashMap();
            }
            int color = biomeConfig.biomeColor;
            this.worldConfig.biomeColorMap.put(color, biome.getIds().getOTGBiomeId());
        }
    }

    private void processInheritance(Map<String, BiomeConfigFinder.BiomeConfigStub> biomeConfigStubs, BiomeConfigFinder.BiomeConfigStub biomeConfigStub, int currentDepth) {
        if (biomeConfigStub.biomeExtendsProcessed) {
            return;
        }
        String extendedBiomeName = biomeConfigStub.getSettings().getSetting(BiomeStandardValues.BIOME_EXTENDS);
        if (extendedBiomeName.isEmpty()) {
            biomeConfigStub.biomeExtendsProcessed = true;
            return;
        }
        BiomeConfigFinder.BiomeConfigStub extendedBiomeConfig = biomeConfigStubs.get(extendedBiomeName);
        if (extendedBiomeConfig == null) {
            OTG.log(LogMarker.WARN, "The biome {} tried to extend the biome {}, but that biome doesn't exist.", biomeConfigStub.getBiomeName(), extendedBiomeName);
            return;
        }
        if (currentDepth > 15) {
            OTG.log(LogMarker.FATAL, "The biome {} cannot extend the biome {} - too much configs processed already! Cyclical inheritance?", biomeConfigStub.getBiomeName(), extendedBiomeConfig.getBiomeName());
        }
        if (!extendedBiomeConfig.biomeExtendsProcessed) {
            this.processInheritance(biomeConfigStubs, extendedBiomeConfig, currentDepth + 1);
        }
        biomeConfigStub.getSettings().setFallback(extendedBiomeConfig.getSettings());
        biomeConfigStub.biomeExtendsProcessed = true;
    }

    private void processMobInheritance(Map<String, BiomeConfigFinder.BiomeConfigStub> biomeConfigStubs, BiomeConfigFinder.BiomeConfigStub biomeConfigStub, int currentDepth) {
        if (biomeConfigStub.inheritMobsBiomeNameProcessed) {
            return;
        }
        String stubInheritMobsBiomeName = biomeConfigStub.getSettings().getSetting(BiomeStandardValues.INHERIT_MOBS_BIOME_NAME, biomeConfigStub.getLoadInstructions().getBiomeTemplate().defaultInheritMobsBiomeName);
        if (stubInheritMobsBiomeName != null && stubInheritMobsBiomeName.length() > 0) {
            String[] inheritMobsBiomeNames;
            for (String inheritMobsBiomeName : inheritMobsBiomeNames = stubInheritMobsBiomeName.split(",")) {
                if (inheritMobsBiomeName.isEmpty()) continue;
                BiomeConfigFinder.BiomeConfigStub inheritMobsBiomeConfig = biomeConfigStubs.get(inheritMobsBiomeName);
                if (inheritMobsBiomeConfig == null || inheritMobsBiomeConfig == biomeConfigStub) {
                    String vanillaBiomeName = BiomeRegistryNames.getRegistryNameForDefaultBiome(inheritMobsBiomeName);
                    if (vanillaBiomeName != null) {
                        inheritMobsBiomeConfig = null;
                        inheritMobsBiomeName = vanillaBiomeName;
                    } else if (inheritMobsBiomeConfig == biomeConfigStub) {
                        OTG.log(LogMarker.WARN, "The biome {} tried to inherit mobs from itself.", biomeConfigStub.getBiomeName());
                        continue;
                    }
                }
                if (currentDepth > 15) {
                    OTG.log(LogMarker.FATAL, "The biome {} cannot inherit mobs from biome {} - too much configs processed already! Cyclical inheritance?", biomeConfigStub.getFile().getName(), inheritMobsBiomeConfig.getFile().getName());
                }
                if (inheritMobsBiomeConfig != null) {
                    if (!inheritMobsBiomeConfig.inheritMobsBiomeNameProcessed) {
                        this.processMobInheritance(biomeConfigStubs, inheritMobsBiomeConfig, currentDepth + 1);
                    }
                    biomeConfigStub.mergeMobs(inheritMobsBiomeConfig);
                    continue;
                }
                this.world.mergeVanillaBiomeMobSpawnSettings(biomeConfigStub, inheritMobsBiomeName);
            }
            biomeConfigStub.inheritMobsBiomeNameProcessed = true;
        }
    }

    private String correctOldBiomeConfigFolder(File settingsDir) {
        String biomeFolderName = "WorldBiomes";
        File oldBiomeConfigs = new File(settingsDir, "BiomeConfigs");
        if (oldBiomeConfigs.exists() && !oldBiomeConfigs.renameTo(new File(settingsDir, biomeFolderName))) {
            OTG.log(LogMarker.WARN, "========================", new Object[0]);
            OTG.log(LogMarker.WARN, "Found old `BiomeConfigs` folder, but it could not be renamed to `", biomeFolderName, "`!");
            OTG.log(LogMarker.WARN, "Please rename the folder manually.", new Object[0]);
            OTG.log(LogMarker.WARN, "========================", new Object[0]);
            biomeFolderName = "BiomeConfigs";
        }
        return biomeFolderName;
    }

    @Override
    public List<LocalBiome> getBiomeArrayLegacy() {
        ArrayList<LocalBiome> nonDefaultbiomes = new ArrayList<LocalBiome>();
        LocalBiome[] defaultBiomes = new LocalBiome[256];
        for (LocalBiome biome : this.biomesByOTGId) {
            if (biome == null) continue;
            Integer defaultBiomeId = DefaultBiome.getId(biome.getName());
            if (defaultBiomeId != null) {
                defaultBiomes[defaultBiomeId.intValue()] = biome;
                continue;
            }
            nonDefaultbiomes.add(biome);
        }
        ArrayList<LocalBiome> outputBiomes = new ArrayList<LocalBiome>();
        for (LocalBiome biome : defaultBiomes) {
            if (biome == null) continue;
            outputBiomes.add(biome);
        }
        outputBiomes.addAll(nonDefaultbiomes);
        return outputBiomes;
    }
}

