/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.util.helpers;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.FifoMap;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;

public class MaterialHelper {
    private static FifoMap<String, LocalMaterialData> CachedMaterials = new FifoMap(4096);

    public static LocalMaterialData readMaterial(String name) throws InvalidConfigException {
        if (name == null) {
            return null;
        }
        LocalMaterialData material = (LocalMaterialData)CachedMaterials.get(name);
        if (material != null) {
            return material;
        }
        if (CachedMaterials.containsKey(name)) {
            throw new InvalidConfigException("Cannot read block: " + name);
        }
        String originalName = name;
        if (name.toLowerCase().equals("snow")) {
            name = "SNOW_LAYER";
        }
        if (name.toLowerCase().equals("water")) {
            name = "FLOWING_WATER";
        }
        if (name.toLowerCase().equals("lava")) {
            name = "FLOWING_LAVA";
        }
        try {
            material = OTG.getEngine().readMaterial(name);
        }
        catch (InvalidConfigException ex) {
            CachedMaterials.put(originalName, null);
            throw ex;
        }
        CachedMaterials.put(originalName, material);
        return material;
    }

    public static LocalMaterialData toLocalMaterialData(DefaultMaterial defaultMaterial, int blockData) {
        return OTG.getEngine().toLocalMaterialData(defaultMaterial, blockData);
    }
}

