/*
 * Decompiled with CFR 0.152.
 */
package com.homicidal_lemon.oremaggedon.world;

import com.google.common.base.Predicate;
import com.homicidal_lemon.oremaggedon.init.ModBlocks;
import com.homicidal_lemon.oremaggedon.util.handlers.ConfigHandler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenCustomOres
implements IWorldGenerator {
    private WorldGenerator silverfish_nest;
    private WorldGenerator celestial_stone;
    private WorldGenerator fossil_ore_bone = new WorldGenMinable(ModBlocks.FOSSIL_BONE.func_176223_P(), ConfigHandler.FOSSIL_BONE_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
    private WorldGenerator fossil_ore = new WorldGenMinable(ModBlocks.FOSSIL_ORE.func_176223_P(), ConfigHandler.FOSSIL_ORE_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
    private WorldGenerator sulphur_ore = new WorldGenMinable(ModBlocks.SULPHUR_ORE.func_176223_P(), ConfigHandler.SULPHUR_ORE_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
    private WorldGenerator sulphur_ore_2 = new WorldGenMinable(ModBlocks.SULPHUR_ORE.func_176223_P(), ConfigHandler.SULPHUR_ORE_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
    private WorldGenerator sulphur_ore_3 = new WorldGenMinable(ModBlocks.SULPHUR_ORE.func_176223_P(), ConfigHandler.SULPHUR_ORE_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
    private WorldGenerator sulphur_ore_4 = new WorldGenMinable(ModBlocks.SULPHUR_ORE.func_176223_P(), ConfigHandler.SULPHUR_ORE_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
    private WorldGenerator stalactite_stone;
    private WorldGenerator stalactite_stone_small;
    private WorldGenerator celestial_end_stone;
    private WorldGenerator netherrack_gold_ore;
    private WorldGenerator netherrack_sulphur_ore;
    private WorldGenerator netherrack_hellfire_ore;
    private WorldGenerator netherrack_gold_ore_2;
    private WorldGenerator netherrack_sulphur_ore_2;
    private WorldGenerator netherrack_hellfire_ore_2;
    private WorldGenerator nether_gold_ore;
    private WorldGenerator nether_sulphur_ore;
    private WorldGenerator basalt;
    private WorldGenerator basalt_quartz_ore;
    private WorldGenerator hellfire_ore;
    private WorldGenerator cobblestone;
    private WorldGenerator dead_mossy_stone;
    private WorldGenerator mossy_stone;
    private WorldGenerator crying_obsidian;
    private WorldGenerator mycelium_spores;
    private WorldGenerator sandstone_coal_ore;
    private WorldGenerator sandstone_iron_ore;
    private WorldGenerator morphite;
    private WorldGenerator infested_end_stone;
    private WorldGenerator web_stone;
    private WorldGenerator glowshroom_stone;
    private WorldGenerator large_mushroom_stone;
    private WorldGenerator basalt_vein;
    private WorldGenerator large_mushroom_stone_nether;
    private WorldGenerator soul_sand_vein;
    private WorldGenerator gravel_vein;

    public WorldGenCustomOres() {
        this.celestial_stone = new WorldGenMinable(ModBlocks.CELESTIAL_STONE.func_176223_P(), ConfigHandler.CELESTIAL_STONE_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        this.silverfish_nest = new WorldGenMinable(ModBlocks.SILVERFISH_NEST.func_176223_P(), ConfigHandler.SILVERFISH_NEST_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        this.stalactite_stone = new WorldGenMinable(ModBlocks.STALACTITE_STONE.func_176223_P(), 3, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        this.stalactite_stone_small = new WorldGenMinable(ModBlocks.STALACTITE_STONE_SMALL.func_176223_P(), 3, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        this.web_stone = new WorldGenMinable(ModBlocks.WEB_STONE.func_176223_P(), 3, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        this.glowshroom_stone = new WorldGenMinable(ModBlocks.GLOWSHROOM_STONE.func_176223_P(), 3, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        this.large_mushroom_stone = new WorldGenMinable(ModBlocks.LARGE_MUSHROOM_STONE.func_176223_P(), 3, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        this.infested_end_stone = new WorldGenMinable(ModBlocks.INFESTED_END_STONE.func_176223_P(), ConfigHandler.INFESTED_END_STONE_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs));
        this.celestial_end_stone = new WorldGenMinable(ModBlocks.CELESTIAL_END_STONE.func_176223_P(), ConfigHandler.CELESTIAL_END_STONE_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs));
        this.morphite = new WorldGenMinable(ModBlocks.MORPHITE_ORE.func_176223_P(), ConfigHandler.MORPHITE_ORE_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150377_bs));
        this.crying_obsidian = new WorldGenMinable(ModBlocks.CRYING_OBSIDIAN.func_176223_P(), ConfigHandler.CRYING_OBSIDIAN_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150343_Z));
        this.netherrack_sulphur_ore = new WorldGenMinable(ModBlocks.NETHERRACK_SULPHUR_ORE.func_176223_P(), ConfigHandler.NETHER_SULPHUR_ORE_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
        this.netherrack_hellfire_ore = new WorldGenMinable(ModBlocks.NETHERRACK_HELLFIRE_ORE.func_176223_P(), ConfigHandler.HELLFIRE_ORE_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
        this.netherrack_gold_ore = new WorldGenMinable(ModBlocks.NETHERRACK_GOLD_ORE.func_176223_P(), ConfigHandler.NETHER_GOLD_ORE_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
        this.netherrack_sulphur_ore_2 = new WorldGenMinable(ModBlocks.NETHERRACK_SULPHUR_ORE.func_176223_P(), ConfigHandler.NETHER_SULPHUR_ORE_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
        this.netherrack_hellfire_ore_2 = new WorldGenMinable(ModBlocks.NETHERRACK_HELLFIRE_ORE.func_176223_P(), ConfigHandler.HELLFIRE_ORE_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
        this.netherrack_gold_ore_2 = new WorldGenMinable(ModBlocks.NETHERRACK_GOLD_ORE.func_176223_P(), ConfigHandler.NETHER_GOLD_ORE_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
        this.nether_sulphur_ore = new WorldGenMinable(ModBlocks.NETHER_SULPHUR_ORE.func_176223_P(), ConfigHandler.NETHER_SULPHUR_ORE_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
        this.hellfire_ore = new WorldGenMinable(ModBlocks.HELLFIRE_ORE.func_176223_P(), ConfigHandler.HELLFIRE_ORE_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
        this.basalt_quartz_ore = new WorldGenMinable(ModBlocks.BASALT_QUARTZ_ORE.func_176223_P(), 14, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
        this.nether_gold_ore = new WorldGenMinable(ModBlocks.NETHER_GOLD_ORE.func_176223_P(), ConfigHandler.NETHER_GOLD_ORE_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
        this.basalt = new WorldGenMinable(ModBlocks.BASALT.func_176223_P(), 33, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
        this.basalt_vein = new WorldGenMinable(ModBlocks.BASALT.func_176223_P(), ConfigHandler.BASALT_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
        this.soul_sand_vein = new WorldGenMinable(Blocks.field_150425_aM.func_176223_P(), ConfigHandler.SOUL_SAND_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
        this.mycelium_spores = new WorldGenMinable(ModBlocks.MYCELIUM_SPORES.func_176223_P(), 3, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150391_bh));
        this.sandstone_coal_ore = new WorldGenMinable(ModBlocks.SANDSTONE_COAL_ORE.func_176223_P(), 17, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150322_A));
        this.sandstone_iron_ore = new WorldGenMinable(ModBlocks.SANDSTONE_IRON_ORE.func_176223_P(), 8, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150322_A));
        this.cobblestone = new WorldGenMinable(Blocks.field_150347_e.func_176223_P(), ConfigHandler.RANDOM_COBBLESTONE_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        this.mossy_stone = new WorldGenMinable(ModBlocks.OVERGROWN_STONE.func_176223_P(), ConfigHandler.RANDOM_MOSS_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        this.dead_mossy_stone = new WorldGenMinable(ModBlocks.DEAD_OVERGROWN_STONE.func_176223_P(), ConfigHandler.RANDOM_DEAD_MOSS_VEIN_SIZE, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
        this.large_mushroom_stone_nether = new WorldGenMinable(ModBlocks.LARGE_MUSHROOM_STONE_NETHER.func_176223_P(), 3, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case -1: {
                if (ConfigHandler.BASALT && ConfigHandler.BASALT) {
                    this.runGenerator(this.basalt, world, random, chunkX, chunkZ, 350, 0, 35);
                }
                if (ConfigHandler.NETHER_SULPHUR_ORE != 0) {
                    this.runGenerator(this.netherrack_sulphur_ore_2, world, random, chunkX, chunkZ, ConfigHandler.NETHER_SULPHUR_ORE, ConfigHandler.NETHER_SULPHUR_ORE_MIN_HEIGHT, ConfigHandler.NETHER_SULPHUR_ORE_MAX_HEIGHT);
                }
                if (ConfigHandler.HELLFIRE_ORE != 0) {
                    this.runGenerator(this.netherrack_hellfire_ore_2, world, random, chunkX, chunkZ, ConfigHandler.HELLFIRE_ORE, ConfigHandler.HELLFIRE_ORE_MIN_HEIGHT, ConfigHandler.HELLFIRE_ORE_MAX_HEIGHT);
                }
                if (ConfigHandler.NETHER_GOLD_ORE != 0) {
                    this.runGenerator(this.netherrack_gold_ore_2, world, random, chunkX, chunkZ, ConfigHandler.NETHER_GOLD_ORE, ConfigHandler.NETHER_GOLD_ORE_MIN_HEIGHT, ConfigHandler.NETHER_GOLD_ORE_MAX_HEIGHT);
                }
                if (ConfigHandler.BASALT_VEIN != 0) {
                    this.runGenerator(this.basalt_vein, world, random, chunkX, chunkZ, ConfigHandler.BASALT_VEIN, ConfigHandler.BASALT_VEIN_MIN_HEIGHT, ConfigHandler.BASALT_VEIN_MAX_HEIGHT);
                }
                if (ConfigHandler.SOUL_SAND_VEIN != 0) {
                    this.runGenerator(this.soul_sand_vein, world, random, chunkX, chunkZ, ConfigHandler.SOUL_SAND_VEIN, ConfigHandler.SOUL_SAND_VEIN_MIN_HEIGHT, ConfigHandler.SOUL_SAND_VEIN_MAX_HEIGHT);
                }
                if (ConfigHandler.WILD_LARGE_MUSHROOM_NETHER == 0) break;
                this.runGenerator(this.large_mushroom_stone_nether, world, random, chunkX, chunkZ, ConfigHandler.WILD_LARGE_MUSHROOM_NETHER, ConfigHandler.WILD_LARGE_MUSHROOM_NETHER_MIN_HEIGHT, ConfigHandler.WILD_LARGE_MUSHROOM_NETHER_MAX_HEIGHT);
                break;
            }
            case 0: {
                if (ConfigHandler.RANDOM_SPORES != 0) {
                    this.runGenerator(this.mycelium_spores, world, random, chunkX, chunkZ, ConfigHandler.RANDOM_SPORES, 40, 128);
                }
                if (ConfigHandler.SANDSTONE_ORES) {
                    this.runGenerator(this.sandstone_coal_ore, world, random, chunkX, chunkZ, 5, 30, 62);
                    this.runGenerator(this.sandstone_iron_ore, world, random, chunkX, chunkZ, 10, 30, 62);
                }
                if (ConfigHandler.RANDOM_COBBLESTONE != 0) {
                    this.runGenerator(this.cobblestone, world, random, chunkX, chunkZ, ConfigHandler.RANDOM_COBBLESTONE, ConfigHandler.RANDOM_COBBLESTONE_MIN_HEIGHT, ConfigHandler.RANDOM_COBBLESTONE_MAX_HEIGHT);
                }
                if (ConfigHandler.RANDOM_DEAD_MOSS != 0) {
                    this.runGenerator(this.dead_mossy_stone, world, random, chunkX, chunkZ, ConfigHandler.RANDOM_DEAD_MOSS, ConfigHandler.RANDOM_DEAD_MOSS_MIN_HEIGHT, ConfigHandler.RANDOM_DEAD_MOSS_MAX_HEIGHT);
                }
                if (ConfigHandler.RANDOM_MOSS != 0) {
                    this.runGenerator(this.mossy_stone, world, random, chunkX, chunkZ, ConfigHandler.RANDOM_MOSS, ConfigHandler.RANDOM_MOSS_MIN_HEIGHT, ConfigHandler.RANDOM_MOSS_MAX_HEIGHT);
                }
                if (ConfigHandler.FOSSIL_BONE != 0) {
                    this.runGenerator(this.fossil_ore_bone, world, random, chunkX, chunkZ, ConfigHandler.FOSSIL_BONE, ConfigHandler.FOSSIL_BONE_MIN_HEIGHT, ConfigHandler.FOSSIL_BONE_MAX_HEIGHT);
                }
                if (ConfigHandler.FOSSIL_ORE != 0) {
                    this.runGenerator(this.fossil_ore, world, random, chunkX, chunkZ, ConfigHandler.FOSSIL_ORE, ConfigHandler.FOSSIL_ORE_MIN_HEIGHT, ConfigHandler.FOSSIL_ORE_MAX_HEIGHT);
                }
                if (ConfigHandler.SULPHUR_ORE != 0) {
                    this.runGenerator(this.sulphur_ore, world, random, chunkX, chunkZ, ConfigHandler.SULPHUR_ORE, 13, 16);
                    this.runGenerator(this.sulphur_ore_2, world, random, chunkX, chunkZ, ConfigHandler.SULPHUR_ORE * 2, 9, 12);
                    this.runGenerator(this.sulphur_ore_3, world, random, chunkX, chunkZ, ConfigHandler.SULPHUR_ORE * 4, 5, 8);
                    this.runGenerator(this.sulphur_ore_4, world, random, chunkX, chunkZ, ConfigHandler.SULPHUR_ORE * 8, 0, 4);
                }
                if (ConfigHandler.SILVERFISH_NEST != 0) {
                    this.runGenerator(this.silverfish_nest, world, random, chunkX, chunkZ, ConfigHandler.SILVERFISH_NEST, ConfigHandler.SILVERFISH_NEST_MIN_HEIGHT, ConfigHandler.SILVERFISH_NEST_MAX_HEIGHT);
                }
                if (ConfigHandler.STALACTITE_LARGE != 0) {
                    this.runGenerator(this.stalactite_stone, world, random, chunkX, chunkZ, ConfigHandler.STALACTITE_LARGE, ConfigHandler.STALACTITE_LARGE_MIN_HEIGHT, ConfigHandler.STALACTITE_LARGE_MAX_HEIGHT);
                }
                if (ConfigHandler.STALACTITE_SMALL != 0) {
                    this.runGenerator(this.stalactite_stone_small, world, random, chunkX, chunkZ, ConfigHandler.STALACTITE_SMALL, ConfigHandler.STALACTITE_SMALL_MIN_HEIGHT, ConfigHandler.STALACTITE_SMALL_MAX_HEIGHT);
                }
                if (ConfigHandler.WEBS != 0) {
                    this.runGenerator(this.web_stone, world, random, chunkX, chunkZ, ConfigHandler.WEBS, ConfigHandler.WEBS_MIN_HEIGHT, ConfigHandler.WEBS_MAX_HEIGHT);
                }
                if (ConfigHandler.WILD_GLOWSHROOM != 0) {
                    this.runGenerator(this.glowshroom_stone, world, random, chunkX, chunkZ, ConfigHandler.WILD_GLOWSHROOM, ConfigHandler.WILD_GLOWSHROOM_MIN_HEIGHT, ConfigHandler.WILD_GLOWSHROOM_MAX_HEIGHT);
                }
                if (ConfigHandler.WILD_LARGE_MUSHROOM == 0) break;
                this.runGenerator(this.large_mushroom_stone, world, random, chunkX, chunkZ, ConfigHandler.WILD_LARGE_MUSHROOM, ConfigHandler.WILD_LARGE_MUSHROOM_MIN_HEIGHT, ConfigHandler.WILD_LARGE_MUSHROOM_MAX_HEIGHT);
                break;
            }
            case 1: {
                if (ConfigHandler.CELESTIAL_END_STONE != 0) {
                    this.runGenerator(this.celestial_end_stone, world, random, chunkX, chunkZ, ConfigHandler.CELESTIAL_END_STONE, ConfigHandler.CELESTIAL_END_STONE_MIN_HEIGHT, ConfigHandler.CELESTIAL_END_STONE_MAX_HEIGHT);
                }
                if (ConfigHandler.MORPHITE_ORE != 0) {
                    this.runGenerator(this.morphite, world, random, chunkX, chunkZ, ConfigHandler.MORPHITE_ORE, ConfigHandler.MORPHITE_ORE_MIN_HEIGHT, ConfigHandler.MORPHITE_ORE_MAX_HEIGHT);
                }
                if (ConfigHandler.INFESTED_END_STONE != 0) {
                    this.runGenerator(this.infested_end_stone, world, random, chunkX, chunkZ, ConfigHandler.INFESTED_END_STONE, ConfigHandler.INFESTED_END_STONE_MIN_HEIGHT, ConfigHandler.INFESTED_END_STONE_MAX_HEIGHT);
                }
                if (ConfigHandler.CRYING_OBSIDIAN == 0) break;
                this.runGenerator(this.crying_obsidian, world, random, chunkX, chunkZ, ConfigHandler.CRYING_OBSIDIAN, ConfigHandler.CRYING_OBSIDIAN_MIN_HEIGHT, ConfigHandler.CRYING_OBSIDIAN_MAX_HEIGHT);
            }
        }
    }

    private void runGenerator(WorldGenerator gen, World world, Random rand, int chunkX, int chunkZ, int chance, int minHeight, int maxHeight) {
        if (minHeight > maxHeight || minHeight < 0 || maxHeight > 256) {
            throw new IllegalArgumentException("Ore generated out of bounds");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chance; ++i) {
            int x = chunkX * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunkZ * 16 + rand.nextInt(16);
            gen.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }
}

