/*
 * Decompiled with CFR 0.152.
 */
package com.homicidal_lemon.oremaggedon.world.structures;

import com.homicidal_lemon.oremaggedon.util.handlers.ConfigHandler;
import com.homicidal_lemon.oremaggedon.world.structures.WorldGenStructure;
import com.homicidal_lemon.oremaggedon.world.structures.WorldGenStructure2;
import com.homicidal_lemon.oremaggedon.world.structures.WorldGenStructure3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenCustomStructures
implements IWorldGenerator {
    public final WorldGenStructure LARGE_DUNGEON = new WorldGenStructure("large_dungeon");
    public final WorldGenStructure LARGE_DUNGEON_2 = new WorldGenStructure("large_dungeon_2");
    public final WorldGenStructure2 VERY_LARGE_DUNGEON = new WorldGenStructure2("very_large_dungeon");
    public final WorldGenStructure3 CAVE_VILLAGE = new WorldGenStructure3("cave_village");

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case -1: {
                break;
            }
            case 0: {
                if (ConfigHandler.STRUCTURE_RARITY == 0) break;
                if (ConfigHandler.LARGE_DUNGEON) {
                    this.generateStructures(this.LARGE_DUNGEON, world, random, chunkX, chunkZ, ConfigHandler.STRUCTURE_RARITY, Blocks.field_150348_b, new Class[0]);
                }
                if (ConfigHandler.LARGE_DUNGEON) {
                    this.generateStructures(this.LARGE_DUNGEON_2, world, random, chunkX, chunkZ, ConfigHandler.STRUCTURE_RARITY, Blocks.field_150348_b, new Class[0]);
                }
                if (ConfigHandler.VERY_LARGE_DUNGEON) {
                    this.generateStructures(this.VERY_LARGE_DUNGEON, world, random, chunkX, chunkZ, ConfigHandler.STRUCTURE_RARITY, Blocks.field_150348_b, new Class[0]);
                }
                if (!ConfigHandler.CAVE_VILLAGES) break;
                this.generateStructures(this.CAVE_VILLAGE, world, random, chunkX, chunkZ, ConfigHandler.STRUCTURE_RARITY, Blocks.field_150348_b, new Class[0]);
                break;
            }
            case 1: {
                break;
            }
        }
    }

    private void generateStructures(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, int chance, Block topBlock, Class<?> ... classes) {
        ArrayList classesList = new ArrayList(Arrays.asList(classes));
        int x = chunkX * 16 + random.nextInt(15);
        int z = chunkZ * 16 + random.nextInt(15);
        int y = WorldGenCustomStructures.calculateGenerationHeight(world, x, z, topBlock);
        BlockPos pos = new BlockPos(x, ConfigHandler.STRUCTURE_MIN_HEIGHT + random.nextInt(ConfigHandler.STRUCTURE_MAX_HEIGHT - ConfigHandler.STRUCTURE_MIN_HEIGHT), z);
        Class<?> biome = world.field_73011_w.getBiomeForCoords(pos).getClass();
        if (world.func_175624_G() != WorldType.field_77138_c && (classesList.contains(biome) || classesList.isEmpty()) && random.nextInt(chance) == 0) {
            generator.func_180709_b(world, random, pos);
        }
    }

    private static int calculateGenerationHeight(World world, int x, int z, Block topBlock) {
        int y = world.func_72800_K();
        boolean foundGround = false;
        while (!foundGround && y-- >= 16) {
            Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = block == topBlock;
        }
        return y;
    }
}

