/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.component;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.registry.ModComponents;
import io.github.apace100.origins.registry.ModRegistries;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nerdhub.cardinal.components.api.ComponentType;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class PlayerOriginComponent
implements OriginComponent {
    private class_1657 player;
    private Origin origin;
    private HashMap<PowerType<?>, Power> powers = new HashMap();

    public PlayerOriginComponent(class_1657 player) {
        this.player = player;
        this.setOrigin(Origin.EMPTY);
    }

    @Override
    public boolean hasOrigin() {
        return this.origin != null && this.origin != Origin.EMPTY;
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public boolean hasPower(PowerType<?> powerType) {
        return this.powers.containsKey(powerType);
    }

    @Override
    public <T extends Power> T getPower(PowerType<T> powerType) {
        if (this.powers.containsKey(powerType)) {
            return (T)this.powers.get(powerType);
        }
        return null;
    }

    @Override
    public List<Power> getPowers() {
        LinkedList<Power> list = new LinkedList<Power>();
        list.addAll(this.powers.values());
        return list;
    }

    @Override
    public <T extends Power> List<T> getPowers(Class<T> powerClass) {
        LinkedList<Power> list = new LinkedList<Power>();
        for (Power power : this.powers.values()) {
            if (!powerClass.isAssignableFrom(power.getClass())) continue;
            list.add(power);
        }
        return list;
    }

    @Override
    public void setOrigin(Origin origin) {
        if (this.origin == origin) {
            return;
        }
        if (this.origin != null) {
            for (Power power : this.powers.values()) {
                power.onRemoved();
            }
            this.powers.clear();
        }
        this.origin = origin;
        origin.getPowerTypes().forEach(powerType -> {
            Object power = powerType.create(this.player);
            this.powers.put((PowerType<?>)powerType, (Power)power);
            ((Power)power).onAdded();
        });
        this.sync();
    }

    public void fromTag(class_2487 compoundTag) {
        if (this.player == null) {
            Origins.LOGGER.error("Player was null in `fromTag`! This is a bug!");
        }
        this.setOrigin((Origin)ModRegistries.ORIGIN.method_10223(class_2960.method_12829((String)compoundTag.method_10558("Origin"))));
        class_2499 powerList = (class_2499)compoundTag.method_10580("Powers");
        for (int i = 0; i < powerList.size(); ++i) {
            class_2487 powerTag = powerList.method_10602(i);
            PowerType type = (PowerType)ModRegistries.POWER_TYPE.method_10223(class_2960.method_12829((String)powerTag.method_10558("Type")));
            class_2520 data = powerTag.method_10580("Data");
            Object power = type.create(this.player);
            ((Power)power).fromTag(data);
            this.powers.put(type, (Power)power);
        }
    }

    public class_2487 toTag(class_2487 compoundTag) {
        compoundTag.method_10582("Origin", ModRegistries.ORIGIN.method_10221((Object)this.origin).toString());
        class_2499 powerList = new class_2499();
        for (Map.Entry<PowerType<?>, Power> powerEntry : this.powers.entrySet()) {
            class_2487 powerTag = new class_2487();
            powerTag.method_10582("Type", ModRegistries.POWER_TYPE.method_10221(powerEntry.getKey()).toString());
            powerTag.method_10566("Data", powerEntry.getValue().toTag());
            powerList.add((Object)powerTag);
        }
        compoundTag.method_10566("Powers", (class_2520)powerList);
        return compoundTag;
    }

    public class_1297 getEntity() {
        return this.player;
    }

    public ComponentType<?> getComponentType() {
        return ModComponents.ORIGIN;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("OriginComponent:" + ModRegistries.ORIGIN.method_10221((Object)this.origin) + "[\n");
        for (Map.Entry<PowerType<?>, Power> powerEntry : this.powers.entrySet()) {
            str.append("\t").append(ModRegistries.POWER_TYPE.method_10221(powerEntry.getKey())).append(": ").append(powerEntry.getValue().toTag().toString()).append("\n");
        }
        str.append("]");
        return str.toString();
    }
}

