/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.NightVisionPower;
import io.github.apace100.origins.power.PowerTypes;
import io.github.apace100.origins.registry.ModComponents;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_757;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_757.class})
public class GameRendererMixin {
    @Shadow
    @Final
    private class_4184 field_18765;
    @Shadow
    @Final
    private class_310 field_4015;
    @Shadow
    private class_1799 field_4006;
    private HashMap<class_2338, class_2680> savedStates = new HashMap();

    @Inject(at={@At(value="HEAD")}, method={"getNightVisionStrength"}, cancellable=true)
    private static void getNightVisionStrength(class_1309 livingEntity, float f, CallbackInfoReturnable<Float> info) {
        List<NightVisionPower> nvs;
        Optional<Float> strength;
        if (livingEntity != null && !livingEntity.method_6059(class_1294.field_5925) && (strength = (nvs = ((OriginComponent)ModComponents.ORIGIN.get((Object)livingEntity)).getPowers(NightVisionPower.class)).stream().filter(NightVisionPower::isActive).map(NightVisionPower::getStrength).max(Float::compareTo)).isPresent()) {
            info.setReturnValue((Object)strength.get());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"render"})
    private void beforeRender(float tickDelta, long startTime, boolean tick, CallbackInfo info) {
        block5: {
            block4: {
                if (!PowerTypes.PHASING.isActive(this.field_18765.method_19331()) || !PowerTypes.PHASING.get(this.field_18765.method_19331()).isActive()) break block4;
                Set<class_2338> eyePositions = this.getEyePos();
                HashSet<class_2338> noLongerEyePositions = new HashSet<class_2338>();
                for (class_2338 p : this.savedStates.keySet()) {
                    if (eyePositions.contains(p)) continue;
                    noLongerEyePositions.add(p);
                }
                for (class_2338 eyePosition : noLongerEyePositions) {
                    class_2680 state = this.savedStates.get(eyePosition);
                    this.field_4015.field_1687.method_8501(eyePosition, state);
                    this.savedStates.remove(eyePosition);
                }
                for (class_2338 p : eyePositions) {
                    class_2680 stateAtP = this.field_4015.field_1687.method_8320(p);
                    if (this.savedStates.containsKey(p) || this.field_4015.field_1687.method_22347(p) || stateAtP.method_26204() instanceof class_2404) continue;
                    this.savedStates.put(p, stateAtP);
                    this.field_4015.field_1687.method_2937(p, class_2246.field_10124.method_9564());
                }
                break block5;
            }
            if (this.savedStates.size() <= 0) break block5;
            HashSet<class_2338> noLongerEyePositions = new HashSet<class_2338>(this.savedStates.keySet());
            for (class_2338 eyePosition : noLongerEyePositions) {
                class_2680 state = this.savedStates.get(eyePosition);
                this.field_4015.field_1687.method_8501(eyePosition, state);
                this.savedStates.remove(eyePosition);
            }
        }
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/render/Camera;update(Lnet/minecraft/world/BlockView;Lnet/minecraft/entity/Entity;ZZF)V"), method={"renderWorld"})
    private void preventThirdPerson(class_4184 camera, class_1922 area, class_1297 focusedEntity, boolean thirdPerson, boolean inverseView, float tickDelta) {
        if (PowerTypes.PHASING.isActive(camera.method_19331()) && PowerTypes.PHASING.get(camera.method_19331()).isActive()) {
            camera.method_19321(area, focusedEntity, false, false, tickDelta);
        } else {
            camera.method_19321(area, focusedEntity, thirdPerson, inverseView, tickDelta);
        }
    }

    private Set<class_2338> getEyePos() {
        class_243 pos = this.field_18765.method_19331().method_19538().method_1031(0.0, (double)this.field_18765.method_19331().method_18381(this.field_18765.method_19331().method_18376()), 0.0);
        class_238 cameraBox = new class_238(pos, pos);
        cameraBox = cameraBox.method_1009(0.25, 0.05, 0.25);
        HashSet<class_2338> set = new HashSet<class_2338>();
        class_2338.method_29715((class_238)cameraBox).forEach(p -> set.add(p.method_10062()));
        return set;
    }
}

