/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.CooldownPower;
import io.github.apace100.origins.power.PowerTypes;
import io.github.apace100.origins.power.SetEntityGroupPower;
import io.github.apace100.origins.registry.ModBlocks;
import io.github.apace100.origins.registry.ModComponents;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Shadow
    protected abstract float method_6106();

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(at={@At(value="HEAD")}, method={"getGroup"}, cancellable=true)
    public void getGroup(CallbackInfoReturnable<class_1310> info) {
        OriginComponent component;
        List<SetEntityGroupPower> groups;
        if (this instanceof class_1657 && (groups = (component = (OriginComponent)ModComponents.ORIGIN.get((Object)this)).getPowers(SetEntityGroupPower.class)).size() > 0) {
            if (groups.size() > 1) {
                Origins.LOGGER.warn("Player " + this.method_5476().toString() + " had two instances of SetEntityGroupPower.");
            }
            info.setReturnValue((Object)groups.get((int)0).group);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getJumpVelocity"}, cancellable=true)
    private void modifyJumpVelocity(CallbackInfoReturnable<Float> info) {
        if (this.method_5624() && PowerTypes.SPRINT_JUMP.isActive(this)) {
            float vanilla = 0.42f * this.method_23313();
            info.setReturnValue((Object)Float.valueOf(vanilla *= 1.5f));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canHaveStatusEffect"}, cancellable=true)
    private void preventStatusEffects(class_1293 effect, CallbackInfoReturnable<Boolean> info) {
        if (PowerTypes.HOTBLOODED.isActive(this) && (effect.method_5579() == class_1294.field_5899 || effect.method_5579() == class_1294.field_5903)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"damage"}, cancellable=true)
    public void damage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> info) {
        if (source.method_5534() && PowerTypes.FIRE_IMMUNITY.isActive(this)) {
            info.setReturnValue((Object)false);
        }
        if (source == class_1282.field_5868 && PowerTypes.FALL_IMMUNITY.isActive(this)) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isClimbing"}, cancellable=true)
    public void doSpiderClimbing(CallbackInfoReturnable<Boolean> info) {
        if (PowerTypes.CLIMBING.isActive(this) && PowerTypes.CLIMBING.get(this).isActive() && this.field_5976) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canBreatheInWater"}, cancellable=true)
    public void doWaterBreathing(CallbackInfoReturnable<Boolean> info) {
        if (PowerTypes.WATER_BREATHING.isActive(this)) {
            info.setReturnValue((Object)true);
        }
    }

    @ModifyConstant(method={"travel"}, constant={@Constant(floatValue=0.02f, ordinal=0)})
    public float modifyBaseUnderwaterSpeed(float in) {
        if (PowerTypes.SWIM_SPEED.isActive(this)) {
            return in + PowerTypes.SWIM_SPEED.get((class_1297)this).value;
        }
        return in;
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;method_26317(DZLnet/minecraft/util/math/Vec3d;)Lnet/minecraft/util/math/Vec3d;"))
    public class_243 method_26317Proxy(class_1309 entity, double d, boolean bl, class_243 vec3d) {
        class_243 oldReturn = entity.method_26317(d, bl, vec3d);
        if (PowerTypes.LIKE_WATER.isActive(this) && Math.abs(vec3d.field_1351 - d / 16.0) < 0.025) {
            return new class_243(oldReturn.field_1352, 0.0, oldReturn.field_1350);
        }
        return entity.method_26317(d, bl, vec3d);
    }

    @ModifyVariable(at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getFluidState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/fluid/FluidState;"), method={"travel"}, name={"d"}, ordinal=0)
    public double doAvianSlowFalling(double in) {
        if (!this.method_5715() && this.method_18798().field_1351 <= 0.0 && PowerTypes.SLOW_FALLING.isActive(this)) {
            this.field_6017 = 0.0f;
            return 0.01;
        }
        return in;
    }

    @Inject(at={@At(value="HEAD")}, method={"onAttacking"})
    public void onAttacking(class_1297 target, CallbackInfo info) {
        class_2338 targetPos;
        CooldownPower power;
        if (target instanceof class_1309 && PowerTypes.WEBBING.isActive(this) && !this.method_5715() && (power = PowerTypes.WEBBING.get(this)).canUse() && (this.field_6002.method_22347(targetPos = target.method_24515()) || this.field_6002.method_8320(targetPos).method_26207().method_15800())) {
            this.field_6002.method_8501(targetPos, ModBlocks.TEMPORARY_COBWEB.method_9564());
            power.use();
        }
    }
}

