/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.origin;

import com.google.common.collect.Lists;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.PowerTypes;
import io.github.apace100.origins.registry.ModComponents;
import io.github.apace100.origins.registry.ModRegistries;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2588;
import net.minecraft.class_2960;

public class Origin {
    public static final Origin EMPTY = Origin.register("empty", new Origin((class_1935)class_1802.field_8162, Impact.NONE, -1).setUnchoosable().add(PowerTypes.INVULNERABILITY));
    public static final Origin HUMAN = Origin.register("human", new Origin((class_1935)class_1802.field_8575, Impact.NONE, 0));
    public static final Origin MERLING = Origin.register("merling", new Origin((class_1935)class_1802.field_8429, Impact.HIGH, 0).add(PowerTypes.WATER_BREATHING, PowerTypes.AQUA_AFFINITY, PowerTypes.WATER_VISION, PowerTypes.SWIM_SPEED, PowerTypes.LIKE_WATER));
    public static final Origin ARACHNID = Origin.register("arachnid", new Origin((class_1935)class_1802.field_8786, Impact.LOW, 1).add(PowerTypes.CLIMBING, PowerTypes.WEBBING, PowerTypes.FRAGILE, PowerTypes.NO_COBWEB_SLOWDOWN, PowerTypes.CARNIVORE, PowerTypes.ARTHROPOD));
    public static final Origin BLAZEBORN = Origin.register("blazeborn", new Origin((class_1935)class_1802.field_8183, Impact.HIGH, 1).add(PowerTypes.FIRE_IMMUNITY, PowerTypes.NETHER_SPAWN, PowerTypes.BURNING_WRATH, PowerTypes.HOTBLOODED, PowerTypes.WATER_VULNERABILITY, PowerTypes.FLAME_PARTICLES));
    public static final Origin AVIAN = Origin.register("avian", new Origin((class_1935)class_1802.field_8153, Impact.LOW, 0).add(PowerTypes.SLOW_FALLING, PowerTypes.TAILWIND, PowerTypes.FRESH_AIR, PowerTypes.VEGETARIAN));
    public static final Origin PHANTOM = Origin.register("phantom", new Origin((class_1935)class_1802.field_8614, Impact.HIGH, 2).add(PowerTypes.PHASING, PowerTypes.INVISIBILITY, PowerTypes.HUNGER_OVER_TIME, PowerTypes.FRAGILE, PowerTypes.BURN_IN_DAYLIGHT));
    public static final Origin FELINE = Origin.register("feline", new Origin((class_1935)class_1802.field_19045, Impact.MEDIUM, 0).add(PowerTypes.FALL_IMMUNITY, PowerTypes.SPRINT_JUMP, PowerTypes.CAT_VISION, PowerTypes.NINE_LIVES, PowerTypes.WEAK_ARMS, PowerTypes.SCARE_CREEPERS));
    private List<PowerType<?>> powerTypes = new LinkedList();
    private final class_1799 displayItem;
    private final Impact impact;
    private boolean isChoosable;
    private final int order;

    public static void init() {
    }

    private static Origin register(String path, Origin origin) {
        return (Origin)class_2378.method_10230(ModRegistries.ORIGIN, (class_2960)new class_2960("origins", path), (Object)origin);
    }

    public static Origin get(class_1297 entity) {
        if (entity instanceof class_1657) {
            return Origin.get((class_1657)entity);
        }
        return EMPTY;
    }

    public static Origin get(class_1657 player) {
        return ((OriginComponent)ModComponents.ORIGIN.get((Object)player)).getOrigin();
    }

    protected Origin(class_1935 item, Impact impact, int order) {
        this.displayItem = new class_1799(item);
        this.impact = impact;
        this.isChoosable = true;
        this.order = order;
    }

    protected Origin add(PowerType<?> ... powerTypes) {
        this.powerTypes.addAll(Lists.newArrayList((Object[])powerTypes));
        return this;
    }

    protected Origin setUnchoosable() {
        this.isChoosable = false;
        return this;
    }

    public boolean isChoosable() {
        return this.isChoosable;
    }

    public Iterable<PowerType<?>> getPowerTypes() {
        return this.powerTypes;
    }

    public Impact getImpact() {
        return this.impact;
    }

    public class_1799 getDisplayItem() {
        return this.displayItem;
    }

    public class_2588 getName() {
        class_2960 id = ModRegistries.ORIGIN.method_10221((Object)this);
        return new class_2588("origin." + id.method_12836() + "." + id.method_12832() + ".name");
    }

    public class_2588 getDescription() {
        class_2960 id = ModRegistries.ORIGIN.method_10221((Object)this);
        return new class_2588("origin." + id.method_12836() + "." + id.method_12832() + ".description");
    }

    public int getOrder() {
        return this.order;
    }
}

