/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.HudRendered;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import net.minecraft.class_1657;
import net.minecraft.class_2503;
import net.minecraft.class_2520;

public class CooldownPower
extends Power
implements HudRendered {
    public final int cooldownDuration;
    private long lastUseTime;
    private final int barIndex;

    public CooldownPower(PowerType<?> type, class_1657 player, int cooldownDuration, int barIndex) {
        super(type, player);
        this.cooldownDuration = cooldownDuration;
        this.barIndex = barIndex;
    }

    public boolean canUse() {
        return this.player.method_5770().method_8510() >= this.lastUseTime + (long)this.cooldownDuration;
    }

    public void use() {
        this.lastUseTime = this.player.method_5770().method_8510();
        OriginComponent.sync(this.player);
    }

    public float getProgress() {
        float time = this.player.method_5770().method_8510() - this.lastUseTime;
        return Math.min(1.0f, Math.max(time / (float)this.cooldownDuration, 0.0f));
    }

    @Override
    public class_2520 toTag() {
        return class_2503.method_23251((long)this.lastUseTime);
    }

    @Override
    public void fromTag(class_2520 tag) {
        this.lastUseTime = ((class_2503)tag).method_10699();
    }

    @Override
    public int getBarIndex() {
        return this.barIndex;
    }

    @Override
    public float getFill() {
        return this.getProgress();
    }

    @Override
    public boolean shouldRender() {
        return this.player.method_5770().method_8510() - this.lastUseTime <= (long)this.cooldownDuration;
    }
}

