/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.registry.ModRegistries;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class ChooseOriginScreen
extends class_437 {
    private static final class_2960 WINDOW = new class_2960("origins", "textures/gui/choose_origin.png");
    private int currentOrigin = 0;
    private List<Origin> originSelection = new ArrayList<Origin>(10);
    private static final int windowWidth = 176;
    private static final int windowHeight = 182;
    private int scrollPos = 0;
    private int currentMaxScroll = 0;
    private int border = 13;
    private int guiTop;
    private int guiLeft;

    public ChooseOriginScreen() {
        super((class_2561)new class_2588("origins.screen.choose_origin"));
        ModRegistries.ORIGIN.forEach(origin -> {
            if (origin.isChoosable()) {
                this.originSelection.add((Origin)origin);
            }
        });
        this.originSelection.sort((a, b) -> {
            int impDelta = a.getImpact().getImpactValue() - b.getImpact().getImpactValue();
            return impDelta == 0 ? a.getOrder() - b.getOrder() : impDelta;
        });
    }

    public boolean method_25422() {
        return false;
    }

    protected void method_25426() {
        super.method_25426();
        this.guiLeft = (this.field_22789 - 176) / 2;
        this.guiTop = (this.field_22790 - 182) / 2;
        this.method_25411((class_339)new class_4185(this.guiLeft - 40, this.field_22790 / 2 - 10, 20, 20, (class_2561)new class_2585("<"), b -> {
            this.currentOrigin = (this.currentOrigin - 1 + this.originSelection.size()) % this.originSelection.size();
            this.scrollPos = 0;
        }));
        this.method_25411((class_339)new class_4185(this.guiLeft + 176 + 20, this.field_22790 / 2 - 10, 20, 20, (class_2561)new class_2585(">"), b -> {
            this.currentOrigin = (this.currentOrigin + 1) % this.originSelection.size();
            this.scrollPos = 0;
        }));
        this.method_25411((class_339)new class_4185(this.guiLeft + 88 - 50, this.guiTop + 182 + 5, 100, 20, (class_2561)new class_2588("origins.gui.select"), b -> {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10814(ModRegistries.ORIGIN.method_10221((Object)this.originSelection.get(this.currentOrigin)).toString());
            ClientSidePacketRegistry.INSTANCE.sendToServer(ModPackets.CHOOSE_ORIGIN, buf);
            class_310.method_1551().method_1507(null);
        }));
        Origin.HUMAN.getDisplayItem().method_7948().method_10582("SkullOwner", class_310.method_1551().field_1724.method_5476().getString());
    }

    public void method_25433(class_4587 matrices, int vOffset) {
        super.method_25434(vOffset);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        this.renderOriginWindow(matrices, mouseX, mouseY);
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    private void renderOriginWindow(class_4587 matrices, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        this.renderWindowBackground(matrices, 16, 0);
        this.renderOriginContent(matrices, mouseX, mouseY);
        this.field_22787.method_1531().method_22813(WINDOW);
        this.method_25302(matrices, this.guiLeft, this.guiTop, 0, 0, 176, 182);
        this.renderOriginName(matrices);
        this.field_22787.method_1531().method_22813(WINDOW);
        this.renderOriginImpact(matrices, mouseX, mouseY);
        class_2588 title = new class_2588("origins.gui.choose_origin.title");
        this.method_25300(matrices, this.field_22793, title.getString(), this.field_22789 / 2, this.guiTop - 15, 0xFFFFFF);
        RenderSystem.disableBlend();
    }

    private void renderOriginImpact(class_4587 matrices, int mouseX, int mouseY) {
        Impact impact = this.originSelection.get(this.currentOrigin).getImpact();
        int impactValue = impact.getImpactValue();
        int wOffset = impactValue * 8;
        for (int i = 0; i < 3; ++i) {
            if (i < impactValue) {
                this.method_25302(matrices, this.guiLeft + 128 + i * 10, this.guiTop + 19, 176 + wOffset, 16, 8, 8);
                continue;
            }
            this.method_25302(matrices, this.guiLeft + 128 + i * 10, this.guiTop + 19, 176, 16, 8, 8);
        }
        if (mouseX >= this.guiLeft + 128 && mouseX <= this.guiLeft + 158 && mouseY >= this.guiTop + 19 && mouseY <= this.guiTop + 27) {
            class_2588 ttc = (class_2588)new class_2588("origins.gui.impact.impact").method_27693(": ").method_10852((class_2561)impact.getTextComponent());
            this.method_25424(matrices, (class_5348)ttc, mouseX, mouseY);
        }
    }

    private void renderOriginName(class_4587 matrices) {
        class_5348 originName = this.field_22793.method_1714((class_5348)this.originSelection.get(this.currentOrigin).getName(), 140);
        this.method_25303(matrices, this.field_22793, originName.getString(), this.guiLeft + 39, this.guiTop + 19, 0xFFFFFF);
        class_1799 is = this.originSelection.get(this.currentOrigin).getDisplayItem();
        this.field_22788.method_27953(is, this.guiLeft + 15, this.guiTop + 15);
    }

    private void renderWindowBackground(class_4587 matrices, int offsetYStart, int offsetYEnd) {
        int endX = this.guiLeft + 176 - this.border;
        int endY = this.guiTop + 182 - this.border;
        this.field_22787.method_1531().method_22813(WINDOW);
        for (int x = this.guiLeft; x < endX; x += 16) {
            for (int y = this.guiTop + offsetYStart; y < endY + offsetYEnd; y += 16) {
                this.method_25302(matrices, x, y, 176, 0, Math.max(16, endX - x), Math.max(16, endY + offsetYEnd - y));
            }
        }
    }

    public boolean method_25401(double x, double y, double z) {
        boolean retValue = super.method_25401(x, y, z);
        int np = this.scrollPos - (int)z * 4;
        this.scrollPos = np < 0 ? 0 : Math.min(np, this.currentMaxScroll);
        return retValue;
    }

    private void renderOriginContent(class_4587 matrices, int mouseX, int mouseY) {
        int y;
        Origin origin = this.originSelection.get(this.currentOrigin);
        int x = this.guiLeft + 18;
        int startY = y = this.guiTop + 50;
        int endY = y - 72 + 182;
        y -= this.scrollPos;
        class_2588 orgDesc = origin.getDescription();
        List descLines = this.field_22793.method_1728((class_5348)orgDesc, 140);
        for (class_5348 class_53482 : descLines) {
            if (y >= startY - 18 && y <= endY + 12) {
                this.field_22793.method_27528(matrices, class_53482, (float)(x + 2), (float)(y - 6), 0xCCCCCC);
            }
            y += 12;
        }
        for (PowerType powerType : origin.getPowerTypes()) {
            if (powerType.isHidden()) continue;
            class_5348 name = this.field_22793.method_1714((class_5348)powerType.getName().method_27692(class_124.field_1073), 140);
            class_2588 desc = powerType.getDescription();
            List drawLines = this.field_22793.method_1728((class_5348)desc, 140);
            if (y >= startY - 24 && y <= endY + 12) {
                this.field_22793.method_27528(matrices, name, (float)x, (float)y, 0xFFFFFF);
            }
            for (class_5348 line : drawLines) {
                if ((y += 12) < startY - 24 || y > endY + 12) continue;
                this.field_22793.method_27528(matrices, line, (float)(x + 2), (float)y, 0xCCCCCC);
            }
            y += 14;
        }
        this.currentMaxScroll = (y += this.scrollPos) - 182 - 15;
        if (this.currentMaxScroll < 0) {
            this.currentMaxScroll = 0;
        }
    }
}

