/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.page.PageBlasting;
import vazkii.patchouli.client.book.page.PageCampfireCooking;
import vazkii.patchouli.client.book.page.PageCrafting;
import vazkii.patchouli.client.book.page.PageEmpty;
import vazkii.patchouli.client.book.page.PageEntity;
import vazkii.patchouli.client.book.page.PageImage;
import vazkii.patchouli.client.book.page.PageLink;
import vazkii.patchouli.client.book.page.PageMultiblock;
import vazkii.patchouli.client.book.page.PageQuest;
import vazkii.patchouli.client.book.page.PageRelations;
import vazkii.patchouli.client.book.page.PageSmelting;
import vazkii.patchouli.client.book.page.PageSmithing;
import vazkii.patchouli.client.book.page.PageSmoking;
import vazkii.patchouli.client.book.page.PageSpotlight;
import vazkii.patchouli.client.book.page.PageStonecutting;
import vazkii.patchouli.client.book.page.PageTemplate;
import vazkii.patchouli.client.book.page.PageText;
import vazkii.patchouli.client.book.template.BookTemplate;
import vazkii.patchouli.client.book.template.TemplateComponent;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.util.SerializationUtil;

public class ClientBookRegistry {
    public final Map<class_2960, Class<? extends BookPage>> pageTypes = new HashMap<class_2960, Class<? extends BookPage>>();
    public final Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(BookPage.class, (Object)new LexiconPageAdapter()).registerTypeHierarchyAdapter(TemplateComponent.class, (Object)new TemplateComponentAdapter()).create();
    public String currentLang;
    public static final ClientBookRegistry INSTANCE = new ClientBookRegistry();

    private ClientBookRegistry() {
    }

    public void init() {
        this.addPageTypes();
    }

    private void addPageTypes() {
        this.pageTypes.put(new class_2960("patchouli", "text"), PageText.class);
        this.pageTypes.put(new class_2960("patchouli", "crafting"), PageCrafting.class);
        this.pageTypes.put(new class_2960("patchouli", "smelting"), PageSmelting.class);
        this.pageTypes.put(new class_2960("patchouli", "blasting"), PageBlasting.class);
        this.pageTypes.put(new class_2960("patchouli", "smoking"), PageSmoking.class);
        this.pageTypes.put(new class_2960("patchouli", "campfire"), PageCampfireCooking.class);
        this.pageTypes.put(new class_2960("patchouli", "smithing"), PageSmithing.class);
        this.pageTypes.put(new class_2960("patchouli", "stonecutting"), PageStonecutting.class);
        this.pageTypes.put(new class_2960("patchouli", "image"), PageImage.class);
        this.pageTypes.put(new class_2960("patchouli", "spotlight"), PageSpotlight.class);
        this.pageTypes.put(new class_2960("patchouli", "empty"), PageEmpty.class);
        this.pageTypes.put(new class_2960("patchouli", "multiblock"), PageMultiblock.class);
        this.pageTypes.put(new class_2960("patchouli", "link"), PageLink.class);
        this.pageTypes.put(new class_2960("patchouli", "relations"), PageRelations.class);
        this.pageTypes.put(new class_2960("patchouli", "entity"), PageEntity.class);
        this.pageTypes.put(new class_2960("patchouli", "quest"), PageQuest.class);
    }

    public void reload() {
        this.currentLang = class_310.method_1551().method_1526().method_4669().getCode();
        BookRegistry.INSTANCE.reloadContents();
    }

    public void reloadLocks(boolean suppressToasts) {
        BookRegistry.INSTANCE.books.values().forEach(b -> b.reloadLocks(suppressToasts));
    }

    public void displayBookGui(class_2960 bookStr, @Nullable class_2960 entryId, int page) {
        class_310 mc = class_310.method_1551();
        this.currentLang = mc.method_1526().method_4669().getCode();
        Book book = BookRegistry.INSTANCE.books.get(bookStr);
        if (book != null) {
            book.contents.checkValidCurrentEntry();
            if (entryId != null) {
                book.contents.setTopEntry(entryId, page);
            }
            book.contents.openLexiconGui(book.contents.getCurrentGui(), false);
            if (mc.field_1724 != null) {
                class_3414 sfx = PatchouliSounds.getSound(book.openSound, PatchouliSounds.book_open);
                mc.field_1724.method_5783(sfx, 1.0f, (float)(0.7 + Math.random() * 0.4));
            }
        }
    }

    public static class TemplateComponentAdapter
    implements JsonDeserializer<TemplateComponent> {
        public TemplateComponent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            JsonPrimitive prim = (JsonPrimitive)obj.get("type");
            String type = prim.getAsString();
            Class<? extends TemplateComponent> clazz = BookTemplate.componentTypes.get(type);
            if (clazz == null) {
                return null;
            }
            TemplateComponent component = (TemplateComponent)SerializationUtil.RAW_GSON.fromJson(json, clazz);
            component.sourceObject = obj;
            return component;
        }
    }

    public static class LexiconPageAdapter
    implements JsonDeserializer<BookPage> {
        public BookPage deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            class_2960 type;
            Class<? extends BookPage> clazz;
            JsonObject obj = json.getAsJsonObject();
            JsonPrimitive prim = (JsonPrimitive)obj.get("type");
            String string = prim.getAsString();
            if (string.indexOf(58) < 0) {
                string = "patchouli:" + string;
            }
            if ((clazz = ClientBookRegistry.INSTANCE.pageTypes.get(type = new class_2960(string))) == null) {
                clazz = PageTemplate.class;
            }
            BookPage page = (BookPage)SerializationUtil.RAW_GSON.fromJson(json, clazz);
            page.sourceObject = obj;
            return page;
        }
    }
}

