/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.gui;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_407;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_500;
import net.minecraft.class_5250;
import net.minecraft.class_526;
import vazkii.patchouli.common.base.Patchouli;

public class GoVoteHandler {
    private static final String BRAND = "Vazkii's Mods";
    private static final String MARKER_PATH = ".vote2020_marker";
    private static final LocalDate ELECTION_DAY = LocalDate.of(2020, Month.NOVEMBER, 3);
    private static final String LINK = "https://vote.gov/";
    private static boolean shownThisSession = false;
    private static boolean markerAlreadyExists = false;
    private static volatile String countryCode = Locale.getDefault().getCountry();

    public static void init() {
        if (GoVoteHandler.isAfterElectionDay()) {
            return;
        }
        try {
            Path path = Paths.get(MARKER_PATH, new String[0]);
            Files.createFile(path, new FileAttribute[0]);
            if (class_156.method_668() == class_156.class_158.field_1133) {
                Files.setAttribute(path, "dos:hidden", true, new LinkOption[0]);
            }
        }
        catch (IOException ex) {
            if (ex instanceof FileAlreadyExistsException) {
                Patchouli.LOGGER.debug("Go vote handler: Marker already exists");
            }
            markerAlreadyExists = true;
            return;
        }
        new Thread(() -> {
            try {
                URL url = new URL("http://ip-api.com/json/");
                URLConnection conn = url.openConnection();
                conn.setConnectTimeout(4000);
                conn.setReadTimeout(4000);
                try (InputStreamReader reader = new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8);){
                    Type typeToken = new TypeToken<Map<String, String>>(){}.getType();
                    Map map = (Map)new Gson().fromJson((Reader)reader, typeToken);
                    countryCode = (String)map.get("countryCode");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, "Go Vote Country Check").start();
    }

    private static boolean isAfterElectionDay() {
        return LocalDate.now().isAfter(ELECTION_DAY);
    }

    public static boolean guiOpen(class_437 curr) {
        class_310 mc = class_310.method_1551();
        if ((curr instanceof class_526 || curr instanceof class_500) && GoVoteHandler.shouldShow(mc)) {
            mc.method_1507((class_437)new GoVoteScreen(curr));
            shownThisSession = true;
            return true;
        }
        return false;
    }

    private static boolean shouldShow(class_310 mc) {
        if (!GoVoteHandler.isEnglish(mc) || shownThisSession || GoVoteHandler.isAfterElectionDay() || markerAlreadyExists) {
            return false;
        }
        return "US".equals(countryCode);
    }

    private static boolean isEnglish(class_310 mc) {
        return mc.method_1526() != null && mc.method_1526().method_4669() != null && "English".equals(mc.method_1526().method_4669().getName());
    }

    private static class GoVoteScreen
    extends class_437 {
        private static final int TICKS_PER_GROUP = 50;
        private final class_437 parent;
        private int ticksElapsed = 0;
        private final List<List<class_2561>> message = new ArrayList<List<class_2561>>();

        protected GoVoteScreen(class_437 parent) {
            super((class_2561)new class_2585(""));
            this.parent = parent;
            this.addGroup(new class_2561[]{GoVoteScreen.s("Please read the following message from Vazkii's Mods.")});
            this.addGroup(new class_2561[]{GoVoteScreen.s("We are at a unique crossroads in the history of our country.")});
            this.addGroup(new class_2561[]{GoVoteScreen.s("In this time of heightened polarization,"), GoVoteScreen.s("breakdown of political decorum, and fear,")});
            this.addGroup(new class_2561[]{GoVoteScreen.s("it is tempting to succumb to apathy,"), GoVoteScreen.s("to think that nothing you do will matter.")});
            this.addGroup(new class_2561[]{class_2585.field_24366, GoVoteScreen.s("But power is still in the hands of We, the People.")});
            this.addGroup(new class_2561[]{GoVoteScreen.s("The Constitution and its amendments guarantee us the right to vote.")});
            this.addGroup(new class_2561[]{GoVoteScreen.s("And it is not only our right, but our ").method_10852((class_2561)GoVoteScreen.s("responsibility").method_27695(new class_124[]{class_124.field_1056, class_124.field_1065})).method_27693(" to do so.")});
            this.addGroup(new class_2561[]{GoVoteScreen.s("Your vote matters. Always.")});
            this.addGroup(new class_2561[]{class_2585.field_24366, GoVoteScreen.s("Click anywhere to check if you are registered to vote."), GoVoteScreen.s("The website is an official government site, unaffiliated with Vazkii's Mods.")});
            this.addGroup(new class_2561[]{GoVoteScreen.s("Press ESC to exit. (This screen will not show up again.)")});
        }

        private void addGroup(class_2561 ... lines) {
            this.message.add(Arrays.asList(lines));
        }

        private static class_2585 s(String txt) {
            return new class_2585(txt);
        }

        public void method_25393() {
            super.method_25393();
            ++this.ticksElapsed;
        }

        public void method_25394(class_4587 mstack, int mx, int my, float pticks) {
            super.method_25394(mstack, mx, my, pticks);
            GoVoteScreen.method_25294((class_4587)mstack, (int)0, (int)0, (int)this.field_22789, (int)this.field_22790, (int)-9868951);
            int middle = this.field_22789 / 2;
            int dist = 12;
            class_5250 note1 = GoVoteScreen.s("Note: If you can't vote in the United States,").method_27692(class_124.field_1056);
            class_5250 note2 = GoVoteScreen.s("Please press ESC and carry on.").method_27692(class_124.field_1056);
            GoVoteScreen.method_27534((class_4587)mstack, (class_327)this.field_22793, (class_2561)note1, (int)middle, (int)10, (int)0xFFFFFF);
            GoVoteScreen.method_27534((class_4587)mstack, (class_327)this.field_22793, (class_2561)note2, (int)middle, (int)22, (int)0xFFFFFF);
            int y = 46;
            for (int groupIdx = 0; groupIdx < this.message.size(); ++groupIdx) {
                List<class_2561> group = this.message.get(groupIdx);
                if (this.ticksElapsed - 20 <= groupIdx * 50) continue;
                for (class_2561 line : group) {
                    GoVoteScreen.method_27534((class_4587)mstack, (class_327)this.field_22793, (class_2561)line, (int)middle, (int)y, (int)0xFFFFFF);
                    y += dist;
                }
            }
        }

        @Nonnull
        public String method_25435() {
            StringBuilder builder = new StringBuilder();
            for (List<class_2561> group : this.message) {
                for (class_2561 line : group) {
                    builder.append(line.getString());
                }
            }
            return builder.toString();
        }

        public boolean method_25404(int keycode, int scanCode, int modifiers) {
            if (keycode == 256) {
                this.field_22787.method_1507(this.parent);
            }
            return super.method_25404(keycode, scanCode, modifiers);
        }

        public boolean method_25402(double x, double y, int modifiers) {
            if (this.ticksElapsed < 80) {
                return false;
            }
            if (modifiers == 0) {
                this.field_22787.method_1507((class_437)new class_407(this::consume, GoVoteHandler.LINK, true));
                return true;
            }
            return super.method_25402(x, y, modifiers);
        }

        private void consume(boolean doIt) {
            this.field_22787.method_1507((class_437)this);
            if (doIt) {
                class_156.method_668().method_670(GoVoteHandler.LINK);
            }
        }
    }
}

