/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.page.abstr;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.page.abstr.PageWithText;

public abstract class PageDoubleRecipe<T>
extends PageWithText {
    @SerializedName(value="recipe")
    ResourceLocation recipeId;
    @SerializedName(value="recipe2")
    ResourceLocation recipe2Id;
    String title;
    protected transient T recipe1;
    protected transient T recipe2;
    protected transient ITextComponent title1;
    protected transient ITextComponent title2;

    @Override
    public void build(BookEntry entry, int pageNum) {
        super.build(entry, pageNum);
        this.recipe1 = this.loadRecipe(entry, this.recipeId);
        this.recipe2 = this.loadRecipe(entry, this.recipe2Id);
        if (this.recipe1 == null && this.recipe2 != null) {
            this.recipe1 = this.recipe2;
            this.recipe2 = null;
        }
        boolean customTitle = this.title != null && !this.title.isEmpty();
        this.title1 = !customTitle ? this.getRecipeOutput(this.recipe1).func_200301_q() : this.i18nText(this.title);
        this.title2 = new StringTextComponent("-");
        if (this.recipe2 != null) {
            ITextComponent iTextComponent = this.title2 = !customTitle ? this.getRecipeOutput(this.recipe2).func_200301_q() : StringTextComponent.field_240750_d_;
            if (this.title1.equals(this.title2)) {
                this.title2 = StringTextComponent.field_240750_d_;
            }
        }
    }

    @Override
    public void render(MatrixStack ms, int mouseX, int mouseY, float pticks) {
        if (this.recipe1 != null) {
            int recipeX = this.getX();
            int recipeY = this.getY();
            this.drawRecipe(ms, this.recipe1, recipeX, recipeY, mouseX, mouseY, false);
            if (this.recipe2 != null) {
                this.drawRecipe(ms, this.recipe2, recipeX, recipeY + this.getRecipeHeight() - (this.title2.getString().isEmpty() ? 10 : 0), mouseX, mouseY, true);
            }
        }
        super.render(ms, mouseX, mouseY, pticks);
    }

    @Override
    public int getTextHeight() {
        return this.getY() + this.getRecipeHeight() * (this.recipe2 == null ? 1 : 2) - (this.title2.getString().isEmpty() ? 23 : 13);
    }

    @Override
    public boolean shouldRenderText() {
        return this.getTextHeight() + 10 < 156;
    }

    protected abstract void drawRecipe(MatrixStack var1, T var2, int var3, int var4, int var5, int var6, boolean var7);

    protected abstract T loadRecipe(BookEntry var1, ResourceLocation var2);

    protected abstract ItemStack getRecipeOutput(T var1);

    protected abstract int getRecipeHeight();

    protected int getX() {
        return 9;
    }

    protected int getY() {
        return 4;
    }

    protected ITextComponent getTitle(boolean second) {
        return second ? this.title2 : this.title1;
    }
}

