/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.template;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.template.TemplateComponent;
import vazkii.patchouli.client.book.template.TemplateInclusion;
import vazkii.patchouli.client.book.template.component.ComponentCustom;
import vazkii.patchouli.client.book.template.component.ComponentEntity;
import vazkii.patchouli.client.book.template.component.ComponentFrame;
import vazkii.patchouli.client.book.template.component.ComponentHeader;
import vazkii.patchouli.client.book.template.component.ComponentImage;
import vazkii.patchouli.client.book.template.component.ComponentItemStack;
import vazkii.patchouli.client.book.template.component.ComponentSeparator;
import vazkii.patchouli.client.book.template.component.ComponentText;
import vazkii.patchouli.client.book.template.component.ComponentTooltip;
import vazkii.patchouli.common.book.Book;

public class BookTemplate {
    public static final HashMap<String, Class<? extends TemplateComponent>> componentTypes = new HashMap();
    @SerializedName(value="include")
    List<TemplateInclusion> inclusions = new ArrayList<TemplateInclusion>();
    List<TemplateComponent> components = new ArrayList<TemplateComponent>();
    @SerializedName(value="processor")
    String processorClass;
    transient Book book;
    @Nullable
    transient TemplateInclusion encapsulation;
    transient IComponentProcessor processor;
    transient boolean compiled = false;
    transient boolean attemptedCreatingProcessor = false;

    public static BookTemplate createTemplate(Book book, String type, @Nullable TemplateInclusion inclusion) {
        ResourceLocation key = type.contains(":") ? new ResourceLocation(type) : new ResourceLocation(book.getModNamespace(), type);
        Supplier<BookTemplate> supplier = book.contents.templates.get(key);
        if (supplier == null) {
            throw new IllegalArgumentException("Template " + key + " does not exist");
        }
        BookTemplate template = supplier.get();
        template.book = book;
        template.encapsulation = inclusion;
        return template;
    }

    public void compile(IVariableProvider variables) {
        if (this.compiled) {
            return;
        }
        this.createProcessor();
        this.components.removeIf(Objects::isNull);
        if (this.processor != null) {
            IVariableProvider processorVars = variables;
            if (this.encapsulation != null) {
                processorVars = this.encapsulation.wrapProvider(variables);
            }
            try {
                this.processor.setup(processorVars);
            }
            catch (Exception e) {
                throw new RuntimeException("Error setting up template processor", e);
            }
        }
        for (TemplateInclusion include : this.inclusions) {
            if (include.template == null || include.template.isEmpty() || include.as == null || include.as.isEmpty()) {
                throw new IllegalArgumentException("Template inclusion must define both \"template\" and \"as\" fields.");
            }
            include.upperMerge(this.encapsulation);
            include.process(this.processor);
            BookTemplate template = BookTemplate.createTemplate(this.book, include.template, include);
            template.compile(variables);
            this.components.addAll(template.components);
        }
        for (TemplateComponent c : this.components) {
            c.compile(variables, this.processor, this.encapsulation);
        }
        this.compiled = true;
    }

    public void build(BookPage page, BookEntry entry, int pageNum) {
        if (this.compiled) {
            this.components.forEach(c -> c.build(page, entry, pageNum));
        }
    }

    public void onDisplayed(BookPage page, GuiBookEntry parent, int left, int top) {
        if (this.compiled) {
            if (this.processor != null) {
                this.processor.refresh(parent, left, top);
            }
            this.components.forEach(c -> {
                c.isVisible = c.getVisibleStatus(this.processor);
            });
            this.components.forEach(c -> c.onDisplayed(page, parent, left, top));
        }
    }

    public void render(MatrixStack ms, BookPage page, int mouseX, int mouseY, float pticks) {
        if (this.compiled) {
            this.components.forEach(c -> {
                if (c.isVisible) {
                    c.render(ms, page, mouseX, mouseY, pticks);
                }
            });
        }
    }

    public boolean func_231043_a_(BookPage page, double mouseX, double mouseY, int mouseButton) {
        if (this.compiled) {
            for (TemplateComponent c : this.components) {
                if (!c.isVisible || !c.func_231043_a_(page, mouseX, mouseY, mouseButton)) continue;
                return true;
            }
        }
        return false;
    }

    public static void registerComponent(String name, Class<? extends TemplateComponent> clazz) {
        componentTypes.put(name, clazz);
    }

    private void createProcessor() {
        if (!this.attemptedCreatingProcessor) {
            if (this.processorClass != null && !this.processorClass.isEmpty()) {
                try {
                    Class<?> clazz = Class.forName(this.processorClass);
                    this.processor = (IComponentProcessor)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create component processor " + this.processorClass, e);
                }
            }
            this.attemptedCreatingProcessor = true;
        }
    }

    static {
        BookTemplate.registerComponent("text", ComponentText.class);
        BookTemplate.registerComponent("item", ComponentItemStack.class);
        BookTemplate.registerComponent("image", ComponentImage.class);
        BookTemplate.registerComponent("header", ComponentHeader.class);
        BookTemplate.registerComponent("separator", ComponentSeparator.class);
        BookTemplate.registerComponent("frame", ComponentFrame.class);
        BookTemplate.registerComponent("entity", ComponentEntity.class);
        BookTemplate.registerComponent("tooltip", ComponentTooltip.class);
        BookTemplate.registerComponent("custom", ComponentCustom.class);
    }
}

