/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.base;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.patchouli.common.base.Patchouli;

public class PatchouliConfig {
    public static ForgeConfigSpec.ConfigValue<Boolean> disableAdvancementLocking;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> noAdvancementBooks;
    public static ForgeConfigSpec.ConfigValue<Boolean> testingMode;
    public static ForgeConfigSpec.ConfigValue<String> inventoryButtonBook;
    public static ForgeConfigSpec.ConfigValue<Boolean> useShiftForQuickLookup;
    private static final Map<String, Boolean> CONFIG_FLAGS;

    public static void setup() {
        Pair clientSpec = new ForgeConfigSpec.Builder().configure(ClientLoader::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (ForgeConfigSpec)clientSpec.getRight());
    }

    public static void reloadFlags() {
        CONFIG_FLAGS.clear();
        List mods = ModList.get().getMods();
        for (ModInfo info : mods) {
            PatchouliConfig.setFlag("mod:" + info.getModId(), true);
        }
        PatchouliConfig.setFlag("debug", Patchouli.debug);
        PatchouliConfig.setFlag("advancements_disabled", (Boolean)disableAdvancementLocking.get());
        PatchouliConfig.setFlag("testing_mode", (Boolean)testingMode.get());
        for (String book : (List)noAdvancementBooks.get()) {
            PatchouliConfig.setFlag("advancements_disabled_" + book, true);
        }
    }

    public static boolean getConfigFlag(String name) {
        Boolean b;
        if (name.startsWith("&")) {
            return PatchouliConfig.getConfigFlagAND(name.replaceAll("[&|]", "").split(","));
        }
        if (name.startsWith("|")) {
            return PatchouliConfig.getConfigFlagOR(name.replaceAll("[&|]", "").split(","));
        }
        boolean target = true;
        if (name.startsWith("!")) {
            name = name.substring(1);
            target = false;
        }
        if ((b = CONFIG_FLAGS.get(name = name.trim().toLowerCase(Locale.ROOT))) == null) {
            if (!name.startsWith("mod:")) {
                Patchouli.LOGGER.warn("Queried for unknown config flag: {}", (Object)name);
            }
            b = false;
        }
        return b == target;
    }

    public static boolean getConfigFlagAND(String[] tokens) {
        for (String s : tokens) {
            if (PatchouliConfig.getConfigFlag(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean getConfigFlagOR(String[] tokens) {
        for (String s : tokens) {
            if (!PatchouliConfig.getConfigFlag(s)) continue;
            return true;
        }
        return false;
    }

    public static void setFlag(String flag, boolean value) {
        CONFIG_FLAGS.put(flag.trim().toLowerCase(Locale.ROOT), value);
    }

    static {
        CONFIG_FLAGS = new HashMap<String, Boolean>();
    }

    static class ClientLoader {
        public ClientLoader(ForgeConfigSpec.Builder builder) {
            builder.push("client");
            disableAdvancementLocking = builder.comment("Set this to true to disable advancement locking for ALL books, making all entries visible at all times. Config Flag: advancements_disabled").define("Disable Advancement Locking", false);
            noAdvancementBooks = builder.comment("Granular list of Book ID's to disable advancement locking for, e.g. [ \"botania:lexicon\" ]. Config Flags: advancements_disabled_<bookid>").defineList("no_advancement_books", Collections.emptyList(), s -> ResourceLocation.func_208304_a((String)((String)s)) != null);
            testingMode = builder.comment("Enable testing mode. By default this doesn't do anything, but you can use the config flag in your books if you want. Config Flag: testing_mode").define("Testing Mode", false);
            inventoryButtonBook = builder.comment("Set this to the ID of a book to have it show up in players' inventories, replacing the recipe book.").define("Inventory Button Book", (Object)"");
            useShiftForQuickLookup = builder.comment("Set this to true to use Shift instead of Ctrl for the inventory quick lookup feature.").define("quickLookupShift", false);
            builder.pop();
        }
    }
}

