/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.commands;

import com.performant.coremod.event.EventHandlerB;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.IEventListener;

public class ReportData {
    private static final String TP_COMMAND = "/execute as @s in %s run tp %d %d %d";
    public static HashMap<UUID, ReportData> entityReport = new HashMap();
    public static HashMap<WorldPos, ReportData> tileEntityReport = new HashMap();
    public LivingEntity entity;
    public Goal lagGoal;
    public TileEntity te;
    public World world;
    public int totalTickTime = 0;
    public int goalTime = 0;

    public int getTotelTickTime() {
        return this.totalTickTime;
    }

    public static void addEntityReport(Entity entity, ReportData data) {
        ReportData existing = entityReport.get(entity.func_110124_au());
        if (existing != null) {
            if (existing.goalTime < data.goalTime || existing.lagGoal == null) {
                existing.lagGoal = data.lagGoal;
            }
            existing.goalTime += data.goalTime;
            existing.totalTickTime += data.totalTickTime;
        } else {
            entityReport.put(entity.func_110124_au(), data);
        }
    }

    public static void addTileEntityReport(TileEntity te, ReportData data) {
        WorldPos pos = new WorldPos(te.func_174877_v(), te.func_145831_w());
        ReportData existing = tileEntityReport.get(pos);
        if (existing != null) {
            existing.totalTickTime += data.totalTickTime;
        } else {
            tileEntityReport.put(pos, data);
        }
    }

    public static void reportEntities(CommandSource source, int startIndex) {
        if (entityReport.isEmpty()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Result is empty, no AI was throttled or startGatherData command was not run yet. Server may not have reached the configured lag threshold before loadbalancing.").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.BLUE))), false);
            return;
        }
        ArrayList<ReportData> sortedData = new ArrayList<ReportData>(entityReport.values());
        sortedData.sort(Comparator.comparingInt(ReportData::getTotelTickTime).reversed());
        int i = 0;
        for (i = startIndex; i < startIndex + 5 && i < sortedData.size(); ++i) {
            ReportData data = (ReportData)sortedData.get(i);
            if (!data.entity.func_70089_S()) {
                sortedData.remove(i);
                --i;
                continue;
            }
            source.func_197030_a((ITextComponent)new StringTextComponent(" Time:").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.DARK_GREEN))).func_230529_a_((ITextComponent)new StringTextComponent("" + (int)((double)data.totalTickTime * 1.0E-6)).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.WHITE)))).func_230529_a_((ITextComponent)new StringTextComponent(" Entity:").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.DARK_GREEN)))).func_230529_a_((ITextComponent)new StringTextComponent(data.entity.func_200600_R().func_212546_e().getString()).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.WHITE)))).func_230529_a_((ITextComponent)new StringTextComponent(" pos:").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.DARK_GREEN)))).func_230529_a_((ITextComponent)new StringTextComponent(data.entity.func_233580_cy_().toString()).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.YELLOW)).func_240713_a_(Boolean.valueOf(true)).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(TP_COMMAND, data.entity.field_70170_p.func_234923_W_().func_240901_a_().toString(), (int)data.entity.func_213303_ch().func_82615_a(), (int)data.entity.func_213303_ch().func_82617_b(), (int)data.entity.func_213303_ch().func_82616_c()))))).func_230529_a_((ITextComponent)new StringTextComponent("AITask:").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.DARK_GREEN)))).func_230529_a_((ITextComponent)new StringTextComponent(data.lagGoal == null ? "" : data.lagGoal.toString() + " %:" + data.goalTime / data.totalTickTime).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.WHITE)))), false);
        }
        if (i + 1 < sortedData.size()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("next ---->").func_230530_a_(Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/performant reportEntities %d", i)))), false);
        }
    }

    public static void reportTileEntities(CommandSource source, int startIndex) {
        if (tileEntityReport.isEmpty()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Result is empty, no Tileentity was throttled or startGatherData command was not run yet. Server may not have reached the configured lag threshold before loadbalancing.").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.BLUE))), false);
            return;
        }
        ArrayList<ReportData> sortedData = new ArrayList<ReportData>(tileEntityReport.values());
        sortedData.sort(Comparator.comparingInt(ReportData::getTotelTickTime).reversed());
        int i = 0;
        for (i = startIndex; i < startIndex + 5 && i < sortedData.size(); ++i) {
            ReportData data = (ReportData)sortedData.get(i);
            if (data.te.func_145837_r()) {
                sortedData.remove(i);
                --i;
                continue;
            }
            source.func_197030_a((ITextComponent)new StringTextComponent("Tileentity: ").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.DARK_GREEN))).func_230529_a_((ITextComponent)new TranslationTextComponent(data.te.func_195044_w().func_177230_c().func_149739_a()).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.WHITE)))).func_230529_a_((ITextComponent)new StringTextComponent(" pos:").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.DARK_GREEN))).func_230529_a_((ITextComponent)new StringTextComponent(data.te.func_174877_v().toString()).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.YELLOW)).func_240713_a_(Boolean.valueOf(true)).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(TP_COMMAND, data.world.func_234923_W_().func_240901_a_().toString(), data.te.func_174877_v().func_177958_n(), data.te.func_174877_v().func_177956_o(), data.te.func_174877_v().func_177952_p())))))).func_230529_a_((ITextComponent)new StringTextComponent(" tickTime:").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.DARK_GREEN))).func_230529_a_((ITextComponent)new StringTextComponent("" + data.totalTickTime))), false);
        }
        if (i + 1 < sortedData.size()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("next ---->").func_230530_a_(Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/performant reportTileEntities %d", i)))), false);
        }
    }

    public static void reportEventData(CommandSource source, int startIndex) {
        ArrayList<EventReportData> listeners = new ArrayList<EventReportData>();
        ReportData.addPausedListenersToFrom(listeners, EventHandlerB.preWorldlisteners, EventHandlerB.preWorldTickPause, "preWorldTickEvent");
        ReportData.addPausedListenersToFrom(listeners, EventHandlerB.postWorldlisteners, EventHandlerB.postWorldTickPause, "postWorldTickEvent");
        ReportData.addPausedListenersToFrom(listeners, EventHandlerB.preServerlisteners, EventHandlerB.preServerTickPause, "preServerTickEvent");
        ReportData.addPausedListenersToFrom(listeners, EventHandlerB.postServerlisteners, EventHandlerB.postServerTickPause, "postServerTickEvent");
        listeners.sort(Comparator.comparingInt(rec$ -> ((EventReportData)rec$).getPauseTime()).reversed());
        int i = 0;
        for (i = startIndex; i < startIndex + 5 && i < listeners.size(); ++i) {
            EventReportData data = (EventReportData)listeners.get(i);
            source.func_197030_a((ITextComponent)new StringTextComponent(data.eventName).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.DARK_GREEN))).func_230529_a_((ITextComponent)new StringTextComponent(" took:").func_230529_a_((ITextComponent)new StringTextComponent(data.pauseTime + "").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.DARK_GREEN))).func_230529_a_((ITextComponent)new StringTextComponent(" cause: ").func_230529_a_((ITextComponent)new StringTextComponent(data.listener.toString().replace("ASM: net.minecraftforge.common.ForgeInternalHandler", "")).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.DARK_PURPLE))))))), false);
        }
        if (i + 1 < listeners.size()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("next ---->").func_230530_a_(Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/performant reportEvents %d", i)))), false);
        }
    }

    private static void addPausedListenersToFrom(List<EventReportData> listeners, IEventListener[] listenersAdd, int[][] pauseTimesAdd, String name) {
        if (listenersAdd == null) {
            return;
        }
        for (int i = 0; i < listenersAdd.length; ++i) {
            if (pauseTimesAdd[0][i] <= 0) continue;
            listeners.add(new EventReportData(listenersAdd[i], pauseTimesAdd[1][i], name));
        }
    }

    private static class EventReportData {
        public IEventListener listener;
        public int pauseTime;
        public String eventName;

        public EventReportData(IEventListener listener, int pauseTime, String eventName) {
            this.listener = listener;
            this.pauseTime = pauseTime;
            this.eventName = eventName;
        }

        private int getPauseTime() {
            return this.pauseTime;
        }
    }

    private static class WorldPos {
        public final BlockPos pos;
        public final World world;

        public WorldPos(BlockPos pos, World world) {
            this.pos = pos;
            this.world = world;
        }

        public int hashCode() {
            return this.pos.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof WorldPos)) {
                return false;
            }
            WorldPos otherPos = (WorldPos)other;
            if (!this.pos.equals((Object)otherPos.pos)) {
                return false;
            }
            return this.world == ((WorldPos)other).world;
        }
    }
}

