/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.entity.ai;

import com.performant.coremod.entity.ai.CustomGoalSelector;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.function.Consumer;

public class CustomHashSet<E>
extends LinkedHashSet<E> {
    protected final CustomGoalSelector selector;

    public CustomHashSet(CustomGoalSelector selector) {
        this.selector = selector;
    }

    @Override
    public boolean add(E e) {
        if (super.add(e)) {
            this.selector.setNeedRefresh();
            return true;
        }
        return false;
    }

    @Override
    public final boolean remove(Object object) {
        if (super.remove(object)) {
            this.selector.setNeedRefresh();
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new CustomIteratorWrapper(super.iterator());
    }

    private class CustomIteratorWrapper<E>
    implements Iterator<E> {
        final Iterator<E> internal;

        public CustomIteratorWrapper(Iterator<E> internal) {
            this.internal = internal;
        }

        @Override
        public boolean hasNext() {
            return this.internal.hasNext();
        }

        @Override
        public E next() {
            return this.internal.next();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            this.internal.forEachRemaining(action);
        }

        @Override
        public void remove() {
            this.internal.remove();
            CustomHashSet.this.selector.setNeedRefresh();
        }
    }
}

