/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.mixin.entity;

import com.performant.coremod.commands.ReportData;
import com.performant.coremod.config.ConfigurationCache;
import com.performant.coremod.entity.threading.BlockCollideAction;
import com.performant.coremod.entity.threading.BlockFallAction;
import com.performant.coremod.entity.threading.BlockWalkAction;
import com.performant.coremod.entity.threading.IEntityAction;
import com.performant.coremod.entity.threading.IThreadedMoveEntity;
import com.performant.coremod.entity.threading.MoveData;
import com.performant.coremod.entity.threading.MoveThread;
import com.performant.coremod.world.ChunkCache;
import com.performant.coremod.world.Collisions;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.ITag;
import net.minecraft.util.AxisRotation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.CubeCoordinateIterator;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class}, priority=998)
public abstract class LivingEntityMixin
extends Entity
implements IThreadedMoveEntity {
    @Shadow
    @Final
    private static DataParameter<Float> field_184632_c;
    @Shadow
    private boolean field_70752_e;
    @Shadow
    @Final
    private static DataParameter<Integer> field_184633_f;
    @Shadow
    @Final
    private static DataParameter<Boolean> field_184634_g;
    @Shadow
    public float field_70761_aq;
    @Shadow
    protected float field_70768_au;
    @Shadow
    protected float field_110154_aX;
    @Shadow
    public float field_70733_aJ;
    @Shadow
    public float field_70760_ar;
    @Shadow
    public float field_70759_as;
    @Shadow
    public float field_70758_at;
    @Shadow
    protected float field_70764_aw;
    @Shadow
    protected int field_184629_bo;
    private int tickCounter;
    LivingEntity self;
    boolean hasMovedForCalc;
    private volatile ChunkCache chunkCache;
    private int chunkOldX;
    private int chunkOldZ;
    private int chunkCounter;
    long preTick;
    double lastTickX;
    double lastTickY;
    double lastTickZ;
    private volatile DamageSource source;
    private volatile float amount;
    boolean isPlayer;
    private static final double MOTION_MULT_LENGHT = 1.0E-7;
    private Vector3d lastMovementVec;
    private Vector3d lastPosVec;
    private ConcurrentLinkedQueue<IEntityAction> mainThreadQue;
    boolean lastHandleWaterMovement;
    boolean isInWaterRainOrBubbleColumn;
    boolean lastIsEntityInsideOpaqueBlock;
    boolean isFlammableWithin;
    double lastX;
    double lastY;
    double lastZ;
    double lastVecX;
    double lastVecY;
    double lastVecZ;
    Vector3d lastVector;
    Vector3d lastHeuristicResult;
    int lastminX;
    int lastmaxX;
    int lastminY;
    int lastmaxY;
    int lastminZ;
    int lastmaxZ;
    int lastEntitySize;
    Vector3d preVec;
    boolean isOffsetPosInLiquidres;
    float lastSpeedFactor;
    volatile boolean lastIsOnLadder;
    boolean forgeLadderCheck;
    private volatile float health;

    @Shadow
    protected abstract void func_70695_b(EffectInstance var1, boolean var2);

    @Shadow
    protected abstract void func_70688_c(EffectInstance var1);

    @Shadow
    protected abstract void func_175135_B();

    @Shadow
    public abstract boolean func_70097_a(DamageSource var1, float var2);

    @Shadow
    protected abstract float func_110146_f(float var1, float var2);

    @Shadow
    public abstract boolean func_184613_cA();

    @Shadow
    public abstract boolean func_70608_bn();

    @Shadow
    public abstract boolean func_70089_S();

    @Shadow
    protected abstract void func_82167_n(Entity var1);

    public LivingEntityMixin(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.tickCounter = this.field_70146_Z.nextInt(100);
        this.self = (LivingEntity)this;
        this.hasMovedForCalc = false;
        this.chunkCache = null;
        this.chunkOldX = 0;
        this.chunkOldZ = 0;
        this.chunkCounter = this.self.field_70170_p.field_73012_v.nextInt(1000);
        this.lastTickX = 0.0;
        this.lastTickY = 0.0;
        this.lastTickZ = 0.0;
        this.source = null;
        this.amount = 0.0f;
        this.isPlayer = this.self instanceof PlayerEntity;
        this.lastMovementVec = Vector3d.field_186680_a;
        this.lastPosVec = Vector3d.field_186680_a;
        this.mainThreadQue = new ConcurrentLinkedQueue();
        this.lastHandleWaterMovement = false;
        this.isInWaterRainOrBubbleColumn = false;
        this.lastIsEntityInsideOpaqueBlock = false;
        this.isFlammableWithin = false;
        this.lastX = 0.0;
        this.lastY = 0.0;
        this.lastZ = 0.0;
        this.lastVecX = 0.0;
        this.lastVecY = 0.0;
        this.lastVecZ = 0.0;
        this.lastVector = null;
        this.lastHeuristicResult = Vector3d.field_186680_a;
        this.lastminX = 0;
        this.lastmaxX = 0;
        this.lastminY = 0;
        this.lastmaxY = 0;
        this.lastminZ = 0;
        this.lastmaxZ = 0;
        this.lastEntitySize = 0;
        this.preVec = Vector3d.field_186680_a;
        this.isOffsetPosInLiquidres = false;
        this.lastSpeedFactor = 1.0f;
        this.lastIsOnLadder = false;
        this.forgeLadderCheck = (Boolean)ForgeConfig.SERVER.fullBoundingBoxLadders.get();
        this.health = -1.0f;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(EntityType<? extends LivingEntity> type, World worldIn, CallbackInfo ci) {
        this.self.func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        this.self.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get());
    }

    @Override
    public ChunkCache getCache() {
        if (this.chunkCache == null) {
            this.chunkCounter = 0;
            this.chunkCache = new ChunkCache(this.field_70170_p, this.self.func_233580_cy_().func_177982_a(-64, 0, -64), this.self.func_233580_cy_().func_177982_a(64, 0, 64));
            this.chunkCache.setEntity(this);
            if (!this.func_70089_S()) {
                this.chunkCache.setInvalid();
            }
        }
        return this.chunkCache;
    }

    private void recheckCache() {
        if (this.chunkCache == null || this.chunkCounter >= 5000 || this.chunkOldX != (int)this.func_226277_ct_() >> 4 || this.chunkOldZ != (int)this.func_226281_cx_() >> 4 || !this.chunkCache.isValid() || this.field_70128_L) {
            if (this.func_70089_S()) {
                this.chunkCache = new ChunkCache(this.field_70170_p, this.self.func_233580_cy_().func_177982_a(-64, 0, -64), this.self.func_233580_cy_().func_177982_a(64, 0, 64));
                this.chunkCache.setEntity(this);
                this.chunkCounter = 0;
            } else {
                this.chunkCache.setInvalid();
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo callbackInfo) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70142_S = this.lastTickX;
            this.field_70137_T = this.lastTickY;
            this.field_70136_U = this.lastTickZ;
            this.lastTickX = this.func_226277_ct_();
            this.lastTickY = this.func_226278_cu_();
            this.lastTickZ = this.func_226281_cx_();
        }
        if (ConfigurationCache.generateReport) {
            this.preTick = System.nanoTime();
        }
        if (this.tickCounter++ == 100) {
            this.tickCounter = 0;
        }
        ++this.chunkCounter;
        this.recheckCache();
        this.chunkOldX = (int)this.func_226277_ct_() >> 4;
        this.chunkOldZ = (int)this.func_226281_cx_() >> 4;
        this.hasMovedForCalc = this.lastX != this.func_213303_ch().func_82615_a() || this.lastY != this.func_213303_ch().func_82617_b() || this.lastZ != this.func_213303_ch().func_82616_c();
        this.lastX = this.func_213303_ch().func_82615_a();
        this.lastY = this.func_213303_ch().func_82617_b();
        this.lastZ = this.func_213303_ch().func_82616_c();
        this.checkFireArea();
        while (!this.mainThreadQue.isEmpty()) {
            IEntityAction next = this.mainThreadQue.poll();
            next.execute(this.self);
        }
        if (this.source != null) {
            this.func_70097_a(this.source, this.amount);
            this.source = null;
        }
        if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K && this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_217464_b((Entity)this.self);
        }
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    public void tickEnd(CallbackInfo callbackInfo) {
        if (ConfigurationCache.generateReport && this.preTick > 30000L) {
            this.preTick = System.nanoTime() - this.preTick;
            ReportData data = new ReportData();
            data.totalTickTime = (int)this.preTick;
            data.entity = this.self;
            ReportData.addEntityReport((Entity)this.self, data);
        }
    }

    @Redirect(method={"aiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;travel(Lnet/minecraft/util/math/vector/Vector3d;)V"))
    public void OnTravelRequest(LivingEntity entity, Vector3d travelVec) {
        if (ConfigurationCache.multiEntities && !this.isPlayer && this instanceof IThreadedMoveEntity && !this.field_70170_p.field_72995_K) {
            MoveThread.enqueMove(new MoveData(this, travelVec));
        } else {
            this.updateLadderState();
            this.self.func_213352_e(travelVec);
        }
    }

    @Override
    public void callTravel(MoveData data) {
        this.updateLadderState();
        this.self.func_213352_e(data.movePos);
        double xDelta = this.func_226277_ct_() - this.field_70169_q;
        double zDelta = this.func_226281_cx_() - this.field_70166_s;
        float squareDist = (float)(xDelta * xDelta + zDelta * zDelta);
        float f1 = this.field_70761_aq;
        float f2 = 0.0f;
        this.field_70768_au = this.field_110154_aX;
        float f3 = 0.0f;
        if (squareDist > 0.0025000002f) {
            f3 = 1.0f;
            f2 = (float)Math.sqrt(squareDist) * 3.0f;
            float f4 = (float)MathHelper.func_181159_b((double)zDelta, (double)xDelta) * 57.295776f - 90.0f;
            float f5 = MathHelper.func_76135_e((float)(MathHelper.func_76142_g((float)this.field_70177_z) - f4));
            f1 = 95.0f < f5 && f5 < 265.0f ? f4 - 180.0f : f4;
        }
        if (this.field_70733_aJ > 0.0f) {
            f1 = this.field_70177_z;
        }
        if (!this.field_70122_E) {
            f3 = 0.0f;
        }
        this.field_110154_aX += (f3 - this.field_110154_aX) * 0.3f;
        f2 = this.func_110146_f(f1, f2);
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        while (this.field_70761_aq - this.field_70760_ar < -180.0f) {
            this.field_70760_ar -= 360.0f;
        }
        while (this.field_70761_aq - this.field_70760_ar >= 180.0f) {
            this.field_70760_ar += 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70759_as - this.field_70758_at < -180.0f) {
            this.field_70758_at -= 360.0f;
        }
        while (this.field_70759_as - this.field_70758_at >= 180.0f) {
            this.field_70758_at += 360.0f;
        }
        this.field_70764_aw += f2;
        this.field_184629_bo = this.func_184613_cA() ? ++this.field_184629_bo : 0;
        if (this.func_70608_bn()) {
            this.field_70125_A = 0.0f;
        }
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/BlockState;"))
    private BlockState onTravelGetBlockState(World world, BlockPos pos) {
        return this.getCache().func_180495_p(pos);
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getFluidState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/fluid/FluidState;"))
    private FluidState onTravelGetFluidState(World world, BlockPos pos) {
        return this.getCache().func_204610_c(pos);
    }

    @Redirect(method={"baseTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/BlockState;"))
    private BlockState onbasetickGetBlockState(World world, BlockPos pos) {
        return this.getCache().func_180495_p(pos);
    }

    @Redirect(method={"onSoulSpeedBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/BlockState;"))
    private BlockState onSoulSandGetBlockState(World world, BlockPos pos) {
        return this.getCache().func_180495_p(pos);
    }

    @Redirect(method={"trapdoorUsableAsLadder"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/BlockState;"))
    private BlockState oncanGoThroughtTrapDoorOnLadderGetBlockState(World world, BlockPos pos) {
        return this.getCache().func_180495_p(pos);
    }

    @Redirect(method={"playBlockFallSound"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/BlockState;"))
    private BlockState onPlayFallSoundGetBlockState(World world, BlockPos pos) {
        return this.getCache().func_180495_p(pos);
    }

    @Redirect(method={"dismountVehicle"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/BlockState;"))
    private BlockState onStopRidingGetBlockState(World world, BlockPos pos) {
        return this.getCache().func_180495_p(pos);
    }

    @Redirect(method={"startSleeping"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/BlockState;"))
    private BlockState onStartSleepingGetBlockState(World world, BlockPos pos) {
        return this.getCache().func_180495_p(pos);
    }

    protected BlockState func_233568_aJ_() {
        return this.getCache().func_180495_p(this.func_226268_ag_());
    }

    @Overwrite
    public BlockState func_213339_cH() {
        return this.getCache().func_180495_p(this.func_233580_cy_());
    }

    public void func_213315_a(MoverType typeIn, Vector3d pos) {
        if (this.isPlayer && this.field_70170_p.field_72995_K) {
            super.func_213315_a(typeIn, pos);
            return;
        }
        if (this.field_70145_X) {
            this.func_174826_a(this.func_174813_aQ().func_191194_a(pos));
            this.func_174829_m();
            return;
        }
        if (typeIn == MoverType.PISTON && (pos = this.func_213308_a(pos)).equals((Object)Vector3d.field_186680_a)) {
            return;
        }
        if (this.field_213328_B.func_189985_c() > 1.0E-7) {
            pos = pos.func_216369_h(this.field_213328_B);
            this.field_213328_B = Vector3d.field_186680_a;
            this.func_213317_d(Vector3d.field_186680_a);
        }
        if (ConfigurationCache.adaptiveSpeed && ConfigurationCache.slownessFactor > 1.0 && !this.field_70170_p.field_72995_K && !(this.self instanceof PlayerEntity) && !(this.self.func_184179_bs() instanceof PlayerEntity)) {
            pos = pos.func_186678_a(ConfigurationCache.slownessFactor);
        }
        pos = this.func_225514_a_(pos, typeIn);
        Vector3d Vector3d2 = this.getAllowedMovement(pos);
        if (this.self instanceof PlayerEntity && !this.field_70170_p.func_175723_af().func_177746_a(new BlockPos(this.func_213303_ch().func_178787_e(Vector3d2))) && this.field_70170_p.func_175723_af().func_177746_a(this.func_233580_cy_())) {
            return;
        }
        if (Vector3d2.func_189985_c() > 1.0E-7) {
            this.func_174826_a(this.func_174813_aQ().func_191194_a(Vector3d2));
            this.func_174829_m();
        }
        this.field_70123_F = !MathHelper.func_219806_b((double)pos.field_72450_a, (double)Vector3d2.field_72450_a) || !MathHelper.func_219806_b((double)pos.field_72449_c, (double)Vector3d2.field_72449_c);
        this.field_70124_G = pos.field_72448_b != Vector3d2.field_72448_b;
        this.field_70122_E = this.field_70124_G && pos.field_72448_b < 0.0;
        this.updateFallState(Vector3d2, pos);
        Vector3d Vector3d1 = this.func_213322_ci();
        if (pos.field_72450_a != Vector3d2.field_72450_a) {
            this.func_213293_j(0.0, Vector3d1.field_72448_b, Vector3d1.field_72449_c);
        }
        if (pos.field_72449_c != Vector3d2.field_72449_c) {
            this.func_213293_j(Vector3d1.field_72450_a, Vector3d1.field_72448_b, 0.0);
        }
        this.checkBlockCollisions();
        this.func_213317_d(this.func_213322_ci().func_216372_d((double)this.func_225515_ai_(), 1.0, (double)this.func_225515_ai_()));
    }

    @Override
    public void callupdateFallState(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.func_184231_a(y, onGroundIn, state, pos);
    }

    private void updateFallState(Vector3d movementVec, Vector3d pos) {
        if (!this.hasMovedForCalc && this.tickCounter % 20 != 0 && this.field_70122_E && pos.equals((Object)this.lastPosVec) && movementVec.equals((Object)this.lastMovementVec)) {
            return;
        }
        this.lastPosVec = pos;
        this.lastMovementVec = movementVec;
        BlockPos blockpos = this.func_226268_ag_();
        BlockState blockstate = this.getCache().func_180495_p(blockpos);
        if (this.field_70122_E && this.field_70143_R > 0.0f && ConfigurationCache.multiEntities && !this.isPlayer) {
            this.mainThreadQue.offer(new BlockFallAction(movementVec.field_72448_b, this.field_70122_E, blockstate, blockpos, this.field_70170_p));
        } else {
            this.func_184231_a(movementVec.field_72448_b, this.field_70122_E, blockstate, blockpos);
        }
        Block block = blockstate.func_177230_c();
        if (pos.field_72448_b != movementVec.field_72448_b) {
            block.func_176216_a((IBlockReader)this.getCache(), (Entity)this);
        }
        if (this.field_70122_E && !this.func_226271_bk_()) {
            if (ConfigurationCache.multiEntities && !this.isPlayer) {
                this.mainThreadQue.offer(new BlockWalkAction(block, this.field_70170_p, blockpos));
            } else {
                block.func_176199_a(this.field_70170_p, blockpos, (Entity)this);
            }
        }
        if (this.func_225502_at_() && !this.func_184218_aH()) {
            double d0 = movementVec.field_72450_a;
            double d1 = movementVec.field_72448_b;
            double d2 = movementVec.field_72449_c;
            if (block != Blocks.field_150468_ap && block != Blocks.field_222420_lI) {
                d1 = 0.0;
            }
            this.field_70140_Q = (float)((double)this.field_70140_Q + (double)MathHelper.func_76133_a((double)LivingEntityMixin.func_213296_b((Vector3d)movementVec)) * 0.6);
            this.field_82151_R = (float)((double)this.field_82151_R + (double)MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2)) * 0.6);
            if (this.field_82151_R > this.field_70150_b && !blockstate.isAir((IBlockReader)this.getCache(), blockpos)) {
                this.field_70150_b = this.func_203009_ad();
                if (this.func_70090_H()) {
                    LivingEntityMixin entity = this.func_184207_aI() && this.func_184179_bs() != null ? this.func_184179_bs() : this;
                    float f = entity == this ? 0.35f : 0.4f;
                    Vector3d Vector3d2 = entity.func_213322_ci();
                    float f1 = MathHelper.func_76133_a((double)(Vector3d2.field_72450_a * Vector3d2.field_72450_a * (double)0.2f + Vector3d2.field_72448_b * Vector3d2.field_72448_b + Vector3d2.field_72449_c * Vector3d2.field_72449_c * (double)0.2f)) * f;
                    if (f1 > 1.0f) {
                        f1 = 1.0f;
                    }
                    this.func_203006_d(f1);
                } else {
                    this.func_180429_a(blockpos, blockstate);
                }
            } else if (this.field_82151_R > this.field_191959_ay && this.func_191957_ae() && blockstate.isAir((IBlockReader)this.getCache(), blockpos)) {
                this.field_191959_ay = this.func_191954_d(this.field_82151_R);
            }
        }
    }

    @Override
    public void clearCache() {
        this.chunkCache = null;
    }

    @Override
    public void clearQueue() {
        this.mainThreadQue.clear();
    }

    protected BlockPos func_226268_ag_() {
        int i = MathHelper.func_76128_c((double)this.func_213303_ch().field_72450_a);
        int j = MathHelper.func_76128_c((double)(this.func_213303_ch().field_72448_b - (double)0.2f));
        int k = MathHelper.func_76128_c((double)this.func_213303_ch().field_72449_c);
        BlockPos blockpos = new BlockPos(i, j, k);
        if (this.getCache().func_175623_d(blockpos)) {
            BlockPos blockpos1 = blockpos.func_177977_b();
            BlockState blockstate = this.getCache().func_180495_p(blockpos1);
            if (blockstate.collisionExtendsVertically((IBlockReader)this.getCache(), blockpos1, (Entity)this)) {
                return blockpos1;
            }
        }
        return blockpos;
    }

    public boolean func_233566_aG_() {
        if (!this.hasMovedForCalc && this.tickCounter % 20 != 0) {
            return this.lastHandleWaterMovement;
        }
        this.lastHandleWaterMovement = super.func_233566_aG_();
        return this.lastHandleWaterMovement;
    }

    public boolean func_210500_b(ITag<Fluid> fluidTag, double p_210500_2_) {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_186664_h(0.001);
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)axisalignedbb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        double d0 = 0.0;
        boolean flag = this.func_96092_aw();
        boolean flag1 = false;
        Vector3d vector3d = Vector3d.field_186680_a;
        int k1 = 0;
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = k; i2 < l; ++i2) {
                for (int j2 = i1; j2 < j1; ++j2) {
                    double d1;
                    BlockPos posToCheck = new BlockPos(l1, i2, j2);
                    FluidState ifluidstate = this.getCache().func_204610_c(posToCheck);
                    if (!ifluidstate.func_206884_a(fluidTag) || !((d1 = (double)((float)i2 + ifluidstate.func_215679_a((IBlockReader)this.getCache(), posToCheck))) >= axisalignedbb.field_72338_b)) continue;
                    flag1 = true;
                    d0 = Math.max(d1 - axisalignedbb.field_72338_b, d0);
                    if (!flag) continue;
                    Vector3d vector3d1 = ifluidstate.func_215673_c((IBlockReader)this.getCache(), posToCheck);
                    if (d0 < 0.4) {
                        vector3d1 = vector3d1.func_186678_a(d0);
                    }
                    vector3d = vector3d.func_178787_e(vector3d1);
                    ++k1;
                }
            }
        }
        if (vector3d.func_72433_c() > 0.0) {
            if (k1 > 0) {
                vector3d = vector3d.func_186678_a(1.0 / (double)k1);
            }
            if (!(this.self instanceof PlayerEntity)) {
                vector3d = vector3d.func_72432_b();
            }
            Vector3d vector3d2 = this.func_213322_ci();
            vector3d = vector3d.func_186678_a(p_210500_2_ * 1.0);
            double d2 = 0.003;
            if (Math.abs(vector3d2.field_72450_a) < 0.003 && Math.abs(vector3d2.field_72449_c) < 0.003 && vector3d.func_72433_c() < 0.0045000000000000005) {
                vector3d = vector3d.func_72432_b().func_186678_a(0.0045000000000000005);
            }
            this.func_213317_d(this.func_213322_ci().func_178787_e(vector3d));
        }
        this.field_233554_M_.put(fluidTag, d0);
        return flag1;
    }

    public boolean func_203008_ap() {
        if (!this.hasMovedForCalc && this.tickCounter % 5 != 0) {
            return this.isInWaterRainOrBubbleColumn;
        }
        this.isInWaterRainOrBubbleColumn = super.func_203008_ap();
        return this.isInWaterRainOrBubbleColumn;
    }

    public boolean func_70094_T() {
        if (this.tickCounter % 5 != 0) {
            return this.lastIsEntityInsideOpaqueBlock;
        }
        if (this.field_70145_X) {
            this.lastIsEntityInsideOpaqueBlock = false;
            return false;
        }
        BlockPos checkPos = this.func_233580_cy_();
        for (int i = 0; i < 8; ++i) {
            VoxelShape blockShape;
            int j = MathHelper.func_76128_c((double)(this.func_226278_cu_() + (double)(((float)((i >> 0) % 2) - 0.5f) * 0.1f) + (double)this.self.func_70047_e()));
            int k = MathHelper.func_76128_c((double)(this.func_226277_ct_() + (double)(((float)((i >> 1) % 2) - 0.5f) * this.self.func_213311_cf() * 0.8f)));
            int l = MathHelper.func_76128_c((double)(this.func_226281_cx_() + (double)(((float)((i >> 2) % 2) - 0.5f) * this.self.func_213311_cf() * 0.8f)));
            if (checkPos.func_177958_n() == k && checkPos.func_177956_o() == j && checkPos.func_177952_p() == l) continue;
            checkPos = new BlockPos(k, j, l);
            BlockState state = this.getCache().func_180495_p(checkPos);
            if (!state.func_229980_m_((IBlockReader)this.getCache(), checkPos) || (blockShape = state.func_215685_b((IBlockReader)this.getCache(), checkPos, ISelectionContext.func_216374_a((Entity)this.self))) == VoxelShapes.func_197880_a()) continue;
            this.lastIsEntityInsideOpaqueBlock = true;
            return true;
        }
        this.lastIsEntityInsideOpaqueBlock = false;
        return false;
    }

    @Override
    public boolean shouldRun() {
        return this.self.func_70089_S();
    }

    private void checkFireArea() {
        if (this.func_230279_az_()) {
            return;
        }
        if (this.tickCounter % 5 == 0) {
            this.isFlammableWithin = this.getCache().isFlammableWithin(this.func_174813_aQ().func_186664_h(0.001));
        }
        if (this.isFlammableWithin) {
            if (!this.func_203008_ap()) {
                ++this.field_190534_ay;
                if (this.field_190534_ay == 0) {
                    this.func_70015_d(8);
                }
            }
            this.func_70097_a(DamageSource.field_76370_b, 1.0f);
        } else if (this.field_190534_ay <= 0) {
            this.field_190534_ay = -this.func_190531_bD();
        }
        if (this.isInWaterRainOrBubbleColumn && this.func_70027_ad()) {
            this.func_184185_a(SoundEvents.field_187541_bC, 0.7f, 1.6f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
            this.field_190534_ay = -this.func_190531_bD();
        }
    }

    private void checkBlockCollisions() {
        this.func_145775_I();
    }

    protected void func_145775_I() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        BlockPos blockpos = new BlockPos(axisalignedbb.field_72340_a + 0.001, axisalignedbb.field_72338_b + 0.001, axisalignedbb.field_72339_c + 0.001);
        BlockPos blockpos1 = new BlockPos(axisalignedbb.field_72336_d - 0.001, axisalignedbb.field_72337_e - 0.001, axisalignedbb.field_72334_f - 0.001);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        if (this.field_70170_p.func_175707_a(blockpos, blockpos1)) {
            for (int i = blockpos.func_177958_n(); i <= blockpos1.func_177958_n(); ++i) {
                for (int j = blockpos.func_177956_o(); j <= blockpos1.func_177956_o(); ++j) {
                    for (int k = blockpos.func_177952_p(); k <= blockpos1.func_177952_p(); ++k) {
                        blockpos$mutable.func_181079_c(i, j, k);
                        BlockState blockstate = this.isPlayer ? this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable) : this.getCache().func_180495_p((BlockPos)blockpos$mutable);
                        try {
                            if (blockstate.func_177230_c() == Blocks.field_150350_a) continue;
                            if (!this.isPlayer) {
                                this.mainThreadQue.offer(new BlockCollideAction(new BlockPos((Vector3i)blockpos$mutable), blockstate, this.field_70170_p));
                            } else {
                                blockstate.func_196950_a(this.self.field_70170_p, (BlockPos)blockpos$mutable, (Entity)this.self);
                            }
                            this.func_191955_a(blockstate);
                            continue;
                        }
                        catch (Throwable throwable) {
                            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Colliding entity with block");
                            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being collided with");
                            CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)blockpos$mutable, (BlockState)blockstate);
                            throw new ReportedException(crashreport);
                        }
                    }
                }
            }
        }
    }

    private Vector3d getAllowedMovement(Vector3d vec) {
        boolean flag3;
        if (!this.isPlayer && !this.hasMovedForCalc && vec.field_72450_a == this.lastVecX && vec.field_72448_b == this.lastVecY && vec.field_72449_c == this.lastVecZ && this.tickCounter % 10 != 0 && this.lastVector != null) {
            return this.lastVector;
        }
        this.lastVecX = vec.field_72450_a;
        this.lastVecY = vec.field_72448_b;
        this.lastVecZ = vec.field_72449_c;
        AxisAlignedBB boundingBox = this.func_174813_aQ();
        ISelectionContext iselectioncontext = ISelectionContext.func_216374_a((Entity)this);
        ArrayList<VoxelShape> entityVoxelShapes = new ArrayList<VoxelShape>();
        if (!(vec.field_72450_a == 0.0 && vec.field_72449_c == 0.0 || !this.isPlayer && this.field_70170_p.field_72995_K)) {
            entityVoxelShapes.addAll(Collisions.getEntityCollisionBoxes(this, boundingBox.func_216361_a(vec), null, this.getCache()));
        }
        Vector3d Vector3d2 = vec.func_189985_c() == 0.0 ? vec : this.collideBoundingBoxHeuristically(this, vec, boundingBox, this.getCache(), iselectioncontext, entityVoxelShapes);
        boolean flag = vec.field_72450_a != Vector3d2.field_72450_a;
        boolean flag1 = vec.field_72448_b != Vector3d2.field_72448_b;
        boolean flag2 = vec.field_72449_c != Vector3d2.field_72449_c;
        boolean bl = flag3 = this.field_70122_E || flag1 && vec.field_72448_b < 0.0;
        if (this.field_70138_W > 0.0f && flag3 && (flag || flag2)) {
            Vector3d Vector3d3;
            Vector3d Vector3d1 = this.collideBoundingBoxHeuristically(this, new Vector3d(vec.field_72450_a, (double)this.field_70138_W, vec.field_72449_c), boundingBox, this.getCache(), iselectioncontext, entityVoxelShapes);
            Vector3d Vector3d22 = this.collideBoundingBoxHeuristically(this, new Vector3d(0.0, (double)this.field_70138_W, 0.0), boundingBox.func_72321_a(vec.field_72450_a, 0.0, vec.field_72449_c), this.getCache(), iselectioncontext, entityVoxelShapes);
            if (Vector3d22.field_72448_b < (double)this.field_70138_W && LivingEntityMixin.func_213296_b((Vector3d)(Vector3d3 = this.collideBoundingBoxHeuristically(this, new Vector3d(vec.field_72450_a, 0.0, vec.field_72449_c), boundingBox.func_191194_a(Vector3d22), this.getCache(), iselectioncontext, entityVoxelShapes).func_178787_e(Vector3d22))) > LivingEntityMixin.func_213296_b((Vector3d)Vector3d1)) {
                Vector3d1 = Vector3d3;
            }
            if (LivingEntityMixin.func_213296_b((Vector3d)Vector3d1) > LivingEntityMixin.func_213296_b((Vector3d)Vector3d2)) {
                this.lastVector = Vector3d1.func_178787_e(this.collideBoundingBoxHeuristically(this, new Vector3d(0.0, -Vector3d1.field_72448_b + vec.field_72448_b, 0.0), boundingBox.func_191194_a(Vector3d1), this.getCache(), iselectioncontext, entityVoxelShapes));
                return this.lastVector;
            }
        }
        this.lastVector = Vector3d2;
        return this.lastVector;
    }

    private Vector3d collideBoundingBoxHeuristically(@Nullable Entity entity, Vector3d Vector3d2, AxisAlignedBB axisAlignedBB, ChunkCache world, ISelectionContext iSelectionContext, List<VoxelShape> entityVoxelShapes) {
        boolean hasXMovement = Vector3d2.field_72450_a != 0.0;
        boolean hasYMovement = Vector3d2.field_72448_b != 0.0;
        boolean hasZMovement = Vector3d2.field_72449_c != 0.0;
        this.lastHeuristicResult = !(!hasXMovement && !hasYMovement || !hasXMovement && !hasZMovement || !hasYMovement && !hasZMovement) ? this.collideBoundingBoxSingle(entity, Vector3d2, axisAlignedBB, entityVoxelShapes) : this.getAllowedMovement(Vector3d2, axisAlignedBB, world, iSelectionContext, entityVoxelShapes);
        return this.lastHeuristicResult;
    }

    private Vector3d collideBoundingBoxSingle(Entity entity, Vector3d Vector3d2, AxisAlignedBB axisAlignedBB, List<VoxelShape> entityCollisionBoxes) {
        boolean flag;
        AxisAlignedBB expandedaxisAlignedBB = axisAlignedBB.func_216361_a(Vector3d2);
        int minX = MathHelper.func_76128_c((double)(expandedaxisAlignedBB.field_72340_a - 1.0E-7)) - 1;
        int maxX = MathHelper.func_76128_c((double)(expandedaxisAlignedBB.field_72336_d + 1.0E-7)) + 1;
        int minY = MathHelper.func_76128_c((double)(expandedaxisAlignedBB.field_72338_b - 1.0E-7)) - 1;
        int maxY = MathHelper.func_76128_c((double)(expandedaxisAlignedBB.field_72337_e + 1.0E-7)) + 1;
        int minZ = MathHelper.func_76128_c((double)(expandedaxisAlignedBB.field_72339_c - 1.0E-7)) - 1;
        int maxZ = MathHelper.func_76128_c((double)(expandedaxisAlignedBB.field_72334_f + 1.0E-7)) + 1;
        ISelectionContext iselectioncontext = entity == null ? ISelectionContext.func_216377_a() : ISelectionContext.func_216374_a((Entity)entity);
        CubeCoordinateIterator cubecoordinateiterator = new CubeCoordinateIterator(minX, minY, minZ, maxX, maxY, maxZ);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        VoxelShape entityVoxelShape = VoxelShapes.func_197881_a((AxisAlignedBB)expandedaxisAlignedBB);
        ArrayList<VoxelShape> allCollisionShapes = new ArrayList<VoxelShape>(entityCollisionBoxes);
        LivingEntityMixin.addShapesForBlockCollision(allCollisionShapes, cubecoordinateiterator, blockpos$mutable, this.getCache(), iselectioncontext, entityVoxelShape);
        double xMotion = Vector3d2.field_72450_a;
        double yMotion = Vector3d2.field_72448_b;
        double zMotion = Vector3d2.field_72449_c;
        this.lastminX = minX;
        this.lastmaxX = maxX;
        this.lastminY = minY;
        this.lastmaxY = maxY;
        this.lastminZ = minZ;
        this.lastmaxZ = maxZ;
        this.preVec = Vector3d2;
        if (yMotion != 0.0 && (yMotion = LivingEntityMixin.getAllowedOffset(Direction.Axis.Y, axisAlignedBB, allCollisionShapes, yMotion)) != 0.0) {
            axisAlignedBB = axisAlignedBB.func_72317_d(0.0, yMotion, 0.0);
        }
        boolean bl = flag = Math.abs(xMotion) < Math.abs(zMotion);
        if (flag && zMotion != 0.0 && (zMotion = LivingEntityMixin.getAllowedOffset(Direction.Axis.Z, axisAlignedBB, allCollisionShapes, zMotion)) != 0.0) {
            axisAlignedBB = axisAlignedBB.func_72317_d(0.0, 0.0, zMotion);
        }
        if (xMotion != 0.0) {
            xMotion = LivingEntityMixin.getAllowedOffset(Direction.Axis.X, axisAlignedBB, allCollisionShapes, xMotion);
            if (!flag && xMotion != 0.0) {
                axisAlignedBB = axisAlignedBB.func_72317_d(xMotion, 0.0, 0.0);
            }
        }
        if (!flag && zMotion != 0.0) {
            zMotion = LivingEntityMixin.getAllowedOffset(Direction.Axis.Z, axisAlignedBB, allCollisionShapes, zMotion);
        }
        return new Vector3d(xMotion, yMotion, zMotion);
    }

    private static double getAllowedOffset(Direction.Axis axis, AxisAlignedBB bb, List<VoxelShape> collisionShapes, double offSet) {
        Iterator<VoxelShape> iterator = collisionShapes.iterator();
        while (iterator.hasNext()) {
            if (Math.abs(offSet) < 1.0E-7) {
                return 0.0;
            }
            offSet = iterator.next().func_212430_a(axis, bb, offSet);
        }
        return offSet;
    }

    private static void addShapesForBlockCollision(List<VoxelShape> shapeCollisionList, CubeCoordinateIterator cubeToCheck, BlockPos.Mutable mutablePos, ChunkCache world, ISelectionContext iselectioncontext, VoxelShape voxelShapeToCheckForCollisions) {
        while (cubeToCheck.func_218301_a()) {
            VoxelShape voxelshape2;
            VoxelShape nextShape;
            int coordX = cubeToCheck.func_218304_b();
            int coordY = cubeToCheck.func_218302_c();
            int coordZ = cubeToCheck.func_218303_d();
            int numBoundariesTouched = cubeToCheck.func_223473_e();
            if (numBoundariesTouched == 3) continue;
            mutablePos.func_181079_c(coordX, coordY, coordZ);
            BlockState blockstate = world.func_180495_p((BlockPos)mutablePos);
            if (numBoundariesTouched == 1 && !blockstate.func_215704_f() || numBoundariesTouched == 2 && blockstate.func_177230_c() != Blocks.field_196603_bb || !VoxelShapes.func_197879_c((VoxelShape)voxelShapeToCheckForCollisions, (VoxelShape)(nextShape = (voxelshape2 = blockstate.func_215685_b((IBlockReader)world, (BlockPos)mutablePos, iselectioncontext)).func_197751_a((double)coordX, (double)coordY, (double)coordZ)), (IBooleanFunction)IBooleanFunction.field_223238_i_)) continue;
            shapeCollisionList.add(nextShape);
        }
    }

    private Vector3d getAllowedMovement(Vector3d vec, AxisAlignedBB collisionBox, ChunkCache worldIn, ISelectionContext selectionContext, List<VoxelShape> potentialHits) {
        boolean flag;
        double xMotion = vec.field_72450_a;
        double yMotion = vec.field_72448_b;
        double zMotion = vec.field_72449_c;
        if (yMotion != 0.0 && (yMotion = this.getAllowedOffset(Direction.Axis.Y, collisionBox, worldIn, yMotion, selectionContext, potentialHits)) != 0.0) {
            collisionBox = collisionBox.func_72317_d(0.0, yMotion, 0.0);
        }
        boolean bl = flag = Math.abs(xMotion) < Math.abs(zMotion);
        if (flag && zMotion != 0.0 && (zMotion = this.getAllowedOffset(Direction.Axis.Z, collisionBox, worldIn, zMotion, selectionContext, potentialHits)) != 0.0) {
            collisionBox = collisionBox.func_72317_d(0.0, 0.0, zMotion);
        }
        if (xMotion != 0.0) {
            xMotion = this.getAllowedOffset(Direction.Axis.X, collisionBox, worldIn, xMotion, selectionContext, potentialHits);
            if (!flag && xMotion != 0.0) {
                collisionBox = collisionBox.func_72317_d(xMotion, 0.0, 0.0);
            }
        }
        if (!flag && zMotion != 0.0) {
            zMotion = this.getAllowedOffset(Direction.Axis.Z, collisionBox, worldIn, zMotion, selectionContext, potentialHits);
        }
        return new Vector3d(xMotion, yMotion, zMotion);
    }

    private double getAllowedOffset(Direction.Axis p_216383_0_, AxisAlignedBB p_216383_1_, IWorldReader p_216383_2_, double p_216383_3_, ISelectionContext p_216383_5_, List<VoxelShape> p_216383_6_) {
        return this.getAllowedOffset(p_216383_1_, p_216383_2_, p_216383_3_, p_216383_5_, AxisRotation.func_197516_a((Direction.Axis)p_216383_0_, (Direction.Axis)Direction.Axis.Z), p_216383_6_);
    }

    private double getAllowedOffset(AxisAlignedBB collisionBox, IWorldReader worldReader, double desiredOffset, ISelectionContext selectionContext, AxisRotation rotationAxis, List<VoxelShape> possibleHits) {
        if (!(collisionBox.func_216364_b() < 1.0E-6 || collisionBox.func_216360_c() < 1.0E-6 || collisionBox.func_216362_d() < 1.0E-6)) {
            if (Math.abs(desiredOffset) < 1.0E-7) {
                return 0.0;
            }
            AxisRotation axisrotation = rotationAxis.func_197514_a();
            Direction.Axis direction$axis = axisrotation.func_197513_a(Direction.Axis.X);
            Direction.Axis direction$axis1 = axisrotation.func_197513_a(Direction.Axis.Y);
            Direction.Axis direction$axis2 = axisrotation.func_197513_a(Direction.Axis.Z);
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            int i = MathHelper.func_76128_c((double)(collisionBox.func_197745_a(direction$axis) - 1.0E-7)) - 1;
            int j = MathHelper.func_76128_c((double)(collisionBox.func_197742_b(direction$axis) + 1.0E-7)) + 1;
            int k = MathHelper.func_76128_c((double)(collisionBox.func_197745_a(direction$axis1) - 1.0E-7)) - 1;
            int l = MathHelper.func_76128_c((double)(collisionBox.func_197742_b(direction$axis1) + 1.0E-7)) + 1;
            double d0 = collisionBox.func_197745_a(direction$axis2) - 1.0E-7;
            double d1 = collisionBox.func_197742_b(direction$axis2) + 1.0E-7;
            boolean flag = desiredOffset > 0.0;
            int i1 = flag ? MathHelper.func_76128_c((double)(collisionBox.func_197742_b(direction$axis2) - 1.0E-7)) - 1 : MathHelper.func_76128_c((double)(collisionBox.func_197745_a(direction$axis2) + 1.0E-7)) + 1;
            int j1 = LivingEntityMixin.getDifferenceFloored(desiredOffset, d0, d1);
            int k1 = flag ? 1 : -1;
            int l1 = i1;
            while (!(flag ? l1 > j1 : l1 < j1)) {
                for (int i2 = i; i2 <= j; ++i2) {
                    for (int j2 = k; j2 <= l; ++j2) {
                        int k2 = 0;
                        if (i2 == i || i2 == j) {
                            ++k2;
                        }
                        if (j2 == k || j2 == l) {
                            ++k2;
                        }
                        if (l1 == i1 || l1 == j1) {
                            ++k2;
                        }
                        if (k2 >= 3) continue;
                        blockpos$mutable.func_218295_a(axisrotation, i2, j2, l1);
                        BlockState blockstate = this.getCache().func_180495_p((BlockPos)blockpos$mutable);
                        if (k2 == 1 && !blockstate.func_215704_f() || k2 == 2 && blockstate.func_177230_c() != Blocks.field_196603_bb) continue;
                        desiredOffset = blockstate.func_215685_b((IBlockReader)worldReader, (BlockPos)blockpos$mutable, selectionContext).func_212430_a(direction$axis2, collisionBox.func_72317_d((double)(-blockpos$mutable.func_177958_n()), (double)(-blockpos$mutable.func_177956_o()), (double)(-blockpos$mutable.func_177952_p())), desiredOffset);
                        if (Math.abs(desiredOffset) < 1.0E-7) {
                            return 0.0;
                        }
                        j1 = LivingEntityMixin.getDifferenceFloored(desiredOffset, d0, d1);
                    }
                }
                l1 += k1;
            }
            for (VoxelShape shape : possibleHits) {
                desiredOffset = shape.func_212430_a(direction$axis2, collisionBox, desiredOffset);
            }
            return desiredOffset;
        }
        return desiredOffset;
    }

    private static int getDifferenceFloored(double desiredOffset, double min, double max) {
        return desiredOffset > 0.0 ? MathHelper.func_76128_c((double)(max + desiredOffset)) + 1 : MathHelper.func_76128_c((double)(min + desiredOffset)) - 1;
    }

    public boolean func_70038_c(double x, double y, double z) {
        if (x == 0.0 && z == 0.0 && this.tickCounter % 20 != 0) {
            return this.isOffsetPosInLiquidres;
        }
        this.isOffsetPosInLiquidres = this.getCache().func_226665_a__(this, this.func_174813_aQ().func_72317_d(x, y, z)) && !this.getCache().func_72953_d(this.func_174813_aQ().func_72317_d(x, y, z));
        return this.isOffsetPosInLiquidres;
    }

    public float func_225515_ai_() {
        if (this.tickCounter % 5 != 0) {
            return this.lastSpeedFactor;
        }
        Block block = this.getCache().func_180495_p(this.func_233580_cy_()).func_177230_c();
        float f = block.func_226891_m_();
        this.lastSpeedFactor = block != Blocks.field_150355_j && block != Blocks.field_203203_C ? ((double)f == 1.0 ? this.getCache().func_180495_p(this.func_226270_aj_()).func_177230_c().func_226891_m_() : f) : f;
        return this.lastSpeedFactor;
    }

    @Overwrite
    public void func_85033_bc() {
        if (!this.isPlayer && (this.tickCounter % 3 != 0 || this.field_70170_p.field_72995_K)) {
            return;
        }
        if (!this.field_70170_p.field_72995_K && ConfigurationCache.multiEntities && !this.isPlayer) {
            MoveThread.enqueEntityColl(this.self);
        } else {
            this.callEntityCollisions();
        }
    }

    @Override
    public void callEntityCollisions() {
        List<Entity> list = this.getCache().func_175674_a(this, this.func_174813_aQ(), EntityPredicates.func_200823_a((Entity)this));
        if (!list.isEmpty()) {
            int i = this.field_70170_p.func_82736_K().func_223592_c(GameRules.field_223616_s);
            if (i > 0 && list.size() > i - 1 && this.field_70146_Z.nextInt(4) == 0) {
                int j = 0;
                for (int k = 0; k < list.size(); ++k) {
                    if (list.get(k).func_184218_aH()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.source = DamageSource.field_191291_g;
                    this.amount = 6.0f;
                }
            }
            for (int l = 0; l < list.size(); ++l) {
                Entity entity = list.get(l);
                this.func_82167_n(entity);
            }
        }
    }

    private void updateLadderState() {
        if (this.tickCounter % 5 != 0 && !this.hasMovedForCalc) {
            return;
        }
        BlockState blockstate = this.getCache().func_180495_p(this.func_233580_cy_());
        boolean isSpectator = this.func_175149_v();
        if (isSpectator) {
            this.lastIsOnLadder = false;
            return;
        }
        if (!this.forgeLadderCheck) {
            this.lastIsOnLadder = blockstate.isLadder((IWorldReader)this.getCache(), this.func_233580_cy_(), this.self);
            return;
        }
        AxisAlignedBB bb = this.self.func_174813_aQ();
        int mX = MathHelper.func_76128_c((double)bb.field_72340_a);
        int mY = MathHelper.func_76128_c((double)bb.field_72338_b);
        int mZ = MathHelper.func_76128_c((double)bb.field_72339_c);
        int y2 = mY;
        while ((double)y2 < bb.field_72337_e) {
            int x2 = mX;
            while ((double)x2 < bb.field_72336_d) {
                int z2 = mZ;
                while ((double)z2 < bb.field_72334_f) {
                    BlockPos tmp = new BlockPos(x2, y2, z2);
                    blockstate = this.getCache().func_180495_p(tmp);
                    if (blockstate.isLadder((IWorldReader)this.field_70170_p, tmp, this.self)) {
                        this.lastIsOnLadder = true;
                        return;
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        this.lastIsOnLadder = false;
    }

    @Redirect(method={"onClimbable"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/common/ForgeHooks;isLivingOnLadder(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/LivingEntity;)Z"))
    private boolean OnisOnLadder(BlockState state, World world, BlockPos pos, LivingEntity entity) {
        return this.lastIsOnLadder;
    }

    public void func_205343_av() {
        if (this.tickCounter % 5 != 0) {
            return;
        }
        super.func_205343_av();
    }

    public void func_174829_m() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        this.func_226288_n_((axisalignedbb.field_72340_a + axisalignedbb.field_72336_d) / 2.0, axisalignedbb.field_72338_b, (axisalignedbb.field_72339_c + axisalignedbb.field_72334_f) / 2.0);
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        if (!blockIn.func_185904_a().func_76224_d()) {
            BlockState blockstate = this.getCache().func_180495_p(pos.func_177984_a());
            SoundType soundtype = blockstate.func_177230_c() == Blocks.field_150433_aE ? blockstate.getSoundType((IWorldReader)this.field_70170_p, pos, (Entity)this) : blockIn.getSoundType((IWorldReader)this.getCache(), pos, (Entity)this);
            this.func_184185_a(soundtype.func_185844_d(), soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
        }
    }

    @Overwrite
    public float func_110143_aJ() {
        if (this.health == -1.0f || this.field_70170_p != null && this.field_70170_p.field_72995_K || this.func_184212_Q().func_187223_a()) {
            this.health = ((Float)this.func_184212_Q().func_187225_a(field_184632_c)).floatValue();
        }
        return this.health;
    }

    @Overwrite
    public void func_70606_j(float health) {
        this.health = health = MathHelper.func_76131_a((float)health, (float)0.0f, (float)this.self.func_110138_aP());
        this.field_70180_af.func_187227_b(field_184632_c, (Object)Float.valueOf(health));
    }

    @Overwrite
    protected void func_70679_bo() {
        if (!this.self.field_70170_p.field_72995_K && this.self.func_193076_bZ().isEmpty() && this.tickCounter % 100 != 0) {
            return;
        }
        Iterator iterator = this.self.func_193076_bZ().entrySet().iterator();
        try {
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                EffectInstance effectinstance = (EffectInstance)entry.getValue();
                if (!effectinstance.func_76455_a(this.self, () -> this.func_70695_b(effectinstance, true))) {
                    if (this.field_70170_p.field_72995_K || MinecraftForge.EVENT_BUS.post((Event)new PotionEvent.PotionExpiryEvent(this.self, effectinstance))) continue;
                    iterator.remove();
                    this.func_70688_c(effectinstance);
                    continue;
                }
                if (effectinstance.func_76459_b() % 600 != 0) continue;
                this.func_70695_b(effectinstance, false);
            }
        }
        catch (ConcurrentModificationException entry) {
            // empty catch block
        }
        if (this.field_70752_e) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_175135_B();
            }
            this.field_70752_e = false;
        }
        int potionEffectColor = (Integer)this.field_70180_af.func_187225_a(field_184633_f);
        boolean flag1 = (Boolean)this.field_70180_af.func_187225_a(field_184634_g);
        if (potionEffectColor > 0) {
            boolean flag = this.func_82150_aj() ? this.field_70146_Z.nextInt(15) == 0 : this.field_70146_Z.nextBoolean();
            if (flag1) {
                flag &= this.field_70146_Z.nextInt(5) == 0;
            }
            if (flag && potionEffectColor > 0) {
                double d0 = (double)(potionEffectColor >> 16 & 0xFF) / 255.0;
                double d1 = (double)(potionEffectColor >> 8 & 0xFF) / 255.0;
                double d2 = (double)(potionEffectColor >> 0 & 0xFF) / 255.0;
                this.field_70170_p.func_195594_a((IParticleData)(flag1 ? ParticleTypes.field_197608_a : ParticleTypes.field_197625_r), this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), d0, d1, d2);
            }
        }
    }

    @Inject(method={"detectEquipmentUpdates"}, at={@At(value="HEAD")}, cancellable=true)
    private void slowEquipmentChecks(CallbackInfo ci) {
        if (!this.isPlayer && this.tickCounter % 20 != 0) {
            ci.cancel();
        }
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
        if (this.chunkCache != null) {
            this.chunkCache.setInvalid();
        }
    }

    protected void func_241204_bJ_() {
        super.func_241204_bJ_();
        if (this.chunkCache != null) {
            this.chunkCache.setInvalid();
        }
    }
}

