/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.world;

import com.google.common.collect.Streams;
import com.performant.coremod.Performant;
import com.performant.coremod.config.ConfigurationCache;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Bootstrap;
import net.minecraft.world.GameRules;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IntegratedServerHangWatchdog
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final MinecraftServer server;
    private final long maxTickTime;

    public IntegratedServerHangWatchdog(MinecraftServer server) {
        this.server = server;
        this.maxTickTime = ((Integer)Performant.getConfig().getCommon().singlePlayerWatchDogTimeout.get()).intValue();
    }

    @Override
    public void run() {
        while (this.server.func_71278_l()) {
            long i = this.server.func_211150_az();
            long j = Util.func_211177_b();
            long k = j - i;
            if (ConfigurationCache.debugOptionsEnabled) {
                Performant.LOGGER.info("Checking integrated server live tick time, current tick duration:" + k);
            }
            if (k > this.maxTickTime) {
                LOGGER.fatal("A single server tick took {} seconds (should be max {})", (Object)String.format(Locale.ROOT, "%.2f", Float.valueOf((float)k / 1000.0f)), (Object)String.format(Locale.ROOT, "%.2f", Float.valueOf(0.05f)));
                LOGGER.fatal("Considering it to be crashed, server will forcibly shutdown.");
                ThreadMXBean threadmxbean = ManagementFactory.getThreadMXBean();
                ThreadInfo[] athreadinfo = threadmxbean.dumpAllThreads(true, true);
                StringBuilder stringbuilder = new StringBuilder();
                Error error = new Error(String.format("ServerHangWatchdog detected that a single server tick took %.2f seconds (should be max 0.05)", Float.valueOf((float)k / 1000.0f)));
                for (ThreadInfo threadinfo : athreadinfo) {
                    if (threadinfo.getThreadId() == this.server.func_213170_ax().getId()) {
                        error.setStackTrace(threadinfo.getStackTrace());
                    }
                    stringbuilder.append(threadinfo);
                    stringbuilder.append("\n");
                }
                CrashReport crashreport = new CrashReport("Watching Server", (Throwable)error);
                this.server.func_71230_b(crashreport);
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Thread Dump");
                crashreportcategory.func_71507_a("Threads", (Object)stringbuilder);
                CrashReportCategory crashreportcategory1 = crashreport.func_85058_a("Performance stats");
                crashreportcategory1.func_189529_a("Random tick rate", () -> ((GameRules.IntegerValue)this.server.func_240793_aU_().func_82574_x().func_223585_a(GameRules.field_223610_m)).toString());
                crashreportcategory1.func_189529_a("Level stats", () -> Streams.stream((Iterable)this.server.func_212370_w()).map(p_244716_0_ -> p_244716_0_.func_234923_W_() + ": " + p_244716_0_.func_244521_F()).collect(Collectors.joining(",\n")));
                Bootstrap.func_179870_a((String)("Crash report:\n" + crashreport.func_71502_e()));
                File file1 = new File(new File(this.server.func_71238_n(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
                if (crashreport.func_147149_a(file1)) {
                    LOGGER.error("This crash report has been saved to: {}", (Object)file1.getAbsolutePath());
                } else {
                    LOGGER.error("We were unable to save this crash report to disk.");
                }
                this.scheduleHalt();
            }
            try {
                Thread.sleep(i + this.maxTickTime - j);
            }
            catch (InterruptedException interruptedException) {}
        }
        Performant.LOGGER.info("Integrated Watchdog stopping");
    }

    private void scheduleHalt() {
        try {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Runtime.getRuntime().halt(1);
                }
            }, 10000L);
            System.exit(1);
        }
        catch (Throwable throwable) {
            Runtime.getRuntime().halt(1);
        }
    }
}

