/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.phosphor.mixin.chunk.light;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.BitSet;
import net.caffeinemc.phosphor.common.block.BlockStateLightInfo;
import net.caffeinemc.phosphor.common.block.BlockStateLightInfoAccess;
import net.caffeinemc.phosphor.common.chunk.light.InitialLightingAccess;
import net.caffeinemc.phosphor.common.chunk.light.LightProviderUpdateTracker;
import net.caffeinemc.phosphor.common.chunk.light.LightStorageAccess;
import net.caffeinemc.phosphor.mixin.chunk.light.MixinLevelPropagator;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2823;
import net.minecraft.class_2826;
import net.minecraft.class_3558;
import net.minecraft.class_3560;
import net.minecraft.class_4076;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3558.class})
public abstract class MixinChunkLightProvider
extends MixinLevelPropagator
implements InitialLightingAccess,
LightProviderUpdateTracker {
    private static final class_2680 DEFAULT_STATE = class_2246.field_10124.method_9564();
    private static final class_2826[] EMPTY_SECTION_ARRAY = new class_2826[0];
    @Shadow
    @Final
    protected class_2338.class_2339 field_19284;
    @Shadow
    @Final
    protected class_2823 field_15795;
    private final long[] cachedChunkPos = new long[2];
    private final class_2826[][] cachedChunkSections = new class_2826[2][];
    private final Long2ObjectOpenHashMap<BitSet> buckets = new Long2ObjectOpenHashMap();
    private long prevChunkBucketKey = class_1923.field_17348;
    private BitSet prevChunkBucketSet;
    private static final long BLOCK_TO_BUCKET_KEY_MASK = class_2338.method_10064((int)15, (int)15, (int)15) ^ 0xFFFFFFFFFFFFFFFFL;
    @Shadow
    @Final
    protected class_3560<?> field_15793;

    @Inject(method={"clearChunkCache"}, at={@At(value="RETURN")})
    private void onCleanup(CallbackInfo ci) {
        if (this.cachedChunkPos != null) {
            Arrays.fill(this.cachedChunkPos, class_1923.field_17348);
            Arrays.fill((Object[])this.cachedChunkSections, null);
        }
    }

    @Unique
    protected boolean hasSection(long sectionPos) {
        return ((LightStorageAccess)this.field_15793).callHasSection(sectionPos);
    }

    @Unique
    protected class_2680 getBlockStateForLighting(int x, int y, int z) {
        long chunkPos = class_1923.method_8331((int)(x >> 4), (int)(z >> 4));
        for (int i = 0; i < 2; ++i) {
            if (this.cachedChunkPos[i] != chunkPos) continue;
            return this.getBlockStateFromSection(this.cachedChunkSections[i], x, y, z);
        }
        return this.getBlockStateForLightingUncached(x, y, z);
    }

    private class_2680 getBlockStateForLightingUncached(int x, int y, int z) {
        return this.getBlockStateFromSection(this.getAndCacheChunkSections(x >> 4, z >> 4), x, y, z);
    }

    private class_2680 getBlockStateFromSection(class_2826[] sections, int x, int y, int z) {
        class_2826 section;
        int index = this.field_15795.method_16399().method_31602(y);
        if (index >= 0 && index < sections.length && !class_2826.method_18090((class_2826)(section = sections[index]))) {
            return section.method_12254(x & 0xF, y & 0xF, z & 0xF);
        }
        return DEFAULT_STATE;
    }

    private class_2826[] getAndCacheChunkSections(int x, int z) {
        class_2791 chunk = (class_2791)this.field_15795.method_12246(x, z);
        class_2826[] sections = chunk != null ? chunk.method_12006() : EMPTY_SECTION_ARRAY;
        class_2826[][] cachedSections = this.cachedChunkSections;
        cachedSections[1] = cachedSections[0];
        cachedSections[0] = sections;
        long[] cachedCoords = this.cachedChunkPos;
        cachedCoords[1] = cachedCoords[0];
        cachedCoords[0] = class_1923.method_8331((int)x, (int)z);
        return sections;
    }

    @Unique
    protected int getSubtractedLight(class_2680 state, int x, int y, int z) {
        BlockStateLightInfo info = ((BlockStateLightInfoAccess)state).getLightInfo();
        if (info != null) {
            return info.getLightSubtracted();
        }
        return this.getSubtractedLightFallback(state, x, y, z);
    }

    private int getSubtractedLightFallback(class_2680 state, int x, int y, int z) {
        return state.method_26204().method_9505(state, this.field_15795.method_16399(), (class_2338)this.field_19284.method_10103(x, y, z));
    }

    @Unique
    protected class_265 getOpaqueShape(class_2680 state, int x, int y, int z, class_2350 dir) {
        if (state != null && state.method_26211()) {
            BlockStateLightInfo info = ((BlockStateLightInfoAccess)state).getLightInfo();
            if (info != null) {
                class_265[] extrudedFaces = info.getExtrudedFaces();
                if (extrudedFaces != null) {
                    return extrudedFaces[dir.ordinal()];
                }
            } else {
                return this.getOpaqueShapeFallback(state, x, y, z, dir);
            }
        }
        return class_259.method_1073();
    }

    private class_265 getOpaqueShapeFallback(class_2680 state, int x, int y, int z, class_2350 dir) {
        return class_259.method_16344((class_265)state.method_26201(this.field_15795.method_16399(), (class_2338)this.field_19284.method_10103(x, y, z)), (class_2350)dir);
    }

    @Override
    public void cancelUpdatesForChunk(long sectionPos) {
        long key = this.getBucketKeyForSection(sectionPos);
        BitSet bits = this.removeChunkBucket(key);
        if (bits != null && !bits.isEmpty()) {
            int startX = class_4076.method_18686((long)sectionPos) << 4;
            int startY = class_4076.method_18689((long)sectionPos) << 4;
            int startZ = class_4076.method_18690((long)sectionPos) << 4;
            int i = bits.nextSetBit(0);
            while (i != -1) {
                int x = i >> 8 & 0xF;
                int y = i >> 4 & 0xF;
                int z = i & 0xF;
                this.method_15483(class_2338.method_10064((int)(startX + x), (int)(startY + y), (int)(startZ + z)));
                i = bits.nextSetBit(i + 1);
            }
        }
    }

    @Override
    protected void onPendingUpdateRemoved(long blockPos) {
        BitSet bits;
        long key = this.getBucketKeyForBlock(blockPos);
        if (this.prevChunkBucketKey == key) {
            bits = this.prevChunkBucketSet;
        } else {
            bits = (BitSet)this.buckets.get(key);
            if (bits == null) {
                return;
            }
        }
        bits.clear(MixinChunkLightProvider.getLocalIndex(blockPos));
        if (bits.isEmpty()) {
            this.removeChunkBucket(key);
        }
    }

    @Override
    protected void onPendingUpdateAdded(long blockPos) {
        BitSet bits;
        long key = this.getBucketKeyForBlock(blockPos);
        if (this.prevChunkBucketKey == key) {
            bits = this.prevChunkBucketSet;
        } else {
            bits = (BitSet)this.buckets.get(key);
            if (bits == null) {
                bits = new BitSet(4096);
                this.buckets.put(key, (Object)bits);
            }
            this.prevChunkBucketKey = key;
            this.prevChunkBucketSet = bits;
        }
        bits.set(MixinChunkLightProvider.getLocalIndex(blockPos));
    }

    private long getBucketKeyForBlock(long blockPos) {
        return blockPos & BLOCK_TO_BUCKET_KEY_MASK;
    }

    private long getBucketKeyForSection(long sectionPos) {
        return class_2338.method_10064((int)(class_4076.method_18686((long)sectionPos) << 4), (int)(class_4076.method_18689((long)sectionPos) << 4), (int)(class_4076.method_18690((long)sectionPos) << 4));
    }

    private BitSet removeChunkBucket(long key) {
        BitSet set = (BitSet)this.buckets.remove(key);
        if (this.prevChunkBucketSet == set) {
            this.prevChunkBucketKey = class_1923.field_17348;
            this.prevChunkBucketSet = null;
        }
        return set;
    }

    private static int getLocalIndex(long blockPos) {
        int x = class_2338.method_10061((long)blockPos) & 0xF;
        int y = class_2338.method_10071((long)blockPos) & 0xF;
        int z = class_2338.method_10083((long)blockPos) & 0xF;
        return x << 8 | y << 4 | z;
    }

    @Shadow
    protected void method_15491(long id) {
    }

    @Overwrite
    public void method_15512(class_1923 pos, boolean enabled) {
        long chunkPos = class_4076.method_18693((long)class_4076.method_18685((int)pos.field_9181, (int)0, (int)pos.field_9180));
        LightStorageAccess lightStorage = (LightStorageAccess)this.field_15793;
        if (enabled) {
            lightStorage.invokeSetColumnEnabled(chunkPos, true);
            lightStorage.enableLightUpdates(chunkPos);
        } else {
            lightStorage.disableChunkLight(chunkPos, (class_3558)this);
        }
    }

    @Override
    public void enableSourceLight(long chunkPos) {
        ((LightStorageAccess)this.field_15793).invokeSetColumnEnabled(chunkPos, true);
    }

    @Override
    public void enableLightUpdates(long chunkPos) {
        ((LightStorageAccess)this.field_15793).enableLightUpdates(chunkPos);
    }

    @Inject(method={"doLightUpdates(IZZ)I"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/chunk/light/LightStorage;notifyChanges()V")})
    private void runCleanups(CallbackInfoReturnable<Integer> ci) {
        ((LightStorageAccess)this.field_15793).runCleanups();
    }
}

