/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.phosphor.mixin.chunk.light;

import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Arrays;
import net.caffeinemc.phosphor.common.chunk.light.IReadonly;
import net.caffeinemc.phosphor.common.chunk.light.LevelPropagatorAccess;
import net.caffeinemc.phosphor.common.chunk.light.SkyLightStorageAccess;
import net.caffeinemc.phosphor.common.chunk.light.SkyLightStorageDataAccess;
import net.caffeinemc.phosphor.common.util.chunk.light.EmptyChunkNibbleArray;
import net.caffeinemc.phosphor.common.util.chunk.light.SkyLightChunkNibbleArray;
import net.caffeinemc.phosphor.common.util.math.ChunkSectionPosHelper;
import net.caffeinemc.phosphor.mixin.chunk.light.MixinLightStorage;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2804;
import net.minecraft.class_3558;
import net.minecraft.class_3569;
import net.minecraft.class_4076;
import org.apache.commons.lang3.ArrayUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;

@Mixin(value={class_3569.class})
public abstract class MixinSkyLightStorage
extends MixinLightStorage
implements SkyLightStorageAccess {
    @Unique
    private final LongSet initSkylightChunks = new LongOpenHashSet();
    @Shadow
    @Final
    private LongSet field_15817;
    @Shadow
    private volatile boolean field_15819;
    @Unique
    private static final class_2804 DIRECT_SKYLIGHT_MAP = new SkyLightChunkNibbleArray(ArrayUtils.toPrimitive((Byte[])new Byte[2048], (byte)-1));
    @Unique
    private static final class_2804 EMPTY_SKYLIGHT_MAP = new EmptyChunkNibbleArray();
    @Unique
    private final Long2IntMap vanillaLightmapComplexities = new Long2IntOpenHashMap();
    @Unique
    private final LongSet removedLightmaps = new LongOpenHashSet();
    @Unique
    private final Long2IntMap scheduledHeightIncreases = (Long2IntMap)class_156.method_654((Object)new Long2IntOpenHashMap(), map -> map.defaultReturnValue(Integer.MIN_VALUE));
    @Unique
    private final LongSet scheduledHeightChecks = new LongOpenHashSet();

    /*
     * Unable to fully structure code
     */
    @Overwrite
    public int method_15538(long pos) {
        posX = class_2338.method_10061((long)pos);
        posYOrig = class_2338.method_10071((long)pos);
        posZ = class_2338.method_10083((long)pos);
        chunkX = class_4076.method_18675((int)posX);
        chunkYOrig = class_4076.method_18675((int)posYOrig);
        chunkZ = class_4076.method_18675((int)posZ);
        chunkOrig = class_4076.method_18685((int)chunkX, (int)chunkYOrig, (int)chunkZ);
        lock = this.uncachedLightArraysLock;
        do lbl-1000:
        // 4 sources

        {
            block2: {
                stamp = lock.tryOptimisticRead();
                posY = posYOrig;
                chunkY = chunkYOrig;
                data = this.field_15806;
                sdata = (SkyLightStorageDataAccess)data;
                chunk = chunkOrig;
                height = sdata.getHeight(class_4076.method_18693((long)chunk));
                if (height != sdata.getDefaultHeight() && chunkY < height) break block2;
                if (!lock.validate(stamp)) ** GOTO lbl-1000
                return 15;
            }
            array = data.method_15501(chunk);
            while (array == null) {
                block3: {
                    if (++chunkY < height) break block3;
                    if (!lock.validate(stamp)) ** GOTO lbl-1000
                    return 15;
                }
                chunk = ChunkSectionPosHelper.updateYLong(chunk, chunkY);
                array = data.method_15501(chunk);
                posY = chunkY << 4;
            }
        } while (!lock.validate(stamp));
        return array.method_12139(class_4076.method_18684((int)posX), class_4076.method_18684((int)posY), class_4076.method_18684((int)posZ));
    }

    @Shadow
    protected abstract boolean method_15566(long var1);

    @Override
    public int getLightWithoutLightmap(long blockPos) {
        long sectionPos = class_4076.method_18691((long)blockPos);
        class_2804 lightmap = this.getLightmapAbove(sectionPos);
        if (lightmap == null) {
            return this.method_15566(sectionPos) ? 15 : 0;
        }
        return lightmap.method_12139(class_4076.method_18684((int)class_2338.method_10061((long)blockPos)), 0, class_4076.method_18684((int)class_2338.method_10083((long)blockPos)));
    }

    @Redirect(method={"createSection(J)Lnet/minecraft/world/chunk/ChunkNibbleArray;"}, at=@At(value="NEW", target="()Lnet/minecraft/world/chunk/ChunkNibbleArray;"))
    private class_2804 initializeLightmap(long pos) {
        class_2804 ret = new class_2804();
        if (this.method_15566(pos)) {
            Arrays.fill(ret.method_12137(), (byte)-1);
        }
        return ret;
    }

    @Override
    protected void beforeChunkEnabled(long chunkPos) {
        long sectionPos;
        int y;
        int minHeight = Integer.MAX_VALUE;
        int height = Integer.MIN_VALUE;
        IntIterator it = this.getTrackedSections(chunkPos);
        while (it.hasNext()) {
            y = it.nextInt();
            sectionPos = ChunkSectionPosHelper.updateYLong(chunkPos, y);
            if (y < minHeight && (this.nonOptimizableSections.contains(sectionPos) || this.method_15522(sectionPos, true) != null)) {
                minHeight = y;
            }
            if (y <= height || !this.field_15808.contains(sectionPos)) continue;
            height = y;
        }
        this.updateMinHeight(minHeight);
        if (height != Integer.MIN_VALUE) {
            this.setHeight(chunkPos, height);
        }
        it = this.getTrackedSections(chunkPos);
        while (it.hasNext()) {
            y = it.nextInt();
            if (y <= height || this.field_15796.method_15500(sectionPos = ChunkSectionPosHelper.updateYLong(chunkPos, y)) == null) continue;
            this.untrackSection(chunkPos, y);
            this.field_15802.add(sectionPos);
        }
        this.field_15796.method_15505();
        it = this.getTrackedSections(chunkPos);
        while (it.hasNext()) {
            long sectionPos2 = ChunkSectionPosHelper.updateYLong(chunkPos, it.nextInt());
            class_2804 lightmap = this.method_15522(sectionPos2, true);
            if (lightmap == null) continue;
            this.initializeVanillaLightmapComplexity(sectionPos2, lightmap);
        }
    }

    @Override
    protected void afterChunkDisabled(long chunkPos, IntIterable removedLightmaps) {
        IntIterator it = removedLightmaps.iterator();
        while (it.hasNext()) {
            this.vanillaLightmapComplexities.remove(ChunkSectionPosHelper.updateYLong(chunkPos, it.nextInt()));
        }
        ((SkyLightStorageDataAccess)this.field_15796).setHeight(chunkPos, this.getMinHeight());
        this.scheduledHeightChecks.remove(chunkPos);
        this.scheduledHeightIncreases.remove(chunkPos);
    }

    @Override
    @Overwrite
    public void method_15535(long chunkPos, boolean enabled) {
        if (enabled) {
            if (this.enabledChunks.contains(chunkPos) && !this.field_15817.contains(chunkPos)) {
                this.initSkylightChunks.add(chunkPos);
                this.markForUpdates();
            } else {
                this.field_15817.add(chunkPos);
            }
        } else {
            this.field_15817.remove(chunkPos);
            this.initSkylightChunks.remove(chunkPos);
        }
    }

    @Unique
    private static void spreadSourceSkylight(LevelPropagatorAccess lightProvider, long src, class_2350 dir) {
        lightProvider.invokePropagateLevel(src, class_2338.method_10060((long)src, (class_2350)dir), 0, true);
    }

    @Unique
    private static void spreadZeroSkylight(LevelPropagatorAccess lightProvider, long src, class_2350 dir, int prevLight) {
        if (prevLight != 0) {
            lightProvider.invokePropagateLevel(src, class_2338.method_10060((long)src, (class_2350)dir), 15 - prevLight, false);
        }
    }

    @Unique
    private static void pullSkylight(LevelPropagatorAccess lightProvider, long dst, class_2350 dir) {
        lightProvider.propagateLevel(class_2338.method_10060((long)dst, (class_2350)dir), dst, true);
    }

    @Override
    protected void runCleanups(class_3558<?, ?> lightProvider) {
        super.runCleanups(lightProvider);
        if (!this.field_15819) {
            return;
        }
        this.updateRemovedLightmaps();
        if (lightProvider == null) {
            this.method_15569();
        }
    }

    @Override
    @Overwrite
    public void method_15527(class_3558<?, ?> lightProvider, boolean doSkylight, boolean skipEdgeLightPropagation) {
        super.method_15527(lightProvider, doSkylight, skipEdgeLightPropagation);
        if (!doSkylight || !this.field_15819) {
            return;
        }
        this.updateHeights(lightProvider);
        this.lightChunks(lightProvider);
        this.field_15819 = false;
    }

    @Unique
    private void updateHeights(class_3558<?, ?> lightProvider) {
        int blockPosZ;
        LevelPropagatorAccess levelPropagator = (LevelPropagatorAccess)lightProvider;
        if (!this.scheduledHeightIncreases.isEmpty()) {
            for (Long2IntMap.Entry entry : this.scheduledHeightIncreases.long2IntEntrySet()) {
                int height;
                long chunkPos = entry.getLongKey();
                int oldHeight = this.getHeight(chunkPos) - 1;
                for (height = entry.getIntValue(); height > oldHeight && !this.field_15808.contains(ChunkSectionPosHelper.updateYLong(chunkPos, height)); --height) {
                }
                if (height == oldHeight) continue;
                this.setHeight(chunkPos, height);
                int blockPosX = class_4076.method_18688((int)class_4076.method_18686((long)chunkPos));
                blockPosZ = class_4076.method_18688((int)class_4076.method_18690((long)chunkPos));
                if (this.method_15522(ChunkSectionPosHelper.updateYLong(chunkPos, oldHeight + 1), true) != null) {
                    long blockPos = class_2338.method_10064((int)blockPosX, (int)class_4076.method_18688((int)(oldHeight + 1)), (int)blockPosZ);
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            MixinSkyLightStorage.pullSkylight(levelPropagator, class_2338.method_10096((long)blockPos, (int)x, (int)0, (int)z), class_2350.field_11033);
                        }
                    }
                }
                for (class_2350 dir : class_2350.class_2353.field_11062) {
                    if (!this.enabledChunks.contains(class_4076.method_18679((long)chunkPos, (class_2350)dir))) continue;
                    int ox = 15 * Math.max(dir.method_10148(), 0);
                    int oz = 15 * Math.max(dir.method_10165(), 0);
                    int dx = Math.abs(dir.method_10165());
                    int dz = Math.abs(dir.method_10148());
                    for (int y = height; y > oldHeight; --y) {
                        if (this.method_15522(ChunkSectionPosHelper.updateYLong(chunkPos, y), true) == null) continue;
                        long blockPos = class_2338.method_10064((int)blockPosX, (int)class_4076.method_18688((int)y), (int)blockPosZ);
                        for (int t = 0; t < 16; ++t) {
                            for (int dy = 0; dy < 16; ++dy) {
                                MixinSkyLightStorage.pullSkylight(levelPropagator, class_2338.method_10096((long)blockPos, (int)(ox + t * dx), (int)dy, (int)(oz + t * dz)), dir);
                            }
                        }
                    }
                }
            }
            this.scheduledHeightIncreases.clear();
        }
        if (!this.scheduledHeightChecks.isEmpty()) {
            LongIterator it = this.scheduledHeightChecks.iterator();
            while (it.hasNext()) {
                long sectionPos;
                long chunkPos = it.nextLong();
                int height = this.getHeight(chunkPos) - 1;
                if (!this.method_15567(height)) continue;
                if (this.field_15817.contains(chunkPos)) {
                    long sectionPos2;
                    while (this.method_15567(height) && !this.field_15808.contains(sectionPos2 = ChunkSectionPosHelper.updateYLong(chunkPos, height)) && !this.hasLightmap(sectionPos2)) {
                        if (this.method_15522(sectionPos2, true) != null) {
                            this.method_15536(lightProvider, sectionPos2);
                        }
                        --height;
                    }
                    this.setHeight(chunkPos, height);
                    continue;
                }
                int lightmapPosAbove = Integer.MIN_VALUE;
                class_2804 lightmapAbove = null;
                while (this.method_15567(height) && !this.field_15808.contains(sectionPos = ChunkSectionPosHelper.updateYLong(chunkPos, height))) {
                    class_2804 lightmap = this.method_15522(sectionPos, true);
                    if (lightmap != null) {
                        this.method_15536(lightProvider, sectionPos);
                        if (lightmapPosAbove == Integer.MIN_VALUE && !((IReadonly)lightmap).isReadonly()) {
                            lightmapPosAbove = height;
                            lightmapAbove = lightmap;
                        }
                    }
                    --height;
                }
                this.setHeight(chunkPos, height);
                if (lightmapPosAbove == Integer.MIN_VALUE) continue;
                int blockPosX = class_4076.method_18688((int)class_4076.method_18686((long)chunkPos));
                blockPosZ = class_4076.method_18688((int)class_4076.method_18690((long)chunkPos));
                boolean hasSectionBelow = this.method_15567(height);
                for (int curY = lightmapPosAbove - 1; curY >= height; --curY) {
                    int x;
                    long curSectionPos = ChunkSectionPosHelper.updateYLong(chunkPos, curY);
                    class_2804 lightmap = this.getLightmap(curSectionPos);
                    if (curY > height && lightmap == null) continue;
                    if (curY == height && hasSectionBelow) {
                        if (lightmap == null) {
                            this.getOrAddLightmap(curSectionPos);
                            this.setLightmapComplexity(curSectionPos, this.vanillaLightmapComplexities.get(ChunkSectionPosHelper.updateYLong(chunkPos, lightmapPosAbove)));
                        } else {
                            int amount = 0;
                            for (int z = 0; z < 16; ++z) {
                                for (x = 0; x < 16; ++x) {
                                    amount += MixinSkyLightStorage.getComplexityChange(lightmap.method_12139(x, 15, z), lightmapAbove.method_12139(x, 0, z), 0);
                                }
                            }
                            this.changeLightmapComplexity(curSectionPos, amount);
                        }
                    }
                    for (int y = lightmapPosAbove; y > curY; --y) {
                        long sectionPos3 = ChunkSectionPosHelper.updateYLong(chunkPos, y);
                        if (this.method_15522(sectionPos3, true) == null) continue;
                        if (this.removeLightmap(sectionPos3)) {
                            this.vanillaLightmapComplexities.remove(sectionPos3);
                        }
                        if (!this.nonOptimizableSections.contains(sectionPos3)) continue;
                        this.field_15796.method_15499(sectionPos3, EMPTY_SKYLIGHT_MAP);
                    }
                    this.field_15796.method_15505();
                    if (curY == height && hasSectionBelow) {
                        long blockPos = class_2338.method_10064((int)blockPosX, (int)class_4076.method_18688((int)(height + 1)), (int)blockPosZ);
                        for (x = 0; x < 16; ++x) {
                            for (int z = 0; z < 16; ++z) {
                                MixinSkyLightStorage.spreadZeroSkylight(levelPropagator, class_2338.method_10096((long)blockPos, (int)x, (int)0, (int)z), class_2350.field_11033, lightmapAbove.method_12139(x, 0, z));
                            }
                        }
                    }
                    for (class_2350 dir : class_2350.class_2353.field_11062) {
                        int ox = 15 * Math.max(dir.method_10148(), 0);
                        int oz = 15 * Math.max(dir.method_10165(), 0);
                        int dx = Math.abs(dir.method_10165());
                        int dz = Math.abs(dir.method_10148());
                        for (int y = lightmapPosAbove; y > curY; --y) {
                            long sectionPos4 = ChunkSectionPosHelper.updateYLong(chunkPos, y);
                            long neighborSectionPos = class_4076.method_18679((long)sectionPos4, (class_2350)dir);
                            if (!this.method_15524(neighborSectionPos)) continue;
                            long blockPos = class_2338.method_10064((int)blockPosX, (int)class_4076.method_18688((int)y), (int)blockPosZ);
                            for (int t = 0; t < 16; ++t) {
                                for (int dy = 0; dy < 16; ++dy) {
                                    int x2 = ox + t * dx;
                                    int z = oz + t * dz;
                                    MixinSkyLightStorage.spreadZeroSkylight(levelPropagator, class_2338.method_10096((long)blockPos, (int)x2, (int)dy, (int)z), dir, lightmapAbove.method_12139(x2, y == lightmapPosAbove ? dy : 0, z));
                                }
                            }
                        }
                    }
                    lightmapPosAbove = curY;
                    lightmapAbove = lightmap;
                }
            }
            this.scheduledHeightChecks.clear();
        }
        levelPropagator.checkForUpdates();
    }

    @Unique
    private void lightChunks(class_3558<?, ?> lightProvider) {
        if (this.initSkylightChunks.isEmpty()) {
            return;
        }
        LevelPropagatorAccess levelPropagator = (LevelPropagatorAccess)lightProvider;
        LongIterator cit = this.initSkylightChunks.iterator();
        while (cit.hasNext()) {
            long chunkPos = cit.nextLong();
            int minY = this.getHeight(chunkPos) - 1;
            boolean hasSectionBelow = this.method_15567(minY);
            if (hasSectionBelow) {
                long sectionPos = ChunkSectionPosHelper.updateYLong(chunkPos, minY);
                class_2804 lightmap = this.getLightmap(sectionPos);
                if (lightmap == null) {
                    this.getOrAddLightmap(sectionPos);
                    this.setLightmapComplexity(sectionPos, 3840);
                } else {
                    int amount = 0;
                    for (int z = 0; z < 16; ++z) {
                        for (int x = 0; x < 16; ++x) {
                            amount += MixinSkyLightStorage.getComplexityChange(lightmap.method_12139(x, 15, z), 0, 15);
                        }
                    }
                    this.changeLightmapComplexity(sectionPos, amount);
                }
            }
            IntIterator it = this.getTrackedSections(chunkPos);
            while (it.hasNext()) {
                int y = it.nextInt();
                if (y <= minY) continue;
                long sectionPos = ChunkSectionPosHelper.updateYLong(chunkPos, y);
                this.removeLightmap(sectionPos);
                if (!this.nonOptimizableSections.contains(sectionPos)) continue;
                this.field_15796.method_15499(sectionPos, DIRECT_SKYLIGHT_MAP);
            }
            this.field_15796.method_15505();
            this.field_15817.add(chunkPos);
            int blockPosX = class_4076.method_18688((int)class_4076.method_18686((long)chunkPos));
            int blockPosZ = class_4076.method_18688((int)class_4076.method_18690((long)chunkPos));
            if (hasSectionBelow) {
                long blockPos = class_2338.method_10064((int)blockPosX, (int)class_4076.method_18688((int)(minY + 1)), (int)blockPosZ);
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        MixinSkyLightStorage.spreadSourceSkylight(levelPropagator, class_2338.method_10096((long)blockPos, (int)x, (int)0, (int)z), class_2350.field_11033);
                    }
                }
            }
            for (class_2350 dir : class_2350.class_2353.field_11062) {
                long neighborChunkPos = class_4076.method_18679((long)chunkPos, (class_2350)dir);
                int ox = 15 * Math.max(dir.method_10148(), 0);
                int oz = 15 * Math.max(dir.method_10165(), 0);
                int dx = Math.abs(dir.method_10165());
                int dz = Math.abs(dir.method_10148());
                for (int y = this.getHeight(neighborChunkPos) - 1; y > minY; --y) {
                    if (!this.method_15524(ChunkSectionPosHelper.updateYLong(neighborChunkPos, y))) continue;
                    long blockPos = class_2338.method_10064((int)blockPosX, (int)class_4076.method_18688((int)y), (int)blockPosZ);
                    for (int t = 0; t < 16; ++t) {
                        for (int dy = 0; dy < 16; ++dy) {
                            MixinSkyLightStorage.spreadSourceSkylight(levelPropagator, class_2338.method_10096((long)blockPos, (int)(ox + t * dx), (int)dy, (int)(oz + t * dz)), dir);
                        }
                    }
                }
            }
        }
        levelPropagator.checkForUpdates();
        this.initSkylightChunks.clear();
    }

    @Unique
    private void updateRemovedLightmaps() {
        while (!this.removedLightmaps.isEmpty()) {
            int y;
            long sectionPos = this.removedLightmaps.iterator().nextLong();
            if (!this.enabledChunks.contains(class_4076.method_18693((long)sectionPos))) continue;
            long removedLightmapPosAbove = sectionPos;
            int height = this.getHeight(class_4076.method_18693((long)sectionPos));
            if (height == this.getMinHeight()) {
                y = height;
            } else {
                for (y = class_4076.method_18689((long)sectionPos); y < height && !this.hasLightmap(sectionPos = ChunkSectionPosHelper.updateYLong(sectionPos, y)); ++y) {
                    if (!this.removedLightmaps.contains(sectionPos)) continue;
                    removedLightmapPosAbove = sectionPos;
                }
            }
            class_2804 lightmapAbove = y >= height ? (this.method_15566(sectionPos) ? DIRECT_SKYLIGHT_MAP : EMPTY_SKYLIGHT_MAP) : (this.vanillaLightmapComplexities.get(sectionPos) == 0 ? EMPTY_SKYLIGHT_MAP : this.method_15522(sectionPos, true));
            this.updateVanillaLightmapsBelow(removedLightmapPosAbove, lightmapAbove);
        }
    }

    @Overwrite
    private void method_15569() {
        this.field_15819 = !this.initSkylightChunks.isEmpty() || !this.removedLightmaps.isEmpty() || !this.scheduledHeightIncreases.isEmpty() || !this.scheduledHeightChecks.isEmpty();
    }

    @Unique
    private void markForUpdates() {
        if (!this.field_15819) {
            this.field_15819 = true;
        }
    }

    @Override
    public boolean method_15524(long sectionPos) {
        return super.method_15524(sectionPos) && this.method_15522(sectionPos, true) != null && !this.method_15568(sectionPos);
    }

    @Redirect(method={"createSection(J)Lnet/minecraft/world/chunk/ChunkNibbleArray;"}, slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/chunk/light/SkyLightStorage;queuedSections:Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", opcode=180)), at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;get(J)Ljava/lang/Object;", ordinal=0, remap=false))
    private Object cancelLightmapLookupFromQueue(Long2ObjectMap<class_2804> lightmapArray, long pos) {
        return null;
    }

    @Unique
    private static int getComplexityChange(int val, int oldNeighborVal, int newNeighborVal) {
        return Math.abs(newNeighborVal - val) - Math.abs(oldNeighborVal - val);
    }

    @Override
    protected void beforeLightChange(long blockPos, int oldVal, int newVal, class_2804 lightmap) {
        long sectionPos = class_4076.method_18691((long)blockPos);
        if (class_4076.method_18684((int)class_2338.method_10071((long)blockPos)) == 0) {
            this.vanillaLightmapComplexities.put(sectionPos, this.vanillaLightmapComplexities.get(sectionPos) + newVal - oldVal);
            long sectionPosBelow = this.getSectionBelow(sectionPos);
            if (sectionPosBelow != Long.MAX_VALUE) {
                class_2804 lightmapBelow = this.getOrAddLightmap(sectionPosBelow);
                int x = class_4076.method_18684((int)class_2338.method_10061((long)blockPos));
                int z = class_4076.method_18684((int)class_2338.method_10083((long)blockPos));
                this.changeLightmapComplexity(sectionPosBelow, MixinSkyLightStorage.getComplexityChange(lightmapBelow.method_12139(x, 15, z), oldVal, newVal));
            }
        } else if (this.field_15802.add(sectionPos)) {
            this.field_15796.method_15502(sectionPos);
            if (this.vanillaLightmapComplexities.get(sectionPos) != 0) {
                this.updateVanillaLightmapsBelow(sectionPos, this.method_15522(sectionPos, true));
            }
        }
    }

    @Override
    @Invoker(value="isAboveMinHeight")
    public abstract boolean callIsAboveMinHeight(int var1);

    @Shadow
    protected abstract boolean method_15567(int var1);

    @Shadow
    protected abstract boolean method_15568(long var1);

    @Unique
    private int getHeight(long chunkPos) {
        return ((SkyLightStorageDataAccess)this.field_15796).getHeight(chunkPos);
    }

    @Unique
    private int getMinHeight() {
        return ((SkyLightStorageDataAccess)this.field_15796).getDefaultHeight();
    }

    @Unique
    private void setHeight(long chunkPos, int height) {
        ((SkyLightStorageDataAccess)this.field_15796).setHeight(chunkPos, height + 1);
    }

    @Unique
    private void updateMinHeight(int y) {
        ((SkyLightStorageDataAccess)this.field_15796).updateMinHeight(y);
    }

    @Unique
    private long getSectionBelow(long sectionPos) {
        int y = class_4076.method_18689((long)sectionPos);
        while (this.method_15567(y)) {
            if (this.method_15524(sectionPos = class_4076.method_18679((long)sectionPos, (class_2350)class_2350.field_11033))) {
                return sectionPos;
            }
            --y;
        }
        return Long.MAX_VALUE;
    }

    @Override
    protected int getLightmapComplexityChange(long blockPos, int oldVal, int newVal, class_2804 lightmap) {
        class_2804 lightmapAbove;
        long sectionPos = class_4076.method_18691((long)blockPos);
        int x = class_4076.method_18684((int)class_2338.method_10061((long)blockPos));
        int y = class_4076.method_18684((int)class_2338.method_10071((long)blockPos));
        int z = class_4076.method_18684((int)class_2338.method_10083((long)blockPos));
        int valAbove = y < 15 ? lightmap.method_12139(x, y + 1, z) : ((lightmapAbove = this.getLightmapAbove(sectionPos)) == null ? this.getDirectSkylight(sectionPos) : lightmapAbove.method_12139(x, 0, z));
        int amount = MixinSkyLightStorage.getComplexityChange(valAbove, oldVal, newVal);
        if (y > 0) {
            amount += MixinSkyLightStorage.getComplexityChange(lightmap.method_12139(x, y - 1, z), oldVal, newVal);
        }
        return amount;
    }

    @Unique
    private class_2804 getLightmapAbove(long sectionPos) {
        long sectionPosAbove = this.getSectionAbove(sectionPos);
        return sectionPosAbove == Long.MAX_VALUE ? null : this.method_15522(sectionPosAbove, true);
    }

    @Unique
    private long getSectionAbove(long sectionPos) {
        int height = this.getHeight(class_4076.method_18693((long)sectionPos));
        if (height != this.getMinHeight()) {
            for (int y = class_4076.method_18689((long)sectionPos) + 1; y < height; ++y) {
                if (!this.hasLightmap(sectionPos = ChunkSectionPosHelper.updateYLong(sectionPos, y))) continue;
                return sectionPos;
            }
        }
        return Long.MAX_VALUE;
    }

    @Unique
    private int getDirectSkylight(long sectionPos) {
        return this.method_15566(sectionPos) ? 15 : 0;
    }

    @Override
    protected void beforeLightmapChange(long sectionPos, class_2804 oldLightmap, class_2804 newLightmap) {
        int vanillaComplexity;
        long sectionPosBelow = this.getSectionBelow(sectionPos);
        int n = vanillaComplexity = oldLightmap == null ? 0 : this.initializeVanillaLightmapComplexity(sectionPos, newLightmap);
        if (sectionPosBelow != Long.MAX_VALUE) {
            class_2804 lightmapBelow = this.getLightmap(sectionPosBelow);
            class_2804 lightmapAbove = oldLightmap == null ? this.getLightmapAbove(sectionPos) : oldLightmap;
            int skyLight = this.getDirectSkylight(sectionPos);
            if (lightmapBelow == null) {
                int complexity = 0;
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        complexity += Math.abs(newLightmap.method_12139(x, 0, z) - (lightmapAbove == null ? skyLight : lightmapAbove.method_12139(x, 0, z)));
                    }
                }
                if (complexity != 0) {
                    this.getOrAddLightmap(sectionPosBelow);
                    this.setLightmapComplexity(sectionPosBelow, complexity);
                } else if (vanillaComplexity != 0) {
                    this.updateVanillaLightmapsBelow(sectionPos, newLightmap);
                }
            } else {
                int amount = 0;
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        amount += MixinSkyLightStorage.getComplexityChange(lightmapBelow.method_12139(x, 15, z), lightmapAbove == null ? skyLight : lightmapAbove.method_12139(x, 0, z), newLightmap.method_12139(x, 0, z));
                    }
                }
                this.changeLightmapComplexity(sectionPosBelow, amount);
            }
        }
    }

    @Override
    protected int getInitialLightmapComplexity(long sectionPos, class_2804 lightmap) {
        int complexity = 0;
        for (int y = 0; y < 15; ++y) {
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    complexity += Math.abs(lightmap.method_12139(x, y + 1, z) - lightmap.method_12139(x, y, z));
                }
            }
        }
        class_2804 lightmapAbove = this.getLightmapAbove(sectionPos);
        int skyLight = this.getDirectSkylight(sectionPos);
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                complexity += Math.abs((lightmapAbove == null ? skyLight : lightmapAbove.method_12139(x, 0, z)) - lightmap.method_12139(x, 15, z));
            }
        }
        return complexity;
    }

    @Override
    public void method_15485(long id, int level) {
        long chunkPos = class_4076.method_18693((long)id);
        if (this.enabledChunks.contains(chunkPos)) {
            int oldLevel = this.method_15480(id);
            int y = class_4076.method_18689((long)id);
            if (oldLevel != 0 && level == 0) {
                if (y + 1 > this.getHeight(chunkPos)) {
                    if (this.field_15817.contains(chunkPos)) {
                        this.setHeight(chunkPos, y);
                    } else if (y > this.scheduledHeightIncreases.get(chunkPos)) {
                        this.scheduledHeightIncreases.put(chunkPos, y);
                        this.markForUpdates();
                    }
                }
            } else if (oldLevel == 0 && level != 0) {
                if (y + 1 == this.getHeight(chunkPos)) {
                    this.scheduledHeightChecks.add(chunkPos);
                    this.markForUpdates();
                }
            } else if (oldLevel >= 2 && level < 2) {
                this.updateMinHeight(y);
            }
        }
        super.method_15485(id, level);
    }

    @Override
    protected class_2804 createInitialVanillaLightmap(long sectionPos) {
        if (!this.field_15808.contains(sectionPos) && !this.field_15808.contains(class_4076.method_18679((long)sectionPos, (class_2350)class_2350.field_11036))) {
            return this.createTrivialVanillaLightmap(sectionPos);
        }
        long sectionPosAbove = this.getSectionAbove(sectionPos);
        int complexity = sectionPosAbove == Long.MAX_VALUE ? (this.method_15566(sectionPos) ? 3840 : 0) : this.vanillaLightmapComplexities.get(sectionPosAbove);
        if (complexity == 0) {
            return EMPTY_SKYLIGHT_MAP;
        }
        class_2804 lightmap = new class_2804(new byte[2048]);
        this.field_15796.method_15499(sectionPos, lightmap);
        this.trackSection(sectionPos);
        this.field_15796.method_15505();
        this.method_15523(sectionPos);
        this.setLightmapComplexity(sectionPos, complexity);
        return lightmap;
    }

    @Override
    protected class_2804 createTrivialVanillaLightmap(long sectionPos) {
        long sectionPosAbove = this.getSectionAbove(sectionPos);
        if (sectionPosAbove == Long.MAX_VALUE) {
            return this.method_15566(sectionPos) ? DIRECT_SKYLIGHT_MAP : EMPTY_SKYLIGHT_MAP;
        }
        return this.vanillaLightmapComplexities.get(sectionPosAbove) == 0 ? EMPTY_SKYLIGHT_MAP : new SkyLightChunkNibbleArray(this.method_15522(sectionPosAbove, true));
    }

    @Override
    @Overwrite
    public void method_15523(long sectionPos) {
        class_2804 lightmap;
        int y = class_4076.method_18689((long)sectionPos);
        this.updateMinHeight(y);
        long chunkPos = class_4076.method_18693((long)sectionPos);
        if (y + 1 > this.getHeight(chunkPos)) {
            this.setHeight(chunkPos, y);
        }
        this.updateVanillaLightmapsBelow(sectionPos, this.initializeVanillaLightmapComplexity(sectionPos, lightmap = this.method_15522(sectionPos, true)) == 0 ? EMPTY_SKYLIGHT_MAP : lightmap);
    }

    @Unique
    private int initializeVanillaLightmapComplexity(long sectionPos, class_2804 lightmap) {
        int complexity = 0;
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                complexity += lightmap.method_12139(x, 0, z);
            }
        }
        this.vanillaLightmapComplexities.put(sectionPos, complexity);
        return complexity;
    }

    @Override
    @Overwrite
    public void method_15534(long sectionPos) {
        if (this.vanillaLightmapComplexities.remove(sectionPos) != 0) {
            this.removedLightmaps.add(sectionPos);
            this.markForUpdates();
        }
        long chunkPos = class_4076.method_18693((long)sectionPos);
        if (class_4076.method_18689((long)sectionPos) + 1 == this.getHeight(chunkPos)) {
            this.scheduledHeightChecks.add(chunkPos);
            this.markForUpdates();
        }
    }

    @Unique
    private void updateVanillaLightmapsBelow(long sectionPos, class_2804 lightmapAbove) {
        this.removedLightmaps.remove(sectionPos);
        class_2804 lightmap = ((IReadonly)lightmapAbove).isReadonly() ? lightmapAbove : new SkyLightChunkNibbleArray(lightmapAbove);
        int y = class_4076.method_18689((long)sectionPos) - 1;
        while (this.method_15567(y)) {
            long sectionPosBelow = class_4076.method_18685((int)class_4076.method_18686((long)sectionPos), (int)y, (int)class_4076.method_18690((long)sectionPos));
            this.removedLightmaps.remove(sectionPosBelow);
            class_2804 lightmapBelow = this.method_15522(sectionPosBelow, true);
            if (lightmapBelow != null) {
                if (!((IReadonly)lightmapBelow).isReadonly()) break;
                this.field_15796.method_15499(sectionPosBelow, lightmap);
                this.field_15802.add(sectionPosBelow);
            }
            --y;
        }
        this.field_15796.method_15505();
    }
}

