/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.phosphor.common.util.cache;

import java.util.Arrays;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2823;
import net.minecraft.class_2826;

public class LightEngineBlockAccess {
    private static final class_2680 DEFAULT_STATE = class_2246.field_10124.method_9564();
    private final class_2823 chunkProvider;
    private final long[] cachedCoords = new long[2];
    private final class_2826[][] cachedSectionArrays = new class_2826[2][];

    public LightEngineBlockAccess(class_2823 provider) {
        this.chunkProvider = provider;
    }

    public class_2680 getBlockState(int x, int y, int z) {
        if (y < 0 || y >= 256) {
            return DEFAULT_STATE;
        }
        class_2826[] sections = this.getCachedSection(x >> 4, z >> 4);
        if (sections != null) {
            class_2826 section = sections[y >> 4];
            if (section == null) {
                return DEFAULT_STATE;
            }
            return section.method_12254(x & 0xF, y & 0xF, z & 0xF);
        }
        return null;
    }

    private class_2826[] getCachedSection(int x, int z) {
        long[] cachedCoords = this.cachedCoords;
        long coord = class_1923.method_8331((int)x, (int)z);
        for (int i = 0; i < cachedCoords.length; ++i) {
            if (cachedCoords[i] != coord) continue;
            return this.cachedSectionArrays[i];
        }
        return this.retrieveChunkSection(coord, x, z);
    }

    private class_2826[] retrieveChunkSection(long coord, int x, int z) {
        class_2826[] sections = this.retrieveChunkSections(x, z);
        this.addToCache(coord, sections);
        return sections;
    }

    private class_2826[] retrieveChunkSections(int chunkX, int chunkZ) {
        class_2791 chunk = (class_2791)this.chunkProvider.method_12246(chunkX, chunkZ);
        if (chunk == null) {
            return null;
        }
        return chunk.method_12006();
    }

    private void addToCache(long coord, class_2826[] sections) {
        class_2826[][] cachedSections = this.cachedSectionArrays;
        cachedSections[1] = cachedSections[0];
        cachedSections[0] = sections;
        long[] cachedCoords = this.cachedCoords;
        cachedCoords[1] = cachedCoords[0];
        cachedCoords[0] = coord;
    }

    public void reset() {
        Arrays.fill(this.cachedCoords, Long.MIN_VALUE);
        Arrays.fill((Object[])this.cachedSectionArrays, null);
    }
}

