/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.phosphor.common.util.collections;

import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntMaps;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import me.jellysquid.mods.phosphor.common.util.sync.SeqLock;

public class DoubleBufferedLong2IntHashMap {
    private final Long2IntMap mapPending;
    private final Long2IntMap mapVisible;
    private final Long2IntMap mapUpdates;
    private final SeqLock lock = new SeqLock();
    private int queuedDefaultReturnValue;

    public DoubleBufferedLong2IntHashMap() {
        this(16, 0.5f);
    }

    public DoubleBufferedLong2IntHashMap(int capacity, float loadFactor) {
        this.mapPending = new Long2IntOpenHashMap(capacity, loadFactor);
        this.mapVisible = new Long2IntOpenHashMap(capacity, loadFactor);
        this.mapUpdates = new Long2IntLinkedOpenHashMap(capacity, loadFactor);
    }

    public void defaultReturnValueSync(int v) {
        this.queuedDefaultReturnValue = v;
        this.mapPending.defaultReturnValue(v);
    }

    public int putSync(long k, int v) {
        if (v == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Value Integer.MIN_VALUE cannot be used");
        }
        this.mapUpdates.put(k, v);
        return this.mapPending.put(k, v);
    }

    public int removeSync(long k) {
        this.mapUpdates.put(k, Integer.MIN_VALUE);
        return this.mapPending.remove(k);
    }

    public int getSync(long k) {
        return this.mapPending.get(k);
    }

    public int getAsync(long k) {
        int ret;
        long stamp;
        do {
            stamp = this.lock.readBegin();
            ret = this.mapVisible.get(k);
        } while (this.lock.shouldRetryRead(stamp));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushChangesSync() {
        this.lock.writeLock();
        try {
            this.mapVisible.defaultReturnValue(this.queuedDefaultReturnValue);
            if (this.mapUpdates.isEmpty()) {
                return;
            }
            for (Long2IntMap.Entry entry : Long2IntMaps.fastIterable((Long2IntMap)this.mapUpdates)) {
                long key = entry.getLongKey();
                int val = entry.getIntValue();
                if (val == Integer.MIN_VALUE) {
                    this.mapVisible.remove(key);
                    continue;
                }
                this.mapVisible.put(key, val);
            }
        }
        finally {
            this.lock.writeUnlock();
        }
        this.mapUpdates.clear();
    }

    public Long2IntOpenHashMap createSyncView() {
        return new Long2IntOpenHashMap(){

            public int size() {
                return DoubleBufferedLong2IntHashMap.this.mapPending.size();
            }

            public void defaultReturnValue(int rv) {
                DoubleBufferedLong2IntHashMap.this.defaultReturnValueSync(rv);
            }

            public int defaultReturnValue() {
                return DoubleBufferedLong2IntHashMap.this.mapPending.defaultReturnValue();
            }

            public boolean containsKey(long key) {
                return DoubleBufferedLong2IntHashMap.this.mapPending.containsKey(key);
            }

            public boolean containsValue(int value) {
                return DoubleBufferedLong2IntHashMap.this.mapPending.containsValue(value);
            }

            public int get(long key) {
                return DoubleBufferedLong2IntHashMap.this.getSync(key);
            }

            public int put(long key, int value) {
                return DoubleBufferedLong2IntHashMap.this.putSync(key, value);
            }

            public int remove(long key) {
                return DoubleBufferedLong2IntHashMap.this.removeSync(key);
            }

            public boolean isEmpty() {
                return DoubleBufferedLong2IntHashMap.this.mapPending.isEmpty();
            }
        };
    }
}

