/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.phosphor.common.util.collections;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import me.jellysquid.mods.phosphor.common.util.sync.SeqLock;

public class DoubleBufferedLong2ObjectHashMap<V> {
    private final Long2ObjectMap<V> mapPending;
    private final Long2ObjectMap<V> mapLive;
    private final Long2ObjectMap<V> mapUpdates;
    private final SeqLock lock = new SeqLock();

    public DoubleBufferedLong2ObjectHashMap() {
        this(16, 0.5f);
    }

    public DoubleBufferedLong2ObjectHashMap(int capacity, float loadFactor) {
        this.mapPending = new Long2ObjectOpenHashMap(capacity, loadFactor);
        this.mapLive = new Long2ObjectOpenHashMap(capacity, loadFactor);
        this.mapUpdates = new Long2ObjectLinkedOpenHashMap(capacity, loadFactor);
    }

    public V getSync(long k) {
        return (V)this.mapPending.get(k);
    }

    public V putSync(long k, V value) {
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null, use enqueueRemoveSync instead to remove entries");
        }
        this.mapUpdates.put(k, value);
        return (V)this.mapPending.put(k, value);
    }

    public V removeSync(long k) {
        this.mapUpdates.put(k, null);
        return (V)this.mapPending.remove(k);
    }

    public boolean containsSync(long k) {
        return this.mapPending.containsKey(k);
    }

    public V getAsync(long k) {
        Object ret;
        long stamp;
        do {
            stamp = this.lock.readBegin();
            ret = this.mapLive.get(k);
        } while (this.lock.shouldRetryRead(stamp));
        return (V)ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushChangesSync() {
        if (this.mapUpdates.isEmpty()) {
            return;
        }
        try {
            this.lock.writeLock();
            for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(this.mapUpdates)) {
                long key = entry.getLongKey();
                Object val = entry.getValue();
                if (val == null) {
                    this.mapLive.remove(key);
                    continue;
                }
                this.mapLive.put(key, val);
            }
        }
        finally {
            this.lock.writeUnlock();
        }
        this.mapUpdates.clear();
    }
}

