/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.phosphor.mixin.chunk.light;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.BitSet;
import me.jellysquid.mods.phosphor.common.block.AbstractBlockStateAccess;
import me.jellysquid.mods.phosphor.common.block.ShapeCacheAccess;
import me.jellysquid.mods.phosphor.common.chunk.level.PendingUpdateListener;
import me.jellysquid.mods.phosphor.common.chunk.light.ChunkLightProviderExtended;
import me.jellysquid.mods.phosphor.common.util.cache.LightEngineBlockAccess;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2823;
import net.minecraft.class_3554;
import net.minecraft.class_3556;
import net.minecraft.class_3558;
import net.minecraft.class_3560;
import net.minecraft.class_4076;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3558.class})
public abstract class MixinChunkLightProvider<M extends class_3556<M>, S extends class_3560<M>>
extends class_3554
implements ChunkLightProviderExtended,
PendingUpdateListener {
    @Shadow
    @Final
    protected class_2338.class_2339 field_19284;
    @Shadow
    @Final
    protected class_2823 field_15795;
    private LightEngineBlockAccess blockAccess;
    private final Long2ObjectOpenHashMap<BitSet> buckets = new Long2ObjectOpenHashMap();
    private long prevChunkBucketKey = Long.MIN_VALUE;
    private BitSet prevChunkBucketSet;
    private static final long BLOCK_TO_BUCKET_KEY_MASK = class_2338.method_10064((int)15, (int)15, (int)15) ^ 0xFFFFFFFFFFFFFFFFL;

    protected MixinChunkLightProvider(int levelCount, int expectedLevelSize, int expectedTotalSize) {
        super(levelCount, expectedLevelSize, expectedTotalSize);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onConstructed(class_2823 provider, class_1944 lightType, S storage, CallbackInfo ci) {
        this.blockAccess = new LightEngineBlockAccess(provider);
    }

    @Inject(method={"clearChunkCache"}, at={@At(value="RETURN")})
    private void onCleanup(CallbackInfo ci) {
        if (this.blockAccess != null) {
            this.blockAccess.reset();
        }
    }

    @Override
    public class_2680 getBlockStateForLighting(int x, int y, int z) {
        return this.blockAccess.getBlockState(x, y, z);
    }

    @Override
    public int getSubtractedLight(class_2680 state, int x, int y, int z) {
        ShapeCacheAccess shapeCache = ((AbstractBlockStateAccess)state).getShapeCache();
        if (shapeCache != null) {
            return shapeCache.getLightSubtracted();
        }
        return state.method_26204().method_9505(state, this.field_15795.method_16399(), (class_2338)this.field_19284.method_10103(x, y, z));
    }

    @Override
    public class_265 getOpaqueShape(class_2680 state, int x, int y, int z, class_2350 dir) {
        if (state == null || !state.method_26211()) {
            return class_259.method_1073();
        }
        ShapeCacheAccess shapeCache = ((AbstractBlockStateAccess)state).getShapeCache();
        if (shapeCache != null) {
            class_265[] extrudedFaces = shapeCache.getExtrudedFaces();
            if (extrudedFaces != null) {
                return extrudedFaces[dir.ordinal()];
            }
            return class_259.method_1073();
        }
        return class_259.method_16344((class_265)state.method_26201(this.field_15795.method_16399(), (class_2338)this.field_19284.method_10103(x, y, z)), (class_2350)dir);
    }

    @Override
    public void spreadLightInto(long a, long b) {
        this.method_15478(a, b, this.method_15488(a, b, this.method_15480(a)), false);
        this.method_15478(b, a, this.method_15488(b, a, this.method_15480(b)), false);
    }

    @Override
    public void cancelUpdatesForChunk(long sectionPos) {
        long key = this.getBucketKeyForSection(sectionPos);
        BitSet bits = this.removeChunkBucket(key);
        if (bits != null && !bits.isEmpty()) {
            int startX = class_4076.method_18686((long)sectionPos) << 4;
            int startY = class_4076.method_18689((long)sectionPos) << 4;
            int startZ = class_4076.method_18690((long)sectionPos) << 4;
            int i = bits.nextSetBit(0);
            while (i != -1) {
                int x = i >> 8 & 0xF;
                int y = i >> 4 & 0xF;
                int z = i & 0xF;
                this.method_15483(class_2338.method_10064((int)(startX + x), (int)(startY + y), (int)(startZ + z)));
                i = bits.nextSetBit(i + 1);
            }
        }
    }

    @Override
    public void onPendingUpdateRemoved(long blockPos) {
        BitSet bits;
        long key = this.getBucketKeyForBlock(blockPos);
        if (this.prevChunkBucketKey == key) {
            bits = this.prevChunkBucketSet;
        } else {
            bits = (BitSet)this.buckets.get(key);
            if (bits == null) {
                return;
            }
        }
        bits.clear(MixinChunkLightProvider.getLocalIndex(blockPos));
        if (bits.isEmpty()) {
            this.removeChunkBucket(key);
        }
    }

    @Override
    public void onPendingUpdateAdded(long blockPos) {
        BitSet bits;
        long key = this.getBucketKeyForBlock(blockPos);
        if (this.prevChunkBucketKey == key) {
            bits = this.prevChunkBucketSet;
        } else {
            bits = (BitSet)this.buckets.get(key);
            if (bits == null) {
                bits = new BitSet(4096);
                this.buckets.put(key, (Object)bits);
            }
            this.prevChunkBucketKey = key;
            this.prevChunkBucketSet = bits;
        }
        bits.set(MixinChunkLightProvider.getLocalIndex(blockPos));
    }

    private long getBucketKeyForBlock(long blockPos) {
        return blockPos & BLOCK_TO_BUCKET_KEY_MASK;
    }

    private long getBucketKeyForSection(long sectionPos) {
        return class_2338.method_10064((int)(class_4076.method_18686((long)sectionPos) << 4), (int)(class_4076.method_18689((long)sectionPos) << 4), (int)(class_4076.method_18690((long)sectionPos) << 4));
    }

    private BitSet removeChunkBucket(long key) {
        BitSet set = (BitSet)this.buckets.remove(key);
        if (this.prevChunkBucketSet == set) {
            this.prevChunkBucketKey = Long.MIN_VALUE;
            this.prevChunkBucketSet = null;
        }
        return set;
    }

    private static int getLocalIndex(long blockPos) {
        int x = class_2338.method_10061((long)blockPos) & 0xF;
        int y = class_2338.method_10071((long)blockPos) & 0xF;
        int z = class_2338.method_10083((long)blockPos) & 0xF;
        return x << 8 | y << 4 | z;
    }
}

