/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.phosphor.mixin.chunk.light;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.BitSet;
import me.jellysquid.mods.phosphor.common.chunk.BlockStateAccess;
import me.jellysquid.mods.phosphor.common.chunk.BlockStateCacheAccess;
import me.jellysquid.mods.phosphor.common.chunk.light.LightEngineExtended;
import me.jellysquid.mods.phosphor.common.chunk.light.PendingUpdateListener;
import me.jellysquid.mods.phosphor.common.util.cache.LightEngineBlockAccess;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.lighting.LevelBasedGraph;
import net.minecraft.world.lighting.LightDataMap;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.lighting.SectionLightStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightEngine.class})
public abstract class MixinLightEngine<M extends LightDataMap<M>, S extends SectionLightStorage<M>>
extends LevelBasedGraph
implements LightEngineExtended,
PendingUpdateListener {
    @Shadow
    @Final
    protected BlockPos.Mutable field_215630_f;
    @Shadow
    @Final
    protected IChunkLightProvider field_215625_a;
    private LightEngineBlockAccess blockAccess;
    private final Long2ObjectOpenHashMap<BitSet> buckets = new Long2ObjectOpenHashMap();
    private long prevChunkBucketKey = Long.MIN_VALUE;
    private BitSet prevChunkBucketSet;
    private static final long BLOCK_TO_BUCKET_KEY_MASK = BlockPos.func_218276_a((int)15, (int)15, (int)15) ^ 0xFFFFFFFFFFFFFFFFL;

    protected MixinLightEngine(int levelCount, int p_i51298_2_, int p_i51298_3_) {
        super(levelCount, p_i51298_2_, p_i51298_3_);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onConstructed(IChunkLightProvider lightProvider, LightType lightType, S storage, CallbackInfo ci) {
        this.blockAccess = new LightEngineBlockAccess(lightProvider);
    }

    @Inject(method={"invalidateCaches"}, at={@At(value="RETURN")})
    private void onCleanup(CallbackInfo ci) {
        if (this.blockAccess != null) {
            this.blockAccess.reset();
        }
    }

    @Override
    public BlockState getBlockStateForLighting(int x, int y, int z) {
        return this.blockAccess.getBlockState(x, y, z);
    }

    @Override
    public int getSubtractedLight(BlockState state, int x, int y, int z) {
        BlockStateCacheAccess shapeCache = ((BlockStateAccess)state).getCache();
        if (shapeCache != null) {
            return shapeCache.getLightSubtracted();
        }
        return state.func_177230_c().func_200011_d(state, this.field_215625_a.func_212864_k_(), (BlockPos)this.field_215630_f.func_181079_c(x, y, z));
    }

    @Override
    public VoxelShape getOpaqueShape(BlockState state, int x, int y, int z, Direction dir) {
        if (state == null || !state.func_215691_g()) {
            return VoxelShapes.func_197880_a();
        }
        BlockStateCacheAccess cache = ((BlockStateAccess)state).getCache();
        if (cache != null) {
            VoxelShape[] extrudedFaces = cache.getExtrudedFaces();
            if (extrudedFaces != null) {
                return extrudedFaces[dir.ordinal()];
            }
            return VoxelShapes.func_197880_a();
        }
        return VoxelShapes.func_216387_a((VoxelShape)state.func_196951_e(this.field_215625_a.func_212864_k_(), (BlockPos)this.field_215630_f.func_181079_c(x, y, z)), (Direction)dir);
    }

    @Override
    public void cancelUpdatesForChunk(long sectionPos) {
        long key = MixinLightEngine.getBucketKeyForSection(sectionPos);
        BitSet bits = this.removeChunkBucket(key);
        if (bits != null && !bits.isEmpty()) {
            int startX = SectionPos.func_218173_b((long)sectionPos) << 4;
            int startY = SectionPos.func_218144_c((long)sectionPos) << 4;
            int startZ = SectionPos.func_218153_d((long)sectionPos) << 4;
            int i = bits.nextSetBit(0);
            while (i != -1) {
                int x = i >> 8 & 0xF;
                int y = i >> 4 & 0xF;
                int z = i & 0xF;
                this.func_215479_e(BlockPos.func_218276_a((int)(startX + x), (int)(startY + y), (int)(startZ + z)));
                i = bits.nextSetBit(i + 1);
            }
        }
    }

    @Override
    public void onPendingUpdateRemoved(long blockPos) {
        BitSet bits;
        long key = MixinLightEngine.getBucketKeyForBlock(blockPos);
        if (this.prevChunkBucketKey == key) {
            bits = this.prevChunkBucketSet;
        } else {
            bits = (BitSet)this.buckets.get(key);
            if (bits == null) {
                return;
            }
        }
        bits.clear(MixinLightEngine.getLocalIndex(blockPos));
        if (bits.isEmpty()) {
            this.removeChunkBucket(key);
        }
    }

    @Override
    public void onPendingUpdateAdded(long blockPos) {
        BitSet bits;
        long key = MixinLightEngine.getBucketKeyForBlock(blockPos);
        if (this.prevChunkBucketKey == key) {
            bits = this.prevChunkBucketSet;
        } else {
            bits = (BitSet)this.buckets.get(key);
            if (bits == null) {
                bits = new BitSet(4096);
                this.buckets.put(key, (Object)bits);
            }
            this.prevChunkBucketKey = key;
            this.prevChunkBucketSet = bits;
        }
        bits.set(MixinLightEngine.getLocalIndex(blockPos));
    }

    private static long getBucketKeyForBlock(long blockPos) {
        return blockPos & BLOCK_TO_BUCKET_KEY_MASK;
    }

    private static long getBucketKeyForSection(long sectionPos) {
        return BlockPos.func_218276_a((int)(SectionPos.func_218173_b((long)sectionPos) << 4), (int)(SectionPos.func_218144_c((long)sectionPos) << 4), (int)(SectionPos.func_218153_d((long)sectionPos) << 4));
    }

    private BitSet removeChunkBucket(long key) {
        BitSet set = (BitSet)this.buckets.remove(key);
        if (this.prevChunkBucketSet == set) {
            this.prevChunkBucketKey = Long.MIN_VALUE;
            this.prevChunkBucketSet = null;
        }
        return set;
    }

    private static int getLocalIndex(long blockPos) {
        int x = BlockPos.func_218290_b((long)blockPos) & 0xF;
        int y = BlockPos.func_218274_c((long)blockPos) & 0xF;
        int z = BlockPos.func_218282_d((long)blockPos) & 0xF;
        return x << 8 | y << 4 | z;
    }
}

