/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.mixin.launch;

import cpw.mods.modlauncher.LaunchPluginHandler;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.IncompatibleEnvironmentException;
import cpw.mods.modlauncher.api.TypesafeMap;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import io.github.lxgaming.classloader.ClassLoaderUtils;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import joptsimple.OptionSpecBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MixinTransformationService
implements ITransformationService {
    public static final String NAME = "mixinbootstrap";
    private static final Logger LOGGER = LogManager.getLogger((String)"MixinBootstrap Launch");
    private final Map<String, ILaunchPluginService> launchPluginServices;
    private final Set<ITransformationService> transformationServices;

    public MixinTransformationService() {
        if (Launcher.INSTANCE == null) {
            throw new IllegalStateException("Launcher has not been initialized!");
        }
        this.launchPluginServices = this.getLaunchPluginServices();
        this.transformationServices = new HashSet<ITransformationService>();
    }

    @Nonnull
    public String name() {
        return NAME;
    }

    public void arguments(BiFunction<String, String, OptionSpecBuilder> argumentBuilder) {
        this.transformationServices.forEach(transformationService -> transformationService.arguments(argumentBuilder));
    }

    public void argumentValues(ITransformationService.OptionResult option) {
        this.transformationServices.forEach(transformationService -> transformationService.argumentValues(option));
    }

    public void initialize(IEnvironment environment) {
        this.transformationServices.forEach(transformationService -> transformationService.initialize(environment));
    }

    public void beginScanning(IEnvironment environment) {
        this.transformationServices.forEach(transformationService -> transformationService.beginScanning(environment));
    }

    public List<Map.Entry<String, Path>> runScan(IEnvironment environment) {
        ArrayList<Map.Entry<String, Path>> list = new ArrayList<Map.Entry<String, Path>>();
        this.transformationServices.forEach(transformationService -> list.addAll(transformationService.runScan(environment)));
        return list;
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) throws IncompatibleEnvironmentException {
        if (this.launchPluginServices == null) {
            throw new IncompatibleEnvironmentException("LaunchPluginServices is unavailable");
        }
        if (this.getClass().getClassLoader() == Launcher.class.getClassLoader()) {
            return;
        }
        try {
            ClassLoaderUtils.appendToClassPath(Launcher.class.getClassLoader(), this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().toURL());
        }
        catch (Throwable ex) {
            LOGGER.error("Encountered an error while attempting to append to the class path", ex);
            throw new IncompatibleEnvironmentException("Failed to append to the class path");
        }
        this.registerLaunchPluginService("org.spongepowered.asm.launch.MixinLaunchPlugin");
        this.registerTransformationService("org.spongepowered.asm.launch.MixinTransformationService");
        this.registerLaunchPluginService("io.github.lxgaming.mixin.launch.MixinLaunchPluginService");
        for (ITransformationService transformationService : this.transformationServices) {
            transformationService.onLoad(env, otherServices);
        }
    }

    @Nonnull
    public List<ITransformer> transformers() {
        ArrayList<ITransformer> list = new ArrayList<ITransformer>();
        this.transformationServices.forEach(transformationService -> list.addAll(transformationService.transformers()));
        return list;
    }

    public Map.Entry<Set<String>, Supplier<Function<String, Optional<URL>>>> additionalClassesLocator() {
        return null;
    }

    public Map.Entry<Set<String>, Supplier<Function<String, Optional<URL>>>> additionalResourcesLocator() {
        return null;
    }

    private void registerLaunchPluginService(String className) throws IncompatibleEnvironmentException {
        try {
            Class<?> launchPluginServiceClass = Class.forName(className, true, Launcher.class.getClassLoader());
            if (this.isLaunchPluginServicePresent(launchPluginServiceClass)) {
                LOGGER.warn("{} is already registered", (Object)launchPluginServiceClass.getSimpleName());
                return;
            }
            ILaunchPluginService launchPluginService = (ILaunchPluginService)launchPluginServiceClass.newInstance();
            String pluginName = launchPluginService.name();
            this.launchPluginServices.put(pluginName, launchPluginService);
            List mods = Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.MODLIST.get()).orElse(null);
            if (mods != null) {
                HashMap<String, String> mod = new HashMap<String, String>();
                mod.put("name", pluginName);
                mod.put("type", "PLUGINSERVICE");
                String fileName = launchPluginServiceClass.getProtectionDomain().getCodeSource().getLocation().getFile();
                mod.put("file", fileName.substring(fileName.lastIndexOf(47)));
                mods.add(mod);
            }
            LOGGER.debug("Registered {} ({})", (Object)launchPluginServiceClass.getSimpleName(), (Object)pluginName);
        }
        catch (Throwable ex) {
            LOGGER.error("Encountered an error while registering {}", (Object)className, (Object)ex);
            throw new IncompatibleEnvironmentException(String.format("Failed to register %s", className));
        }
    }

    private void registerTransformationService(String className) throws IncompatibleEnvironmentException {
        try {
            Class<?> transformationServiceClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            if (this.isTransformationServicePresent(transformationServiceClass)) {
                LOGGER.warn("{} is already registered", (Object)transformationServiceClass.getSimpleName());
                return;
            }
            ITransformationService transformationService = (ITransformationService)transformationServiceClass.newInstance();
            String name = transformationService.name();
            this.transformationServices.add(transformationService);
            LOGGER.debug("Registered {} ({})", (Object)transformationServiceClass.getSimpleName(), (Object)name);
        }
        catch (Exception ex) {
            LOGGER.error("Encountered an error while registering {}", (Object)className, (Object)ex);
            throw new IncompatibleEnvironmentException(String.format("Failed to register %s", className));
        }
    }

    private boolean isLaunchPluginServicePresent(Class<? extends ILaunchPluginService> launchPluginServiceClass) {
        for (ILaunchPluginService launchPluginService : this.launchPluginServices.values()) {
            if (!launchPluginServiceClass.isInstance(launchPluginService)) continue;
            return true;
        }
        return false;
    }

    private boolean isTransformationServicePresent(Class<? extends ITransformationService> transformationServiceClass) {
        for (ITransformationService transformationService : this.transformationServices) {
            if (!transformationServiceClass.isInstance(transformationService)) continue;
            return true;
        }
        return false;
    }

    private Map<String, ILaunchPluginService> getLaunchPluginServices() {
        try {
            Field launchPluginsField = Launcher.class.getDeclaredField("launchPlugins");
            launchPluginsField.setAccessible(true);
            LaunchPluginHandler launchPluginHandler = (LaunchPluginHandler)launchPluginsField.get(Launcher.INSTANCE);
            Field pluginsField = LaunchPluginHandler.class.getDeclaredField("plugins");
            pluginsField.setAccessible(true);
            return (Map)pluginsField.get(launchPluginHandler);
        }
        catch (Exception ex) {
            LOGGER.error("Encountered an error while getting LaunchPluginServices", (Throwable)ex);
            return null;
        }
    }
}

