/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.List;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.recipes.AssemblyRecipe;
import me.desht.pneumaticcraft.common.recipes.programs.AssemblyProgram;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyPlatform;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyRobot;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityAssemblyIOUnit
extends TileEntityAssemblyRobot {
    private static final int INVENTORY_SIZE = 1;
    @DescSynced
    private boolean shouldClawClose;
    @DescSynced
    @LazySynced
    public float clawProgress;
    public float oldClawProgress;
    @DescSynced
    private ItemStackHandler inventory = new BaseItemStackHandler(this, 1);
    private List<AssemblyRecipe> recipeList;
    private ItemStack searchedItemStack = ItemStack.field_190927_a;
    private byte state = 0;
    private byte tickCounter = 0;
    private boolean hasSwitchedThisTick;
    @DescSynced
    private boolean exporting;
    private static final byte SLEEP_TICKS = 50;
    private static final byte STATE_IDLE = 0;
    private static final byte STATE_SEARCH_SRC = 1;
    private static final byte STATE_CLOSECLAW_AFTER_PICKUP = 5;
    private static final byte STATE_RESET_CLOSECLAW_AFTER_PICKUP = 20;
    private static final byte STATE_RESET_GOTO_IDLE = 26;
    private static final byte STATE_MAX = 127;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.hasSwitchedThisTick = false;
        if (this.func_145831_w().field_72995_K) {
            if (!this.isClawDone()) {
                this.moveClaw();
            }
        } else {
            this.slowMode = false;
            switch (this.state) {
                case 0: {
                    break;
                }
                case 1: {
                    if (!this.findPickupLocation()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 2: 
                case 7: 
                case 22: {
                    if (!this.hoverOverTarget()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 3: 
                case 8: 
                case 23: {
                    this.slowMode = true;
                    if (!this.gotoTarget()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 4: {
                    if (!this.getItemFromCurrentDirection()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 5: 
                case 20: {
                    if (!this.closeClaw()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 6: 
                case 21: {
                    if (!this.findDropOffLocation()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 9: 
                case 24: {
                    if (!this.openClaw()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 10: 
                case 25: {
                    if (!this.putItemToCurrentDirection()) break;
                    this.state = (byte)(this.state + 1);
                    break;
                }
                case 11: 
                case 26: {
                    if (this.gotoIdlePos()) {
                        this.state = 0;
                    }
                }
                case 127: {
                    break;
                }
                default: {
                    System.out.printf("unexpected state: %d%n", this.state);
                    this.state = (byte)127;
                }
            }
        }
    }

    public ItemStack getHeldStack() {
        return this.inventory.getStackInSlot(0);
    }

    @Override
    public boolean reset() {
        if (this.state >= 20) {
            return false;
        }
        if (!this.inventory.getStackInSlot(0).func_190926_b()) {
            this.state = (byte)20;
            return false;
        }
        if (this.state == 0) {
            return true;
        }
        this.state = (byte)26;
        return this.isIdle();
    }

    public boolean pickupItem(List<AssemblyRecipe> list) {
        this.recipeList = list;
        if (this.state == 0) {
            this.state = (byte)(this.state + 1);
        }
        return this.state > 0 && !this.isSleeping() && this.state < 127;
    }

    private boolean gotoIdlePos() {
        this.gotoHomePosition();
        return this.isDoneInternal();
    }

    private boolean findPickupLocation() {
        if (this.shouldSleep()) {
            return false;
        }
        EnumFacing[] inventoryDir = null;
        if (this.isImportUnit()) {
            this.searchedItemStack = ItemStack.field_190927_a;
            if (this.recipeList != null) {
                for (AssemblyRecipe recipe : this.recipeList) {
                    inventoryDir = this.getInventoryDirectionForItem(recipe.getInput());
                    if (inventoryDir == null) continue;
                    this.searchedItemStack = recipe.getInput();
                    break;
                }
            }
        } else {
            inventoryDir = this.getPlatformDirection();
        }
        this.targetDirection = inventoryDir;
        if (this.targetDirection == null) {
            this.sleepBeforeNextSearch();
            return false;
        }
        return true;
    }

    private boolean isSleeping() {
        return this.tickCounter > 0;
    }

    private boolean shouldSleep() {
        if (this.tickCounter > 0) {
            byte by = this.tickCounter;
            this.tickCounter = (byte)(by + 1);
            if (by < 50) {
                return true;
            }
        }
        this.tickCounter = 0;
        return false;
    }

    private void sleepBeforeNextSearch() {
        this.tickCounter = 1;
    }

    private boolean findDropOffLocation() {
        if (this.shouldSleep()) {
            return false;
        }
        EnumFacing[] enumFacingArray = this.targetDirection = this.isImportUnit() ? this.getPlatformDirection() : this.getExportLocationForItem(this.inventory.getStackInSlot(0));
        if (this.targetDirection == null) {
            this.sleepBeforeNextSearch();
            return false;
        }
        return true;
    }

    private boolean getItemFromCurrentDirection() {
        TileEntityAssemblyPlatform plat;
        TileEntity tile = this.getTileEntityForCurrentDirection();
        boolean extracted = false;
        if (this.isImportUnit()) {
            if (this.searchedItemStack.func_190926_b()) {
                this.reset();
            } else if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                IItemHandler otherInv = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                ItemStack currentStack = this.inventory.getStackInSlot(0);
                int oldStackSize = currentStack.func_190916_E();
                for (int i = 0; i < otherInv.getSlots(); ++i) {
                    ItemStack exStack;
                    if (otherInv.getStackInSlot(i).func_190926_b()) continue;
                    if (currentStack.func_190926_b()) {
                        if (otherInv.getStackInSlot(i).func_77969_a(this.searchedItemStack)) {
                            exStack = otherInv.extractItem(i, 1, false);
                            this.inventory.insertItem(0, exStack, false);
                        }
                    } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)currentStack, (ItemStack)otherInv.getStackInSlot(i))) {
                        exStack = otherInv.extractItem(i, 1, false);
                        this.inventory.insertItem(0, exStack, false);
                    }
                    boolean bl = extracted = this.inventory.getStackInSlot(0).func_190916_E() >= this.searchedItemStack.func_190916_E();
                    if (extracted) break;
                }
                if (oldStackSize == this.inventory.getStackInSlot(0).func_190916_E()) {
                    this.state = 1;
                }
            } else {
                this.state = 1;
            }
        } else if (tile instanceof TileEntityAssemblyPlatform && (plat = (TileEntityAssemblyPlatform)tile).openClaw()) {
            this.inventory.setStackInSlot(0, plat.getHeldStack());
            plat.setHeldStack(ItemStack.field_190927_a);
            boolean bl = extracted = !this.inventory.getStackInSlot(0).func_190926_b();
            if (!extracted) {
                this.state = 1;
            }
        }
        return extracted;
    }

    private boolean putItemToCurrentDirection() {
        if (this.isImportUnit()) {
            TileEntity tile = this.getTileEntityForCurrentDirection();
            if (tile instanceof TileEntityAssemblyPlatform) {
                TileEntityAssemblyPlatform plat = (TileEntityAssemblyPlatform)tile;
                if (this.inventory.getStackInSlot(0).func_190926_b()) {
                    return plat.closeClaw();
                }
                if (plat.isIdle()) {
                    plat.setHeldStack(this.inventory.getStackInSlot(0));
                    this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                    return plat.closeClaw();
                }
            } else {
                this.repeatDropOffSearch();
            }
        } else {
            TileEntity te = this.getTileEntityForCurrentDirection();
            if (te == null) {
                this.repeatDropOffSearch();
            } else {
                ItemStack currentStack = this.inventory.getStackInSlot(0);
                int startSize = currentStack.func_190916_E();
                for (int i = 0; i < 6; ++i) {
                    ItemStack excess = PneumaticCraftUtils.exportStackToInventory((ICapabilityProvider)te, currentStack, EnumFacing.func_82600_a((int)i));
                    this.inventory.setStackInSlot(0, excess);
                    if (excess.func_190926_b()) break;
                }
                if ((currentStack = this.inventory.getStackInSlot(0)).func_190926_b() || startSize != currentStack.func_190916_E()) {
                    this.sendDescriptionPacket();
                }
                if (!currentStack.func_190926_b() && startSize == currentStack.func_190916_E()) {
                    this.repeatDropOffSearch();
                }
            }
            return this.inventory.getStackInSlot(0).func_190926_b();
        }
        return false;
    }

    private void repeatDropOffSearch() {
        this.state = (byte)(this.state >= 20 ? 20 : 5);
    }

    private boolean closeClaw() {
        this.shouldClawClose = true;
        return this.moveClaw();
    }

    private boolean openClaw() {
        this.shouldClawClose = false;
        return this.moveClaw();
    }

    private boolean moveClaw() {
        this.oldClawProgress = this.clawProgress;
        if (!this.shouldClawClose && this.clawProgress > 0.0f) {
            this.clawProgress = Math.max(this.clawProgress - 0.05f * this.speed, 0.0f);
        } else if (this.shouldClawClose && this.clawProgress < 1.0f) {
            this.clawProgress = Math.min(this.clawProgress + 0.05f * this.speed, 1.0f);
        }
        this.func_70296_d();
        return this.isClawDone();
    }

    private boolean isClawDone() {
        return this.clawProgress == this.oldClawProgress && this.clawProgress == (this.shouldClawClose ? 1.0f : 0.0f);
    }

    public boolean isImportUnit() {
        return !this.exporting;
    }

    public boolean switchMode() {
        if (this.state <= 1) {
            if (!this.hasSwitchedThisTick) {
                this.exporting = !this.exporting;
                this.hasSwitchedThisTick = true;
                this.func_70296_d();
                this.invalidateSystem();
            }
            return true;
        }
        return false;
    }

    @Override
    public void gotoHomePosition() {
        super.gotoHomePosition();
        if (this.isClawDone()) {
            this.openClaw();
        }
    }

    @Override
    public boolean isIdle() {
        return this.state == 0;
    }

    @Override
    public AssemblyProgram.EnumMachine getAssemblyType() {
        return this.isImportUnit() ? AssemblyProgram.EnumMachine.IO_UNIT_IMPORT : AssemblyProgram.EnumMachine.IO_UNIT_EXPORT;
    }

    private boolean isDoneInternal() {
        return super.isDoneMoving();
    }

    private EnumFacing[] getInventoryDirectionForItem(ItemStack searchedItem) {
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (!searchedItem.func_190926_b() && (stack.func_190926_b() || stack.func_77969_a(searchedItem))) {
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                IItemHandler handler = IOHelper.getInventoryForTE(this.getCachedNeighbor(dir), EnumFacing.UP);
                if (handler == null || IOHelper.extract(handler, searchedItem, IOHelper.ExtractCount.EXACT, true, false).func_190926_b()) continue;
                return new EnumFacing[]{dir, null};
            }
            if (this.canMoveToDiagonalNeighbours()) {
                for (EnumFacing secDir : new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST}) {
                    for (EnumFacing primDir : new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH}) {
                        TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(primDir).func_177972_a(secDir));
                        IItemHandler handler = IOHelper.getInventoryForTE(te, EnumFacing.UP);
                        if (IOHelper.extract(handler, searchedItem, IOHelper.ExtractCount.EXACT, true, false).func_190926_b()) continue;
                        return new EnumFacing[]{primDir, secDir};
                    }
                }
            }
        }
        return null;
    }

    private EnumFacing[] getExportLocationForItem(ItemStack exportedItem) {
        if (!exportedItem.func_190926_b()) {
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(dir));
                int slot = TileEntityAssemblyIOUnit.getPlacementSlot(exportedItem, te);
                if (slot < 0) continue;
                return new EnumFacing[]{dir, null};
            }
            if (this.canMoveToDiagonalNeighbours()) {
                for (EnumFacing secDir : new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST}) {
                    for (EnumFacing primDir : new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH}) {
                        TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(primDir).func_177972_a(secDir));
                        int slot = TileEntityAssemblyIOUnit.getPlacementSlot(exportedItem, te);
                        if (slot < 0) continue;
                        return new EnumFacing[]{primDir, secDir};
                    }
                }
            }
        }
        return null;
    }

    private static int getPlacementSlot(ItemStack exportedItem, TileEntity te) {
        if (te != null && !(te instanceof TileEntityAssemblyRobot) && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) {
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack excess = handler.insertItem(slot, exportedItem, true);
                if (excess.func_190916_E() >= exportedItem.func_190916_E()) continue;
                return slot;
            }
        }
        return -1;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.clawProgress = tag.func_74760_g("clawProgress");
        this.shouldClawClose = tag.func_74767_n("clawClosing");
        this.state = tag.func_74771_c("state");
        this.exporting = tag.func_74767_n("exporting");
        this.inventory = new ItemStackHandler(1);
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74776_a("clawProgress", this.clawProgress);
        tag.func_74757_a("clawClosing", this.shouldClawClose);
        tag.func_74774_a("state", this.state);
        tag.func_74757_a("exporting", this.exporting);
        tag.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    @Override
    public boolean canMoveToDiagonalNeighbours() {
        return true;
    }
}

