/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft;

import com.mojang.brigadier.CommandDispatcher;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.item.IUpgradeAcceptor;
import me.desht.pneumaticcraft.client.ClientSetup;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.event.ClientTickHandler;
import me.desht.pneumaticcraft.client.render.area.AreaRenderManager;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.entity_tracker.EntityTrackHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.CoordTrackUpgradeHandler;
import me.desht.pneumaticcraft.common.PneumaticCraftAPIHandler;
import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.capabilities.CapabilityAirHandler;
import me.desht.pneumaticcraft.common.capabilities.CapabilityHacking;
import me.desht.pneumaticcraft.common.capabilities.CapabilityHeat;
import me.desht.pneumaticcraft.common.commands.ModCommands;
import me.desht.pneumaticcraft.common.config.ConfigHolder;
import me.desht.pneumaticcraft.common.config.aux.AuxConfigHandler;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModContainers;
import me.desht.pneumaticcraft.common.core.ModEntities;
import me.desht.pneumaticcraft.common.core.ModFluids;
import me.desht.pneumaticcraft.common.core.ModHarvestHandlers;
import me.desht.pneumaticcraft.common.core.ModHoeHandlers;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModParticleTypes;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.core.ModRecipes;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.core.ModVillagers;
import me.desht.pneumaticcraft.common.dispenser.BehaviorDispenseDrone;
import me.desht.pneumaticcraft.common.event.DroneSpecialVariableHandler;
import me.desht.pneumaticcraft.common.event.EventHandlerAmadron;
import me.desht.pneumaticcraft.common.event.EventHandlerPneumaticArmor;
import me.desht.pneumaticcraft.common.event.EventHandlerPneumaticCraft;
import me.desht.pneumaticcraft.common.event.EventHandlerUniversalSensor;
import me.desht.pneumaticcraft.common.event.HackTickHandler;
import me.desht.pneumaticcraft.common.event.TickHandlerPneumaticCraft;
import me.desht.pneumaticcraft.common.fluid.FluidSetup;
import me.desht.pneumaticcraft.common.hacking.HackableHandler;
import me.desht.pneumaticcraft.common.heat.BlockHeatProperties;
import me.desht.pneumaticcraft.common.item.ItemGPSAreaTool;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.recipes.MachineRecipeHandler;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.sensor.SensorHandler;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.util.Reflections;
import me.desht.pneumaticcraft.common.util.upgrade.UpgradesDBSetup;
import me.desht.pneumaticcraft.common.villages.POIFixup;
import me.desht.pneumaticcraft.common.villages.VillageStructures;
import me.desht.pneumaticcraft.common.worldgen.ModDecorators;
import me.desht.pneumaticcraft.common.worldgen.ModWorldGen;
import me.desht.pneumaticcraft.datagen.ModBlockTagsProvider;
import me.desht.pneumaticcraft.datagen.ModFluidTagsProvider;
import me.desht.pneumaticcraft.datagen.ModItemTagsProvider;
import me.desht.pneumaticcraft.datagen.ModLootTablesProvider;
import me.desht.pneumaticcraft.datagen.ModRecipeProvider;
import me.desht.pneumaticcraft.datagen.loot.TileEntitySerializerFunction;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.DispenserBlock;
import net.minecraft.command.CommandSource;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="pneumaticcraft")
public class PneumaticCraftRepressurized {
    public PneumaticCraftRepressurized() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ConfigHolder.init();
        AuxConfigHandler.preInit();
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ThirdPartyManager.instance().clientPreInit();
            modBus.addListener(ClientHandler::clientSetup);
            MinecraftForge.EVENT_BUS.addListener(ClientHandler::registerRenders);
        });
        modBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(this::serverAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarted);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopping);
        ModBlocks.BLOCKS.register(modBus);
        ModItems.ITEMS.register(modBus);
        ModFluids.FLUIDS.register(modBus);
        ModSounds.SOUNDS.register(modBus);
        ModTileEntities.TILE_ENTITIES.register(modBus);
        ModEntities.ENTITIES.register(modBus);
        ModContainers.CONTAINERS.register(modBus);
        ModParticleTypes.PARTICLES.register(modBus);
        ModRecipes.RECIPES.register(modBus);
        ModDecorators.DECORATORS.register(modBus);
        ModVillagers.POI.register(modBus);
        ModVillagers.PROFESSIONS.register(modBus);
        modBus.addListener(EventPriority.LOW, this::addCustomRegistryDeferredRegisters);
        Reflections.init();
        PneumaticRegistry.init(PneumaticCraftAPIHandler.getInstance());
        ThirdPartyManager.instance().preInit();
        AdvancementTriggers.registerTriggers();
        LootFunctionManager.func_186582_a((ILootFunction.Serializer)new TileEntitySerializerFunction.Serializer());
        MinecraftForge.EVENT_BUS.register((Object)new TickHandlerPneumaticCraft());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerPneumaticCraft());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerAmadron());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerPneumaticArmor());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerUniversalSensor());
        MinecraftForge.EVENT_BUS.register((Object)new DroneSpecialVariableHandler());
        MinecraftForge.EVENT_BUS.register(ItemGPSAreaTool.EventHandler.class);
        MinecraftForge.EVENT_BUS.register((Object)HackTickHandler.instance());
    }

    private void addCustomRegistryDeferredRegisters(RegistryEvent.NewRegistry event) {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModHarvestHandlers.HARVEST_HANDLERS.register(modBus);
        ModHoeHandlers.HOE_HANDLERS.register(modBus);
        ModProgWidgets.PROG_WIDGETS.register(modBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        Log.info("PneumaticCraft: Repressurized is loading!", new Object[0]);
        AuxConfigHandler.postInit();
        this.registerCapabilities();
        NetworkHandler.init();
        FluidSetup.init();
        HackableHandler.addDefaultEntries();
        SensorHandler.getInstance().init();
        UpgradesDBSetup.init();
        ModWorldGen.init();
        POIFixup.fixup();
        VillageStructures.init();
        ModNameCache.init();
        ThirdPartyManager.instance().init();
        DeferredWorkQueue.runLater(() -> {
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ModItems.DRONE.get()), (IDispenseItemBehavior)new BehaviorDispenseDrone());
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ModItems.LOGISTICS_DRONE.get()), (IDispenseItemBehavior)new BehaviorDispenseDrone());
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ModItems.HARVESTING_DRONE.get()), (IDispenseItemBehavior)new BehaviorDispenseDrone());
            ThirdPartyManager.instance().postInit();
            for (RegistryObject block : ModBlocks.BLOCKS.getEntries()) {
                if (!(block.get() instanceof IUpgradeAcceptor)) continue;
                PneumaticRegistry.getInstance().getItemRegistry().registerUpgradeAcceptor((IUpgradeAcceptor)block.get());
            }
            for (RegistryObject item : ModItems.ITEMS.getEntries()) {
                if (!(item.get() instanceof IUpgradeAcceptor)) continue;
                PneumaticRegistry.getInstance().getItemRegistry().registerUpgradeAcceptor((IUpgradeAcceptor)item.get());
            }
        });
    }

    private void registerCapabilities() {
        CapabilityAirHandler.register();
        CapabilityHeat.register();
        CapabilityHacking.register();
    }

    private void serverAboutToStart(FMLServerAboutToStartEvent event) {
        event.getServer().func_195570_aG().func_219534_a((IFutureReloadListener)new MachineRecipeHandler.ReloadListener());
        event.getServer().func_195570_aG().func_219534_a((IFutureReloadListener)new BlockHeatProperties.ReloadListener());
    }

    private void serverStarting(FMLServerStartingEvent event) {
        ModCommands.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    private void serverStopping(FMLServerStoppingEvent event) {
        AmadronOfferManager.getInstance().saveAll();
    }

    private void serverStarted(FMLServerStartedEvent event) {
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class DataGenerators {
        @SubscribeEvent
        public static void gatherData(GatherDataEvent event) {
            DataGenerator generator = event.getGenerator();
            if (event.includeServer()) {
                generator.func_200390_a((IDataProvider)new ModRecipeProvider(generator));
                generator.func_200390_a((IDataProvider)new ModLootTablesProvider(generator));
                generator.func_200390_a((IDataProvider)new ModBlockTagsProvider(generator));
                generator.func_200390_a((IDataProvider)new ModItemTagsProvider(generator));
                generator.func_200390_a((IDataProvider)new ModFluidTagsProvider(generator));
            }
        }
    }

    static class ClientHandler {
        ClientHandler() {
        }

        static void clientSetup(FMLClientSetupEvent event) {
            MinecraftForge.EVENT_BUS.register((Object)HUDHandler.instance());
            MinecraftForge.EVENT_BUS.register((Object)ClientTickHandler.instance());
            MinecraftForge.EVENT_BUS.register((Object)HackTickHandler.instance());
            MinecraftForge.EVENT_BUS.register((Object)HUDHandler.instance().getSpecificRenderer(CoordTrackUpgradeHandler.class));
            MinecraftForge.EVENT_BUS.register((Object)AreaRenderManager.getInstance());
            MinecraftForge.EVENT_BUS.register((Object)KeyHandler.getInstance());
            EntityTrackHandler.registerDefaultEntries();
            ThirdPartyManager.instance().clientInit();
            DeferredWorkQueue.runLater(ClientSetup::init);
        }

        static void registerRenders(ModelRegistryEvent event) {
        }
    }
}

