/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;

public class FluidIngredient
extends Ingredient {
    private final List<Fluid> fluids;
    private final int amount;
    private ItemStack[] cachedStacks;
    private final ResourceLocation tagId;
    public static final FluidIngredient EMPTY = new FluidIngredient();

    public FluidIngredient(Fluid fluid, int amount) {
        this(new FluidStack(fluid, amount));
    }

    private FluidIngredient() {
        super(Stream.empty());
        this.fluids = Collections.emptyList();
        this.amount = 0;
        this.tagId = null;
    }

    private FluidIngredient(FluidStack fluidStack) {
        super(Stream.empty());
        Validate.isTrue((!fluidStack.isEmpty() ? 1 : 0) != 0);
        this.fluids = Collections.singletonList(fluidStack.getFluid());
        this.amount = fluidStack.getAmount();
        this.tagId = null;
    }

    private FluidIngredient(Tag<Fluid> tag, int amount) {
        super(Stream.empty());
        this.fluids = ImmutableList.copyOf((Collection)tag.func_199885_a());
        this.amount = amount;
        this.tagId = tag.func_199886_b();
    }

    public boolean func_203189_d() {
        return this.fluids.isEmpty();
    }

    public boolean test(@Nullable ItemStack stack) {
        return (Boolean)FluidUtil.getFluidContained((ItemStack)stack).map(this::testFluid).orElse((Object)false);
    }

    public ItemStack[] func_193365_a() {
        if (this.cachedStacks == null) {
            this.cachedStacks = (ItemStack[])this.fluids.stream().map(fluid -> FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000))).toArray(ItemStack[]::new);
        }
        return this.cachedStacks;
    }

    public boolean testFluid(FluidStack fluidStack) {
        return this.fluids.stream().anyMatch(f -> fluidStack.getFluid() == f && fluidStack.getAmount() >= this.amount);
    }

    public boolean testFluid(Fluid otherFluid) {
        return this.fluids.stream().anyMatch(f -> f == otherFluid);
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.ID.toString());
        if (this.tagId == null) {
            json.addProperty("fluid", this.fluids.get(0).getRegistryName().toString());
        } else {
            json.addProperty("tag", this.tagId.toString());
        }
        json.addProperty("amount", (Number)this.amount);
        return json;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public void writeToPacket(PacketBuffer buffer) {
        Serializer.INSTANCE.write(buffer, this);
    }

    public static FluidIngredient readFromPacket(PacketBuffer buffer) {
        return Serializer.INSTANCE.parse(buffer);
    }

    public int getAmount() {
        return this.amount;
    }

    public List<FluidStack> getFluidStacks() {
        return this.fluids.stream().map(f -> new FluidStack(f, this.amount)).collect(Collectors.toList());
    }

    public static class Serializer
    implements IIngredientSerializer<FluidIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("pneumaticcraft:fluid");

        public FluidIngredient parse(PacketBuffer buffer) {
            boolean isTag = buffer.readBoolean();
            if (isTag) {
                ResourceLocation tagId = buffer.func_192575_l();
                int amount = buffer.readInt();
                Tag tag = FluidTags.getCollection().func_199910_a(tagId);
                if (tag == null) {
                    throw new JsonSyntaxException("Failed to read fluid tag from buffer");
                }
                return new FluidIngredient(FluidTags.getCollection().func_199910_a(tagId), amount);
            }
            FluidStack stack = buffer.readFluidStack();
            if (stack.isEmpty()) {
                throw new JsonSyntaxException("Failed to read fluidstack from buffer");
            }
            return new FluidIngredient(stack);
        }

        public FluidIngredient parse(JsonObject json) {
            int amount = JSONUtils.func_151208_a((JsonObject)json, (String)"amount", (int)1000);
            if (json.has("tag")) {
                ResourceLocation rl = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"tag"));
                Tag tag = FluidTags.getCollection().func_199910_a(rl);
                if (tag == null) {
                    throw new JsonSyntaxException("Unknown fluid tag '" + rl + "'");
                }
                return new FluidIngredient(tag, amount);
            }
            if (json.has("fluid")) {
                ResourceLocation fluidName = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"fluid"));
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidName);
                if (fluid == null || fluid == Fluids.field_204541_a) {
                    throw new JsonSyntaxException("Unknown fluid '" + fluidName + "'");
                }
                return new FluidIngredient(fluid, amount);
            }
            throw new JsonSyntaxException("fluid ingredient must have 'fluid' or 'tag' field!");
        }

        public void write(PacketBuffer buffer, FluidIngredient ingredient) {
            if (ingredient.tagId == null) {
                buffer.writeBoolean(false);
                buffer.writeFluidStack(new FluidStack((Fluid)ingredient.fluids.get(0), ingredient.amount));
            } else {
                buffer.writeBoolean(true);
                buffer.func_192572_a(ingredient.tagId);
                buffer.writeInt(ingredient.amount);
            }
        }
    }
}

