/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class StackedIngredient
extends Ingredient {
    public static final StackedIngredient EMPTY = new StackedIngredient(Stream.empty());

    private StackedIngredient(Stream<? extends Ingredient.IItemList> itemLists) {
        super(itemLists);
    }

    public static Ingredient fromTag(Tag<Item> tag, int count) {
        return StackedIngredient.fromItemListStream(Stream.of(new TagListStacked(tag, count)));
    }

    public static Ingredient fromStacks(ItemStack ... stacks) {
        return StackedIngredient.fromItemListStream(Arrays.stream(stacks).map(Ingredient.SingleItemList::new));
    }

    public static Ingredient fromItems(int count, IItemProvider ... itemsIn) {
        return StackedIngredient.fromItemListStream(Arrays.stream(itemsIn).map(itemProvider -> new Ingredient.SingleItemList(new ItemStack(itemProvider, count))));
    }

    public static StackedIngredient fromItemListStream(Stream<? extends Ingredient.IItemList> stream) {
        StackedIngredient ingredient = new StackedIngredient(stream);
        return ingredient.func_203189_d() ? EMPTY : ingredient;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public boolean test(@Nullable ItemStack checkingStack) {
        if (checkingStack == null || checkingStack.func_190926_b()) {
            return super.test(checkingStack);
        }
        for (ItemStack stack : this.func_193365_a()) {
            if (stack.func_77973_b() != checkingStack.func_77973_b() || stack.func_190916_E() > checkingStack.func_190916_E()) continue;
            return true;
        }
        return false;
    }

    private static Ingredient.IItemList deserializeItemListWithCount(JsonObject json) {
        if (json.has("item") && json.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
        }
        if (json.has("item")) {
            ResourceLocation resourcelocation1 = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"item"));
            Item item = (Item)Registry.field_212630_s.func_218349_b(resourcelocation1).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + resourcelocation1 + "'"));
            int count = json.has("count") ? JSONUtils.func_151203_m((JsonObject)json, (String)"count") : 1;
            return new Ingredient.SingleItemList(new ItemStack((IItemProvider)item, count));
        }
        if (json.has("tag")) {
            ResourceLocation resourcelocation = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"tag"));
            Tag tag = ItemTags.func_199903_a().func_199910_a(resourcelocation);
            if (tag == null) {
                throw new JsonSyntaxException("Unknown item tag '" + resourcelocation + "'");
            }
            int count = json.has("count") ? JSONUtils.func_151203_m((JsonObject)json, (String)"count") : 1;
            return new TagListStacked((Tag<Item>)tag, count);
        }
        throw new JsonParseException("An ingredient entry needs either a tag or an item");
    }

    public static class TagListStacked
    implements Ingredient.IItemList {
        private final Tag<Item> tag;
        private final int count;

        public TagListStacked(Tag<Item> tagIn, int count) {
            this.tag = tagIn;
            this.count = count;
        }

        public Collection<ItemStack> func_199799_a() {
            ArrayList list = Lists.newArrayList();
            for (Item item : this.tag.func_199885_a()) {
                list.add(new ItemStack((IItemProvider)item, this.count));
            }
            if (list.size() == 0 && !((Boolean)ForgeConfig.SERVER.treatEmptyTagsAsAir.get()).booleanValue()) {
                list.add(new ItemStack((IItemProvider)Blocks.field_180401_cv).func_200302_a((ITextComponent)new StringTextComponent("Empty Tag: " + this.tag.func_199886_b().toString())));
            }
            return list;
        }

        public JsonObject func_200303_b() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("tag", this.tag.func_199886_b().toString());
            return jsonobject;
        }
    }

    public static class Serializer
    implements IIngredientSerializer<StackedIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("pneumaticcraft:stacked_item");

        public StackedIngredient parse(PacketBuffer buffer) {
            return StackedIngredient.fromItemListStream(Stream.generate(() -> new Ingredient.SingleItemList(buffer.func_150791_c())).limit(buffer.func_150792_a()));
        }

        public StackedIngredient parse(JsonObject json) {
            return StackedIngredient.fromItemListStream(Stream.of(StackedIngredient.deserializeItemListWithCount(json)));
        }

        public void write(PacketBuffer buffer, StackedIngredient ingredient) {
            ItemStack[] items = ingredient.func_193365_a();
            buffer.func_150787_b(items.length);
            for (ItemStack stack : items) {
                buffer.func_150788_a(stack);
            }
        }
    }
}

