/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting;

import org.apache.commons.lang3.Validate;

public class TemperatureRange {
    private static TemperatureRange INVALID = new TemperatureRange(0, 1){

        @Override
        public boolean inRange(int temp) {
            return false;
        }

        @Override
        public boolean inRange(double temp) {
            return false;
        }
    };
    private static TemperatureRange ANY = new TemperatureRange(0, Integer.MAX_VALUE);
    private final int min;
    private final int max;

    private TemperatureRange(int min, int max) {
        Validate.isTrue((min >= 0 && max >= 0 ? 1 : 0) != 0, (String)"negative temperatures are not accepted!", (Object[])new Object[0]);
        Validate.isTrue((min < max ? 1 : 0) != 0, (String)"min temp must be < max temp!", (Object[])new Object[0]);
        this.min = min;
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public static TemperatureRange of(int minTemp, int maxTemp) {
        return new TemperatureRange(minTemp, maxTemp);
    }

    public static TemperatureRange any() {
        return ANY;
    }

    public static TemperatureRange min(int minTemp) {
        return new TemperatureRange(minTemp, Integer.MAX_VALUE);
    }

    public static TemperatureRange max(int maxTemp) {
        return new TemperatureRange(0, maxTemp);
    }

    public boolean inRange(int temp) {
        return temp >= this.min && temp <= this.max;
    }

    public boolean inRange(double temp) {
        return (int)temp >= this.min && (int)temp <= this.max;
    }

    public static TemperatureRange invalid() {
        return INVALID;
    }

    public boolean isAny() {
        return this == ANY;
    }
}

