/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting.recipe;

import me.desht.pneumaticcraft.api.crafting.FluidIngredient;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.recipe.IModRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;

public interface IThermopneumaticProcessingPlantRecipe
extends IModRecipe {
    public boolean matches(FluidStack var1, ItemStack var2);

    public TemperatureRange getOperatingTemperature();

    public float getRequiredPressure();

    default public double heatUsed(double ambientTemperature) {
        TemperatureRange range = this.getOperatingTemperature();
        if (range.isAny()) {
            return 0.0;
        }
        double used = (double)range.getMin() > ambientTemperature ? ((double)range.getMin() - ambientTemperature) / 10.0 : ((double)range.getMax() < ambientTemperature ? (ambientTemperature - (double)range.getMax()) / 10.0 : (this.isExothermic() ? ((double)range.getMax() - ambientTemperature) / 10.0 : (ambientTemperature - (double)range.getMin()) / 10.0));
        return this.isExothermic() ? -used : used;
    }

    default public int airUsed() {
        return (int)(50.0f * this.getRequiredPressure());
    }

    public Ingredient getInputItem();

    public FluidIngredient getInputFluid();

    public FluidStack getOutputFluid();

    public ItemStack getOutputItem();

    public boolean isExothermic();
}

