/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraftCamo;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.IHeatTinted;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pneumaticcraft", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ColorHandlers {
    @SubscribeEvent
    public static void registerItemColorHandlers(ColorHandlerEvent.Item event) {
        for (RegistryObject item : ModItems.ITEMS.getEntries()) {
            Block b;
            if (item.get() instanceof ITintableItem) {
                event.getItemColors().func_199877_a(((ITintableItem)item.get())::getTintColor, new IItemProvider[]{(IItemProvider)item.get()});
                continue;
            }
            if (!(item.get() instanceof BlockItem) || !((b = ((BlockItem)item.get()).func_179223_d()) instanceof ITintableBlock)) continue;
            event.getItemColors().func_199877_a((stack, index) -> event.getBlockColors().func_216860_a(b.func_176223_P(), null, null, index), new IItemProvider[]{(IItemProvider)item.get()});
        }
    }

    @SubscribeEvent
    public static void registerBlockColorHandlers(ColorHandlerEvent.Block event) {
        for (RegistryObject block : ModBlocks.BLOCKS.getEntries()) {
            if (block.get() instanceof ITintableBlock) {
                event.getBlockColors().func_186722_a(((ITintableBlock)block.get())::getTintColor, new Block[]{(Block)block.get()});
                continue;
            }
            if (!(block.get() instanceof BlockPneumaticCraftCamo)) continue;
            event.getBlockColors().func_186722_a((state, blockAccess, pos, tintIndex) -> {
                TileEntity te;
                if (blockAccess != null && pos != null && (te = blockAccess.func_175625_s(pos)) instanceof ICamouflageableTE && ((ICamouflageableTE)te).getCamouflage() != null) {
                    return event.getBlockColors().func_216860_a(((ICamouflageableTE)te).getCamouflage(), (IEnviromentBlockReader)te.func_145831_w(), pos, tintIndex);
                }
                return -1;
            }, new Block[]{(Block)block.get()});
        }
    }

    public static int desaturate(int c) {
        float[] hsb = TintColor.RGBtoHSB((c & 0xFF0000) >> 16, (c & 0xFF00) >> 8, c & 0xFF, null);
        TintColor color = TintColor.getHSBColor(hsb[0], hsb[1] * 0.4f, hsb[2]);
        if ((double)hsb[2] < 0.7) {
            color = color.brighter();
        }
        return color.getRGB();
    }

    public static interface IHeatTintable
    extends ITintableBlock {
        @Override
        default public int getTintColor(BlockState state, @Nullable IEnviromentBlockReader world, @Nullable BlockPos pos, int tintIndex) {
            if (world != null && pos != null) {
                TileEntity te = world.func_175625_s(pos);
                TintColor tint = te instanceof IHeatTinted ? ((IHeatTinted)te).getColorForTintIndex(tintIndex) : TintColor.WHITE;
                return tint.getRGB();
            }
            return -1;
        }
    }

    public static interface ITintableBlock {
        public int getTintColor(BlockState var1, @Nullable IEnviromentBlockReader var2, @Nullable BlockPos var3, int var4);
    }

    public static interface ITintableItem {
        public int getTintColor(ItemStack var1, int var2);
    }
}

