/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.event;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.item.IInventoryItem;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.api.item.IUpgradeAcceptor;
import me.desht.pneumaticcraft.client.gui.IGuiDrone;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.core.ModRegistries;
import me.desht.pneumaticcraft.common.item.ICustomTooltipName;
import me.desht.pneumaticcraft.common.item.ItemMicromissiles;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BucketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(modid="pneumaticcraft", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TooltipEventHandler {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof BucketItem) {
            TooltipEventHandler.handleFluidContainerTooltip(event);
        } else if (stack.func_77973_b().getRegistryName().func_110624_b().equals("pneumaticcraft")) {
            TooltipEventHandler.addStandardTooltip(stack, event.getToolTip(), event.getFlags());
        }
        if (stack.func_77973_b() instanceof IProgrammable) {
            TooltipEventHandler.handleProgrammableTooltip(event);
        }
    }

    private static void addStandardTooltip(ItemStack stack, List<ITextComponent> curInfo, ITooltipFlag flagIn) {
        String key;
        TooltipEventHandler.addPressureTooltip(stack, curInfo);
        if (stack.func_77973_b() instanceof IUpgradeAcceptor) {
            UpgradableItemUtils.addUpgradeInformation(stack, curInfo, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
        }
        if (stack.func_77973_b() instanceof IInventoryItem) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            IInventoryItem item = (IInventoryItem)stack.func_77973_b();
            item.getStacksInItem(stack, stacks);
            if (item.getInventoryHeader() != null && !stacks.isEmpty()) {
                curInfo.add(item.getInventoryHeader());
            }
            PneumaticCraftUtils.sortCombineItemStacksAndToString(curInfo, stacks.toArray(new ItemStack[0]), item.getTooltipPrefix(stack));
        }
        if (I18n.func_188566_a((String)(key = ICustomTooltipName.getTranslationKey(stack)))) {
            if (ClientUtils.hasShiftDown()) {
                String translatedInfo = TextFormatting.AQUA + I18n.func_135052_a((String)key, (Object[])new Object[0]);
                curInfo.addAll(PneumaticCraftUtils.asStringComponent(PneumaticCraftUtils.splitString(translatedInfo, 50)));
                if (!ThirdPartyManager.instance().docsProvider.docsProviderInstalled()) {
                    curInfo.add(PneumaticCraftUtils.xlate("gui.tab.info.assistIGW", new Object[0]));
                }
            } else {
                curInfo.add(PneumaticCraftUtils.xlate("gui.tooltip.sneakForInfo", new Object[0]).func_211708_a(TextFormatting.AQUA));
            }
        }
    }

    private static void addPressureTooltip(ItemStack stack, List<ITextComponent> textList) {
        stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(airHandler -> {
            float f = airHandler.getPressure() / airHandler.maxPressure();
            TextFormatting color = f < 0.1f ? TextFormatting.RED : (f < 0.5f ? TextFormatting.GOLD : TextFormatting.DARK_GREEN);
            textList.add(PneumaticCraftUtils.xlate("gui.tooltip.pressure", PneumaticCraftUtils.roundNumberTo(airHandler.getPressure(), 1)).func_211708_a(color));
        });
    }

    private static void handleProgrammableTooltip(ItemTooltipEvent event) {
        IProgrammable programmable = (IProgrammable)event.getItemStack().func_77973_b();
        if (programmable.canProgram(event.getItemStack()) && programmable.showProgramTooltip()) {
            boolean hasInvalidPrograms = false;
            ArrayList<ITextComponent> addedEntries = new ArrayList<ITextComponent>();
            List<IProgWidget> widgets = TileEntityProgrammer.getProgWidgets(event.getItemStack());
            Map<ResourceLocation, Integer> widgetMap = TooltipEventHandler.getPuzzleSummary(widgets);
            for (Map.Entry<ResourceLocation, Integer> entry : widgetMap.entrySet()) {
                TextFormatting[] prefix = new TextFormatting[]{};
                ProgWidgetType widgetType = (ProgWidgetType)ModRegistries.PROG_WIDGETS.getValue(entry.getKey());
                Screen curScreen = Minecraft.func_71410_x().field_71462_r;
                if (curScreen instanceof IGuiDrone && !((IGuiDrone)curScreen).getDrone().isProgramApplicable(widgetType)) {
                    prefix = new TextFormatting[]{TextFormatting.RED, TextFormatting.ITALIC};
                    hasInvalidPrograms = true;
                }
                addedEntries.add(new StringTextComponent("\u2022 " + entry.getValue() + " x ").func_150257_a(PneumaticCraftUtils.xlate(widgetType.getTranslationKey(), new Object[0])).func_211709_a(prefix));
            }
            if (hasInvalidPrograms) {
                event.getToolTip().add(PneumaticCraftUtils.xlate("gui.tooltip.programmable.invalidPieces", new Object[0]).func_211708_a(TextFormatting.RED));
            }
            addedEntries.sort(Comparator.comparing(ITextComponent::func_150254_d));
            event.getToolTip().addAll(addedEntries);
            if (ClientUtils.hasShiftDown() && !widgets.isEmpty()) {
                event.getToolTip().add(PneumaticCraftUtils.xlate("gui.tooltip.programmable.requiredPieces", widgets.size()).func_211709_a(new TextFormatting[]{TextFormatting.GREEN}));
            }
        }
    }

    private static void handleFluidContainerTooltip(ItemTooltipEvent event) {
        FluidUtil.getFluidContained((ItemStack)event.getItemStack()).ifPresent(fluidStack -> {
            String fluidName = fluidStack.getFluid().getRegistryName().toString().replace(':', '.');
            String key = "gui.tooltip.item." + fluidName;
            if (I18n.func_188566_a((String)key)) {
                if (Screen.hasShiftDown()) {
                    PneumaticCraftUtils.splitString(I18n.func_135052_a((String)key, (Object[])new Object[0]), 45).forEach(s -> event.getToolTip().add(new StringTextComponent(s).func_211708_a(TextFormatting.AQUA)));
                } else {
                    event.getToolTip().add(PneumaticCraftUtils.xlate("gui.tooltip.sneakForInfo", new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.AQUA}));
                }
            }
        });
    }

    private static Map<ResourceLocation, Integer> getPuzzleSummary(List<IProgWidget> widgets) {
        HashMap<ResourceLocation, Integer> map = new HashMap<ResourceLocation, Integer>();
        for (IProgWidget widget : widgets) {
            map.put(widget.getTypeID(), map.getOrDefault(widget.getTypeID(), 0) + 1);
        }
        return map;
    }

    @SubscribeEvent
    public static void renderTooltipEvent(RenderTooltipEvent.PostText event) {
        ItemStack stack = event.getStack();
        if (stack.func_77973_b() instanceof ItemMicromissiles && stack.func_77942_o()) {
            int width = 0;
            FontRenderer fr = event.getFontRenderer();
            int n = event.getY();
            fr.getClass();
            int y = n + 9 * 2 + 5;
            width = Math.max(width, TooltipEventHandler.renderString(fr, I18n.func_135052_a((String)"gui.micromissile.topSpeed", (Object[])new Object[0]), event.getX(), y));
            String string = I18n.func_135052_a((String)"gui.micromissile.turnSpeed", (Object[])new Object[0]);
            int n2 = event.getX();
            fr.getClass();
            width = Math.max(width, TooltipEventHandler.renderString(fr, string, n2, y + 9));
            String string2 = I18n.func_135052_a((String)"gui.micromissile.damage", (Object[])new Object[0]);
            int n3 = event.getX();
            fr.getClass();
            width = Math.max(width, TooltipEventHandler.renderString(fr, string2, n3, y + 9 * 2));
            int barX = event.getX() + width + 2;
            int barW = event.getWidth() - width - 10;
            GlStateManager.disableTexture();
            GlStateManager.lineWidth((float)10.0f);
            GL11.glEnable((int)2852);
            GL11.glLineStipple((int)1, (short)-258);
            RenderUtils.glColorHex(49152, 255);
            GlStateManager.begin((int)1);
            GL11.glVertex2i((int)barX, (int)(y + 4));
            GL11.glVertex2i((int)(barX + (int)((float)barW * NBTUtil.getFloat(stack, "topSpeed"))), (int)(y + 4));
            GlStateManager.end();
            GlStateManager.begin((int)1);
            fr.getClass();
            GL11.glVertex2i((int)barX, (int)(y + 4 + 9));
            int n4 = barX + (int)((float)barW * NBTUtil.getFloat(stack, "turnSpeed"));
            fr.getClass();
            GL11.glVertex2i((int)n4, (int)(y + 4 + 9));
            GlStateManager.end();
            GlStateManager.begin((int)1);
            fr.getClass();
            GL11.glVertex2i((int)barX, (int)(y + 4 + 9 * 2));
            int n5 = barX + (int)((float)barW * NBTUtil.getFloat(stack, "damage"));
            fr.getClass();
            GL11.glVertex2i((int)n5, (int)(y + 4 + 9 * 2));
            GlStateManager.end();
            GlStateManager.lineWidth((float)1.0f);
            GL11.glDisable((int)2852);
        }
    }

    private static int renderString(FontRenderer fr, String s, int x, int y) {
        fr.func_175063_a(s, (float)x, (float)y, -5592406);
        return fr.func_78256_a(s);
    }
}

