/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.ContainerElevator;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElevatorBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiElevator
extends GuiPneumaticContainerBase<ContainerElevator, TileEntityElevatorBase> {
    private WidgetAnimatedStat statusStat;
    private WidgetAnimatedStat floorNameStat;
    private WidgetTextField floorNameField;
    private int currentEditedFloor;

    public GuiElevator(ContainerElevator container, PlayerInventory inventoryPlayer, ITextComponent displayName) {
        super(container, inventoryPlayer, displayName);
    }

    @Override
    public void init() {
        super.init();
        this.statusStat = this.addAnimatedStat(I18n.func_135052_a((String)"gui.tab.status", (Object[])new Object[0]), new ItemStack((IItemProvider)ModBlocks.ELEVATOR_BASE.get()), -22016, false);
        this.floorNameStat = this.addAnimatedStat(I18n.func_135052_a((String)"gui.tab.info.elevator.floorNames", (Object[])new Object[0]), new ItemStack((IItemProvider)ModBlocks.ELEVATOR_CALLER.get()), -16755456, false);
        this.floorNameStat.setTextWithoutCuttingString(this.getFloorNameStat());
        Rectangle2d fieldRectangle = this.floorNameStat.getButtonScaledRectangle(6, 60, 160, 20);
        this.floorNameField = this.getTextFieldFromRectangle(fieldRectangle);
        this.floorNameField.func_146180_a(((TileEntityElevatorBase)this.te).getFloorName(this.currentEditedFloor));
        this.floorNameField.func_212954_a(this::updateFloor);
        this.floorNameStat.addSubWidget((Widget)this.floorNameField);
        Rectangle2d prev = this.floorNameStat.getButtonScaledRectangle(5, 35, 20, 20);
        this.floorNameStat.addSubWidget((Widget)this.getButtonFromRectangle("", prev, "\u27f5", button -> this.cycleFloor(-1)));
        Rectangle2d next = this.floorNameStat.getButtonScaledRectangle(145, 35, 20, 20);
        this.floorNameStat.addSubWidget((Widget)this.getButtonFromRectangle("", next, "\u27f6", button -> this.cycleFloor(1)));
    }

    private void cycleFloor(int dir) {
        if (((TileEntityElevatorBase)this.te).floorHeights.length > 0) {
            this.currentEditedFloor += dir;
            if (this.currentEditedFloor >= ((TileEntityElevatorBase)this.te).floorHeights.length) {
                this.currentEditedFloor = 0;
            } else if (this.currentEditedFloor < 0) {
                this.currentEditedFloor = ((TileEntityElevatorBase)this.te).floorHeights.length - 1;
            }
            this.floorNameField.func_146180_a(((TileEntityElevatorBase)this.te).getFloorName(this.currentEditedFloor));
            this.floorNameField.func_146195_b(true);
            this.floorNameStat.setTextWithoutCuttingString(this.getFloorNameStat());
        }
    }

    private void updateFloor(String floorName) {
        this.sendDelayed(5);
        ((TileEntityElevatorBase)this.te).setFloorName(this.currentEditedFloor, floorName);
    }

    @Override
    protected void doDelayedAction() {
        NetworkHandler.sendToServer(new PacketUpdateTextfield(this.te, this.currentEditedFloor));
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_ELEVATOR;
    }

    @Override
    protected void func_146976_a(float opacity, int x, int y) {
        super.func_146976_a(opacity, x, y);
    }

    @Override
    public void tick() {
        super.tick();
        this.statusStat.setText(this.getStatusText());
    }

    private List<String> getFloorNameStat() {
        int i;
        ArrayList<String> textList = new ArrayList<String>();
        for (i = 0; i < 3; ++i) {
            textList.add("");
        }
        textList.add(TextFormatting.GRAY + "         Floor " + (this.currentEditedFloor + 1) + "                   ");
        for (i = 0; i < 3; ++i) {
            textList.add("");
        }
        return textList;
    }

    private List<String> getStatusText() {
        ArrayList<String> text = new ArrayList<String>();
        text.add(TextFormatting.BLACK + I18n.func_135052_a((String)"gui.tab.info.elevator.extension", (Object[])new Object[]{PneumaticCraftUtils.roundNumberTo(((TileEntityElevatorBase)this.te).extension, 1)}));
        text.add(TextFormatting.BLACK + I18n.func_135052_a((String)"gui.tab.info.elevator.maxExtension", (Object[])new Object[]{PneumaticCraftUtils.roundNumberTo(((TileEntityElevatorBase)this.te).getMaxElevatorHeight(), 1)}));
        return text;
    }

    @Override
    protected void addWarnings(List<String> textList) {
        super.addWarnings(textList);
        if (((TileEntityElevatorBase)this.te).getMaxElevatorHeight() == ((TileEntityElevatorBase)this.te).extension) {
            textList.add(I18n.func_135052_a((String)"gui.tab.problems.elevator.fully_extended", (Object[])new Object[0]));
        }
    }
}

