/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Arrays;
import me.desht.pneumaticcraft.client.gui.widget.ITickableWidget;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.text.WordUtils;

public abstract class GuiPneumaticScreenBase
extends Screen {
    public int guiLeft;
    public int guiTop;
    public int xSize;
    public int ySize;

    public GuiPneumaticScreenBase(ITextComponent title) {
        super(title);
    }

    public void init() {
        super.init();
        this.guiLeft = this.width / 2 - this.xSize / 2;
        this.guiTop = this.height / 2 - this.ySize / 2;
    }

    protected abstract ResourceLocation getTexture();

    protected WidgetLabel addLabel(String text, int x, int y) {
        return this.addLabel(text, x, y, WidgetLabel.Alignment.LEFT);
    }

    protected WidgetLabel addLabel(String text, int x, int y, WidgetLabel.Alignment alignment) {
        return (WidgetLabel)this.addButton(new WidgetLabel(x, y, text).setAlignment(alignment));
    }

    protected void removeWidget(Widget widget) {
        this.buttons.remove(widget);
        this.children.remove(widget);
    }

    public void tick() {
        super.tick();
        this.buttons.stream().filter(w -> w instanceof ITickableWidget).forEach(w -> ((ITickableWidget)w).tickWidget());
    }

    public void render(int x, int y, float partialTicks) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.getTexture() != null) {
            this.minecraft.func_110434_K().func_110577_a(this.getTexture());
            this.blit(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        }
        super.render(x, y, partialTicks);
        GlStateManager.enableTexture();
        GlStateManager.color4f((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
        ArrayList<String> tooltip = new ArrayList<String>();
        boolean shift = Screen.hasShiftDown();
        for (Widget widget : this.buttons) {
            if (!(widget instanceof ITooltipProvider) || !widget.isHovered()) continue;
            ((ITooltipProvider)widget).addTooltip(x, y, tooltip, shift);
        }
        if (!tooltip.isEmpty()) {
            ArrayList<String> localizedTooltip = new ArrayList<String>();
            for (String line : tooltip) {
                String localizedLine = I18n.func_135052_a((String)line, (Object[])new Object[0]);
                for (String wrappedLine : localizedLine.split("\\\\n")) {
                    String[] lines = WordUtils.wrap((String)wrappedLine, (int)50).split(System.getProperty("line.separator"));
                    localizedTooltip.addAll(Arrays.asList(lines));
                }
            }
            this.renderTooltip(localizedTooltip, x, y, this.font);
            RenderHelper.func_74520_c();
        }
        GlStateManager.color4f((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
    }
}

