/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.GuiPastebin;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.GuiUnitProgrammer;
import me.desht.pneumaticcraft.client.gui.programmer.GuiProgWidgetOptionBase;
import me.desht.pneumaticcraft.client.gui.programmer.ProgWidgetGuiManager;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetRadioButton;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.inventory.ContainerProgrammer;
import me.desht.pneumaticcraft.common.item.ItemGPSAreaTool;
import me.desht.pneumaticcraft.common.item.ItemGPSTool;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.network.PacketProgrammerUpdate;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCoordinate;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCoordinateOperator;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetStart;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiProgrammer
extends GuiPneumaticContainerBase<ContainerProgrammer, TileEntityProgrammer> {
    private GuiPastebin pastebinGui;
    private WidgetButtonExtended importButton;
    private WidgetButtonExtended exportButton;
    private WidgetButtonExtended allWidgetsButton;
    private List<WidgetRadioButton> difficultyButtons;
    private WidgetCheckBox showInfo;
    private WidgetCheckBox showFlow;
    private WidgetTextField nameField;
    private WidgetTextField filterField;
    private WidgetButtonExtended undoButton;
    private WidgetButtonExtended redoButton;
    private WidgetButtonExtended convertToRelativeButton;
    private final List<IProgWidget> visibleSpawnWidgets = new ArrayList<IProgWidget>();
    private final List<RemovingWidget> removingWidgets = new ArrayList<RemovingWidget>();
    private BitSet filteredSpawnWidgets;
    private GuiUnitProgrammer programmerUnit;
    private IProgWidget draggingWidget;
    private int lastMouseX;
    private int lastMouseY;
    private double dragMouseStartX;
    private double dragMouseStartY;
    private double dragWidgetStartX;
    private double dragWidgetStartY;
    private boolean draggingBG;
    private static final int FAULT_MARGIN = 4;
    private int widgetPage;
    private int maxPage;
    private boolean showingAllWidgets;
    private int showingWidgetProgress;
    private int oldShowingWidgetProgress;
    private static final Rectangle2d PROGRAMMER_STD_RES = new Rectangle2d(5, 17, 294, 154);
    private static final Rectangle2d PROGRAMMER_HI_RES = new Rectangle2d(5, 17, 644, 410);
    private static final int WIDGET_X_SPACING = 22;
    private boolean hiRes;

    public GuiProgrammer(ContainerProgrammer container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.hiRes = container.isHiRes();
        this.field_146999_f = this.hiRes ? 700 : 350;
        this.field_147000_g = this.hiRes ? 512 : 256;
    }

    @Override
    public void init() {
        super.init();
        if (this.pastebinGui != null && this.pastebinGui.outputTag != null) {
            if (this.pastebinGui.shouldMerge) {
                List<IProgWidget> newWidgets = ((TileEntityProgrammer)this.te).mergeWidgetsFromNBT(this.pastebinGui.outputTag);
                TileEntityProgrammer.updatePuzzleConnections(newWidgets);
                ((TileEntityProgrammer)this.te).setProgWidgets(newWidgets, ClientUtils.getClientPlayer());
            } else {
                ((TileEntityProgrammer)this.te).readProgWidgetsFromNBT(this.pastebinGui.outputTag);
            }
            this.pastebinGui = null;
            NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
            ((TileEntityProgrammer)this.te).recentreStartPiece = true;
        }
        if (this.programmerUnit != null) {
            ((TileEntityProgrammer)this.te).translatedX = this.programmerUnit.getTranslatedX();
            ((TileEntityProgrammer)this.te).translatedY = this.programmerUnit.getTranslatedY();
            ((TileEntityProgrammer)this.te).zoomState = this.programmerUnit.getLastZoom();
        }
        Rectangle2d bounds = this.getProgrammerBounds();
        this.programmerUnit = new GuiUnitProgrammer(((TileEntityProgrammer)this.te).progWidgets, this.font, this.field_147003_i, this.field_147009_r, this.width, this.height, bounds, ((TileEntityProgrammer)this.te).translatedX, ((TileEntityProgrammer)this.te).translatedY, ((TileEntityProgrammer)this.te).zoomState);
        this.addButton(this.programmerUnit.getScrollBar());
        int xStart = (this.width - this.field_146999_f) / 2;
        int yStart = (this.height - this.field_147000_g) / 2;
        int xRight = this.getProgrammerBounds().func_199318_a() + this.getProgrammerBounds().func_199316_c();
        int yBottom = this.getProgrammerBounds().func_199319_b() + this.getProgrammerBounds().func_199317_d() + 3;
        this.importButton = new WidgetButtonExtended(xStart + xRight + 2, yStart + 3, 20, 15, "\u27f5").withTag("import");
        this.importButton.setTooltipText(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)"gui.programmer.button.import", (Object[])new Object[0]), 40));
        this.addButton((Widget)this.importButton);
        this.exportButton = new WidgetButtonExtended(xStart + xRight + 2, yStart + 20, 20, 15, "\u27f6").withTag("export");
        this.addButton((Widget)this.exportButton);
        this.addButton((Widget)new WidgetButtonExtended(xStart + xRight - 3, yStart + yBottom, 13, 10, "\u25c0", b -> this.adjustPage(-1)));
        this.addButton((Widget)new WidgetButtonExtended(xStart + xRight + 34, yStart + yBottom, 13, 10, "\u25b6", b -> this.adjustPage(1)));
        this.allWidgetsButton = new WidgetButtonExtended(xStart + xRight + 22, yStart + yBottom - 16, 10, 10, "\u25e4", b -> this.toggleShowWidgets());
        this.allWidgetsButton.setTooltipText(I18n.func_135052_a((String)"gui.programmer.button.openPanel.tooltip", (Object[])new Object[0]));
        this.addButton((Widget)this.allWidgetsButton);
        this.difficultyButtons = new ArrayList<WidgetRadioButton>();
        for (IProgWidget.WidgetDifficulty difficulty : IProgWidget.WidgetDifficulty.values()) {
            DifficultyButton dButton = new DifficultyButton(xStart + xRight - 36, yStart + yBottom + 29 + difficulty.ordinal() * 12, -12566464, difficulty, b -> this.updateDifficulty(difficulty));
            dButton.checked = difficulty == PNCConfig.Client.programmerDifficulty;
            this.addButton(dButton);
            this.difficultyButtons.add(dButton);
            dButton.otherChoices = this.difficultyButtons;
            dButton.setTooltip("gui.programmer.difficulty." + difficulty.toString().toLowerCase() + ".tooltip");
        }
        this.addButton((Widget)new WidgetButtonExtended(xStart + 5, yStart + yBottom + 4, 87, 20, I18n.func_135052_a((String)"gui.programmer.button.showStart", (Object[])new Object[0]), b -> this.gotoStart()).setTooltipText(I18n.func_135052_a((String)"gui.programmer.button.showStart.tooltip", (Object[])new Object[0])));
        this.addButton((Widget)new WidgetButtonExtended(xStart + 5, yStart + yBottom + 26, 87, 20, I18n.func_135052_a((String)"gui.programmer.button.showLatest", (Object[])new Object[0]), b -> this.gotoLatest()).setTooltipText(I18n.func_135052_a((String)"gui.programmer.button.showLatest.tooltip", (Object[])new Object[0])));
        this.showInfo = new WidgetCheckBox(xStart + 5, yStart + yBottom + 49, -12566464, "gui.programmer.checkbox.showInfo").setChecked(((TileEntityProgrammer)this.te).showInfo);
        this.addButton(this.showInfo);
        this.showFlow = new WidgetCheckBox(xStart + 5, yStart + yBottom + 61, -12566464, "gui.programmer.checkbox.showFlow").setChecked(((TileEntityProgrammer)this.te).showFlow);
        this.addButton(this.showFlow);
        WidgetButtonExtended pastebinButton = new WidgetButtonExtended(this.field_147003_i - 24, this.field_147009_r + 44, 20, 20, "", b -> this.pastebin());
        pastebinButton.setTooltipText(I18n.func_135052_a((String)"gui.remote.button.pastebinButton", (Object[])new Object[0]));
        pastebinButton.setRenderedIcon(Textures.GUI_PASTEBIN_ICON_LOCATION);
        this.addButton((Widget)pastebinButton);
        this.undoButton = new WidgetButtonExtended(this.field_147003_i - 24, this.field_147009_r + 2, 20, 20, "").withTag("undo");
        this.redoButton = new WidgetButtonExtended(this.field_147003_i - 24, this.field_147009_r + 23, 20, 20, "").withTag("redo");
        WidgetButtonExtended clearAllButton = new WidgetButtonExtended(this.field_147003_i - 24, this.field_147009_r + 65, 20, 20, "", b -> this.clear());
        this.convertToRelativeButton = new WidgetButtonExtended(this.field_147003_i - 24, this.field_147009_r + 86, 20, 20, "Rel", b -> this.convertToRelative());
        this.undoButton.setRenderedIcon(Textures.GUI_UNDO_ICON_LOCATION);
        this.redoButton.setRenderedIcon(Textures.GUI_REDO_ICON_LOCATION);
        clearAllButton.setRenderedIcon(Textures.GUI_DELETE_ICON_LOCATION);
        this.undoButton.setTooltipText(I18n.func_135052_a((String)"gui.programmer.button.undoButton.tooltip", (Object[])new Object[0]));
        this.redoButton.setTooltipText(I18n.func_135052_a((String)"gui.programmer.button.redoButton.tooltip", (Object[])new Object[0]));
        clearAllButton.setTooltipText(I18n.func_135052_a((String)"gui.programmer.button.clearAllButton.tooltip", (Object[])new Object[0]));
        this.addButton((Widget)this.undoButton);
        this.addButton((Widget)this.redoButton);
        this.addButton((Widget)clearAllButton);
        this.addButton((Widget)this.convertToRelativeButton);
        this.addLabel(this.title.func_150254_d(), this.field_147003_i + 7, this.field_147009_r + 5, -12566464);
        this.font.getClass();
        this.nameField = new WidgetTextField(this.font, this.field_147003_i + xRight - 99, this.field_147009_r + 5, 98, 9);
        this.nameField.func_212954_a(s -> this.updateDroneName());
        this.addButton((Widget)this.nameField);
        this.font.getClass();
        this.filterField = new FilterTextField(this.font, this.field_147003_i + 78, this.field_147009_r + 26, 100, 9);
        this.filterField.func_212954_a(s -> this.filterSpawnWidgets());
        this.addButton((Widget)this.filterField);
        String name = I18n.func_135052_a((String)"gui.programmer.name", (Object[])new Object[0]);
        this.addLabel(name, this.field_147003_i + xRight - 102 - this.font.func_78256_a(name), this.field_147009_r + 5, -12566464);
        this.updateVisibleProgWidgets();
        for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
            if (this.programmerUnit.isOutsideProgrammingArea(widget)) continue;
            return;
        }
        this.programmerUnit.gotoPiece(GuiProgrammer.findWidget(((TileEntityProgrammer)this.te).progWidgets, ProgWidgetStart.class));
    }

    public static void onCloseFromContainer() {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiProgrammer) {
            GuiProgrammer p = (GuiProgrammer)Minecraft.func_71410_x().field_71462_r;
            p.onClose();
        }
    }

    private Rectangle2d getProgrammerBounds() {
        return this.hiRes ? PROGRAMMER_HI_RES : PROGRAMMER_STD_RES;
    }

    private int getWidgetTrayRight() {
        return this.hiRes ? 672 : 322;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return this.hiRes ? Textures.GUI_PROGRAMMER_LARGE : Textures.GUI_PROGRAMMER_STD;
    }

    private void updateVisibleProgWidgets() {
        int i;
        int y = 0;
        int page = 0;
        int x = this.getWidgetTrayRight() - this.maxPage * 22;
        boolean showAllWidgets = this.showingWidgetProgress == 22 * this.maxPage && this.showingAllWidgets;
        this.filterField.func_146189_e(showAllWidgets);
        this.maxPage = 0;
        this.visibleSpawnWidgets.clear();
        int difficulty = 0;
        for (i = 0; i < this.difficultyButtons.size(); ++i) {
            if (!this.difficultyButtons.get((int)i).checked) continue;
            difficulty = i;
            break;
        }
        i = 0;
        for (Supplier<ProgWidgetType<?>> type : ModProgWidgets.WIDGET_LIST) {
            IProgWidget widget = IProgWidget.create(type.get());
            if (difficulty >= widget.getDifficulty().ordinal()) {
                widget.setY(y + 40);
                widget.setX(showAllWidgets ? x : this.getWidgetTrayRight());
                int widgetHeight = widget.getHeight() / 2 + (widget.hasStepOutput() ? 5 : 0) + 1;
                y += widgetHeight;
                if (showAllWidgets || page == this.widgetPage) {
                    this.visibleSpawnWidgets.add(widget);
                }
                if (y > this.field_147000_g - (this.hiRes ? 260 : 160)) {
                    y = 0;
                    x += 22;
                    ++page;
                    if (i < ModProgWidgets.WIDGET_LIST.size() - 1) {
                        ++this.maxPage;
                    }
                }
            }
            ++i;
        }
        ++this.maxPage;
        this.filterField.x = Math.min(this.field_147003_i + this.getWidgetTrayRight() - 25 - this.filterField.getWidth(), this.field_147003_i + this.getWidgetTrayRight() - this.maxPage * 22 - 2);
        this.filterSpawnWidgets();
        if (this.widgetPage >= this.maxPage) {
            this.widgetPage = this.maxPage - 1;
            this.updateVisibleProgWidgets();
        }
    }

    private void filterSpawnWidgets() {
        String filterText = this.filterField.func_146179_b().trim();
        if (!this.visibleSpawnWidgets.isEmpty() && !filterText.isEmpty()) {
            this.filteredSpawnWidgets = new BitSet(this.visibleSpawnWidgets.size());
            for (int i = 0; i < this.visibleSpawnWidgets.size(); ++i) {
                IProgWidget widget = this.visibleSpawnWidgets.get(i);
                String widgetName = I18n.func_135052_a((String)widget.getTranslationKey(), (Object[])new Object[0]);
                this.filteredSpawnWidgets.set(i, widgetName.toLowerCase().contains(filterText.toLowerCase()));
            }
        } else {
            this.filteredSpawnWidgets = null;
        }
    }

    @Override
    protected boolean shouldAddInfoTab() {
        return false;
    }

    private void updateDroneName() {
        ItemStack stack = ((TileEntityProgrammer)this.te).getItemInProgrammingSlot();
        if (stack != ItemStack.field_190927_a && !stack.func_200301_q().func_150261_e().equals(this.nameField.func_146179_b())) {
            stack.func_200302_a((ITextComponent)new StringTextComponent(this.nameField.func_146179_b()));
            this.sendDelayed(5);
        }
    }

    @Override
    protected void doDelayedAction() {
        NetworkHandler.sendToServer(new PacketUpdateTextfield(this.te, 0));
    }

    private void adjustPage(int dir) {
        this.widgetPage += dir;
        if (this.widgetPage < 0) {
            this.widgetPage = this.maxPage - 1;
        } else if (this.widgetPage >= this.maxPage) {
            this.widgetPage = 0;
        }
        this.updateVisibleProgWidgets();
    }

    private void toggleShowWidgets() {
        this.showingAllWidgets = !this.showingAllWidgets;
        this.allWidgetsButton.setMessage(this.showingAllWidgets ? "\u25e2" : "\u25e4");
        this.updateVisibleProgWidgets();
        this.filterField.func_146195_b(this.showingAllWidgets);
    }

    private void updateDifficulty(IProgWidget.WidgetDifficulty difficulty) {
        ConfigHelper.setProgrammerDifficulty(difficulty);
        if (this.showingAllWidgets) {
            this.toggleShowWidgets();
        }
        this.updateVisibleProgWidgets();
    }

    private void gotoLatest() {
        if (((TileEntityProgrammer)this.te).progWidgets.size() > 0) {
            this.programmerUnit.gotoPiece(((TileEntityProgrammer)this.te).progWidgets.get(((TileEntityProgrammer)this.te).progWidgets.size() - 1));
        }
    }

    private void gotoStart() {
        this.programmerUnit.gotoPiece(GuiProgrammer.findWidget(((TileEntityProgrammer)this.te).progWidgets, ProgWidgetStart.class));
    }

    private void pastebin() {
        CompoundNBT mainTag = ((TileEntityProgrammer)this.te).writeProgWidgetsToNBT(new CompoundNBT());
        this.pastebinGui = new GuiPastebin((Screen)this, mainTag);
        this.minecraft.func_147108_a((Screen)this.pastebinGui);
    }

    private void clear() {
        ((TileEntityProgrammer)this.te).progWidgets.forEach(w -> this.removingWidgets.add(new RemovingWidget((IProgWidget)w)));
        ((TileEntityProgrammer)this.te).progWidgets.clear();
        NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
    }

    private void convertToRelative() {
        for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
            if (!(widget instanceof ProgWidgetStart)) continue;
            this.generateRelativeOperators((ProgWidgetCoordinateOperator)widget.getOutputWidget(), null, false);
            break;
        }
    }

    @Override
    protected PointXY getInvNameOffset() {
        return null;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        int xRight = this.getProgrammerBounds().func_199318_a() + this.getProgrammerBounds().func_199316_c();
        int yBottom = this.getProgrammerBounds().func_199319_b() + this.getProgrammerBounds().func_199317_d();
        String str = this.widgetPage + 1 + "/" + this.maxPage;
        this.font.func_211126_b(str, (float)xRight + (22.0f - (float)this.font.func_78256_a(str) / 2.0f), (float)(yBottom + 4), -12566464);
        this.font.func_211126_b(I18n.func_135052_a((String)"gui.programmer.difficulty", (Object[])new Object[0]), (float)(xRight - 36), (float)(yBottom + 20), -12566464);
        if (this.showingWidgetProgress == 0) {
            this.programmerUnit.renderForeground(x, y, this.draggingWidget);
        }
        for (int i = 0; i < this.visibleSpawnWidgets.size(); ++i) {
            IProgWidget widget = this.visibleSpawnWidgets.get(i);
            if (widget == this.draggingWidget || x - this.field_147003_i < widget.getX() || y - this.field_147009_r < widget.getY() || x - this.field_147003_i > widget.getX() + widget.getWidth() / 2 || y - this.field_147009_r > widget.getY() + widget.getHeight() / 2 || this.showingAllWidgets && this.filteredSpawnWidgets != null && !this.filteredSpawnWidgets.get(i)) continue;
            ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
            widget.getTooltip(tooltip);
            ThirdPartyManager.instance().docsProvider.addTooltip(tooltip, this.showingAllWidgets);
            if (tooltip.isEmpty()) continue;
            this.drawHoveringString(tooltip.stream().map(ITextComponent::func_150254_d).collect(Collectors.toList()), x - this.field_147003_i, y - this.field_147009_r, this.font);
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderBackground();
        this.bindGuiTexture();
        int xStart = (this.width - this.field_146999_f) / 2;
        int yStart = (this.height - this.field_147000_g) / 2;
        GuiProgrammer.blit((int)xStart, (int)yStart, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)this.field_146999_f, (int)this.field_147000_g);
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.programmerUnit.render(mouseX, mouseY, this.showFlow.checked, this.showInfo.checked && this.showingWidgetProgress == 0);
        if (this.showingWidgetProgress > 0) {
            int xRight = this.getProgrammerBounds().func_199318_a() + this.getProgrammerBounds().func_199316_c();
            int yBottom = this.getProgrammerBounds().func_199319_b() + this.getProgrammerBounds().func_199317_d();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.bindGuiTexture();
            int width = (int)MathHelper.func_219799_g((float)partialTicks, (float)this.oldShowingWidgetProgress, (float)this.showingWidgetProgress);
            for (int i = 0; i < width; ++i) {
                GuiProgrammer.blit((int)(xStart + xRight + 21 - i), (int)(yStart + 36), (float)(xRight + 24), (float)36.0f, (int)1, (int)(yBottom - 35), (int)this.field_146999_f, (int)this.field_147000_g);
            }
            GuiProgrammer.blit((int)(xStart + xRight + 20 - width), (int)(yStart + 36), (float)(xRight + 20), (float)36.0f, (int)2, (int)(yBottom - 35), (int)this.field_146999_f, (int)this.field_147000_g);
            if (this.showingAllWidgets && this.draggingWidget != null) {
                this.toggleShowWidgets();
            }
        }
        GlStateManager.enableTexture();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        for (int i = 0; i < this.visibleSpawnWidgets.size(); ++i) {
            IProgWidget widget = this.visibleSpawnWidgets.get(i);
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)(widget.getX() + this.field_147003_i), (double)(widget.getY() + this.field_147009_r), (double)0.0);
            GlStateManager.scaled((double)0.5, (double)0.5, (double)1.0);
            if (this.showingAllWidgets && this.filteredSpawnWidgets != null && !this.filteredSpawnWidgets.get(i)) {
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
            } else {
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            widget.render();
            GlStateManager.popMatrix();
        }
        GlStateManager.disableBlend();
        float scale = this.programmerUnit.getScale();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)this.programmerUnit.getTranslatedX(), (double)this.programmerUnit.getTranslatedY(), (double)0.0);
        GlStateManager.scaled((double)scale, (double)scale, (double)1.0);
        if (this.draggingWidget != null) {
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)(this.draggingWidget.getX() + this.field_147003_i), (double)(this.draggingWidget.getY() + this.field_147009_r), (double)0.0);
            GlStateManager.scaled((double)0.5, (double)0.5, (double)1.0);
            this.draggingWidget.render();
            GlStateManager.popMatrix();
        }
        GlStateManager.popMatrix();
        if (!this.removingWidgets.isEmpty()) {
            this.drawRemovingWidgets();
        }
    }

    private void drawRemovingWidgets() {
        Iterator<RemovingWidget> iter = this.removingWidgets.iterator();
        int h = this.minecraft.field_195558_d.func_198087_p();
        float scale = this.programmerUnit.getScale();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)this.programmerUnit.getTranslatedX(), (double)this.programmerUnit.getTranslatedY(), (double)0.0);
        GlStateManager.scaled((double)scale, (double)scale, (double)1.0);
        while (iter.hasNext()) {
            RemovingWidget rw = iter.next();
            IProgWidget w = rw.widget;
            if ((double)w.getY() + rw.ty > (double)((float)h / scale)) {
                iter.remove();
                continue;
            }
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)((double)w.getX() + rw.tx + (double)this.field_147003_i), (double)((double)w.getY() + rw.ty + (double)this.field_147009_r), (double)0.0);
            GlStateManager.scaled((double)0.5, (double)0.5, (double)1.0);
            w.render();
            GlStateManager.popMatrix();
            rw.ty += rw.velY;
            rw.tx += rw.velX;
            rw.velY += 0.3;
        }
        GlStateManager.popMatrix();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        if (this.nameField.isFocused()) {
            return this.nameField.keyPressed(keyCode, scanCode, modifiers);
        }
        if (this.filterField.isFocused() && keyCode != 258) {
            return this.filterField.keyPressed(keyCode, scanCode, modifiers);
        }
        switch (keyCode) {
            case 73: {
                return this.showWidgetDocs();
            }
            case 82: {
                if (this.exportButton.isHovered()) {
                    NetworkHandler.sendToServer(new PacketGuiButton("redstone"));
                }
                return true;
            }
            case 258: {
                this.toggleShowWidgets();
                return true;
            }
            case 261: {
                if (ClientUtils.hasShiftDown()) {
                    this.clear();
                } else {
                    IProgWidget widget = this.programmerUnit.getHoveredWidget(this.lastMouseX, this.lastMouseY);
                    if (widget != null) {
                        this.removingWidgets.add(new RemovingWidget(widget));
                        ((TileEntityProgrammer)this.te).progWidgets.remove(widget);
                        NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
                    }
                }
                return true;
            }
            case 90: {
                NetworkHandler.sendToServer(new PacketGuiButton("undo"));
                return true;
            }
            case 89: {
                NetworkHandler.sendToServer(new PacketGuiButton("redo"));
                return true;
            }
            case 268: {
                this.gotoStart();
                break;
            }
            case 269: {
                this.gotoLatest();
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private boolean showWidgetDocs() {
        int x = this.lastMouseX;
        int y = this.lastMouseY;
        IProgWidget hoveredWidget = this.programmerUnit.getHoveredWidget(x, y);
        if (hoveredWidget != null) {
            ThirdPartyManager.instance().docsProvider.showWidgetDocs(this.getWidgetId(hoveredWidget));
            return true;
        }
        for (IProgWidget widget : this.visibleSpawnWidgets) {
            if (widget == this.draggingWidget || x - this.field_147003_i < widget.getX() || y - this.field_147009_r < widget.getY() || x - this.field_147003_i > widget.getX() + widget.getWidth() / 2 || y - this.field_147009_r > widget.getY() + widget.getHeight() / 2) continue;
            ThirdPartyManager.instance().docsProvider.showWidgetDocs(this.getWidgetId(widget));
            return true;
        }
        return false;
    }

    private String getWidgetId(IProgWidget w) {
        return w == null ? null : w.getTypeID().func_110623_a();
    }

    @Override
    protected boolean shouldDrawBackground() {
        return false;
    }

    private boolean isValidPlaced(IProgWidget widget1) {
        IProgWidget iProgWidget;
        Rectangle2d draggingRect = new Rectangle2d(widget1.getX(), widget1.getY(), widget1.getWidth() / 2, widget1.getHeight() / 2);
        for (IProgWidget iProgWidget2 : ((TileEntityProgrammer)this.te).progWidgets) {
            if (iProgWidget2 == widget1 || !ClientUtils.intersects(draggingRect, iProgWidget2.getX(), iProgWidget2.getY(), (double)iProgWidget2.getWidth() / 2.0, (double)iProgWidget2.getHeight() / 2.0)) continue;
            return false;
        }
        IProgWidget[] parameters = widget1.getConnectedParameters();
        if (parameters != null) {
            for (IProgWidget widget : parameters) {
                if (widget == null || this.isValidPlaced(widget)) continue;
                return false;
            }
        }
        return (iProgWidget = widget1.getOutputWidget()) == null || this.isValidPlaced(iProgWidget);
    }

    private void handlePuzzleMargins() {
        List<ProgWidgetType<?>> parameters;
        ProgWidgetType returnValue = this.draggingWidget.returnType();
        if (returnValue != null) {
            for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
                if (widget == this.draggingWidget || Math.abs(widget.getX() + widget.getWidth() / 2 - this.draggingWidget.getX()) > 4) continue;
                List<ProgWidgetType<?>> parameters2 = widget.getParameters();
                for (int i = 0; i < parameters2.size(); ++i) {
                    if (!widget.canSetParameter(i) || parameters2.get(i) != returnValue || Math.abs(widget.getY() + i * 11 - this.draggingWidget.getY()) > 4) continue;
                    this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX() + widget.getWidth() / 2, widget.getY() + i * 11);
                    return;
                }
            }
        }
        if (!(parameters = this.draggingWidget.getParameters()).isEmpty()) {
            for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
                IProgWidget outerPiece = this.draggingWidget;
                if (outerPiece.returnType() != null) {
                    while (outerPiece.getConnectedParameters()[0] != null) {
                        outerPiece = outerPiece.getConnectedParameters()[0];
                    }
                }
                if (widget == this.draggingWidget || Math.abs(outerPiece.getX() + outerPiece.getWidth() / 2 - widget.getX()) > 4) continue;
                if (widget.returnType() != null) {
                    for (int i = 0; i < parameters.size(); ++i) {
                        if (!this.draggingWidget.canSetParameter(i) || parameters.get(i) != widget.returnType() || Math.abs(this.draggingWidget.getY() + i * 11 - widget.getY()) > 4) continue;
                        this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX() - this.draggingWidget.getWidth() / 2 - (outerPiece.getX() - this.draggingWidget.getX()), widget.getY() - i * 11);
                    }
                    continue;
                }
                List<ProgWidgetType<?>> checkingPieceParms = widget.getParameters();
                for (int i = 0; i < checkingPieceParms.size(); ++i) {
                    if (!widget.canSetParameter(i + parameters.size()) || checkingPieceParms.get(i) != parameters.get(0) || Math.abs(widget.getY() + i * 11 - this.draggingWidget.getY()) > 4) continue;
                    this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX() - this.draggingWidget.getWidth() / 2 - (outerPiece.getX() - this.draggingWidget.getX()), widget.getY() + i * 11);
                }
            }
        }
        if (this.draggingWidget.hasStepInput()) {
            for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
                if (!widget.hasStepOutput() || Math.abs(widget.getX() - this.draggingWidget.getX()) > 4 || Math.abs(widget.getY() + widget.getHeight() / 2 - this.draggingWidget.getY()) > 4) continue;
                this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX(), widget.getY() + widget.getHeight() / 2);
            }
        }
        if (this.draggingWidget.hasStepOutput()) {
            for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
                if (!widget.hasStepInput() || Math.abs(widget.getX() - this.draggingWidget.getX()) > 4 || Math.abs(widget.getY() - this.draggingWidget.getY() - this.draggingWidget.getHeight() / 2) > 4) continue;
                this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX(), widget.getY() - this.draggingWidget.getHeight() / 2);
            }
        }
    }

    private void setConnectingWidgetsToXY(IProgWidget widget, int x, int y) {
        IProgWidget outputWidget;
        widget.setX(x);
        widget.setY(y);
        IProgWidget[] connectingWidgets = widget.getConnectedParameters();
        if (connectingWidgets != null) {
            for (int i = 0; i < connectingWidgets.length; ++i) {
                if (connectingWidgets[i] == null) continue;
                if (i < connectingWidgets.length / 2) {
                    this.setConnectingWidgetsToXY(connectingWidgets[i], x + widget.getWidth() / 2, y + i * 11);
                    continue;
                }
                int totalWidth = 0;
                IProgWidget branch = connectingWidgets[i];
                while (branch != null) {
                    totalWidth += branch.getWidth() / 2;
                    branch = branch.getConnectedParameters()[0];
                }
                this.setConnectingWidgetsToXY(connectingWidgets[i], x - totalWidth, y + (i - connectingWidgets.length / 2) * 11);
            }
        }
        if ((outputWidget = widget.getOutputWidget()) != null) {
            this.setConnectingWidgetsToXY(outputWidget, x, y + widget.getHeight() / 2);
        }
    }

    private void copyAndConnectConnectingWidgets(IProgWidget original, IProgWidget copy) {
        IProgWidget outputWidget;
        IProgWidget c;
        IProgWidget[] connectingWidgets = original.getConnectedParameters();
        if (connectingWidgets != null) {
            for (int i = 0; i < connectingWidgets.length; ++i) {
                if (connectingWidgets[i] == null) continue;
                c = connectingWidgets[i].copy();
                ((TileEntityProgrammer)this.te).progWidgets.add(c);
                copy.setParameter(i, c);
                this.copyAndConnectConnectingWidgets(connectingWidgets[i], c);
            }
        }
        if ((outputWidget = original.getOutputWidget()) != null) {
            c = outputWidget.copy();
            ((TileEntityProgrammer)this.te).progWidgets.add(c);
            copy.setOutputWidget(c);
            this.copyAndConnectConnectingWidgets(outputWidget, c);
        }
    }

    private void deleteConnectingWidgets(IProgWidget widget) {
        IProgWidget outputWidget;
        ((TileEntityProgrammer)this.te).progWidgets.remove(widget);
        this.removingWidgets.add(new RemovingWidget(widget));
        IProgWidget[] connectingWidgets = widget.getConnectedParameters();
        if (connectingWidgets != null) {
            for (IProgWidget widg : connectingWidgets) {
                if (widg == null) continue;
                this.deleteConnectingWidgets(widg);
            }
        }
        if ((outputWidget = widget.getOutputWidget()) != null) {
            this.deleteConnectingWidgets(outputWidget);
        }
    }

    @Override
    public void tick() {
        boolean isDeviceInserted;
        super.tick();
        if (((TileEntityProgrammer)this.te).recentreStartPiece) {
            this.programmerUnit.gotoPiece(GuiProgrammer.findWidget(((TileEntityProgrammer)this.te).progWidgets, ProgWidgetStart.class));
            ((TileEntityProgrammer)this.te).recentreStartPiece = false;
        }
        boolean bl = this.programmerUnit.getScrollBar().visible = this.showingWidgetProgress == 0;
        if (this.showingWidgetProgress > 0) {
            this.programmerUnit.getScrollBar().setCurrentState(this.programmerUnit.getLastZoom());
        }
        this.undoButton.active = ((TileEntityProgrammer)this.te).canUndo;
        this.redoButton.active = ((TileEntityProgrammer)this.te).canRedo;
        this.updateConvertRelativeState();
        ItemStack programmedItem = ((TileEntityProgrammer)this.te).getItemInProgrammingSlot();
        this.oldShowingWidgetProgress = this.showingWidgetProgress;
        int maxProgress = this.maxPage * 22;
        if (this.showingAllWidgets) {
            if (this.showingWidgetProgress < maxProgress) {
                this.showingWidgetProgress += maxProgress / 5;
                if (this.showingWidgetProgress >= maxProgress) {
                    this.showingWidgetProgress = maxProgress;
                    this.updateVisibleProgWidgets();
                }
            } else {
                this.setFocused((IGuiEventListener)this.filterField);
            }
        } else {
            this.showingWidgetProgress -= maxProgress / 5;
            if (this.showingWidgetProgress < 0) {
                this.showingWidgetProgress = 0;
            }
        }
        ArrayList<ITextComponent> errors = new ArrayList<ITextComponent>();
        ArrayList<ITextComponent> warnings = new ArrayList<ITextComponent>();
        for (IProgWidget w : ((TileEntityProgrammer)this.te).progWidgets) {
            w.addErrors(errors, ((TileEntityProgrammer)this.te).progWidgets);
            w.addWarnings(warnings, ((TileEntityProgrammer)this.te).progWidgets);
        }
        this.importButton.active = isDeviceInserted = !programmedItem.func_190926_b();
        this.exportButton.active = isDeviceInserted && errors.size() == 0;
        this.updateExportButtonTooltip(programmedItem, errors, warnings);
        if (!programmedItem.func_190926_b()) {
            this.nameField.func_146184_c(true);
            if (!this.nameField.func_146179_b().equals(programmedItem.func_200301_q().func_150261_e())) {
                this.nameField.func_146180_a(programmedItem.func_200301_q().func_150254_d());
            }
        } else {
            this.nameField.func_146184_c(false);
            this.nameField.func_146180_a("");
        }
    }

    private void updateExportButtonTooltip(ItemStack programmedItem, List<ITextComponent> errors, List<ITextComponent> warnings) {
        ArrayList<String> exportButtonTooltip = new ArrayList<String>();
        exportButtonTooltip.add(I18n.func_135052_a((String)"gui.programmer.button.export", (Object[])new Object[0]));
        exportButtonTooltip.add(I18n.func_135052_a((String)"gui.programmer.button.export.programmingWhen", (Object[])new Object[]{I18n.func_135052_a((String)("gui.programmer.button.export." + (((TileEntityProgrammer)this.te).redstoneMode == 0 ? "pressingButton" : "onItemInsert")), (Object[])new Object[0])}));
        exportButtonTooltip.add(I18n.func_135052_a((String)"gui.programmer.button.export.pressRToChange", (Object[])new Object[0]));
        if (!programmedItem.func_190926_b()) {
            int r;
            int required = ((TileEntityProgrammer)this.te).getRequiredPuzzleCount();
            if (required != 0) {
                exportButtonTooltip.add("");
            }
            int n = r = this.minecraft.field_71439_g.func_184812_l_() ? 0 : required;
            if (required > 0) {
                exportButtonTooltip.add(I18n.func_135052_a((String)"gui.tooltip.programmable.requiredPieces", (Object[])new Object[]{r}));
            } else if (required < 0) {
                exportButtonTooltip.add(I18n.func_135052_a((String)"gui.tooltip.programmable.returnedPieces", (Object[])new Object[]{-r}));
            }
            if (required != 0 && this.minecraft.field_71439_g.func_184812_l_()) {
                exportButtonTooltip.add("(Creative mode)");
            }
        } else {
            exportButtonTooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"gui.programmer.button.export.noProgrammableItem", (Object[])new Object[0]));
        }
        if (errors.size() > 0) {
            exportButtonTooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"gui.programmer.errorCount", (Object[])new Object[]{errors.size()}));
        }
        if (warnings.size() > 0) {
            exportButtonTooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"gui.programmer.warningCount", (Object[])new Object[]{warnings.size()}));
        }
        this.exportButton.setTooltipText(exportButtonTooltip);
    }

    private void updateConvertRelativeState() {
        this.convertToRelativeButton.active = false;
        ArrayList<String> tooltip = new ArrayList<String>();
        tooltip.add("gui.programmer.button.convertToRelative.desc");
        boolean startFound = false;
        for (IProgWidget startWidget : ((TileEntityProgrammer)this.te).progWidgets) {
            if (!(startWidget instanceof ProgWidgetStart)) continue;
            startFound = true;
            IProgWidget widget = startWidget.getOutputWidget();
            if (widget instanceof ProgWidgetCoordinateOperator) {
                ProgWidgetCoordinateOperator operatorWidget = (ProgWidgetCoordinateOperator)widget;
                if (!operatorWidget.getVariable().equals("")) {
                    try {
                        if (this.generateRelativeOperators(operatorWidget, tooltip, true)) {
                            this.convertToRelativeButton.active = true;
                            continue;
                        }
                        tooltip.add("gui.programmer.button.convertToRelative.notEnoughRoom");
                    }
                    catch (NullPointerException e) {
                        tooltip.add("gui.programmer.button.convertToRelative.cantHaveVariables");
                    }
                    continue;
                }
                tooltip.add("gui.programmer.button.convertToRelative.noVariableName");
                continue;
            }
            tooltip.add("gui.programmer.button.convertToRelative.noBaseCoordinate");
        }
        if (!startFound) {
            tooltip.add("gui.programmer.button.convertToRelative.noStartPiece");
        }
        ArrayList<String> localizedTooltip = new ArrayList<String>();
        for (String s : tooltip) {
            localizedTooltip.addAll(PneumaticCraftUtils.splitString(I18n.func_135052_a((String)s, (Object[])new Object[0]), 40));
        }
        this.convertToRelativeButton.setTooltipText(localizedTooltip);
    }

    private boolean generateRelativeOperators(ProgWidgetCoordinateOperator baseWidget, List<String> tooltip, boolean simulate) {
        BlockPos baseCoord = ProgWidgetCoordinateOperator.calculateCoordinate(baseWidget, 0, baseWidget.getOperator());
        HashMap<BlockPos, String> offsetToVariableNames = new HashMap<BlockPos, String>();
        for (IProgWidget widget : ((TileEntityProgrammer)this.te).progWidgets) {
            ProgWidgetCoordinate coordinate;
            if (widget instanceof ProgWidgetArea) {
                String var;
                BlockPos offset;
                ProgWidgetArea area = (ProgWidgetArea)widget;
                if (area.getCoord1Variable().equals("") && (area.x1 != 0 || area.y1 != 0 || area.z1 != 0)) {
                    offset = new BlockPos(area.x1 - baseCoord.func_177958_n(), area.y1 - baseCoord.func_177956_o(), area.z1 - baseCoord.func_177952_p());
                    var = this.getOffsetVariable(offsetToVariableNames, baseWidget.getVariable(), offset);
                    if (!simulate) {
                        area.setCoord1Variable(var);
                    }
                }
                if (!area.getCoord2Variable().equals("") || area.x2 == 0 && area.y2 == 0 && area.z2 == 0) continue;
                offset = new BlockPos(area.x2 - baseCoord.func_177958_n(), area.y2 - baseCoord.func_177956_o(), area.z2 - baseCoord.func_177952_p());
                var = this.getOffsetVariable(offsetToVariableNames, baseWidget.getVariable(), offset);
                if (simulate) continue;
                area.setCoord2Variable(var);
                continue;
            }
            if (!(widget instanceof ProgWidgetCoordinate) || baseWidget.getConnectedParameters()[0] == widget || (coordinate = (ProgWidgetCoordinate)widget).isUsingVariable()) continue;
            BlockPos c = coordinate.getCoordinate();
            String chunkString = "(" + c.func_177958_n() + ", " + c.func_177956_o() + ", " + c.func_177952_p() + ")";
            if (PneumaticCraftUtils.distBetween((Vec3i)c, 0.0, 0.0, 0.0) < 64.0) {
                if (tooltip == null) continue;
                tooltip.add(I18n.func_135052_a((String)"gui.programmer.button.convertToRelative.coordIsNotChangedWarning", (Object[])new Object[]{chunkString}));
                continue;
            }
            if (tooltip != null) {
                tooltip.add(I18n.func_135052_a((String)"gui.programmer.button.convertToRelative.coordIsChangedWarning", (Object[])new Object[]{chunkString}));
            }
            if (simulate) continue;
            BlockPos offset = new BlockPos(c.func_177958_n() - baseCoord.func_177958_n(), c.func_177956_o() - baseCoord.func_177956_o(), c.func_177952_p() - baseCoord.func_177952_p());
            String var = this.getOffsetVariable(offsetToVariableNames, baseWidget.getVariable(), offset);
            coordinate.setVariable(var);
            coordinate.setUsingVariable(true);
        }
        if (offsetToVariableNames.size() > 0) {
            ProgWidgetCoordinateOperator firstOperator = null;
            ProgWidgetCoordinateOperator prevOperator = baseWidget;
            int x = baseWidget.getX();
            for (Map.Entry entry : offsetToVariableNames.entrySet()) {
                ProgWidgetCoordinateOperator operator = new ProgWidgetCoordinateOperator();
                operator.setVariable((String)entry.getValue());
                int y = prevOperator.getY() + prevOperator.getHeight() / 2;
                operator.setX(x);
                operator.setY(y);
                if (!this.isValidPlaced(operator)) {
                    return false;
                }
                ProgWidgetCoordinate coordinatePiece1 = new ProgWidgetCoordinate();
                coordinatePiece1.setX(x + prevOperator.getWidth() / 2);
                coordinatePiece1.setY(y);
                coordinatePiece1.setVariable(baseWidget.getVariable());
                coordinatePiece1.setUsingVariable(true);
                if (!this.isValidPlaced(coordinatePiece1)) {
                    return false;
                }
                ProgWidgetCoordinate coordinatePiece2 = new ProgWidgetCoordinate();
                coordinatePiece2.setX(x + prevOperator.getWidth() / 2 + coordinatePiece1.getWidth() / 2);
                coordinatePiece2.setY(y);
                coordinatePiece2.setCoordinate((BlockPos)entry.getKey());
                if (!this.isValidPlaced(coordinatePiece2)) {
                    return false;
                }
                if (!simulate) {
                    ((TileEntityProgrammer)this.te).progWidgets.add(operator);
                    ((TileEntityProgrammer)this.te).progWidgets.add(coordinatePiece1);
                    ((TileEntityProgrammer)this.te).progWidgets.add(coordinatePiece2);
                }
                if (firstOperator == null) {
                    firstOperator = operator;
                }
                prevOperator = operator;
            }
            if (!simulate) {
                NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
                TileEntityProgrammer.updatePuzzleConnections(((TileEntityProgrammer)this.te).progWidgets);
            }
            return true;
        }
        return true;
    }

    private String getOffsetVariable(Map<BlockPos, String> offsetToVariableNames, String baseVariable, BlockPos offset) {
        if (offset.equals((Object)BlockPos.field_177992_a)) {
            return baseVariable;
        }
        return offsetToVariableNames.computeIfAbsent(offset, k -> "var" + (offsetToVariableNames.size() + 1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        double origX = mouseX;
        double origY = mouseY;
        float scale = this.programmerUnit.getScale();
        mouseX = (mouseX - this.programmerUnit.getTranslatedX()) / (double)scale;
        mouseY = (mouseY - this.programmerUnit.getTranslatedY()) / (double)scale;
        if (button == 0) {
            IProgWidget hovered = this.programmerUnit.getHoveredWidget((int)origX, (int)origY);
            ItemStack heldItem = this.minecraft.field_71439_g.field_71071_by.func_70445_o();
            if (heldItem.func_77973_b() instanceof IPositionProvider) {
                ProgWidgetArea areaToolWidget;
                ProgWidgetArea progWidgetArea = areaToolWidget = heldItem.func_77973_b() instanceof ItemGPSAreaTool ? ItemGPSAreaTool.getArea(heldItem) : null;
                if (hovered != null) {
                    if (areaToolWidget != null && hovered instanceof ProgWidgetArea) {
                        CompoundNBT tag = new CompoundNBT();
                        areaToolWidget.writeToNBT(tag);
                        tag.func_74768_a("x", hovered.getX());
                        tag.func_74768_a("y", hovered.getY());
                        hovered.readFromNBT(tag);
                        return true;
                    } else {
                        if (heldItem.func_77973_b() != ModItems.GPS_TOOL.get()) return true;
                        if (hovered instanceof ProgWidgetCoordinate) {
                            ((ProgWidgetCoordinate)hovered).loadFromGPSTool(heldItem);
                            return true;
                        } else {
                            if (!(hovered instanceof ProgWidgetArea)) return true;
                            BlockPos pos = ItemGPSTool.getGPSLocation(heldItem);
                            String var = ItemGPSTool.getVariable(heldItem);
                            ProgWidgetArea areaHovered = (ProgWidgetArea)hovered;
                            if (pos != null) {
                                areaHovered.setP1(pos);
                            }
                            areaHovered.setP2(BlockPos.field_177992_a);
                            areaHovered.setCoord1Variable(var);
                            areaHovered.setCoord2Variable("");
                        }
                    }
                    return true;
                } else {
                    ProgWidget toCreate = null;
                    if (areaToolWidget != null) {
                        toCreate = areaToolWidget;
                    } else if (heldItem.func_77973_b() == ModItems.GPS_TOOL.get()) {
                        if (Screen.hasShiftDown()) {
                            BlockPos pos = ItemGPSTool.getGPSLocation(heldItem);
                            ProgWidgetArea areaWidget = ProgWidgetArea.fromPositions(pos, BlockPos.field_177992_a);
                            String var = ItemGPSTool.getVariable(heldItem);
                            if (!var.isEmpty()) {
                                areaWidget.setCoord1Variable(var);
                            }
                            toCreate = areaWidget;
                        } else {
                            ProgWidgetCoordinate coordWidget = new ProgWidgetCoordinate();
                            coordWidget.loadFromGPSTool(heldItem);
                            toCreate = coordWidget;
                        }
                    }
                    if (toCreate == null) return true;
                    toCreate.setX((int)(mouseX - (double)this.field_147003_i - (double)toCreate.getWidth() / 3.0));
                    toCreate.setY((int)(mouseY - (double)this.field_147009_r - (double)toCreate.getHeight() / 4.0));
                    if (this.programmerUnit.isOutsideProgrammingArea(toCreate)) return true;
                    ((TileEntityProgrammer)this.te).progWidgets.add(toCreate);
                }
                return true;
            }
            if (this.showingAllWidgets || origX > (double)(this.field_147003_i + this.getProgrammerBounds().func_199318_a() + this.getProgrammerBounds().func_199316_c())) {
                for (IProgWidget widget : this.visibleSpawnWidgets) {
                    if (!(origX >= (double)(widget.getX() + this.field_147003_i)) || !(origY >= (double)(widget.getY() + this.field_147009_r)) || !(origX <= (double)((float)(widget.getX() + this.field_147003_i) + (float)widget.getWidth() / 2.0f)) || !(origY <= (double)((float)(widget.getY() + this.field_147009_r) + (float)widget.getHeight() / 2.0f))) continue;
                    this.draggingWidget = widget.copy();
                    ((TileEntityProgrammer)this.te).progWidgets.add(this.draggingWidget);
                    this.dragMouseStartX = mouseX - (double)((int)((float)this.field_147003_i / scale));
                    this.dragMouseStartY = mouseY - (double)((int)((float)this.field_147009_r / scale));
                    this.dragWidgetStartX = (int)(((double)widget.getX() - this.programmerUnit.getTranslatedX()) / (double)scale);
                    this.dragWidgetStartY = (int)(((double)widget.getY() - this.programmerUnit.getTranslatedY()) / (double)scale);
                    return true;
                }
            }
            if (hovered != null) {
                this.draggingWidget = hovered;
                this.dragMouseStartX = mouseX - (double)this.field_147003_i;
                this.dragMouseStartY = mouseY - (double)this.field_147009_r;
                this.dragWidgetStartX = hovered.getX();
                this.dragWidgetStartY = hovered.getY();
                return true;
            }
            if (!this.getProgrammerBounds().func_199315_b((int)origX - this.field_147003_i, (int)origY - this.field_147009_r)) return super.mouseClicked(origX, origY, button);
            this.draggingBG = true;
            return super.mouseClicked(origX, origY, button);
        } else {
            GuiProgWidgetOptionBase gui;
            if (button == 2) {
                if (this.showingWidgetProgress != 0) return this.showWidgetDocs();
                IProgWidget widget = this.programmerUnit.getHoveredWidget((int)origX, (int)origY);
                if (widget == null) return super.mouseClicked(origX, origY, button);
                this.draggingWidget = widget.copy();
                ((TileEntityProgrammer)this.te).progWidgets.add(this.draggingWidget);
                this.dragMouseStartX = mouseX - (double)this.field_147003_i;
                this.dragMouseStartY = mouseY - (double)this.field_147009_r;
                this.dragWidgetStartX = widget.getX();
                this.dragWidgetStartY = widget.getY();
                if (!Screen.hasShiftDown()) return true;
                this.copyAndConnectConnectingWidgets(widget, this.draggingWidget);
                return true;
            }
            if (button != 1 || this.showingWidgetProgress != 0) return super.mouseClicked(origX, origY, button);
            IProgWidget widget = this.programmerUnit.getHoveredWidget((int)origX, (int)origY);
            if (widget == null || (gui = ProgWidgetGuiManager.getGui(widget, this)) == null) return true;
            this.minecraft.func_147108_a((Screen)gui);
            return true;
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.draggingBG = false;
        if (this.draggingWidget != null) {
            if (this.programmerUnit.isOutsideProgrammingArea(this.draggingWidget)) {
                this.deleteConnectingWidgets(this.draggingWidget);
            } else {
                this.handlePuzzleMargins();
                if (!this.isValidPlaced(this.draggingWidget)) {
                    this.setConnectingWidgetsToXY(this.draggingWidget, (int)this.dragWidgetStartX, (int)this.dragWidgetStartY);
                    if (this.programmerUnit.isOutsideProgrammingArea(this.draggingWidget) || !this.isValidPlaced(this.draggingWidget)) {
                        this.deleteConnectingWidgets(this.draggingWidget);
                    }
                }
            }
            NetworkHandler.sendToServer(new PacketProgrammerUpdate((TileEntityProgrammer)this.te));
            TileEntityProgrammer.updatePuzzleConnections(((TileEntityProgrammer)this.te).progWidgets);
            this.draggingWidget = null;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        return this.programmerUnit.mouseScrolled(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        if (this.draggingWidget != null) {
            mouseX = (mouseX - this.programmerUnit.getTranslatedX()) / (double)this.programmerUnit.getScale();
            mouseY = (mouseY - this.programmerUnit.getTranslatedY()) / (double)this.programmerUnit.getScale();
            this.setConnectingWidgetsToXY(this.draggingWidget, (int)(mouseX - this.dragMouseStartX + this.dragWidgetStartX - (double)this.field_147003_i), (int)(mouseY - this.dragMouseStartY + this.dragWidgetStartY - (double)this.field_147009_r));
            return true;
        }
        if (this.draggingBG) {
            return this.programmerUnit.mouseDragged(mouseX, mouseY, mouseButton, dragX, dragY);
        }
        return false;
    }

    @Override
    public void onClose() {
        ((TileEntityProgrammer)this.te).translatedX = this.programmerUnit.getTranslatedX();
        ((TileEntityProgrammer)this.te).translatedY = this.programmerUnit.getTranslatedY();
        ((TileEntityProgrammer)this.te).zoomState = this.programmerUnit.getLastZoom();
        ((TileEntityProgrammer)this.te).showFlow = this.showFlow.checked;
        ((TileEntityProgrammer)this.te).showInfo = this.showInfo.checked;
    }

    public static IProgWidget findWidget(List<IProgWidget> widgets, Class<? extends IProgWidget> cls) {
        return widgets.stream().filter(w -> cls.isAssignableFrom(w.getClass())).findFirst().orElse(null);
    }

    private class RemovingWidget {
        final IProgWidget widget;
        double ty = 0.0;
        double tx = 0.0;
        double velX;
        double velY;

        private RemovingWidget(IProgWidget widget) {
            this.velX = (Minecraft.func_71410_x().field_71441_e.field_73012_v.nextDouble() - 0.5) * 3.0;
            this.velY = -4.0;
            this.widget = widget;
        }
    }

    private class DifficultyButton
    extends WidgetRadioButton {
        final IProgWidget.WidgetDifficulty difficulty;

        DifficultyButton(int x, int y, int color, IProgWidget.WidgetDifficulty difficulty, Consumer<WidgetRadioButton> pressable) {
            super(x, y, color, difficulty.getTranslationKey(), pressable);
            this.difficulty = difficulty;
        }
    }

    private class FilterTextField
    extends WidgetTextField {
        FilterTextField(FontRenderer font, int x, int y, int width, int height) {
            super(font, x, y, width, height);
        }

        @Override
        public void renderButton(int x, int y, float partialTicks) {
            GlStateManager.translated((double)0.0, (double)0.0, (double)300.0);
            super.renderButton(x, y, partialTicks);
            GlStateManager.translated((double)0.0, (double)0.0, (double)-300.0);
        }
    }
}

