/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.inventory.ContainerRefinery;
import me.desht.pneumaticcraft.common.tileentity.TileEntityRefineryController;
import me.desht.pneumaticcraft.common.tileentity.TileEntityRefineryOutput;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.IFluidTank;

public class GuiRefineryController
extends GuiPneumaticContainerBase<ContainerRefinery, TileEntityRefineryController> {
    private List<TileEntityRefineryOutput> outputs;
    private WidgetTemperature widgetTemperature;
    private int nExposedFaces;

    public GuiRefineryController(ContainerRefinery container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.field_147000_g = 189;
    }

    @Override
    public void init() {
        super.init();
        this.widgetTemperature = new WidgetTemperature(this.field_147003_i + 32, this.field_147009_r + 32, 273, 673, ((TileEntityRefineryController)this.te).getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY), new int[0]){

            @Override
            public void addTooltip(double mouseX, double mouseY, List<String> curTip, boolean shift) {
                super.addTooltip(mouseX, mouseY, curTip, shift);
                if (((TileEntityRefineryController)GuiRefineryController.this.te).minTemp > 0) {
                    int temp = (Integer)this.logic.map(IHeatExchangerLogic::getTemperatureAsInt).orElseThrow(RuntimeException::new);
                    TextFormatting tf = ((TileEntityRefineryController)GuiRefineryController.this.te).minTemp < temp ? TextFormatting.GREEN : TextFormatting.GOLD;
                    curTip.add(tf + I18n.func_135052_a((String)"gui.misc.requiredTemperature", (Object[])new Object[]{((TileEntityRefineryController)GuiRefineryController.this.te).minTemp - 273}));
                }
            }
        };
        this.addButton(this.widgetTemperature);
        this.addButton(new WidgetTank(this.field_147003_i + 8, this.field_147009_r + 25, (IFluidTank)((TileEntityRefineryController)this.te).getInputTank()));
        int x = this.field_147003_i + 95;
        int y = this.field_147009_r + 29;
        this.outputs = new ArrayList<TileEntityRefineryOutput>();
        TileEntityRefineryOutput te1 = ((TileEntityRefineryController)this.te).findAdjacentOutput();
        if (te1 instanceof TileEntityRefineryOutput) {
            int i = 0;
            do {
                TileEntityRefineryOutput teRO = te1;
                if (this.outputs.size() < 4) {
                    this.addButton(new WidgetTank(x, y, (IFluidTank)((TileEntityRefineryController)this.te).outputsSynced[i++]));
                }
                x += 20;
                y -= 4;
                this.outputs.add(teRO);
            } while ((te1 = te1.func_145831_w().func_175625_s(te1.func_174877_v().func_177984_a())) instanceof TileEntityRefineryOutput);
        }
        if (this.outputs.size() < 2 || this.outputs.size() > 4) {
            this.problemTab.openWindow();
        }
        this.nExposedFaces = HeatUtil.countExposedFaces(this.outputs);
    }

    @Override
    public void tick() {
        super.tick();
        if (((TileEntityRefineryController)this.te).minTemp > 0) {
            this.widgetTemperature.setScales(((TileEntityRefineryController)this.te).minTemp);
        } else {
            this.widgetTemperature.setScales(new int[0]);
        }
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        super.func_146976_a(f, x, y);
        if (this.outputs.size() < 4) {
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)770, (int)771);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiRefineryController.fill((int)(this.field_147003_i + 155), (int)(this.field_147009_r + 17), (int)(this.field_147003_i + 171), (int)(this.field_147009_r + 81), (int)0x40FF0000);
            if (this.outputs.size() < 3) {
                GuiRefineryController.fill((int)(this.field_147003_i + 135), (int)(this.field_147009_r + 21), (int)(this.field_147003_i + 151), (int)(this.field_147009_r + 85), (int)0x40FF0000);
            }
            if (this.outputs.size() < 2) {
                GuiRefineryController.fill((int)(this.field_147003_i + 115), (int)(this.field_147009_r + 25), (int)(this.field_147003_i + 131), (int)(this.field_147009_r + 89), (int)0x40FF0000);
            }
            if (this.outputs.size() < 1) {
                GuiRefineryController.fill((int)(this.field_147003_i + 95), (int)(this.field_147009_r + 29), (int)(this.field_147003_i + 111), (int)(this.field_147009_r + 93), (int)0x40FF0000);
            }
            GlStateManager.disableBlend();
        }
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_REFINERY;
    }

    @Override
    public void addProblems(List<String> curInfo) {
        super.addProblems(curInfo);
        int temp = (Integer)((TileEntityRefineryController)this.te).getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).map(IHeatExchangerLogic::getTemperatureAsInt).orElseThrow(RuntimeException::new);
        if (temp < ((TileEntityRefineryController)this.te).minTemp) {
            curInfo.add("gui.tab.problems.notEnoughHeat");
        }
        if (((TileEntityRefineryController)this.te).getInputTank().getFluidAmount() < 10) {
            curInfo.add("gui.tab.problems.refinery.noOil");
        }
        if (this.outputs.size() < 2) {
            curInfo.add("gui.tab.problems.refinery.notEnoughRefineries");
        } else if (this.outputs.size() > 4) {
            curInfo.add("gui.tab.problems.refinery.tooManyRefineries");
        }
    }

    @Override
    protected void addWarnings(List<String> curInfo) {
        super.addWarnings(curInfo);
        if (((TileEntityRefineryController)this.te).isBlocked()) {
            curInfo.add("gui.tab.problems.refinery.outputBlocked");
        }
        if (this.nExposedFaces > 0) {
            curInfo.add(I18n.func_135052_a((String)"gui.tab.problems.exposedFaces", (Object[])new Object[]{this.nExposedFaces, this.outputs.size() * 6}));
        }
    }

    @Override
    protected boolean shouldAddUpgradeTab() {
        return false;
    }
}

