/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.render.area.AreaRenderManager;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.ContainerSmartChest;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSmartChestSync;
import me.desht.pneumaticcraft.common.tileentity.SideConfigurator;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySmartChest;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.tuple.Pair;

public class GuiSmartChest
extends GuiPneumaticContainerBase<ContainerSmartChest, TileEntitySmartChest> {
    private List<Pair<Integer, Item>> filter;
    private IGuiAnimatedStat statusStat;
    private WidgetButtonExtended showRangeButton;

    public GuiSmartChest(ContainerSmartChest container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
        this.field_146999_f = 234;
        this.field_147000_g = 216;
        this.filter = ((TileEntitySmartChest)this.te).getFilter();
    }

    @Override
    public void init() {
        super.init();
        this.addAnimatedStat("gui.tab.info.smart_chest.slots.title", Textures.GUI_MOUSE_LOCATION, -16733441, true).setText("gui.tab.info.smart_chest.slots");
        this.statusStat = this.addAnimatedStat("gui.tab.status", new ItemStack((IItemProvider)ModBlocks.SMART_CHEST.get()), -22016, false);
        this.addPushPullTab();
        this.showRangeButton = new WidgetButtonExtended(this.field_147003_i + 196, this.field_147009_r + 189, 12, 12, "A", b -> this.showRangeLines());
        this.addButton((Widget)this.showRangeButton);
    }

    private void showRangeLines() {
        if (AreaRenderManager.getInstance().isShowing(this.te)) {
            AreaRenderManager.getInstance().removeHandlers(this.te);
        } else if (((TileEntitySmartChest)this.te).getUpgrades(EnumUpgrade.MAGNET) > 0) {
            int range = ((TileEntitySmartChest)this.te).getUpgrades(EnumUpgrade.RANGE) + 1;
            HashSet<BlockPos> posSet = new HashSet<BlockPos>();
            for (SideConfigurator.RelativeFace face : SideConfigurator.RelativeFace.values()) {
                if (((TileEntitySmartChest)this.te).getPushPullMode(face) != TileEntitySmartChest.PushPullMode.PULL) continue;
                Direction dir = ((TileEntitySmartChest)this.te).getAbsoluteFacing(face, ((TileEntitySmartChest)this.te).getRotation());
                BlockPos p = ((TileEntitySmartChest)this.te).func_174877_v().func_177967_a(dir, range + 1);
                for (int x = -range; x <= range; ++x) {
                    for (int y = -range; y <= range; ++y) {
                        for (int z = -range; z <= range; ++z) {
                            posSet.add(p.func_177982_a(x, y, z));
                        }
                    }
                }
            }
            AreaRenderManager.getInstance().showArea(posSet, 0x6000FFFF, (TileEntity)this.te);
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.statusStat.setText(this.getStatus());
        if (((TileEntitySmartChest)this.te).getUpgrades(EnumUpgrade.MAGNET) > 0) {
            this.showRangeButton.setVisible(true);
            if (AreaRenderManager.getInstance().isShowing(this.te)) {
                this.showRangeButton.setMessage(TextFormatting.AQUA + "A");
                this.showRangeButton.setTooltipText(I18n.func_135052_a((String)"gui.programmer.button.stopShowingArea", (Object[])new Object[0]));
            } else {
                this.showRangeButton.setMessage(TextFormatting.GRAY + "A");
                this.showRangeButton.setTooltipText(I18n.func_135052_a((String)"gui.programmer.button.showArea", (Object[])new Object[0]));
            }
        } else {
            this.showRangeButton.setVisible(false);
        }
    }

    private List<String> getStatus() {
        ArrayList<String> textList = new ArrayList<String>();
        textList.add(I18n.func_135052_a((String)"gui.tab.smartChestStatus.header", (Object[])new Object[0]));
        textList.add(I18n.func_135052_a((String)"gui.tab.smartChestStatus.itemsPerOperation", (Object[])new Object[]{((TileEntitySmartChest)this.te).getMaxItems()}));
        textList.add(I18n.func_135052_a((String)"gui.tab.smartChestStatus.tickInterval", (Object[])new Object[]{((TileEntitySmartChest)this.te).getTickRate()}));
        return textList;
    }

    private void addPushPullTab() {
        WidgetAnimatedStat stat = this.addAnimatedStat("gui.tab.info.smart_chest.push_pull.title", new ItemStack((IItemProvider)ModBlocks.OMNIDIRECTIONAL_HOPPER.get()), -7290656, false);
        stat.addPadding(7, 16);
        int yTop = 15;
        int xLeft = 25;
        stat.addSubWidget((Widget)this.makePushPullButton(SideConfigurator.RelativeFace.TOP, xLeft + 22, yTop));
        stat.addSubWidget((Widget)this.makePushPullButton(SideConfigurator.RelativeFace.LEFT, xLeft, yTop + 22));
        stat.addSubWidget((Widget)this.makePushPullButton(SideConfigurator.RelativeFace.FRONT, xLeft + 22, yTop + 22));
        stat.addSubWidget((Widget)this.makePushPullButton(SideConfigurator.RelativeFace.RIGHT, xLeft + 44, yTop + 22));
        stat.addSubWidget((Widget)this.makePushPullButton(SideConfigurator.RelativeFace.BOTTOM, xLeft + 22, yTop + 44));
        stat.addSubWidget((Widget)this.makePushPullButton(SideConfigurator.RelativeFace.BACK, xLeft + 44, yTop + 44));
    }

    private WidgetButtonExtended makePushPullButton(SideConfigurator.RelativeFace face, int x, int y) {
        WidgetButtonExtended button = new WidgetButtonExtended(x, y, 20, 20, "", b -> {
            ((TileEntitySmartChest)this.te).cycleMode(face);
            this.setupPushPullButton((WidgetButtonExtended)b, face);
        }).withTag("push_pull:" + face.toString());
        this.setupPushPullButton(button, face);
        return button;
    }

    private void setupPushPullButton(WidgetButtonExtended button, SideConfigurator.RelativeFace face) {
        TileEntitySmartChest.PushPullMode mode = ((TileEntitySmartChest)this.te).getPushPullMode(face);
        switch (mode) {
            case NONE: {
                button.setRenderedIcon(Textures.GUI_X_BUTTON);
                button.setRenderStacks(ItemStack.field_190927_a);
                break;
            }
            case PUSH: {
                button.setRenderStacks(new ItemStack((IItemProvider)Blocks.field_150331_J));
                break;
            }
            case PULL: {
                button.setRenderStacks(new ItemStack((IItemProvider)Blocks.field_150320_F));
            }
        }
        button.setTooltipText((List<String>)ImmutableList.of((Object)(TextFormatting.YELLOW + face.toString()), (Object)I18n.func_135052_a((String)mode.getTranslationKey(), (Object[])new Object[0])));
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_SMART_CHEST;
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    public void render(int x, int y, float partialTick) {
        super.render(x, y, partialTick);
        if (this.minecraft.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.field_147006_u != null && this.field_147006_u.func_75211_c().func_190926_b() && this.field_147006_u.field_75222_d < 72 && !((TileEntitySmartChest)this.te).getFilter(this.field_147006_u.field_75222_d).func_190926_b()) {
            ArrayList l = Lists.newArrayList((Object[])new String[]{TextFormatting.GRAY + "Filter", ((TileEntitySmartChest)this.te).getFilter(this.field_147006_u.field_75222_d).func_200301_q().func_150254_d()});
            this.renderTooltip(l, x, y);
        }
    }

    @Override
    protected void func_146979_b(int x, int y) {
        GlStateManager.enableTexture();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        for (Pair<Integer, Item> p : this.filter) {
            int slot = (Integer)p.getLeft();
            if (slot >= ((TileEntitySmartChest)this.te).getLastSlot()) continue;
            int sx = 8 + slot % 12 * 18;
            int sy = 18 + slot / 12 * 18;
            if (((Slot)((ContainerSmartChest)this.field_147002_h).field_75151_b.get(slot)).func_75211_c().func_190926_b()) {
                ItemStack stack = new ItemStack((IItemProvider)p.getRight());
                GuiUtils.drawItemStack(stack, sx, sy);
                GlStateManager.translated((double)0.0, (double)0.0, (double)300.0);
            }
            GuiSmartChest.fill((int)sx, (int)sy, (int)(sx + 16), (int)(sy + 16), (int)-2139041664);
            if (!((Slot)((ContainerSmartChest)this.field_147002_h).field_75151_b.get(slot)).func_75211_c().func_190926_b()) continue;
            GlStateManager.translated((double)0.0, (double)0.0, (double)-300.0);
        }
        super.func_146979_b(x, y);
        for (int slot = ((TileEntitySmartChest)this.te).getLastSlot(); slot < 72; ++slot) {
            int sx = 8 + slot % 12 * 18;
            int sy = 18 + slot / 12 * 18;
            GuiSmartChest.fill((int)sx, (int)sy, (int)(sx + 16), (int)(sy + 16), (int)1090478176);
        }
        GlStateManager.disableBlend();
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (slotId < 72 && mouseButton == 0 && Screen.hasAltDown()) {
            ItemStack stack = slotIn.func_75211_c();
            if (stack.func_190926_b() && slotId > 0 && ((TileEntitySmartChest)this.te).getFilter(slotId).func_190926_b()) {
                if (slotId == ((TileEntitySmartChest)this.te).getLastSlot()) {
                    ((TileEntitySmartChest)this.te).setLastSlot(72);
                } else {
                    for (int i = slotId; i < 72; ++i) {
                        if (((Slot)((ContainerSmartChest)this.field_147002_h).field_75151_b.get(i)).func_75211_c().func_190926_b()) continue;
                        return;
                    }
                    ((TileEntitySmartChest)this.te).setLastSlot(slotId);
                }
                NetworkHandler.sendToServer(new PacketSmartChestSync((TileEntitySmartChest)this.te));
            } else {
                if (((TileEntitySmartChest)this.te).getFilter(slotId).func_190926_b()) {
                    ((TileEntitySmartChest)this.te).setFilter(slotId, stack);
                } else {
                    ((TileEntitySmartChest)this.te).setFilter(slotId, ItemStack.field_190927_a);
                }
                this.filter = ((TileEntitySmartChest)this.te).getFilter();
                NetworkHandler.sendToServer(new PacketSmartChestSync((TileEntitySmartChest)this.te));
            }
        } else {
            super.func_184098_a(slotIn, slotId, mouseButton, type);
        }
    }
}

