/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.client.gui.programmer.ProgWidgetGuiManager;
import me.desht.pneumaticcraft.client.gui.widget.WidgetVerticalScrollbar;
import me.desht.pneumaticcraft.common.progwidgets.IJump;
import me.desht.pneumaticcraft.common.progwidgets.ILabel;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;

public class GuiUnitProgrammer
extends Screen {
    private static final float SCALE_PER_STEP = 0.2f;
    private final FontRenderer fontRenderer;
    private final List<IProgWidget> progWidgets;
    private final int guiLeft;
    private final int guiTop;
    private final int startX;
    private final int startY;
    private final int areaWidth;
    private final int areaHeight;
    private final WidgetVerticalScrollbar scaleScroll;
    private double translatedX;
    private double translatedY;
    private int lastZoom;

    public GuiUnitProgrammer(List<IProgWidget> progWidgets, FontRenderer fontRenderer, int guiLeft, int guiTop, int width, int height, Rectangle2d bounds, double translatedX, double translatedY, int lastZoom) {
        super((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"block.pneumaticcraft.programmer", (Object[])new Object[0])));
        this.fontRenderer = fontRenderer;
        this.progWidgets = progWidgets;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.init(Minecraft.func_71410_x(), width, height);
        this.startX = bounds.func_199318_a();
        this.startY = bounds.func_199319_b();
        this.areaWidth = bounds.func_199316_c();
        this.areaHeight = bounds.func_199317_d();
        this.translatedX = translatedX;
        this.translatedY = translatedY;
        this.lastZoom = lastZoom;
        this.scaleScroll = new WidgetVerticalScrollbar(guiLeft + this.areaWidth + 8, guiTop + 40, this.areaHeight - 25).setStates(9).setCurrentState(lastZoom).setListening(true);
    }

    public WidgetVerticalScrollbar getScrollBar() {
        return this.scaleScroll;
    }

    int getLastZoom() {
        return this.lastZoom;
    }

    double getTranslatedX() {
        return this.translatedX;
    }

    double getTranslatedY() {
        return this.translatedY;
    }

    public void renderForeground(int x, int y, IProgWidget tooltipExcludingWidget) {
        IProgWidget progWidget = this.getHoveredWidget(x, y);
        if (progWidget != null && progWidget != tooltipExcludingWidget) {
            ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
            progWidget.getTooltip(tooltip);
            ArrayList<ITextComponent> errors = new ArrayList<ITextComponent>();
            progWidget.addErrors(errors, this.progWidgets);
            if (errors.size() > 0) {
                tooltip.add(PneumaticCraftUtils.xlate("gui.programmer.errors", new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.RED, TextFormatting.UNDERLINE}));
                for (ITextComponent iTextComponent : errors) {
                    PneumaticCraftUtils.splitString("\u25b6 " + iTextComponent.func_150254_d(), 40).forEach(str -> tooltip.add(new StringTextComponent(str).func_211708_a(TextFormatting.RED)));
                }
            }
            ArrayList<ITextComponent> warnings = new ArrayList<ITextComponent>();
            progWidget.addWarnings(warnings, this.progWidgets);
            if (warnings.size() > 0) {
                tooltip.add(PneumaticCraftUtils.xlate("gui.programmer.warnings", new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.UNDERLINE}));
                for (ITextComponent warning : warnings) {
                    PneumaticCraftUtils.splitString("\u25b6 " + warning.func_150254_d(), 40).forEach(str -> tooltip.add(new StringTextComponent(str).func_211708_a(TextFormatting.YELLOW)));
                }
            }
            this.addAdditionalInfoToTooltip(progWidget, tooltip);
            if (!tooltip.isEmpty()) {
                List list = tooltip.stream().map(ITextComponent::func_150254_d).collect(Collectors.toList());
                this.renderTooltip(list, x - this.guiLeft, y - this.guiTop, this.fontRenderer);
            }
        }
    }

    public IProgWidget getHoveredWidget(int mouseX, int mouseY) {
        float scale = this.getScale();
        for (IProgWidget widget : this.progWidgets) {
            if (this.isOutsideProgrammingArea(widget) || !(((double)mouseX - this.translatedX) / (double)scale - (double)this.guiLeft >= (double)widget.getX()) || !(((double)mouseY - this.translatedY) / (double)scale - (double)this.guiTop >= (double)widget.getY()) || !(((double)mouseX - this.translatedX) / (double)scale - (double)this.guiLeft <= (double)(widget.getX() + widget.getWidth() / 2)) || !(((double)mouseY - this.translatedY) / (double)scale - (double)this.guiTop <= (double)(widget.getY() + widget.getHeight() / 2))) continue;
            return widget;
        }
        return null;
    }

    protected void addAdditionalInfoToTooltip(IProgWidget widget, List<ITextComponent> tooltip) {
        if (ProgWidgetGuiManager.hasGui(widget)) {
            tooltip.add(new StringTextComponent("Right-click for options").func_211708_a(TextFormatting.GOLD));
        }
        ThirdPartyManager.instance().docsProvider.addTooltip(tooltip, false);
    }

    public void render(int x, int y, boolean showFlow, boolean showInfo) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.scaleScroll.getState() != this.lastZoom) {
            float shift = 0.2f * (float)(this.scaleScroll.getState() - this.lastZoom);
            float prevScale = 2.0f - (float)this.lastZoom * 0.2f;
            this.translatedX += (double)shift * ((double)x - this.translatedX) / (double)prevScale;
            this.translatedY += (double)shift * ((double)y - this.translatedY) / (double)prevScale;
        }
        this.lastZoom = this.scaleScroll.getState();
        MainWindow mw = this.minecraft.field_195558_d;
        float sfX = (float)mw.func_198105_m() / (float)mw.func_198107_o();
        float sfY = (float)mw.func_198083_n() / (float)mw.func_198087_p();
        GL11.glScissor((int)((int)((float)(this.guiLeft + this.startX) * sfX)), (int)((int)((float)(mw.func_198087_p() - this.areaHeight - (this.guiTop + this.startY)) * sfY) + 1), (int)((int)((float)this.areaWidth * sfX)), (int)((int)((float)this.areaHeight * sfY)));
        GL11.glEnable((int)3089);
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)this.translatedX, (double)this.translatedY, (double)0.0);
        float scale = this.getScale();
        GlStateManager.scaled((double)scale, (double)scale, (double)1.0);
        if (showFlow) {
            this.showFlow();
        }
        GlStateManager.enableTexture();
        for (IProgWidget widget : this.progWidgets) {
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)(widget.getX() + this.guiLeft), (double)(widget.getY() + this.guiTop), (double)0.0);
            GlStateManager.scaled((double)0.5, (double)0.5, (double)1.0);
            widget.render();
            GlStateManager.popMatrix();
        }
        for (IProgWidget widget : this.progWidgets) {
            ArrayList<ITextComponent> errors = new ArrayList<ITextComponent>();
            widget.addErrors(errors, this.progWidgets);
            if (errors.size() > 0) {
                this.drawBorder(widget, -65536);
                continue;
            }
            ArrayList<ITextComponent> warnings = new ArrayList<ITextComponent>();
            widget.addWarnings(warnings, this.progWidgets);
            if (warnings.size() <= 0) continue;
            this.drawBorder(widget, -256);
        }
        this.renderAdditionally();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (showInfo) {
            for (IProgWidget widget : this.progWidgets) {
                GlStateManager.pushMatrix();
                GlStateManager.translated((double)(widget.getX() + this.guiLeft), (double)(widget.getY() + this.guiTop), (double)0.0);
                GlStateManager.scaled((double)0.5, (double)0.5, (double)1.0);
                widget.renderExtraInfo();
                GlStateManager.popMatrix();
            }
        }
        GlStateManager.popMatrix();
        GL11.glDisable((int)3089);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double dx, double dy) {
        if (mouseButton == 0 && !this.scaleScroll.isDragging() && new Rectangle2d(this.guiLeft + this.startX, this.guiTop + this.startY, this.areaWidth, this.areaHeight).func_199315_b((int)mouseX, (int)mouseY)) {
            this.translatedX += dx;
            this.translatedY += dy;
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double dir) {
        return this.scaleScroll.mouseScrolled(mouseX, mouseY, dir);
    }

    protected void renderAdditionally() {
    }

    protected void drawBorder(IProgWidget widget, int color) {
        this.drawBorder(widget, color, 0);
    }

    protected void drawBorder(IProgWidget widget, int color, int inset) {
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(widget.getX() + this.guiLeft), (double)(widget.getY() + this.guiTop), (double)0.0);
        GlStateManager.scaled((double)0.5, (double)0.5, (double)1.0);
        this.vLine(inset, inset, widget.getHeight() - inset, color);
        this.vLine(widget.getWidth() - inset, inset, widget.getHeight() - inset, color);
        this.hLine(widget.getWidth() - inset, inset, inset, color);
        this.hLine(widget.getWidth() - inset, inset, widget.getHeight() - inset, color);
        GlStateManager.popMatrix();
    }

    private void showFlow() {
        GlStateManager.lineWidth((float)1.0f);
        GlStateManager.disableTexture();
        GlStateManager.begin((int)1);
        for (IProgWidget widget : this.progWidgets) {
            if (!(widget instanceof IJump)) continue;
            for (String jumpLocation : ((IJump)((Object)widget)).getPossibleJumpLocations()) {
                if (jumpLocation == null) continue;
                for (IProgWidget w : this.progWidgets) {
                    if (!(w instanceof ILabel) || !jumpLocation.equals(((ILabel)((Object)w)).getLabel())) continue;
                    int x1 = widget.getX() + widget.getWidth() / 4;
                    int y1 = widget.getY() + widget.getHeight() / 4;
                    int x2 = w.getX() + w.getWidth() / 4;
                    int y2 = w.getY() + w.getHeight() / 4;
                    float midX = (float)(x2 + x1) / 2.0f;
                    float midY = (float)(y2 + y1) / 2.0f;
                    GlStateManager.vertex3f((float)(this.guiLeft + x1), (float)(this.guiTop + y1), (float)0.0f);
                    GlStateManager.vertex3f((float)(this.guiLeft + x2), (float)(this.guiTop + y2), (float)0.0f);
                    Vec3d arrowVec = new Vec3d((double)(x1 - x2), (double)(y1 - y2), 0.0).func_72432_b();
                    float arrowAngle = (float)Math.toRadians(30.0);
                    float arrowSize = 5.0f;
                    arrowVec = new Vec3d(arrowVec.field_72450_a * (double)arrowSize, 0.0, arrowVec.field_72448_b * (double)arrowSize);
                    arrowVec = arrowVec.func_178785_b(arrowAngle);
                    GlStateManager.vertex3f((float)((float)this.guiLeft + midX), (float)((float)this.guiTop + midY), (float)0.0f);
                    GlStateManager.vertex3f((float)((float)this.guiLeft + midX + (float)arrowVec.field_72450_a), (float)((float)this.guiTop + midY + (float)arrowVec.field_72449_c), (float)0.0f);
                    arrowVec = arrowVec.func_178785_b(-2.0f * arrowAngle);
                    GlStateManager.vertex3f((float)((float)this.guiLeft + midX), (float)((float)this.guiTop + midY), (float)0.0f);
                    GlStateManager.vertex3f((float)((float)this.guiLeft + midX + (float)arrowVec.field_72450_a), (float)((float)this.guiTop + midY + (float)arrowVec.field_72449_c), (float)0.0f);
                }
            }
        }
        GlStateManager.end();
        GlStateManager.enableTexture();
    }

    public float getScale() {
        return 2.0f - (float)this.scaleScroll.getState() * 0.2f;
    }

    boolean isOutsideProgrammingArea(IProgWidget widget) {
        float scale = this.getScale();
        int x = (int)((float)(widget.getX() + this.guiLeft) * scale);
        int y = (int)((float)(widget.getY() + this.guiTop) * scale);
        x = (int)((double)x + (this.translatedX - (double)this.guiLeft));
        y = (int)((double)y + (this.translatedY - (double)this.guiTop));
        return x < this.startX || (float)x + (float)widget.getWidth() * scale / 2.0f > (float)(this.startX + this.areaWidth) || y < this.startY || (float)y + (float)widget.getHeight() * scale / 2.0f > (float)(this.startY + this.areaHeight);
    }

    public void gotoPiece(IProgWidget widget) {
        if (widget != null) {
            this.scaleScroll.currentScroll = 0.0f;
            this.lastZoom = 0;
            this.translatedX = (double)(-widget.getX()) * 2.0 + (double)this.areaWidth / 2.0 - (double)this.guiLeft;
            this.translatedY = (double)(-widget.getY()) * 2.0 + (double)this.areaHeight / 2.0 - (double)this.guiTop;
        }
    }
}

